/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import javax.media.MediaLocator;

public class RTPMediaLocator
extends MediaLocator {
    String address = "";
    String contentType = "";
    private boolean valid = true;
    public static final int PORT_UNDEFINED = -1;
    public static final int SSRC_UNDEFINED = 0;
    public static final int TTL_UNDEFINED = 1;
    int port = -1;
    long ssrc = 0L;
    int ttl = 1;

    public RTPMediaLocator(String locatorString) throws MalformedURLException {
        super(locatorString);
        this.parseLocator(locatorString);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getSessionAddress() {
        return this.address;
    }

    public int getSessionPort() {
        return this.port;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public int getTTL() {
        return this.ttl;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void parseLocator(String locatorString) throws MalformedURLException {
        String remainder = this.getRemainder();
        int colonIndex = remainder.indexOf(":");
        int slashIndex = remainder.indexOf("/", 2);
        int nextcolonIndex = -1;
        int nextslashIndex = -1;
        if (colonIndex != -1) {
            nextcolonIndex = remainder.indexOf(":", colonIndex + 1);
        }
        if (slashIndex != -1) {
            nextslashIndex = remainder.indexOf("/", slashIndex + 1);
        }
        if (colonIndex != -1) {
            this.address = remainder.substring(2, colonIndex);
        }
        try {
            InetAddress Iaddr = InetAddress.getByName(this.address);
        }
        catch (UnknownHostException e) {
            throw new MalformedURLException("Valid RTP Session Address must be given");
        }
        if (colonIndex == -1 || slashIndex == -1) {
            throw new MalformedURLException("RTP MediaLocator is Invalid. Must be of form rtp://addr:port/content/ttl");
        }
        String portstr = "";
        portstr = nextcolonIndex == -1 ? remainder.substring(colonIndex + 1, slashIndex) : remainder.substring(colonIndex + 1, nextcolonIndex);
        try {
            Integer Iport = Integer.valueOf(portstr);
            this.port = Iport;
        }
        catch (NumberFormatException e) {
            throw new MalformedURLException("RTP MediaLocator Port must be a valid integer");
        }
        if (nextcolonIndex != -1) {
            String ssrcstr = remainder.substring(nextcolonIndex + 1, slashIndex);
            try {
                Long Lssrcstr = Long.valueOf(ssrcstr);
                this.ssrc = Lssrcstr;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (slashIndex != -1) {
            this.contentType = nextslashIndex == -1 ? remainder.substring(slashIndex + 1, remainder.length()) : remainder.substring(slashIndex + 1, nextslashIndex);
            if (!this.contentType.equals("audio") && !this.contentType.equals("video")) {
                throw new MalformedURLException("Content Type in URL must be audio or video ");
            }
            this.contentType = "rtp/" + this.contentType;
        }
        if (nextslashIndex != -1) {
            String ttlstr = remainder.substring(nextslashIndex + 1, remainder.length());
            try {
                Integer Ittl = Integer.valueOf(ttlstr);
                this.ttl = Ittl;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

