/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoPanel
extends JPanel {
    private String title = "Title";
    private String description = "Description";
    private JLabel jLabel = null;

    public InfoPanel() {
        this.initialize();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateInfo();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateInfo();
    }

    private void updateInfo() {
        this.jLabel.setText("<html><b>" + this.title + "</b><br>" + this.description);
    }

    private void initialize() {
        this.jLabel = new JLabel();
        this.jLabel.setText("<html><b>Some title</b><br>Some description about this window... feel free to write anithing you want");
        this.jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlShadow, 1), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.jLabel.setMinimumSize(new Dimension(69, 45));
        this.jLabel.setHorizontalTextPosition(2);
        this.jLabel.setVerticalAlignment(1);
        this.setLayout(new BorderLayout());
        this.setSize(230, 46);
        this.add((Component)this.jLabel, "Center");
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isOpaque()) {
            return;
        }
        Color control = new Color(150, 150, 255);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        Paint storedPaint = g2.getPaint();
        g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, width, height, control));
        g2.fillRect(0, 0, width, height);
        g2.setPaint(storedPaint);
    }
}

