/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.perms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.provider.PolicyFile;

public class SMGlobalPolicyUtil {
    static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    public static final String EE_GRANT_FILE = "javaee.server.policy";
    public static final String EE_RESTRICTED_FILE = "restrict.server.policy";
    public static final String SERVER_ALLOWED_FILE = "restrict.server.policy";
    protected static final String SYS_PROP_JAVA_SEC_POLICY = "java.security.policy";
    public static final String EJB_TYPE_CODESOURCE = "file:/module/Ejb";
    public static final String WEB_TYPE_CODESOURCE = "file:/module/Web";
    public static final String RAR_TYPE_CODESOURCE = "file:/module/Rar";
    public static final String CLIENT_TYPE_CODESOURCE = "file:/module/Car";
    public static final String EAR_TYPE_CODESOURCE = "file:/module/Ear";
    public static final String EAR_CLASS_LOADER = "org.glassfish.javaee.full.deployment.EarClassLoader";
    private static final Map<CommponentType, String> CompTypeToCodeBaseMap = new HashMap<CommponentType, String>();
    private static final Map<CommponentType, PermissionCollection> compTypeToEEGarntsMap;
    private static final Map<CommponentType, PermissionCollection> compTypeToEERestrictedMap;
    private static final Map<CommponentType, PermissionCollection> compTypeToServAllowedMap;
    private static boolean eeGrantedPolicyInitDone;
    protected static final String domainCfgFolder;
    private static final AllPermission ALL_PERM;

    public static CommponentType convertComponentType(String type) {
        return Enum.valueOf(CommponentType.class, type);
    }

    public static PermissionCollection getEECompGrantededPerms(CommponentType type) {
        SMGlobalPolicyUtil.initDefPolicy();
        return compTypeToEEGarntsMap.get((Object)type);
    }

    public static PermissionCollection getEECompGrantededPerms(String type) {
        CommponentType compType = SMGlobalPolicyUtil.convertComponentType(type);
        return SMGlobalPolicyUtil.getEECompGrantededPerms(compType);
    }

    public static PermissionCollection getCompRestrictedPerms(CommponentType type) {
        SMGlobalPolicyUtil.initDefPolicy();
        return compTypeToEERestrictedMap.get((Object)type);
    }

    public static PermissionCollection getCompRestrictedPerms(String type) {
        CommponentType compType = SMGlobalPolicyUtil.convertComponentType(type);
        return SMGlobalPolicyUtil.getCompRestrictedPerms(compType);
    }

    private static synchronized void initDefPolicy() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("defGrantedPolicyInitDone= " + eeGrantedPolicyInitDone);
            }
            if (eeGrantedPolicyInitDone) {
                return;
            }
            eeGrantedPolicyInitDone = true;
            SMGlobalPolicyUtil.loadServerPolicy(PolicyType.EEGranted);
            SMGlobalPolicyUtil.loadServerPolicy(PolicyType.EERestricted);
            SMGlobalPolicyUtil.loadServerPolicy(PolicyType.ServerAllowed);
            SMGlobalPolicyUtil.checkDomainRestrictionsForDefaultPermissions();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static String getJavaPolicyFolder() {
        String policyPath = System.getProperty(SYS_PROP_JAVA_SEC_POLICY);
        if (policyPath == null) {
            return null;
        }
        File pf = new File(policyPath);
        return pf.getParent();
    }

    private static void loadServerPolicy(PolicyType policyType) throws IOException {
        File f;
        if (policyType == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PolicyType= " + (Object)((Object)policyType));
        }
        String policyFilename = null;
        Map<CommponentType, PermissionCollection> policyMap = null;
        switch (policyType) {
            case EEGranted: {
                policyFilename = domainCfgFolder + EE_GRANT_FILE;
                policyMap = compTypeToEEGarntsMap;
                break;
            }
            case EERestricted: {
                policyFilename = domainCfgFolder + "restrict.server.policy";
                policyMap = compTypeToEERestrictedMap;
                break;
            }
            case ServerAllowed: {
                policyFilename = domainCfgFolder + "restrict.server.policy";
                policyMap = compTypeToServAllowedMap;
            }
        }
        if (policyFilename == null || policyMap == null) {
            throw new IllegalArgumentException("Unrecognized policy type: " + (Object)((Object)policyType));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("policyFilename= " + policyFilename);
        }
        if (!(f = new File(policyFilename)).exists()) {
            return;
        }
        URL furl = new URL("file:" + policyFilename);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading policy from " + furl);
        }
        PolicyFile pf = new PolicyFile(furl);
        CodeSource cs = new CodeSource(new URL(EJB_TYPE_CODESOURCE), (Certificate[])null);
        PermissionCollection pc = pf.getPermissions(cs);
        policyMap.put(CommponentType.ejb, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded EJB policy = " + pc);
        }
        cs = new CodeSource(new URL(WEB_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(cs);
        policyMap.put(CommponentType.war, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded WEB policy =" + pc);
        }
        cs = new CodeSource(new URL(RAR_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(cs);
        policyMap.put(CommponentType.rar, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded rar policy =" + pc);
        }
        cs = new CodeSource(new URL(CLIENT_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(cs);
        policyMap.put(CommponentType.car, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded car policy =" + pc);
        }
        cs = new CodeSource(new URL(EAR_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(cs);
        policyMap.put(CommponentType.ear, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded ear policy =" + pc);
        }
    }

    private static void checkDomainRestrictionsForDefaultPermissions() throws SecurityException {
        SMGlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.ejb);
        SMGlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.war);
        SMGlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.rar);
        SMGlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.car);
        SMGlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.ear);
    }

    private static void checkEETypePermsAgainstServerRestiction(CommponentType type) throws SecurityException {
        SMGlobalPolicyUtil.checkRestriction(compTypeToEEGarntsMap.get((Object)type), compTypeToEERestrictedMap.get((Object)type));
    }

    public static void checkRestriction(CommponentType type, PermissionCollection declaredPC) throws SecurityException {
        SMGlobalPolicyUtil.checkRestriction(declaredPC, SMGlobalPolicyUtil.getCompRestrictedPerms(type));
    }

    public static void checkRestriction(PermissionCollection declaredPC, PermissionCollection restrictedPC) throws SecurityException {
        if (restrictedPC == null || declaredPC == null) {
            return;
        }
        SMGlobalPolicyUtil.checkContains(declaredPC, restrictedPC);
        SMGlobalPolicyUtil.checkContains(restrictedPC, declaredPC);
    }

    private static void checkContains(PermissionCollection containPC, PermissionCollection toBeCheckedPC) throws SecurityException {
        if (containPC == null || toBeCheckedPC == null) {
            return;
        }
        Enumeration<Permission> checkEnum = toBeCheckedPC.elements();
        while (checkEnum.hasMoreElements()) {
            Permission p = checkEnum.nextElement();
            if (!containPC.implies(p)) continue;
            throw new SecurityException("Restricted permission " + p + " is declared or implied in the " + containPC);
        }
    }

    public static void checkRestrictionOfComponentType(PermissionCollection declaredPC, CommponentType type) throws SecurityException {
        if (CommponentType.ear == type) {
            SMGlobalPolicyUtil.checkRestrictionOfEar(declaredPC);
        }
        PermissionCollection restrictedPC = compTypeToEERestrictedMap.get((Object)type);
        SMGlobalPolicyUtil.checkRestriction(declaredPC, restrictedPC);
    }

    public static void checkRestrictionOfEar(PermissionCollection declaredPC) throws SecurityException {
        PermissionCollection pc = compTypeToEERestrictedMap.get((Object)CommponentType.ejb);
        if (pc != null) {
            SMGlobalPolicyUtil.checkRestriction(declaredPC, pc);
        }
        if ((pc = compTypeToEERestrictedMap.get((Object)CommponentType.war)) != null) {
            SMGlobalPolicyUtil.checkRestriction(declaredPC, pc);
        }
        if ((pc = compTypeToEERestrictedMap.get((Object)CommponentType.rar)) != null) {
            SMGlobalPolicyUtil.checkRestriction(declaredPC, pc);
        }
        if ((pc = compTypeToEERestrictedMap.get((Object)CommponentType.car)) != null) {
            SMGlobalPolicyUtil.checkRestriction(declaredPC, pc);
        }
    }

    static {
        CompTypeToCodeBaseMap.put(CommponentType.ejb, EJB_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.war, WEB_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.rar, RAR_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.car, CLIENT_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.ear, EAR_TYPE_CODESOURCE);
        compTypeToEEGarntsMap = new HashMap<CommponentType, PermissionCollection>();
        compTypeToEERestrictedMap = new HashMap<CommponentType, PermissionCollection>();
        compTypeToServAllowedMap = new HashMap<CommponentType, PermissionCollection>();
        eeGrantedPolicyInitDone = false;
        domainCfgFolder = SMGlobalPolicyUtil.getJavaPolicyFolder() + File.separator;
        ALL_PERM = new AllPermission();
    }

    public static enum CommponentType {
        ear,
        ejb,
        war,
        rar,
        car;

    }

    private static enum PolicyType {
        EEGranted,
        EERestricted,
        ServerAllowed;

    }
}

