/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly2;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.mgmt.transport.AbstractMessageSender;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyNetworkManager;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly2.ConnectionCache;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.Futures;

public class GrizzlyTCPMessageSender
extends AbstractMessageSender {
    private static final Logger LOG = GrizzlyNetworkManager.getLogger();
    private final TCPNIOTransport tcpNioTransport;
    private final ConnectionCache connectionCache;
    private final long writeTimeoutMillis;

    public GrizzlyTCPMessageSender(TCPNIOTransport tcpNioTransport, ConnectionCache connectionCache, PeerID<GrizzlyPeerID> localPeerID, long writeTimeoutMillis) {
        this.tcpNioTransport = tcpNioTransport;
        this.localPeerID = localPeerID;
        this.connectionCache = connectionCache;
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Override
    protected boolean doSend(PeerID peerID, Message message) throws IOException {
        if (peerID == null) {
            throw new IOException("peer ID can not be null");
        }
        Object uniqueID = peerID.getUniqueID();
        if (!(uniqueID instanceof GrizzlyPeerID)) {
            throw new IOException("peer ID must be GrizzlyPeerID type");
        }
        GrizzlyPeerID grizzlyPeerID = (GrizzlyPeerID)uniqueID;
        InetSocketAddress remoteSocketAddress = new InetSocketAddress(grizzlyPeerID.getHost(), grizzlyPeerID.getTcpPort());
        return this.send(null, remoteSocketAddress, message, peerID);
    }

    private boolean send(SocketAddress localAddress, SocketAddress remoteAddress, Message message, PeerID target) throws IOException {
        int MAX_RESEND_ATTEMPTS = 4;
        if (this.tcpNioTransport == null) {
            throw new IOException("grizzly controller must be initialized");
        }
        if (remoteAddress == null) {
            throw new IOException("remote address can not be null");
        }
        if (message == null) {
            throw new IOException("message can not be null");
        }
        int attemptNo = 1;
        do {
            Connection connection;
            try {
                connection = this.connectionCache.poll(localAddress, remoteAddress);
                if (connection == null) {
                    LOG.log(Level.WARNING, "failed to get a connection from connectionCache in attempt# " + attemptNo + ". GrizzlyTCPMessageSender.send(localAddr=" + localAddress + " , remoteAddr=" + remoteAddress + " sendTo=" + target + " msg=" + message + ". Retrying send", new Exception("stack trace"));
                    continue;
                }
            }
            catch (Throwable t) {
                IOException localIOE = new IOException("failed to connect to " + target.toString(), t);
                throw localIOE;
            }
            try {
                FutureImpl syncWriteFuture = Futures.createSafeFuture();
                connection.write((Object)remoteAddress, (Object)message, Futures.toCompletionHandler((FutureImpl)syncWriteFuture), null);
                syncWriteFuture.get(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
                this.connectionCache.offer(connection);
                return true;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof MessageIOException) {
                    try {
                        connection.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw (MessageIOException)cause;
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "exception writing message to connection. Retrying with another connection #" + attemptNo, e);
                }
                connection.close();
                ++attemptNo;
            }
        } while (attemptNo <= 4);
        return false;
    }
}

