/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9;

import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class ControllerUtils {
    public static void startController(Controller controller) {
        final CountDownLatch latch = new CountDownLatch(1);
        controller.addStateListener((ControllerStateListener)new ControllerStateListenerAdapter(){

            public void onReady() {
                latch.countDown();
            }

            public void onException(Throwable e) {
                if (latch.getCount() > 0L) {
                    Controller.logger().log(Level.SEVERE, "Exception during starting the controller", e);
                    latch.countDown();
                } else {
                    Controller.logger().log(Level.SEVERE, "Exception during controller processing", e);
                }
            }
        });
        new WorkerThreadImpl("ControllerWorker", (Runnable)controller).start();
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!controller.isStarted()) {
            throw new IllegalStateException("Controller is not started!");
        }
    }

    public static void stopController(Controller controller) {
        try {
            controller.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void startControllers(Controller[] controllers) {
        ControllerUtils.startControllers(Arrays.asList(controllers));
    }

    public static void startControllers(Collection<Controller> controllers) {
        for (Controller controller : controllers) {
            ControllerUtils.startController(controller);
        }
    }

    public static void stopControllers(Controller[] controllers) {
        ControllerUtils.stopControllers(Arrays.asList(controllers));
    }

    public static void stopControllers(Collection<Controller> controllers) {
        for (Controller controller : controllers) {
            ControllerUtils.stopController(controller);
        }
    }
}

