/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class NiceLogFormatter
extends Formatter {
    private HashMap<String, ResourceBundle> loggerResourceBundleTable;
    private Date date = new Date();
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private long recordNumber = 0L;
    private static final String LINE_SEPARATOR;
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER;
    private static final char FIELD_SEPARATOR = '|';
    private static final char NVPAIR_SEPARATOR = ';';
    private static final char NV_SEPARATOR = '=';
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat dateFormatter;
    private static final String PRODUCT_VERSION = "Shoal";

    public NiceLogFormatter() {
        this.loggerResourceBundleTable = new HashMap();
    }

    @Override
    public String format(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    protected String getProductId() {
        return PRODUCT_VERSION;
    }

    private String uniformLogFormat(LogRecord record) {
        try {
            StringBuilder recordBuffer = new StringBuilder(RECORD_BEGIN_MARKER);
            this.date.setTime(record.getMillis());
            recordBuffer.append(dateFormatter.format(this.date));
            recordBuffer.append('|');
            recordBuffer.append(record.getLevel()).append('|');
            recordBuffer.append(this.getProductId()).append('|');
            recordBuffer.append(record.getLoggerName()).append('|');
            recordBuffer.append("_ThreadID").append('=');
            recordBuffer.append(record.getThreadID()).append(';');
            recordBuffer.append("_ThreadName").append('=');
            recordBuffer.append(Thread.currentThread().getName());
            recordBuffer.append(';');
            Level level = record.getLevel();
            String className = record.getSourceClassName();
            className = className.substring(className.lastIndexOf(".") + 1, className.length());
            if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                recordBuffer.append("ClassName").append('=');
                recordBuffer.append(className);
                recordBuffer.append(';');
                recordBuffer.append("MethodName").append('=');
                recordBuffer.append(record.getSourceMethodName());
                recordBuffer.append(';');
            }
            if (RECORD_NUMBER_IN_KEY_VALUE) {
                recordBuffer.append("RecordNumber").append('=');
                recordBuffer.append(this.recordNumber++).append(';');
            }
            recordBuffer.append('|');
            String logMessage = record.getMessage();
            if (logMessage == null) {
                logMessage = "The log message is null.";
            }
            if (logMessage.indexOf("{0}") >= 0) {
                logMessage = MessageFormat.format(logMessage, record.getParameters());
            } else {
                ResourceBundle rb = this.getResourceBundle(record.getLoggerName());
                if (rb != null) {
                    try {
                        logMessage = MessageFormat.format(rb.getString(logMessage), record.getParameters());
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                }
            }
            recordBuffer.append(logMessage);
            if (record.getThrown() != null) {
                recordBuffer.append(LINE_SEPARATOR);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                recordBuffer.append(sw.toString());
            }
            recordBuffer.append(RECORD_END_MARKER);
            return recordBuffer.toString();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return new String("");
        }
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle rb = this.loggerResourceBundleTable.get(loggerName);
        if (rb == null) {
            rb = LogManager.getLogManager().getLogger(loggerName).getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, rb);
        }
        return rb;
    }

    static {
        String recordCount;
        LOG_SOURCE_IN_KEY_VALUE = true;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        LINE_SEPARATOR = System.getProperty("line.separator");
        RECORD_END_MARKER = "|#]" + LINE_SEPARATOR + LINE_SEPARATOR;
        dateFormatter = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
    }
}

