/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.base.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.base.GMSThreadFactory;
import com.sun.enterprise.ee.cms.impl.base.MessagePacket;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.common.DSCMessage;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.MessageSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.ShutdownHelper;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageWindow
implements Runnable {
    private static Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    private GMSContext ctx;
    private ArrayBlockingQueue<MessagePacket> messageQueue;
    private AtomicInteger messageQueueHighWaterMark = new AtomicInteger(0);
    private final String groupName;
    private final ExecutorService dscExecutor;

    public MessageWindow(String groupName, ArrayBlockingQueue<MessagePacket> messageQueue) {
        this.groupName = groupName;
        this.messageQueue = messageQueue;
        GMSThreadFactory gtf = new GMSThreadFactory("GMS-DistributedStateCache-Group-" + groupName + "-thread");
        this.dscExecutor = Executors.newSingleThreadExecutor(gtf);
    }

    void stop() {
        this.dscExecutor.shutdown();
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    private void recordMessageQueueHighWaterMark() {
        int localHighWater;
        int currentQueueSize;
        if (this.monitorLogger.isLoggable(Level.FINE) && (currentQueueSize = this.messageQueue.size()) > (localHighWater = this.messageQueueHighWaterMark.get())) {
            this.messageQueueHighWaterMark.compareAndSet(localHighWater, currentQueueSize);
        }
    }

    @Override
    public void run() {
        while (!this.getGMSContext().isShuttingDown()) {
            try {
                this.recordMessageQueueHighWaterMark();
                MessagePacket packet = this.messageQueue.take();
                if (packet == null) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Processing received message .... " + packet.getMessage());
                }
                this.newMessageReceived(packet);
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, e.getLocalizedMessage());
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "msg.wdw.exception.processing.msg", t);
            }
        }
        if (this.monitorLogger.isLoggable(Level.FINE)) {
            int msgQueueCapacity = this.messageQueue == null ? 0 : this.messageQueue.remainingCapacity();
            this.monitorLogger.log(Level.FINE, "message queue high water mark:" + this.messageQueueHighWaterMark.get() + " msg queue remaining capacity:" + msgQueueCapacity);
        }
        if (this.messageQueue != null && this.messageQueue.size() > 0) {
            int messageQueueSize = this.messageQueue.size();
            logger.log(Level.WARNING, "msg.wdw.thread.shutdown", new Object[]{this.groupName, messageQueueSize});
            if (messageQueueSize > 0 && logger.isLoggable(Level.FINER)) {
                Iterator<MessagePacket> mqIter = this.messageQueue.iterator();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Dumping received but unprocessed messages for group: " + this.groupName);
                }
                while (mqIter.hasNext()) {
                    MessagePacket mp = mqIter.next();
                    Object message = mp.getMessage();
                    String sender = mp.getAdvertisement().getName();
                    if (message instanceof GMSMessage) {
                        this.writeLog(sender, (GMSMessage)mp.getMessage());
                        continue;
                    }
                    if (!(message instanceof DSCMessage) || !logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, MessageFormat.format("Unprocessed DSCMessageReceived from :{0}, Operation :{1}", sender, ((DSCMessage)message).getOperation()));
                }
            }
        } else {
            logger.log(Level.INFO, "msg.wdw.thread.terminated", new Object[]{this.groupName});
        }
    }

    private void newMessageReceived(MessagePacket packet) {
        Object message = packet.getMessage();
        SystemAdvertisement adv = packet.getAdvertisement();
        String sender = adv.getName();
        if (message instanceof GMSMessage) {
            this.handleGMSMessage((GMSMessage)message, sender);
        } else if (message instanceof DSCMessage) {
            try {
                this.dscExecutor.submit(new ProcessDSCMessageTask(this, (DSCMessage)message, sender));
            }
            catch (RejectedExecutionException ree) {
                logger.log(Level.WARNING, "failed to schedule processDSCMessageTask for mesasge " + message);
            }
        }
    }

    private void handleDSCMessage(DSCMessage dMsg, String token) {
        Logger DSCLogger = GMSLogDomain.getDSCLogger();
        if (this.ctx.isWatchdog()) {
            return;
        }
        String ops = dMsg.getOperation();
        if (DSCLogger.isLoggable(Level.FINE)) {
            DSCLogger.log(Level.FINE, MessageFormat.format("DSCMessageReceived from :{0}, Operation :{1}", token, ops));
        }
        DistributedStateCacheImpl dsc = (DistributedStateCacheImpl)this.getGMSContext().getDistributedStateCache();
        if (ops.equals(DSCMessage.OPERATION.ADD.toString())) {
            if (DSCLogger.isLoggable(Level.FINE)) {
                DSCLogger.log(Level.FINE, "Adding Message: " + dMsg.getKey() + ":" + dMsg.getValue());
            }
            dsc.addToLocalCache(dMsg.getKey(), dMsg.getValue());
        } else if (ops.equals(DSCMessage.OPERATION.REMOVE.toString())) {
            if (DSCLogger.isLoggable(Level.FINE)) {
                DSCLogger.log(Level.FINE, "Removing Values with Key: " + dMsg.getKey());
            }
            dsc.removeFromLocalCache(dMsg.getKey());
        } else if (ops.equals(DSCMessage.OPERATION.ADDALLLOCAL.toString())) {
            if (dMsg.isCoordinator()) {
                try {
                    DSCLogger.log(Level.FINE, "Syncing local cache with group ...");
                    dsc.addAllToRemoteCache();
                    DSCLogger.log(Level.FINE, "done with local to group sync...");
                }
                catch (GMSException e) {
                    DSCLogger.log(Level.WARNING, e.getLocalizedMessage());
                }
                if (DSCLogger.isLoggable(Level.FINE)) {
                    DSCLogger.log(Level.FINE, "adding group cache state to local cache..");
                }
                dsc.addAllToLocalCache(dMsg.getCache());
            }
        } else if (ops.equals(DSCMessage.OPERATION.ADDALLREMOTE.toString())) {
            dsc.addAllToLocalCache(dMsg.getCache());
            if (DSCLogger.isLoggable(Level.FINE)) {
                DSCLogger.log(Level.FINE, "Add All Remote from member:" + token + " dsc=" + dsc);
            }
        }
    }

    private void handleGMSMessage(GMSMessage gMsg, String sender) {
        if (gMsg.getComponentName() != null && gMsg.getComponentName().equals(GMSConstants.shutdownType.GROUP_SHUTDOWN.toString())) {
            ShutdownHelper sh = GMSContextFactory.getGMSContext(gMsg.getGroupName()).getShutdownHelper();
            logger.log(Level.INFO, "member.groupshutdown", new Object[]{sender, this.groupName});
            sh.addToGroupShutdownList(gMsg.getGroupName());
            logger.log(Level.FINE, "setting clusterStopping variable to true");
            GMSContextFactory.getGMSContext(gMsg.getGroupName()).getGroupCommunicationProvider().setGroupStoppingState();
        } else if (this.getRouter().isMessageAFRegistered()) {
            this.writeLog(sender, gMsg);
            MessageSignalImpl ms = new MessageSignalImpl(gMsg.getMessage(), gMsg.getComponentName(), sender, gMsg.getGroupName(), gMsg.getStartTime());
            SignalPacket signalPacket = new SignalPacket((Signal)ms);
            this.getRouter().queueSignal(signalPacket);
        }
    }

    private Router getRouter() {
        return this.getGMSContext().getRouter();
    }

    private void writeLog(String sender, GMSMessage message) {
        String localId = this.getGMSContext().getServerIdentityToken();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, MessageFormat.format("Sender:{0}, Receiver :{1}, TargetComponent :{2}, Message :{3}", sender, localId, message.getComponentName(), new String(message.getMessage())));
        }
    }

    private static class ProcessDSCMessageTask
    implements Runnable {
        private final MessageWindow mw;
        private final DSCMessage dMsg;
        private final String fromMember;

        public ProcessDSCMessageTask(MessageWindow mw, DSCMessage dMsg, String token) {
            this.mw = mw;
            this.dMsg = dMsg;
            this.fromMember = token;
        }

        @Override
        public void run() {
            try {
                this.mw.handleDSCMessage(this.dMsg, this.fromMember);
            }
            catch (Throwable t) {
                ProcessDSCMessageTask processDSCMessageTask = this;
                logger.log(Level.SEVERE, "failed to handleDSCMessage", t);
            }
        }
    }
}

