/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.spi;

import java.io.Serializable;

public class GMSMessage
implements Serializable {
    static final long serialVersionUID = -5485293884999776323L;
    private final String componentName;
    private final byte[] message;
    private final String groupName;
    private final Long startTime;

    public GMSMessage(String componentName, byte[] message, String groupName, Long startTime) {
        if (componentName == null) {
            throw new IllegalArgumentException("parameter componentName must be non-null");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("parameter groupName must be non-null");
        }
        this.componentName = componentName;
        this.message = message;
        this.groupName = groupName;
        this.startTime = startTime;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getStartTime() {
        if (this.startTime == null) {
            return 0L;
        }
        return this.startTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(30);
        sb.append("GMSMessage to componentName:").append(this.componentName);
        sb.append(" message size:" + this.message.length);
        sb.append(" payload:");
        if (this.message.length < 30) {
            sb.append(new String(this.message));
        } else {
            sb.append(new String(this.message).substring(0, 15));
        }
        sb.append(" group:").append(this.groupName);
        return sb.toString();
    }
}

