/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationAdminFactory;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.DynamicBindings;
import org.apache.felix.cm.impl.Factory;
import org.apache.felix.cm.impl.RankingComparator;
import org.apache.felix.cm.impl.UpdateThread;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationManager
implements BundleActivator,
BundleListener {
    public static final String CM_CONFIG_DIR = "felix.cm.dir";
    public static final String CM_LOG_LEVEL = "felix.cm.loglevel";
    private static final String LOG_SERVICE_NAME = "org.osgi.service.log.LogService";
    private static final int CM_LOG_LEVEL_DEFAULT = 2;
    private static SecureRandom numberGenerator;
    private static final Comparator cmRankComp;
    private BundleContext bundleContext;
    private ServiceRegistration configurationAdminRegistration;
    private ServiceTracker logTracker;
    private ServiceTracker configurationListenerTracker;
    private ServiceTracker managedServiceTracker;
    private ServiceTracker managedServiceFactoryTracker;
    private ServiceTracker persistenceManagerTracker;
    private UpdateThread updateThread;
    private PersistenceManager[] persistenceManagers;
    private int pmtCount;
    private final Map factories = new HashMap();
    private final Map configurations = new HashMap();
    private DynamicBindings dynamicBindings;
    private int logLevel = 2;
    private volatile boolean handleBundleEvents;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationListener;
    static /* synthetic */ Class class$org$apache$felix$cm$PersistenceManager;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationPlugin;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    public void start(BundleContext bundleContext) {
        Hashtable<String, Object> props;
        this.logTracker = new ServiceTracker(bundleContext, LOG_SERVICE_NAME, null);
        this.logTracker.open();
        String logLevelProp = bundleContext.getProperty(CM_LOG_LEVEL);
        if (logLevelProp == null) {
            this.logLevel = 2;
        } else {
            try {
                this.logLevel = Integer.parseInt(logLevelProp);
            }
            catch (NumberFormatException nfe) {
                this.logLevel = 2;
            }
        }
        this.bundleContext = bundleContext;
        this.configurationListenerTracker = new ServiceTracker(bundleContext, (class$org$osgi$service$cm$ConfigurationListener == null ? (class$org$osgi$service$cm$ConfigurationListener = ConfigurationManager.class$("org.osgi.service.cm.ConfigurationListener")) : class$org$osgi$service$cm$ConfigurationListener).getName(), null);
        this.configurationListenerTracker.open();
        this.updateThread = new UpdateThread(this);
        this.updateThread.start();
        try {
            FilePersistenceManager fpm = new FilePersistenceManager(bundleContext, bundleContext.getProperty(CM_CONFIG_DIR));
            props = new Hashtable<String, Object>();
            props.put("service.pid", fpm.getClass().getName());
            props.put("service.description", "Platform Filesystem Persistence Manager");
            props.put("service.vendor", "Apache Software Foundation");
            props.put("service.ranking", new Integer(Integer.MIN_VALUE));
            bundleContext.registerService((class$org$apache$felix$cm$PersistenceManager == null ? (class$org$apache$felix$cm$PersistenceManager = ConfigurationManager.class$("org.apache.felix.cm.PersistenceManager")) : class$org$apache$felix$cm$PersistenceManager).getName(), (Object)fpm, props);
            this.dynamicBindings = new DynamicBindings(bundleContext, fpm);
        }
        catch (IOException ioe) {
            this.log(1, "Failure setting up dynamic configuration bindings", ioe);
        }
        catch (IllegalArgumentException iae) {
            this.log(1, "Cannot create the FilePersistenceManager", iae);
        }
        this.handleBundleEvents = true;
        bundleContext.addBundleListener((BundleListener)this);
        this.pmtCount = 1;
        this.persistenceManagerTracker = new ServiceTracker(bundleContext, (class$org$apache$felix$cm$PersistenceManager == null ? (class$org$apache$felix$cm$PersistenceManager = ConfigurationManager.class$("org.apache.felix.cm.PersistenceManager")) : class$org$apache$felix$cm$PersistenceManager).getName(), null);
        this.persistenceManagerTracker.open();
        ConfigurationAdminFactory caf = new ConfigurationAdminFactory(this);
        props = new Hashtable();
        props.put("service.pid", "org.apache.felix.cm.ConfigurationAdmin");
        props.put("service.description", "Configuration Admin Service Specification 1.2 Implementation");
        props.put("service.vendor", "Apache Software Foundation");
        this.configurationAdminRegistration = bundleContext.registerService((class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = ConfigurationManager.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName(), (Object)caf, props);
        this.managedServiceTracker = new ManagedServiceTracker(this);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) {
        this.handleBundleEvents = false;
        if (this.configurationAdminRegistration != null) {
            ServiceRegistration reg = this.configurationAdminRegistration;
            this.configurationAdminRegistration = null;
            reg.unregister();
        }
        this.managedServiceFactoryTracker.close();
        this.managedServiceTracker.close();
        this.persistenceManagerTracker.close();
        bundleContext.removeBundleListener((BundleListener)this);
        if (this.configurationListenerTracker != null) {
            this.configurationListenerTracker.close();
        }
        if (this.updateThread != null) {
            this.updateThread.terminate();
            try {
                this.updateThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
        Map map = this.configurations;
        synchronized (map) {
            this.configurations.clear();
        }
        map = this.factories;
        synchronized (map) {
            this.factories.clear();
        }
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl getCachedConfiguration(String pid) {
        Map map = this.configurations;
        synchronized (map) {
            return (ConfigurationImpl)this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl[] getCachedConfigurations() {
        Map map = this.configurations;
        synchronized (map) {
            return this.configurations.values().toArray(new ConfigurationImpl[this.configurations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl cacheConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            Object existing = this.configurations.get(configuration.getPid());
            if (existing != null) {
                return (ConfigurationImpl)existing;
            }
            this.configurations.put(configuration.getPid(), configuration);
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            this.configurations.remove(configuration.getPid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory getCachedFactory(String factoryPid) {
        Map map = this.factories;
        synchronized (map) {
            return (Factory)this.factories.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory[] getCachedFactories() {
        Map map = this.factories;
        synchronized (map) {
            return this.factories.values().toArray(new Factory[this.factories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheFactory(Factory factory) {
        Map map = this.factories;
        synchronized (map) {
            this.factories.put(factory.getFactoryPid(), factory);
        }
    }

    void setDynamicBundleLocation(String pid, String location) {
        if (this.dynamicBindings != null) {
            try {
                this.dynamicBindings.putLocation(pid, location);
            }
            catch (IOException ioe) {
                this.log(1, "Failed storing dynamic configuration binding for " + pid + " to " + location, ioe);
            }
        }
    }

    String getDynamicBundleLocation(String pid) {
        if (this.dynamicBindings != null) {
            return this.dynamicBindings.getLocation(pid);
        }
        return null;
    }

    ConfigurationImpl createFactoryConfiguration(ConfigurationAdminImpl configurationAdmin, String factoryPid) throws IOException {
        Factory factory = this.getFactory(factoryPid);
        if (factory.getBundleLocation() != null && !factory.getBundleLocation().equals(configurationAdmin.getBundle().getLocation())) {
            configurationAdmin.checkPermission();
        }
        String pid = ConfigurationManager.createPid(factoryPid);
        ConfigurationImpl config = this.createConfiguration(pid, factoryPid, configurationAdmin.getBundle().getLocation());
        return config;
    }

    ConfigurationImpl createFactoryConfiguration(String factoryPid, String location) throws IOException {
        String pid = ConfigurationManager.createPid(factoryPid);
        ConfigurationImpl config = this.createConfiguration(pid, factoryPid, location);
        return config;
    }

    ConfigurationImpl getExistingConfiguration(String pid) throws IOException {
        ConfigurationImpl config = this.getCachedConfiguration(pid);
        if (config != null) {
            return config;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!pmList[i].exists(pid)) continue;
            Dictionary props = pmList[i].load(pid);
            config = new ConfigurationImpl(this, pmList[i], props);
            return this.cacheConfiguration(config);
        }
        return null;
    }

    ConfigurationImpl getConfiguration(String pid, String bundleLocation) throws IOException {
        ConfigurationImpl config = this.getExistingConfiguration(pid);
        if (config != null) {
            return config;
        }
        config = this.createConfiguration(pid, null, bundleLocation);
        return this.cacheConfiguration(config);
    }

    ConfigurationImpl[] listConfigurations(ConfigurationAdminImpl configurationAdmin, String filterString) throws IOException, InvalidSyntaxException {
        Filter filter = null;
        if (filterString != null) {
            filter = this.bundleContext.createFilter(filterString);
        }
        boolean unprivileged = configurationAdmin != null && !configurationAdmin.hasPermission();
        String location = unprivileged ? configurationAdmin.getBundle().getLocation() : null;
        ArrayList<ConfigurationImpl> configList = new ArrayList<ConfigurationImpl>();
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            Enumeration configs = pmList[i].getDictionaries();
            while (configs.hasMoreElements()) {
                Object boundLocation;
                Dictionary config = (Dictionary)configs.nextElement();
                String pid = (String)config.get("service.pid");
                if (pid == null || unprivileged && !location.equals(boundLocation = config.get("service.bundleLocation")) || filter != null && !filter.match(config)) continue;
                ConfigurationImpl cfg = this.getCachedConfiguration(pid);
                if (cfg == null) {
                    cfg = new ConfigurationImpl(this, pmList[i], config);
                }
                if (cfg.isNew()) continue;
                configList.add(cfg);
            }
        }
        return configList.toArray(new ConfigurationImpl[configList.size()]);
    }

    void deleted(ConfigurationImpl config) {
        this.removeConfiguration(config);
        this.updateThread.schedule(new DeleteConfiguration(config, true));
    }

    void updated(ConfigurationImpl config, boolean fireEvent) {
        this.updateThread.schedule(new UpdateConfiguration(config, fireEvent));
    }

    void revokeConfiguration(ConfigurationImpl config) {
        this.updateThread.schedule(new DeleteConfiguration(config, false));
        config.setDynamicBundleLocation(null);
        config.setServiceReference(null);
    }

    void reassignConfiguration(ConfigurationImpl config) {
        this.updateThread.schedule(new UpdateConfiguration(config, false));
    }

    void fireConfigurationEvent(int type, String pid, String factoryPid) {
        this.updateThread.schedule(new FireConfigurationEvent(type, pid, factoryPid));
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16 && this.handleBundleEvents) {
            String location = event.getBundle().getLocation();
            ConfigurationImpl[] configs = this.getCachedConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                ConfigurationImpl cfg = configs[i];
                if (!location.equals(cfg.getDynamicBundleLocation())) continue;
                cfg.setDynamicBundleLocation(null);
            }
            Factory[] factories = this.getCachedFactories();
            for (int i = 0; i < factories.length; ++i) {
                Factory factory = factories[i];
                if (!location.equals(factory.getDynamicBundleLocation())) continue;
                factory.setDynamicBundleLocation(null);
            }
        }
    }

    private PersistenceManager[] getPersistenceManagers() {
        int currentPmtCount = this.persistenceManagerTracker.getTrackingCount();
        if (this.persistenceManagers == null || currentPmtCount > this.pmtCount) {
            PersistenceManager[] pm;
            ArrayList<Object> pmList = new ArrayList<Object>();
            ServiceReference[] refs = this.persistenceManagerTracker.getServiceReferences();
            if (refs == null || refs.length == 0) {
                pm = new PersistenceManager[]{};
            } else {
                TreeSet<ServiceReference> pms = new TreeSet<ServiceReference>(new RankingComparator(false));
                for (int i = 0; i < refs.length; ++i) {
                    pms.add(refs[i]);
                }
                int pmIndex = 0;
                Iterator pi = pms.iterator();
                while (pi.hasNext()) {
                    ServiceReference ref = (ServiceReference)pi.next();
                    Object service = this.persistenceManagerTracker.getService(ref);
                    if (service != null) {
                        pmList.add(service);
                    }
                    ++pmIndex;
                }
                pm = pmList.toArray(new PersistenceManager[pmList.size()]);
            }
            this.pmtCount = pm.length;
            this.persistenceManagers = pm;
        }
        return this.persistenceManagers;
    }

    private ServiceReference getServiceReference() {
        ServiceRegistration reg = this.configurationAdminRegistration;
        return reg != null ? reg.getReference() : null;
    }

    private void configure(ServiceReference sr, ManagedService service) {
        String[] pids = ConfigurationManager.getServicePid(sr);
        if (pids != null) {
            for (int i = 0; i < pids.length; ++i) {
                ManagedServiceUpdate update = new ManagedServiceUpdate(pids[i], sr, service);
                this.updateThread.schedule(update);
            }
        }
    }

    private void configure(ServiceReference sr, ManagedServiceFactory service) {
        String[] pids = ConfigurationManager.getServicePid(sr);
        if (pids != null) {
            for (int i = 0; i < pids.length; ++i) {
                ManagedServiceFactoryUpdate update = new ManagedServiceFactoryUpdate(pids[i], sr, service);
                this.updateThread.schedule(update);
            }
        }
    }

    ConfigurationImpl createConfiguration(String pid, String factoryPid, String bundleLocation) throws IOException {
        return new ConfigurationImpl(this, this.getPersistenceManagers()[0], pid, factoryPid, bundleLocation);
    }

    Factory getFactory(String factoryPid) throws IOException {
        Factory factory = this.getCachedFactory(factoryPid);
        if (factory != null) {
            return factory;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!Factory.exists(pmList[i], factoryPid)) continue;
            factory = Factory.load(this, pmList[i], factoryPid);
            this.cacheFactory(factory);
            return factory;
        }
        return this.createFactory(factoryPid);
    }

    Factory createFactory(String factoryPid) {
        Factory factory = new Factory(this, this.getPersistenceManagers()[0], factoryPid);
        this.cacheFactory(factory);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callPlugins(Dictionary props, String targetPid, ServiceReference sr, ConfigurationImpl cfg) {
        if (props == null) {
            return;
        }
        ServiceReference[] plugins = null;
        try {
            String filter = "(|(!(cm.target=*))(cm.target=" + targetPid + "))";
            plugins = this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ConfigurationPlugin == null ? (class$org$osgi$service$cm$ConfigurationPlugin = ConfigurationManager.class$("org.osgi.service.cm.ConfigurationPlugin")) : class$org$osgi$service$cm$ConfigurationPlugin).getName(), filter);
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        if (plugins == null || plugins.length == 0) {
            return;
        }
        TreeSet<ServiceReference> pluginSet = new TreeSet<ServiceReference>(cmRankComp);
        for (int i = 0; i < plugins.length; ++i) {
            pluginSet.add(plugins[i]);
        }
        Iterator pi = pluginSet.iterator();
        while (pi.hasNext()) {
            ServiceReference pluginRef = (ServiceReference)pi.next();
            ConfigurationPlugin plugin = (ConfigurationPlugin)this.bundleContext.getService(pluginRef);
            try {
                plugin.modifyConfiguration(sr, props);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem calling configuration plugin " + ConfigurationManager.toString(pluginRef), t);
            }
            finally {
                this.bundleContext.ungetService(pluginRef);
            }
            cfg.setAutoProperties(props, false);
        }
    }

    private static String createPid(String factoryPid) {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        StringBuffer buf = new StringBuffer(factoryPid.length() + 1 + 36);
        buf.append(factoryPid).append(".");
        for (int i = 0; i < randomBytes.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buf.append('-');
            }
            int val = randomBytes[i] & 0xFF;
            buf.append(Integer.toHexString(val >> 4));
            buf.append(Integer.toHexString(val & 0xF));
        }
        return buf.toString();
    }

    void log(int level, String message, Throwable t) {
        Object log = this.logTracker.getService();
        if (log != null) {
            ((LogService)log).log(this.getServiceReference(), level, message, t);
            return;
        }
        if (level <= this.logLevel) {
            String code;
            switch (level) {
                case 3: {
                    code = "*INFO *";
                    break;
                }
                case 2: {
                    code = "*WARN *";
                    break;
                }
                case 1: {
                    code = "*ERROR*";
                    break;
                }
                default: {
                    code = "*DEBUG*";
                }
            }
            System.err.println(code + " " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    static String[] getServicePid(ServiceReference reference) {
        Object pidObj = reference.getProperty("service.pid");
        if (pidObj instanceof String) {
            return new String[]{(String)pidObj};
        }
        if (pidObj instanceof String[]) {
            return (String[])pidObj;
        }
        if (pidObj instanceof Collection) {
            Collection pidCollection = (Collection)pidObj;
            return pidCollection.toArray(new String[pidCollection.size()]);
        }
        return null;
    }

    static String toString(ServiceReference ref) {
        String[] ocs = (String[])ref.getProperty("objectClass");
        String oc = "[";
        for (int i = 0; i < ocs.length; ++i) {
            oc = oc + ocs[i];
            if (i >= ocs.length - 1) continue;
            oc = oc + ", ";
        }
        oc = oc + ", id=" + ref.getProperty("service.id");
        oc = oc + ", bundle=" + ref.getBundle().getBundleId();
        oc = oc + "]";
        return oc;
    }

    void handleCallBackError(Throwable error, ServiceReference target, ConfigurationImpl config) {
        if (error instanceof ConfigurationException) {
            ConfigurationException ce = (ConfigurationException)error;
            if (ce.getProperty() != null) {
                this.log(1, ConfigurationManager.toString(target) + ": Updating configuration property " + ce.getProperty() + " caused a problem: " + ce.getReason(), ce);
            } else {
                this.log(1, ConfigurationManager.toString(target) + ": Updating configuration caused a problem: " + ce.getReason(), ce);
            }
        } else {
            this.log(1, ConfigurationManager.toString(target) + ": Unexpected problem updating " + config, error);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        cmRankComp = new RankingComparator(true, "service.cmRanking");
    }

    private class DeleteConfiguration
    implements Runnable {
        private final ConfigurationImpl config;
        private final String configLocation;
        private final boolean fireEvent;

        DeleteConfiguration(ConfigurationImpl config, boolean fireEvent) {
            this.config = config;
            this.configLocation = config.getBoundBundleLocation();
            this.fireEvent = fireEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block23: {
                String pid = this.config.getPid();
                String factoryPid = this.config.getFactoryPid();
                try {
                    if (factoryPid == null) {
                        ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), "(service.pid=" + pid + ")");
                        if (srList != null) {
                            for (int i = 0; i < srList.length; ++i) {
                                ServiceReference sr = srList[i];
                                if (!sr.getBundle().getLocation().equals(this.configLocation)) continue;
                                ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(sr);
                                try {
                                    srv.updated(null);
                                    continue;
                                }
                                catch (Throwable t) {
                                    ConfigurationManager.this.handleCallBackError(t, sr, this.config);
                                    continue;
                                }
                                finally {
                                    ConfigurationManager.this.bundleContext.ungetService(sr);
                                }
                            }
                        }
                        break block23;
                    }
                    try {
                        Factory factory = ConfigurationManager.this.getFactory(factoryPid);
                        factory.removePID(pid);
                        factory.store();
                    }
                    catch (IOException ioe) {
                        ConfigurationManager.this.log(1, "Failed removing " + pid + " from the factory " + factoryPid, ioe);
                    }
                    ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigurationManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), "(service.pid=" + factoryPid + ")");
                    if (srList != null) {
                        for (int i = 0; i < srList.length; ++i) {
                            ServiceReference sr = srList[i];
                            if (!sr.getBundle().getLocation().equals(this.configLocation)) continue;
                            ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(sr);
                            try {
                                srv.deleted(pid);
                                continue;
                            }
                            catch (Throwable t) {
                                ConfigurationManager.this.handleCallBackError(t, sr, this.config);
                                continue;
                            }
                            finally {
                                ConfigurationManager.this.bundleContext.ungetService(sr);
                            }
                        }
                    }
                }
                catch (InvalidSyntaxException ise) {
                    ConfigurationManager.this.log(1, "Service selection filter is invalid to update " + this.config, ise);
                }
                finally {
                    if (this.fireEvent) {
                        ConfigurationManager.this.fireConfigurationEvent(2, pid, factoryPid);
                    }
                }
            }
        }

        public String toString() {
            return "Delete: pid=" + this.config.getPid();
        }
    }

    private class FireConfigurationEvent
    implements Runnable {
        private int type;
        private String pid;
        private String factoryPid;

        FireConfigurationEvent(int type, String pid, String factoryPid) {
            this.type = type;
            this.pid = pid;
            this.factoryPid = factoryPid;
        }

        public void run() {
            ServiceReference[] srs = ConfigurationManager.this.configurationListenerTracker.getServiceReferences();
            if (srs == null || srs.length == 0) {
                return;
            }
            ConfigurationEvent event = new ConfigurationEvent(ConfigurationManager.this.getServiceReference(), this.type, this.factoryPid, this.pid);
            for (int i = 0; i < srs.length; ++i) {
                ConfigurationListener cl = (ConfigurationListener)ConfigurationManager.this.configurationListenerTracker.getService(srs[i]);
                try {
                    cl.configurationEvent(event);
                    continue;
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, "Unexpected problem delivery configuration event to " + ConfigurationManager.toString(srs[i]), t);
                }
            }
        }

        public String toString() {
            return "Fire ConfigurationEvent: pid=" + this.pid;
        }
    }

    private static class ManagedServiceFactoryTracker
    extends ServiceTracker {
        private final ConfigurationManager cm;

        ManagedServiceFactoryTracker(ConfigurationManager cm) {
            super(cm.bundleContext, (class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigurationManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), null);
            this.cm = cm;
            this.open();
        }

        public Object addingService(ServiceReference reference) {
            Object serviceObject = super.addingService(reference);
            if (serviceObject instanceof ManagedServiceFactory) {
                this.cm.configure(reference, (ManagedServiceFactory)serviceObject);
            } else {
                this.cm.log(2, "Service " + serviceObject + " is not a ManagedServiceFactory", null);
            }
            return serviceObject;
        }

        public void removedService(ServiceReference reference, Object service) {
            String[] factoryPids = ConfigurationManager.getServicePid(reference);
            if (factoryPids != null) {
                for (int i = 0; i < factoryPids.length; ++i) {
                    Factory factory = this.cm.getCachedFactory(factoryPids[i]);
                    if (factory == null) continue;
                    Iterator pi = factory.getPIDs().iterator();
                    while (pi.hasNext()) {
                        String pid = (String)pi.next();
                        ConfigurationImpl cfg = this.cm.getCachedConfiguration(pid);
                        if (cfg == null || !reference.equals(cfg.getServiceReference())) continue;
                        cfg.setServiceReference(null);
                    }
                }
            }
            super.removedService(reference, service);
        }
    }

    private class ManagedServiceFactoryUpdate
    implements Runnable {
        private final String factoryPid;
        private final ServiceReference sr;
        private final ManagedServiceFactory service;
        private final Factory factory;
        private final Map configs;

        ManagedServiceFactoryUpdate(String factoryPid, ServiceReference sr, ManagedServiceFactory service) {
            HashMap<ConfigurationImpl, Dictionary> configs;
            Factory factory;
            block8: {
                this.factoryPid = factoryPid;
                this.sr = sr;
                this.service = service;
                factory = null;
                configs = null;
                try {
                    factory = ConfigurationManager.this.getFactory(factoryPid);
                    if (factory == null) break block8;
                    configs = new HashMap<ConfigurationImpl, Dictionary>();
                    Iterator pi = factory.getPIDs().iterator();
                    while (pi.hasNext()) {
                        ConfigurationImpl cfg;
                        String pid = (String)pi.next();
                        try {
                            cfg = ConfigurationManager.this.getExistingConfiguration(pid);
                        }
                        catch (IOException ioe) {
                            ConfigurationManager.this.log(1, "Error loading configuration for " + pid, ioe);
                            continue;
                        }
                        if (cfg == null) {
                            ConfigurationManager.this.log(1, "Configuration " + pid + " referred to by factory " + factoryPid + " does not exist", null);
                            factory.removePID(pid);
                            factory.storeSilently();
                            continue;
                        }
                        if (cfg.isNew()) {
                            ConfigurationManager.this.log(1, "Ignoring new configuration pid=" + pid, null);
                            continue;
                        }
                        if (!factoryPid.equals(cfg.getFactoryPid())) {
                            ConfigurationManager.this.log(1, "Configuration " + pid + " referred to by factory " + factoryPid + " seems to belong to factory " + cfg.getFactoryPid(), null);
                            factory.removePID(pid);
                            factory.storeSilently();
                            continue;
                        }
                        configs.put(cfg, cfg.getProperties(true));
                    }
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Cannot get factory mapping for factory PID " + factoryPid, ioe);
                }
            }
            this.factory = factory;
            this.configs = configs;
        }

        public void run() {
            Bundle serviceBundle = this.sr.getBundle();
            if (serviceBundle == null) {
                ConfigurationManager.this.log(3, "ManagedServiceFactory for factory PID " + this.factoryPid + " seems to already have been unregistered, not updating with factory", null);
                return;
            }
            String serviceBundleLocation = serviceBundle.getLocation();
            if (!this.factory.tryBindLocation(serviceBundleLocation)) {
                ConfigurationManager.this.log(1, "Cannot use factory configuration " + this.factoryPid + " for " + ConfigurationManager.toString(this.sr) + ": Configuration bound to bundle " + this.factory.getBundleLocation(), null);
                return;
            }
            Iterator ci = this.configs.entrySet().iterator();
            while (ci.hasNext()) {
                Map.Entry entry = ci.next();
                ConfigurationImpl cfg = (ConfigurationImpl)entry.getKey();
                Dictionary properties = (Dictionary)entry.getValue();
                if (!cfg.tryBindLocation(serviceBundleLocation)) {
                    ConfigurationManager.this.log(1, "Cannot use configuration " + cfg.getPid() + " (factory " + this.factoryPid + ") for " + ConfigurationManager.toString(this.sr) + ": Configuration bound to bundle " + cfg.getBundleLocation(), null);
                    continue;
                }
                if (cfg.getServiceReference() == null) {
                    cfg.setServiceReference(this.sr);
                } else if (!this.sr.equals(cfg.getServiceReference())) {
                    ConfigurationManager.this.log(1, "Configuration for " + cfg.getPid() + " (factory " + this.factoryPid + ") has already been used for service " + ConfigurationManager.toString(cfg.getServiceReference()) + " and will now also be given to " + ConfigurationManager.toString(this.sr), null);
                }
                ConfigurationManager.this.callPlugins(properties, this.factoryPid, this.sr, cfg);
                if (properties == null) continue;
                ConfigurationManager.this.log(4, this.sr + ": Updating configuration pid=" + cfg.getPid(), null);
                try {
                    this.service.updated(cfg.getPid(), properties);
                }
                catch (Throwable t) {
                    ConfigurationManager.this.handleCallBackError(t, this.sr, cfg);
                }
                cfg.setLastUpdatedTime();
            }
        }

        public String toString() {
            return "ManagedServiceFactory Update: factoryPid=" + this.factoryPid;
        }
    }

    private static class ManagedServiceTracker
    extends ServiceTracker {
        private final ConfigurationManager cm;

        ManagedServiceTracker(ConfigurationManager cm) {
            super(cm.bundleContext, (class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), null);
            this.cm = cm;
            this.open();
        }

        public Object addingService(ServiceReference reference) {
            Object serviceObject = super.addingService(reference);
            if (serviceObject instanceof ManagedService) {
                this.cm.configure(reference, (ManagedService)serviceObject);
            } else {
                this.cm.log(2, "Service " + serviceObject + " is not a ManagedService", null);
            }
            return serviceObject;
        }

        public void removedService(ServiceReference reference, Object service) {
            String[] pids = ConfigurationManager.getServicePid(reference);
            if (pids != null) {
                for (int i = 0; i < pids.length; ++i) {
                    ConfigurationImpl cfg = this.cm.getCachedConfiguration(pids[i]);
                    if (cfg == null || !reference.equals(cfg.getServiceReference())) continue;
                    cfg.setServiceReference(null);
                }
            }
            super.removedService(reference, service);
        }
    }

    private class ManagedServiceUpdate
    implements Runnable {
        private final String pid;
        private final ServiceReference sr;
        private final ManagedService service;
        private final ConfigurationImpl config;
        private final Dictionary rawProperties;

        ManagedServiceUpdate(String pid, ServiceReference sr, ManagedService service) {
            this.pid = pid;
            this.sr = sr;
            this.service = service;
            ConfigurationImpl config = null;
            Dictionary rawProperties = null;
            try {
                config = ConfigurationManager.this.getExistingConfiguration(pid);
                if (config != null) {
                    rawProperties = config.getProperties(true);
                }
            }
            catch (IOException ioe) {
                ConfigurationManager.this.log(1, "Error loading configuration for " + pid, ioe);
            }
            this.config = config;
            this.rawProperties = rawProperties;
        }

        public void run() {
            Dictionary properties = this.rawProperties;
            if (this.config != null) {
                Bundle serviceBundle = this.sr.getBundle();
                if (serviceBundle == null) {
                    ConfigurationManager.this.log(3, "Service for PID " + this.pid + " seems to already have been unregistered, not updating with configuration", null);
                    return;
                }
                if (!this.config.tryBindLocation(serviceBundle.getLocation())) {
                    ConfigurationManager.this.log(1, "Cannot use configuration " + this.pid + " for " + ConfigurationManager.toString(this.sr) + ": Configuration bound to bundle " + this.config.getBundleLocation(), null);
                    return;
                }
                if (this.config.getServiceReference() == null) {
                    this.config.setServiceReference(this.sr);
                } else if (!this.sr.equals(this.config.getServiceReference())) {
                    ConfigurationManager.this.log(1, "Configuration for " + this.pid + " has already been used for service " + ConfigurationManager.toString(this.config.getServiceReference()) + " and will now also be given to " + ConfigurationManager.toString(this.sr), null);
                }
                ConfigurationManager.this.callPlugins(properties, this.pid, this.sr, this.config);
            } else {
                properties = null;
            }
            try {
                this.service.updated(properties);
            }
            catch (Throwable t) {
                ConfigurationManager.this.handleCallBackError(t, this.sr, this.config);
            }
            if (this.config != null) {
                this.config.setLastUpdatedTime();
            }
        }

        public String toString() {
            return "ManagedService Update: pid=" + this.pid;
        }
    }

    private class UpdateConfiguration
    implements Runnable {
        private final ConfigurationImpl config;
        private final Dictionary properties;
        private final long lastModificationTime;
        private final boolean fireEvent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        UpdateConfiguration(ConfigurationImpl config, boolean fireEvent) {
            this.config = config;
            ConfigurationImpl configurationImpl = config;
            synchronized (configurationImpl) {
                this.properties = config.getProperties(true);
                this.lastModificationTime = config.getLastModificationTime();
            }
            this.fireEvent = fireEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block29: {
                try {
                    String bundleLocation;
                    if (this.lastModificationTime < this.config.getLastUpdatedTime()) {
                        ConfigurationManager.this.log(4, "Configuration " + this.config.getPid() + " has already been updated, nothing to be done anymore.", null);
                        return;
                    }
                    if (this.config.getFactoryPid() == null) {
                        String bundleLocation2;
                        ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), "(service.pid=" + this.config.getPid() + ")");
                        if (srList == null) break block29;
                        ServiceReference ownerRef = this.getOwner(this.config, srList);
                        String string = bundleLocation2 = ownerRef != null ? ownerRef.getBundle().getLocation() : this.config.getBoundBundleLocation();
                        if (this.config.getBundleLocation() == null) {
                            this.config.setDynamicBundleLocation(bundleLocation2);
                        }
                        String configBundleLocation = this.config.getBundleLocation();
                        for (int i = 0; i < srList.length; ++i) {
                            ServiceReference userRef = srList[i];
                            String userRefLocation = userRef.getBundle().getLocation();
                            if (!userRefLocation.equals(configBundleLocation)) {
                                ConfigurationManager.this.log(1, "Cannot use configuration " + this.config.getPid() + " for " + ConfigurationManager.toString(userRef) + ": Configuration bound to bundle " + configBundleLocation, null);
                                continue;
                            }
                            if (userRef != ownerRef) {
                                ConfigurationManager.this.log(1, "Configuration for " + this.config.getPid() + " has already been used for service " + ConfigurationManager.toString(ownerRef) + " and will now also be given to " + ConfigurationManager.toString(userRef), null);
                            }
                            try {
                                ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(userRef);
                                if (srv != null) {
                                    CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties);
                                    ConfigurationManager.this.callPlugins(props, this.config.getPid(), userRef, this.config);
                                    srv.updated(props);
                                }
                            }
                            catch (Throwable t) {
                                ConfigurationManager.this.handleCallBackError(t, userRef, this.config);
                            }
                            finally {
                                ConfigurationManager.this.bundleContext.ungetService(userRef);
                            }
                            this.config.setLastUpdatedTime();
                        }
                        break block29;
                    }
                    ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigurationManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), "(service.pid=" + this.config.getFactoryPid() + ")");
                    if (srList == null || srList.length <= 0) break block29;
                    ServiceReference ownerRef = this.getOwner(this.config, srList);
                    String string = bundleLocation = ownerRef != null ? ownerRef.getBundle().getLocation() : this.config.getBoundBundleLocation();
                    if (this.config.getBundleLocation() == null) {
                        this.config.setDynamicBundleLocation(bundleLocation);
                    }
                    String configBundleLocation = this.config.getBundleLocation();
                    for (int i = 0; i < srList.length; ++i) {
                        ServiceReference ref = srList[i];
                        String refLocation = ref.getBundle().getLocation();
                        if (!refLocation.equals(configBundleLocation)) {
                            ConfigurationManager.this.log(1, "Cannot use configuration " + this.config.getPid() + " (factory " + this.config.getFactoryPid() + ") for " + ConfigurationManager.toString(ref) + ": Configuration bound to bundle " + configBundleLocation, null);
                            continue;
                        }
                        if (ref != ownerRef) {
                            ConfigurationManager.this.log(1, "Configuration for " + this.config.getPid() + " (factory " + this.config.getFactoryPid() + ") has already been used for service " + ConfigurationManager.toString(ownerRef) + " and will now also be given to " + ConfigurationManager.toString(ref), null);
                        }
                        try {
                            ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(ref);
                            if (srv != null && this.properties != null) {
                                CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties);
                                ConfigurationManager.this.callPlugins(props, this.config.getFactoryPid(), ref, this.config);
                                srv.updated(this.config.getPid(), props);
                            }
                        }
                        catch (Throwable t) {
                            ConfigurationManager.this.handleCallBackError(t, ref, this.config);
                        }
                        finally {
                            ConfigurationManager.this.bundleContext.ungetService(ref);
                        }
                        this.config.setLastUpdatedTime();
                    }
                }
                catch (InvalidSyntaxException ise) {
                    ConfigurationManager.this.log(1, "Service selection filter is invalid to update " + this.config, ise);
                }
                finally {
                    if (this.fireEvent) {
                        ConfigurationManager.this.fireConfigurationEvent(1, this.config.getPid(), this.config.getFactoryPid());
                    }
                }
            }
        }

        private ServiceReference getOwner(ConfigurationImpl config, ServiceReference[] srList) {
            String configLocation;
            if (config.getServiceReference() != null) {
                for (int i = 0; i < srList.length; ++i) {
                    if (!srList[i].equals(config.getServiceReference())) continue;
                    return srList[i];
                }
            }
            if ((configLocation = config.getBoundBundleLocation()) != null) {
                for (int i = 0; i < srList.length; ++i) {
                    if (!configLocation.equals(srList[i].getBundle().getLocation())) continue;
                    return srList[i];
                }
                return null;
            }
            ServiceReference ownerRef = srList[0];
            config.setServiceReference(ownerRef);
            return ownerRef;
        }

        public String toString() {
            return "Update: pid=" + this.config.getPid();
        }
    }
}

