/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.config.dom.Transports;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-transport")
@PerLookup
@I18n(value="delete.transport")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteTransport
implements AdminCommand {
    private static final ResourceBundle rb = HttpServiceStatsProviderBootstrap.rb;
    @LogMessageInfo(message="{0} transport is being used in the network listener {1}.", level="INFO")
    protected static final String DELETE_TRANSPORT_BEINGUSED = "AS-WEB-ADMIN-00040";
    @LogMessageInfo(message="Deletion of Transport {0} failed.", level="INFO")
    protected static final String DELETE_TRANSPORT_FAIL = "AS-WEB-ADMIN-00041";
    @LogMessageInfo(message="{0} transport doesn''t exist.", level="INFO")
    protected static final String DELETE_TRANSPORT_NOT_EXISTS = "AS-WEB-ADMIN-00042";
    @Param(name="transportname", primary=true)
    String transportName;
    Transport transportToBeRemoved = null;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Transports transports = networkConfig.getTransports();
        try {
            for (Transport transport : transports.getTransport()) {
                if (!this.transportName.equalsIgnoreCase(transport.getName())) continue;
                this.transportToBeRemoved = transport;
            }
            if (this.transportToBeRemoved == null) {
                report.setMessage(MessageFormat.format(rb.getString(DELETE_TRANSPORT_NOT_EXISTS), this.transportName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List nwlsnrList = this.transportToBeRemoved.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!this.transportToBeRemoved.getName().equals(nwlsnr.getTransport())) continue;
                report.setMessage(MessageFormat.format(rb.getString(DELETE_TRANSPORT_BEINGUSED), this.transportName, nwlsnr.getName()));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

                public Object run(Transports param) {
                    param.getTransport().remove(DeleteTransport.this.transportToBeRemoved);
                    return DeleteTransport.this.transportToBeRemoved;
                }
            }, (ConfigBeanProxy)transports);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString(DELETE_TRANSPORT_FAIL), this.transportName) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

