/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.logex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperationTracer {
    private static boolean enabled = true;
    private static boolean frozen = false;
    private static ThreadLocal<List<Element>> state = new ThreadLocal<List<Element>>(){

        @Override
        public List<Element> initialValue() {
            return new ArrayList<Element>();
        }
    };

    public static String convertToString(Object arg) {
        if (arg == null) {
            return "<NULL>";
        }
        Class<?> cls = arg.getClass();
        if (cls.isArray()) {
            Class<?> cclass = cls.getComponentType();
            if (cclass.equals(Integer.TYPE)) {
                return Arrays.toString((int[])arg);
            }
            if (cclass.equals(Byte.TYPE)) {
                return Arrays.toString((byte[])arg);
            }
            if (cclass.equals(Boolean.TYPE)) {
                return Arrays.toString((boolean[])arg);
            }
            if (cclass.equals(Character.TYPE)) {
                return Arrays.toString((char[])arg);
            }
            if (cclass.equals(Short.TYPE)) {
                return Arrays.toString((short[])arg);
            }
            if (cclass.equals(Long.TYPE)) {
                return Arrays.toString((long[])arg);
            }
            if (cclass.equals(Float.TYPE)) {
                return Arrays.toString((float[])arg);
            }
            if (cclass.equals(Double.TYPE)) {
                return Arrays.toString((double[])arg);
            }
            return Arrays.toString((Object[])arg);
        }
        return arg.toString();
    }

    public static void freeze() {
        frozen = true;
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    private OperationTracer() {
    }

    public static String getAsString() {
        StringBuilder sb = new StringBuilder();
        List<Element> elements = state.get();
        int count = 0;
        for (Element elem : elements) {
            if (count == 0) {
                sb.append(elem.getAsString());
                sb.append(':');
            } else if (count == 1) {
                sb.append(elem.getAsString());
            } else {
                sb.append(',');
                sb.append(elem.getAsString());
            }
            ++count;
        }
        return sb.toString();
    }

    public static void enter(String name, Object ... args) {
        if (enabled && !frozen) {
            state.get().add(new GenericElement(name, args));
        }
    }

    public static void begin(final String label) {
        if (enabled && !frozen) {
            List<Element> elements = state.get();
            elements.clear();
            elements.add(new Element(){

                @Override
                public String getAsString() {
                    return label;
                }
            });
        }
    }

    public static void finish() {
        if (enabled && !frozen) {
            state.get().clear();
        }
    }

    public static void startReadValue(String name) {
        if (enabled && !frozen) {
            state.get().add(new ValueElement(name));
        }
    }

    public static void readingField(String fieldName) {
        Element elem;
        List<Element> elements;
        int lastIndex;
        if (enabled && !frozen && (lastIndex = (elements = state.get()).size() - 1) >= 0 && (elem = elements.get(lastIndex)) instanceof ValueElement) {
            ValueElement ve = (ValueElement)elem;
            ve.setFieldName(fieldName);
        }
    }

    public static void endReadValue() {
        if (enabled && !frozen) {
            OperationTracer.end();
        }
    }

    public static void startReadArray(String name, int size) {
        if (enabled && !frozen) {
            state.get().add(new ArrayElement(name, size));
        }
    }

    public static void readingIndex(int index) {
        Element elem;
        List<Element> elements;
        int lastIndex;
        if (enabled && !frozen && (lastIndex = (elements = state.get()).size() - 1) >= 0 && (elem = elements.get(lastIndex)) instanceof ArrayElement) {
            ArrayElement ae = (ArrayElement)elem;
            ae.setIndex(index);
        }
    }

    public static void endReadArray() {
        if (enabled && !frozen) {
            OperationTracer.end();
        }
    }

    private static void end() {
        List<Element> elements = state.get();
        int lastIndex = elements.size() - 1;
        if (lastIndex >= 0) {
            elements.remove(lastIndex);
        }
    }

    public static void clear() {
        if (enabled) {
            state.get().clear();
            frozen = false;
        }
    }

    public static void exit() {
        if (enabled && !frozen) {
            OperationTracer.end();
        }
    }

    private static class ArrayElement
    implements Element {
        private String componentName;
        private int size;
        private int index;

        public ArrayElement(String componentName, int size) {
            this.componentName = componentName;
            this.size = size;
            this.index = -1;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public String getAsString() {
            if (this.index < 0) {
                return this.componentName + '<' + this.size + '>';
            }
            return this.componentName + '<' + this.size + ">[" + this.index + ']';
        }
    }

    static interface Element {
        public String getAsString();
    }

    private static class GenericElement
    implements Element {
        private String name;
        private Object[] data;

        public GenericElement(String name, Object[] data) {
            this.name = name;
            this.data = data;
        }

        @Override
        public String getAsString() {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                sb.append("!NULL_NAME!");
            } else {
                sb.append(this.name);
            }
            sb.append('(');
            boolean first = true;
            for (Object obj : this.data) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(OperationTracer.convertToString(obj));
            }
            sb.append(')');
            return sb.toString();
        }
    }

    private static class ValueElement
    implements Element {
        private String valueName;
        private String fieldName;

        public ValueElement(String valueName) {
            this.valueName = valueName;
            this.fieldName = null;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getAsString() {
            if (this.fieldName == null) {
                return this.valueName;
            }
            return this.valueName + '.' + this.fieldName;
        }
    }
}

