/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.glassfish.logging.annotation.LogMessageInfo;

public class FilterRegistrationImpl
implements FilterRegistration {
    protected FilterDef filterDef;
    protected StandardContext ctx;
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message="Unable to configure {0} for filter {1} of servlet context {2}, because this servlet context has already been initialized", level="WARNING")
    public static final String FILTER_REGISTRATION_ALREADY_INIT = "AS-WEB-CORE-00117";
    @LogMessageInfo(message="Unable to configure mapping for filter {0} of servlet context {1}, because servlet names are null or empty", level="WARNING")
    public static final String FILTER_REGISTRATION_MAPPING_SERVLET_NAME_EXCEPTION = "AS-WEB-CORE-00118";
    @LogMessageInfo(message="Unable to configure mapping for filter {0} of servlet context {1}, because URL patterns are null or empty", level="WARNING")
    public static final String FILTER_REGISTRATION_MAPPING_URL_PATTERNS_EXCEPTION = "AS-WEB-CORE-00119";

    FilterRegistrationImpl(FilterDef filterDef, StandardContext ctx) {
        this.filterDef = filterDef;
        this.ctx = ctx;
    }

    @Override
    public String getName() {
        return this.filterDef.getFilterName();
    }

    public FilterDef getFilterDefinition() {
        return this.filterDef;
    }

    @Override
    public String getClassName() {
        return this.filterDef.getFilterClassName();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(FILTER_REGISTRATION_ALREADY_INIT), "init parameter", this.filterDef.getFilterName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        return this.filterDef.setInitParameter(name, value, false);
    }

    @Override
    public String getInitParameter(String name) {
        return this.filterDef.getInitParameter(name);
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        return this.filterDef.setInitParameters(initParameters);
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this.filterDef.getInitParameters();
    }

    @Override
    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(FILTER_REGISTRATION_ALREADY_INIT), "servlet-name mapping", this.filterDef.getFilterName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        if (servletNames == null || servletNames.length == 0) {
            String msg = MessageFormat.format(rb.getString(FILTER_REGISTRATION_MAPPING_SERVLET_NAME_EXCEPTION), this.filterDef.getFilterName(), this.ctx.getName());
            throw new IllegalArgumentException(msg);
        }
        for (String servletName : servletNames) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.filterDef.getFilterName());
            fmap.setServletName(servletName);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
    }

    @Override
    public Collection<String> getServletNameMappings() {
        return this.ctx.getServletNameFilterMappings(this.getName());
    }

    @Override
    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(FILTER_REGISTRATION_ALREADY_INIT), "url-pattern mapping", this.filterDef.getFilterName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            String msg = MessageFormat.format(rb.getString(FILTER_REGISTRATION_MAPPING_URL_PATTERNS_EXCEPTION), this.filterDef.getFilterName(), this.ctx.getName());
            throw new IllegalArgumentException(msg);
        }
        for (String urlPattern : urlPatterns) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.filterDef.getFilterName());
            fmap.setURLPattern(urlPattern);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
    }

    @Override
    public Collection<String> getUrlPatternMappings() {
        return this.ctx.getUrlPatternFilterMappings(this.getName());
    }
}

