/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.HashSet;
import java.util.Set;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class DelayedComponentManager
extends ImmediateComponentManager
implements ServiceFactory {
    private final Set m_usingBundles = new HashSet();

    public DelayedComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata) {
        super(activator, componentHolder, metadata);
    }

    protected boolean createComponent() {
        return true;
    }

    protected void deleteComponent(int reason) {
        if (this.getInstance() != null) {
            super.deleteComponent(reason);
        }
        this.m_usingBundles.clear();
    }

    protected Object getService() {
        return this;
    }

    public synchronized Object getService(Bundle bundle, ServiceRegistration sr) {
        this.m_usingBundles.add(bundle);
        return this.state().getService(this);
    }

    protected boolean createRealComponent() {
        return super.createComponent();
    }

    public void ungetService(Bundle bundle, ServiceRegistration sr, Object service) {
        this.m_usingBundles.remove(bundle);
        if (this.m_usingBundles.isEmpty()) {
            this.state().ungetService(this);
        }
    }
}

