/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.User;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Realms;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.util.AMXLoggerInfo;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.config.types.Property;

public final class RealmsImpl
extends AMXImplBase {
    private volatile boolean realmsLoaded = false;
    private static final String ADMIN_REALM = "admin-realm";
    private static final String ANONYMOUS_USER = "anonymous";
    private static final String FILE_REALM_CLASSNAME = "com.sun.enterprise.security.auth.realm.file.FileRealm";

    public RealmsImpl(ObjectName containerObjectName) {
        super(containerObjectName, Realms.class);
    }

    public static RealmsManager getRealmsManager() {
        RealmsManager mgr = (RealmsManager)Globals.getDefaultHabitat().getService(RealmsManager.class, new Annotation[0]);
        return mgr;
    }

    private SecurityService getSecurityService() {
        return (SecurityService)InjectedValues.getInstance().getHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
    }

    private List<AuthRealm> getAuthRealms() {
        return this.getSecurityService().getAuthRealm();
    }

    private Set<String> getConfiguredRealmNames() {
        HashSet<String> names = new HashSet<String>();
        List<AuthRealm> realms = this.getAuthRealms();
        for (AuthRealm realm : realms) {
            names.add(realm.getName());
        }
        return names;
    }

    private synchronized void loadRealms() {
        if (this.realmsLoaded) {
            Set<String> loaded = SetUtil.newStringSet(this._getRealmNames());
            if (this.getConfiguredRealmNames().equals(loaded)) {
                return;
            }
            this.realmsLoaded = false;
        }
        this._loadRealms();
    }

    private void _loadRealms() {
        if (this.realmsLoaded) {
            throw new IllegalStateException();
        }
        List<AuthRealm> authRealms = this.getAuthRealms();
        ArrayList<String> goodRealms = new ArrayList<String>();
        for (AuthRealm authRealm : authRealms) {
            List propList = authRealm.getProperty();
            Properties props = new Properties();
            for (Property p : propList) {
                props.setProperty(p.getName(), p.getValue());
            }
            try {
                Realm.instantiate((String)authRealm.getName(), (String)authRealm.getClassname(), (Properties)props);
                goodRealms.add(authRealm.getName());
            }
            catch (Exception e) {
                AMXLoggerInfo.getLogger().log(Level.WARNING, "NCLS-COM-00044", new Object[]{StringUtil.quote(authRealm), e.getLocalizedMessage()});
            }
        }
        if (goodRealms.size() != 0) {
            String goodRealm = (String)goodRealms.iterator().next();
            try {
                String defaultRealm = this.getSecurityService().getDefaultRealm();
                Realm.getInstance((String)defaultRealm);
                Realm.setDefaultRealm((String)defaultRealm);
            }
            catch (Exception e) {
                AMXLoggerInfo.getLogger().log(Level.WARNING, "NCLS-COM-00044", new Object[]{StringUtil.quote(goodRealm), e.getLocalizedMessage()});
                Realm.setDefaultRealm((String)((String)goodRealms.iterator().next()));
            }
        }
        this.realmsLoaded = true;
    }

    private String[] _getRealmNames() {
        List<Enumeration> items = ListUtil.newList(RealmsImpl.getRealmsManager().getRealmNames());
        return CollectionUtil.toArray(items, String.class);
    }

    public String[] getRealmNames() {
        try {
            this.loadRealms();
            return this._getRealmNames();
        }
        catch (Exception e) {
            AMXLoggerInfo.getLogger().log(Level.WARNING, "NCLS-COM-00045", e.getLocalizedMessage());
            return new String[0];
        }
    }

    public String[] getPredefinedAuthRealmClassNames() {
        List items = RealmsImpl.getRealmsManager().getPredefinedAuthRealmClassNames();
        return CollectionUtil.toArray(items, String.class);
    }

    public String getDefaultRealmName() {
        return RealmsImpl.getRealmsManager().getDefaultRealmName();
    }

    public void setDefaultRealmName(String realmName) {
        RealmsImpl.getRealmsManager().setDefaultRealmName(realmName);
    }

    private Realm getRealm(String realmName) {
        this.loadRealms();
        Realm realm = RealmsImpl.getRealmsManager().getFromLoadedRealms(realmName);
        if (realm == null) {
            throw new IllegalArgumentException("No such realm: " + realmName);
        }
        return realm;
    }

    public void addUser(String realmName, String user, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.addUser(user, password.toCharArray(), groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateUser(String realmName, String existingUser, String newUser, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.updateUser(existingUser, newUser, password.toCharArray(), groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(String realmName, String user) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.removeUser(user);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsUserManagement(String realmName) {
        return this.getRealm(realmName).supportsUserManagement();
    }

    private void checkSupportsUserManagement(String realmName) {
        if (!this.supportsUserManagement(realmName)) {
            throw new IllegalStateException("Realm " + realmName + " does not support user management");
        }
    }

    public String[] getUserNames(String realmName) {
        try {
            List<Enumeration> names = ListUtil.newList(this.getRealm(realmName).getUserNames());
            return CollectionUtil.toArray(names, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName) {
        try {
            List<Enumeration> names = ListUtil.newList(this.getRealm(realmName).getGroupNames());
            return CollectionUtil.toArray(names, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName, String user) {
        try {
            return CollectionUtil.toArray(ListUtil.newList(this.getRealm(realmName).getGroupNames(user)), String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getUserAttributes(String realmName, String username) {
        try {
            User user = this.getRealm(realmName).getUser(username);
            HashMap<String, Object> m = new HashMap<String, Object>();
            List<Enumeration> attrNames = ListUtil.newList(user.getAttributeNames());
            for (String string : attrNames) {
                m.put(string, user.getAttribute(string));
            }
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getAnonymousUser() {
        Domain domain = (Domain)InjectedValues.getInstance().getHabitat().getService(Domain.class, new Annotation[0]);
        List configs = domain.getConfigs().getConfig();
        AuthRealm adminFileAuthRealm = null;
        block2: for (Config config : configs) {
            if (config.getSecurityService() == null) continue;
            for (AuthRealm auth : config.getSecurityService().getAuthRealm()) {
                if (!auth.getName().equals(ADMIN_REALM)) continue;
                adminFileAuthRealm = auth;
                continue block2;
            }
        }
        if (adminFileAuthRealm == null) {
            throw new IllegalStateException("Cannot find admin realm");
        }
        String fileRealmClassName = adminFileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals(FILE_REALM_CLASSNAME)) {
            return null;
        }
        Property keyfileProp = adminFileAuthRealm.getProperty("file");
        if (keyfileProp == null) {
            throw new IllegalStateException("Cannot find property 'file'");
        }
        String keyFile = keyfileProp.getValue();
        if (keyFile == null) {
            throw new IllegalStateException("Cannot find key file");
        }
        String user = null;
        String[] usernames = this.getUserNames(adminFileAuthRealm.getName());
        if (usernames.length == 1) {
            try {
                InjectedValues.getInstance().getHabitat().getService(SecurityLifecycle.class, new Annotation[0]);
                LoginContextDriver.login((String)usernames[0], (char[])new char[0], (String)ADMIN_REALM);
                user = usernames[0];
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return user;
    }
}

