/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.web.TomcatDeploymentConfig;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.catalina.Authenticator;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.startup.ContextConfig;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.valve.GlassFishValve;

public class WebModuleContextConfig
extends ContextConfig {
    private static final String DEFAULT_DIGEST_ALGORITHM = "default-digest-algorithm";
    private static final Logger logger = WebContainer.logger;
    protected static final ResourceBundle rb = logger.getResourceBundle();
    @LogMessageInfo(message="Configured an authenticator for method {0}", level="FINEST")
    public static final String AUTHENTICATOR_CONFIGURED = "AS-WEB-GLUE-00254";
    @LogMessageInfo(message="[{0}] failed to unbind namespace", level="WARNING")
    public static final String UNBIND_NAME_SPACE_ERROR = "AS-WEB-GLUE-00255";
    @LogMessageInfo(message="No Realm with name [{0}] configured to authenticate against", level="WARNING")
    public static final String MISSING_REALM = "AS-WEB-GLUE-00256";
    @LogMessageInfo(message="Cannot configure an authenticator for method {0}", level="WARNING")
    public static final String AUTHENTICATOR_MISSING = "AS-WEB-GLUE-00257";
    @LogMessageInfo(message="Cannot instantiate an authenticator of class {0}", level="WARNING")
    public static final String AUTHENTICATOR_INSTANTIATE_ERROR = "AS-WEB-GLUE-00258";
    public static final int CHILDREN = 0;
    public static final int SERVLET_MAPPINGS = 1;
    public static final int LOCAL_EJBS = 2;
    public static final int EJBS = 3;
    public static final int ENVIRONMENTS = 4;
    public static final int ERROR_PAGES = 5;
    public static final int FILTER_DEFS = 6;
    public static final int FILTER_MAPS = 7;
    public static final int APPLICATION_LISTENERS = 8;
    public static final int RESOURCES = 9;
    public static final int APPLICATION_PARAMETERS = 10;
    public static final int MESSAGE_DESTINATIONS = 11;
    public static final int MESSAGE_DESTINATION_REFS = 12;
    public static final int MIME_MAPPINGS = 13;
    protected ServiceLocator services;
    private WebBundleDescriptorImpl webBundleDescriptor;
    private Collection<ResourceReferenceDescriptor> resRefs = new HashSet<ResourceReferenceDescriptor>();
    private Collection<EnvironmentProperty> envProps = new HashSet<EnvironmentProperty>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebModuleContextConfig(ServiceLocator services) {
        WebModuleContextConfig webModuleContextConfig = this;
        synchronized (webModuleContextConfig) {
            this.services = services;
        }
    }

    public void setDescriptor(WebBundleDescriptorImpl wbd) {
        this.webBundleDescriptor = wbd;
    }

    public WebBundleDescriptorImpl getDescriptor() {
        return this.webBundleDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void configureResource() throws LifecycleException {
        List appParams;
        List list = appParams = this.context.findApplicationParameters();
        synchronized (list) {
            for (ApplicationParameter appParam : appParams) {
                EnvironmentProperty contextParam = new EnvironmentProperty(appParam.getName(), appParam.getValue(), appParam.getDescription());
                this.webBundleDescriptor.addContextParameter((ContextParameter)contextParam);
            }
        }
        ContextEnvironment[] envs = this.context.findEnvironments();
        for (int i = 0; i < envs.length; ++i) {
            EnvironmentProperty envEntry = new EnvironmentProperty(envs[i].getName(), envs[i].getValue(), envs[i].getDescription(), envs[i].getType());
            if (envs[i].getValue() != null) {
                envEntry.setValue(envs[i].getValue());
            }
            this.webBundleDescriptor.addEnvironmentProperty(envEntry);
            this.envProps.add(envEntry);
        }
        ContextResource[] resources = this.context.findResources();
        Set<ResourceReferenceDescriptor> rrs = this.webBundleDescriptor.getResourceReferenceDescriptors();
        for (int i = 0; i < resources.length; ++i) {
            ResourceReferenceDescriptor resourceReference = new ResourceReferenceDescriptor(resources[i].getName(), resources[i].getDescription(), resources[i].getType());
            resourceReference.setJndiName(resources[i].getName());
            for (ResourceReferenceDescriptor rr : rrs) {
                if (!resources[i].getName().equals(rr.getName())) continue;
                resourceReference.setJndiName(rr.getJndiName());
                ResourcePrincipal rp = rr.getResourcePrincipal();
                if (rp == null) continue;
                resourceReference.setResourcePrincipal(new ResourcePrincipal(rp.getName(), rp.getPassword()));
            }
            resourceReference.setAuthorization(resources[i].getAuth());
            this.webBundleDescriptor.addResourceReferenceDescriptor(resourceReference);
            this.resRefs.add(resourceReference);
        }
    }

    protected synchronized void start() throws LifecycleException {
        this.configureResource();
        this.context.setConfigured(false);
        ComponentEnvManager namingMgr = (ComponentEnvManager)this.services.getService(ComponentEnvManager.class, new Annotation[0]);
        if (namingMgr != null) {
            try {
                boolean webBundleContainsEjbs;
                boolean bl = webBundleContainsEjbs = this.webBundleDescriptor.getExtensionsDescriptors(EjbBundleDescriptor.class).size() > 0;
                if (webBundleContainsEjbs) {
                    namingMgr.addToComponentNamespace((JndiNameEnvironment)this.webBundleDescriptor, this.envProps, this.resRefs);
                } else {
                    namingMgr.bindToComponentNamespace((JndiNameEnvironment)this.webBundleDescriptor);
                }
                String componentId = namingMgr.getComponentEnvId((JndiNameEnvironment)this.webBundleDescriptor);
                ((WebModule)this.context).setComponentId(componentId);
            }
            catch (NamingException ne) {
                throw new LifecycleException((Throwable)ne);
            }
        }
        try {
            TomcatDeploymentConfig.configureWebModule((WebModule)this.context, this.webBundleDescriptor);
            this.authenticatorConfig();
            this.managerConfig();
            this.context.setConfigured(true);
        }
        catch (Throwable t) {
            this.unbindFromComponentNamespace(namingMgr);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException(t);
        }
    }

    protected synchronized void authenticatorConfig() throws LifecycleException {
        Pipeline pipeline;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)this.context).getPipeline();
            if (pipeline2 != null) {
                GlassFishValve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                GlassFishValve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        Realm rlm = this.context.getRealm();
        if (rlm == null) {
            String realmName;
            String string = realmName = this.context.getLoginConfig() != null ? this.context.getLoginConfig().getRealmName() : null;
            if (realmName != null && !realmName.isEmpty()) {
                String msg = rb.getString(MISSING_REALM);
                throw new LifecycleException(MessageFormat.format(msg, realmName));
            }
            return;
        }
        rlm.setRealmName(loginConfig.getRealmName(), loginConfig.getAuthMethod());
        GlassFishValve authenticator = null;
        if (this.customAuthenticators != null) {
            authenticator = (GlassFishValve)this.customAuthenticators.get(loginConfig.getAuthMethod());
        }
        if (authenticator == null) {
            String authenticatorName = null;
            String authMethod = loginConfig.getAuthMethod();
            if (authMethod == null) {
                authMethod = "NONE";
            }
            if ((authenticatorName = authenticators.getProperty(authMethod)) == null) {
                String msg = rb.getString(AUTHENTICATOR_MISSING);
                throw new LifecycleException(MessageFormat.format(msg, loginConfig.getAuthMethod()));
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (GlassFishValve)authenticatorClass.newInstance();
            }
            catch (Exception e) {
                String msg = rb.getString(AUTHENTICATOR_INSTANTIATE_ERROR);
                throw new LifecycleException(MessageFormat.format(msg, authenticatorName), (Throwable)e);
            }
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)this.context).getPipeline()) != null) {
            ((ContainerBase)this.context).addValve(authenticator);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, AUTHENTICATOR_CONFIGURED, loginConfig.getAuthMethod());
            }
        }
        if (authenticator instanceof DigestAuthenticator) {
            Config config = (Config)this.services.getService(Config.class, "default-instance-name", new Annotation[0]);
            SecurityService securityService = config.getSecurityService();
            String digestAlgorithm = null;
            if (securityService != null) {
                digestAlgorithm = securityService.getPropertyValue(DEFAULT_DIGEST_ALGORITHM);
            }
            if (digestAlgorithm != null) {
                DigestAuthenticator cfr_ignored_0 = (DigestAuthenticator)authenticator;
                DigestAuthenticator.setAlgorithm((String)digestAlgorithm);
            }
        }
    }

    protected void defaultConfig() {
    }

    protected synchronized void stop() {
        super.stop();
        ComponentEnvManager namingMgr = (ComponentEnvManager)this.services.getService(ComponentEnvManager.class, new Annotation[0]);
        this.unbindFromComponentNamespace(namingMgr);
    }

    private void unbindFromComponentNamespace(ComponentEnvManager namingMgr) {
        if (namingMgr != null) {
            try {
                namingMgr.unbindFromComponentNamespace((JndiNameEnvironment)this.webBundleDescriptor);
            }
            catch (NamingException ex) {
                String msg = rb.getString(UNBIND_NAME_SPACE_ERROR);
                msg = MessageFormat.format(msg, this.context.getName());
                logger.log(Level.WARNING, msg, ex);
            }
        }
    }
}

