/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.MbeanService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class DynamicInterceptor
implements MBeanServer {
    private volatile MBeanServer mDelegateMBeanServer = null;
    private static final HashMap<String, MBeanServerConnection> instanceConnections = new HashMap();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DynamicInterceptor.class);
    private static final String SERVER_PREFIX = "amx:pp=/domain/servers";
    private static final String CLUSTER_PREFIX = "amx:pp=/domain/clusters";
    private static final String CONFIG_PREFIX = "amx:pp=/domain/configs/config[";
    private static final String JSR77_PREFIX = "amx:pp=/J2EEDomain";
    private static final String MON_PREFIX = "amx:pp=/mon/server-mon[";

    public DynamicInterceptor() {
        MbeanService.getInstance();
    }

    private ReplicationInfo getTargets(ObjectName objectName) throws InstanceNotFoundException {
        String targetName;
        ReplicationInfo result = new ReplicationInfo();
        if (objectName == null) {
            result.addInstance("server");
            return result;
        }
        String oName = objectName.toString();
        if (MbeanService.getInstance() == null) {
            result.addInstance("server");
            return result;
        }
        if (objectName.getKeyProperty("type") != null && (objectName.getKeyProperty("type").equals("Mapper") || objectName.getKeyProperty("type").equals("Connector") || objectName.getKeyProperty("type").equals("Engine") || objectName.getKeyProperty("type").equals("ProtocolHandler") || objectName.getKeyProperty("type").equals("Service") || objectName.getKeyProperty("type").equals("Host") || objectName.getKeyProperty("type").equals("Loader") || objectName.getKeyProperty("type").equals("JspMonitor") || objectName.getKeyProperty("type").equals("Valve"))) {
            result.addInstance("server");
            return result;
        }
        if (this.isConfig(oName)) {
            String configName = this.getName(oName);
            if (configName != null && configName.endsWith("-config")) {
                String targetName2 = configName.substring(0, configName.indexOf("-config"));
                if (!"default".equals(targetName2) && !"server".equals(targetName2)) {
                    result.addAllInstances(MbeanService.getInstance().getInstances(configName));
                }
            } else {
                result.addInstance("server");
            }
        }
        if (this.isCluster(oName) && (targetName = this.getName(oName)) != null) {
            result.addAllInstances(MbeanService.getInstance().getInstances(targetName));
        }
        if (this.isServer(oName)) {
            targetName = this.getName(oName);
            if (targetName != null) {
                result.addInstance(targetName);
                if (!"server".equals(targetName)) {
                    result.setTargetIsAnInstance(true);
                }
            } else {
                result.addInstance("server");
            }
        }
        if (this.isJSR77(oName, objectName)) {
            String targetInstance;
            if (objectName.getKeyProperty("j2eeType") != null && objectName.getKeyProperty("j2eeType").equals("J2EEDomain")) {
                result.addInstance("server");
            } else if (objectName.getKeyProperty("j2eeType") != null && objectName.getKeyProperty("j2eeType").equals("J2EEServer")) {
                targetInstance = objectName.getKeyProperty("name");
                if (MbeanService.getInstance().isValidServer(targetInstance)) {
                    result.addInstance("server");
                    result.addInstance(targetInstance);
                }
            } else {
                targetInstance = objectName.getKeyProperty("J2EEServer");
                if (MbeanService.getInstance().isValidServer(targetInstance)) {
                    result.addInstance(targetInstance);
                }
            }
        }
        if (this.isMonitoring(oName)) {
            targetName = this.getName(oName);
            result.addInstance(targetName);
            if (!"server".equals(targetName)) {
                result.setTargetIsAnInstance(true);
            }
        }
        if ("amx:*".equals(oName) || "*.*".equals(oName)) {
            result.addInstance("server");
            result.addAllInstances(MbeanService.getInstance().getAllInstances());
        }
        if (objectName.getKeyProperty("type") != null && (objectName.getKeyProperty("type").equals("domain-root") || objectName.getKeyProperty("type").equals("domain") || objectName.getKeyProperty("type").equals("resources") || objectName.getKeyProperty("type").equals("system-applications") || objectName.getKeyProperty("type").equals("applications") || objectName.getKeyProperty("type").equals("realms") || objectName.getKeyProperty("type").equalsIgnoreCase("MBeanServerDelegate"))) {
            result.addInstance("server");
        }
        if (oName.startsWith("amx-support") || oName.startsWith("jmxremote")) {
            result.addInstance("server");
        }
        if (MbeanService.getInstance().isDas()) {
            result.addInstance("server");
            return result;
        }
        return result;
    }

    private ReplicationInfo getInstance(ObjectName o) throws InstanceNotFoundException {
        return this.getTargets(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServerConnection getInstanceConnection(String instanceName) throws InstanceNotFoundException {
        if (MbeanService.getInstance().isInstance(instanceName)) {
            return this.getDelegateMBeanServer();
        }
        if (MbeanService.getInstance().isSecureJMX(instanceName)) {
            return this.getSecureInstanceConnection(instanceName);
        }
        HashMap<String, MBeanServerConnection> hashMap = instanceConnections;
        synchronized (hashMap) {
            if (!instanceConnections.containsKey(instanceName)) {
                try {
                    String urlStr = "service:jmx:rmi:///jndi/rmi://" + MbeanService.getInstance().getHost(instanceName) + ":" + MbeanService.getInstance().getJMXPort(instanceName) + "/jmxrmi";
                    JMXServiceURL url = new JMXServiceURL(urlStr);
                    JMXConnector jmxConn = JMXConnectorFactory.connect(url);
                    MBeanServerConnection conn = jmxConn.getMBeanServerConnection();
                    instanceConnections.put(instanceName, conn);
                }
                catch (Exception ex) {
                    throw new InstanceNotFoundException(ex.getLocalizedMessage());
                }
            }
            return instanceConnections.get(instanceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServerConnection getSecureInstanceConnection(String instanceName) throws InstanceNotFoundException {
        HashMap<String, MBeanServerConnection> hashMap = instanceConnections;
        synchronized (hashMap) {
            if (!instanceConnections.containsKey(instanceName)) {
                try {
                    System.out.println("\nInitialize the environment map");
                    HashMap<String, SslRMIClientSocketFactory> env = new HashMap<String, SslRMIClientSocketFactory>();
                    SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                    env.put("com.sun.jndi.rmi.factory.socket", csf);
                    String urlStr = "service:jmx:rmi:///jndi/rmi://" + MbeanService.getInstance().getHost(instanceName) + ":" + MbeanService.getInstance().getJMXPort(instanceName) + "/jmxrmi";
                    JMXServiceURL url = new JMXServiceURL(urlStr);
                    JMXConnector jmxConn = JMXConnectorFactory.connect(url, env);
                    MBeanServerConnection conn = jmxConn.getMBeanServerConnection();
                    instanceConnections.put(instanceName, conn);
                }
                catch (Exception ex) {
                    throw new InstanceNotFoundException(ex.getLocalizedMessage());
                }
            }
            return instanceConnections.get(instanceName);
        }
    }

    public MBeanServer getDelegateMBeanServer() {
        return this.mDelegateMBeanServer;
    }

    public void setDelegateMBeanServer(MBeanServer server) {
        this.mDelegateMBeanServer = server;
    }

    @Override
    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        Object returnValue = null;
        try {
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    returnValue = this.getDelegateMBeanServer().invoke(objectName, operationName, params, signature);
                    continue;
                }
                returnValue = this.getInstanceConnection(svr).invoke(objectName, operationName, params, signature);
            }
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
        return returnValue;
    }

    @Override
    public final Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        if (!result.isTargetAnInstance()) {
            return this.getDelegateMBeanServer().getAttribute(objectName, attributeName);
        }
        try {
            return this.getInstanceConnection(result.getInstances().get(0)).getAttribute(objectName, attributeName);
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).setAttribute(objectName, attribute);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().setAttribute(objectName, attribute);
                    continue;
                }
                this.getInstanceConnection(svr).setAttribute(objectName, attribute);
            }
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    @Override
    public final AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).getAttributes(objectName, attrNames);
            }
            return this.getDelegateMBeanServer().getAttributes(objectName, attrNames);
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        AttributeList ret = null;
        try {
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).setAttributes(objectName, attributeList);
            }
            for (String svr : result.getInstances()) {
                if (result.getInstances().get(0).equals("server")) {
                    ret = this.getDelegateMBeanServer().setAttributes(objectName, attributeList);
                    continue;
                }
                ret = this.getInstanceConnection(svr).setAttributes(objectName, attributeList);
            }
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
        return ret;
    }

    @Override
    public final ObjectInstance registerMBean(Object obj, ObjectName objectName) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        return this.getDelegateMBeanServer().registerMBean(obj, objectName);
    }

    @Override
    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).unregisterMBean(objectName);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().unregisterMBean(objectName);
                    continue;
                }
                this.getInstanceConnection(svr).unregisterMBean(objectName);
            }
        }
        catch (IOException io) {
            throw new MBeanRegistrationException(io);
        }
    }

    @Override
    public final Integer getMBeanCount() {
        return this.getDelegateMBeanServer().getMBeanCount();
    }

    public final Set queryMBeans(ObjectName objectName, QueryExp expr) {
        try {
            Set<ObjectInstance> returnVal = null;
            List<String> instance = this.getInstance(objectName).getInstances();
            for (String ins : instance) {
                Set<ObjectInstance> tmp = ins.equals("server") ? this.getDelegateMBeanServer().queryMBeans(objectName, expr) : this.getInstanceConnection(ins).queryMBeans(objectName, expr);
                if (returnVal == null) {
                    returnVal = tmp;
                    continue;
                }
                returnVal.addAll(tmp);
            }
            return returnVal;
        }
        catch (Exception e) {
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public final MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).getMBeanInfo(objectName);
            }
            return this.getDelegateMBeanServer().getMBeanInfo(objectName);
        }
        catch (IOException ioex) {
            throw new ReflectionException(ioex);
        }
    }

    @Override
    public final boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            return false;
        }
        try {
            List<String> instance = this.getInstance(objectName).getInstances();
            for (String instanceName : instance) {
                if (!instanceName.equals(System.getProperty("com.sun.aas.instanceName"))) continue;
                return this.getDelegateMBeanServer().isRegistered(objectName);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).addNotificationListener(objectName, notificationListener, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().addNotificationListener(objectName, notificationListener, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).addNotificationListener(objectName, notificationListener, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    @Override
    public final void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).addNotificationListener(objectName, objectName1, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if ("server".equals(svr)) {
                    this.getDelegateMBeanServer().addNotificationListener(objectName, objectName1, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).addNotificationListener(objectName, objectName1, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    @Override
    public final ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(str, objectName, null, null);
    }

    @Override
    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(str, objectName, objectName2, null, null);
    }

    @Override
    public final ObjectInstance createMBean(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            ReplicationInfo result = this.getInstance(objectName);
            ObjectInstance ret = null;
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).createMBean(str, objectName, obj, str3);
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    ret = this.getDelegateMBeanServer().createMBean(str, objectName, obj, str3);
                    continue;
                }
                ret = this.getInstanceConnection(svr).createMBean(str, objectName, obj, str3);
            }
            return ret;
        }
        catch (InstanceNotFoundException ex) {
            throw new MBeanException(ex);
        }
        catch (IOException ex) {
            throw new MBeanException(ex);
        }
    }

    @Override
    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2, Object[] obj, String[] str4) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            ReplicationInfo result = this.getInstance(objectName);
            ObjectInstance ret = null;
            if (result.isTargetAnInstance()) {
                return this.getInstanceConnection(result.getInstances().get(0)).createMBean(str, objectName, objectName2, obj, str4);
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    ret = this.getDelegateMBeanServer().createMBean(str, objectName, objectName2, obj, str4);
                    continue;
                }
                ret = this.getInstanceConnection(svr).createMBean(str, objectName, objectName2, obj, str4);
            }
            return ret;
        }
        catch (InstanceNotFoundException ex) {
            throw new MBeanException(ex);
        }
        catch (IOException ex) {
            throw new MBeanException(ex);
        }
    }

    @Override
    public final ObjectInputStream deserialize(String str, byte[] values) throws OperationsException, ReflectionException {
        return this.getDelegateMBeanServer().deserialize(str, values);
    }

    @Override
    public final ObjectInputStream deserialize(ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException {
        return this.getDelegateMBeanServer().deserialize(objectName, values);
    }

    @Override
    public final ObjectInputStream deserialize(String str, ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.getDelegateMBeanServer().deserialize(str, objectName, values);
    }

    @Override
    public final String getDefaultDomain() {
        return this.getDelegateMBeanServer().getDefaultDomain();
    }

    @Override
    public final ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        List<String> instance = this.getInstance(objectName).getInstances();
        if (instance.size() != 1) {
            throw new InstanceNotFoundException(localStrings.getLocalString("interceptor.objectName.wrongservernames", "This mbean call does not support multiple target instances"));
        }
        if (instance.get(0).equals("server")) {
            return this.getDelegateMBeanServer().getObjectInstance(objectName);
        }
        try {
            return this.getInstanceConnection(instance.get(0)).getObjectInstance(objectName);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    @Override
    public final Object instantiate(String str) throws ReflectionException, MBeanException {
        return this.getDelegateMBeanServer().instantiate(str);
    }

    @Override
    public final Object instantiate(String str, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().instantiate(str, objectName);
    }

    @Override
    public final Object instantiate(String str, Object[] obj, String[] str2) throws ReflectionException, MBeanException {
        return this.getDelegateMBeanServer().instantiate(str, obj, str2);
    }

    @Override
    public final Object instantiate(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().instantiate(str, objectName, obj, str3);
    }

    @Override
    public final boolean isInstanceOf(ObjectName objectName, String str) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        List<String> instance = this.getInstance(objectName).getInstances();
        if (instance.size() != 1) {
            throw new InstanceNotFoundException(localStrings.getLocalString("interceptor.objectName.wrongservernames", "This mbean call does not support multiple target instances"));
        }
        if (instance.get(0).equals("server")) {
            return this.getDelegateMBeanServer().isInstanceOf(objectName, str);
        }
        try {
            return this.getInstanceConnection(instance.get(0)).isInstanceOf(objectName, str);
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    public final Set queryNames(ObjectName objectName, QueryExp queryExp) {
        List<String> instance;
        Set<ObjectName> returnVal = null;
        try {
            instance = this.getInstance(objectName).getInstances();
        }
        catch (InstanceNotFoundException e) {
            return Collections.EMPTY_SET;
        }
        for (String ins : instance) {
            Set<ObjectName> tmp = null;
            if (ins.equals("server")) {
                tmp = this.getDelegateMBeanServer().queryNames(objectName, queryExp);
            } else {
                try {
                    tmp = this.getInstanceConnection(ins).queryNames(objectName, queryExp);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tmp == null) continue;
            if (returnVal == null) {
                returnVal = tmp;
                continue;
            }
            returnVal.addAll(tmp);
        }
        if (returnVal == null) {
            return Collections.EMPTY_SET;
        }
        return returnVal;
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, objectName1);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, objectName1);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, notificationListener);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, notificationListener);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        ReplicationInfo result = this.getInstance(objectName);
        try {
            if (result.isTargetAnInstance()) {
                this.getInstanceConnection(result.getInstances().get(0)).removeNotificationListener(objectName, objectName1, notificationFilter, obj);
                return;
            }
            for (String svr : result.getInstances()) {
                if (svr.equals("server")) {
                    this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1, notificationFilter, obj);
                    continue;
                }
                this.getInstanceConnection(svr).removeNotificationListener(objectName, objectName1, notificationFilter, obj);
            }
        }
        catch (IOException ioex) {
            throw new InstanceNotFoundException(ioex.getLocalizedMessage());
        }
    }

    @Override
    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().getClassLoader(objectName);
    }

    @Override
    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException();
        }
        return this.getDelegateMBeanServer().getClassLoaderFor(objectName);
    }

    @Override
    public final ClassLoaderRepository getClassLoaderRepository() {
        return this.getDelegateMBeanServer().getClassLoaderRepository();
    }

    @Override
    public final String[] getDomains() {
        return this.getDelegateMBeanServer().getDomains();
    }

    private boolean isConfig(String oName) {
        return oName.startsWith(CONFIG_PREFIX);
    }

    private boolean isCluster(String oName) {
        return oName.startsWith(CLUSTER_PREFIX);
    }

    private boolean isServer(String oName) {
        return oName.startsWith(SERVER_PREFIX);
    }

    private boolean isJSR77(String oName, ObjectName o) {
        if (o.getKeyProperty("j2eeType") != null) {
            return true;
        }
        return oName.startsWith(JSR77_PREFIX);
    }

    private boolean isMonitoring(String oName) {
        return oName.startsWith(MON_PREFIX);
    }

    private String getName(String oName) {
        if (oName.indexOf("[") != -1) {
            return oName.substring(oName.indexOf("[") + 1, oName.indexOf("]"));
        }
        return null;
    }

    private static class ReplicationInfo {
        private boolean instanceTarget = false;
        private List<String> instances = new ArrayList<String>();

        private ReplicationInfo() {
        }

        boolean isTargetAnInstance() {
            return this.instanceTarget;
        }

        void setTargetIsAnInstance(boolean b) {
            this.instanceTarget = b;
        }

        List<String> getInstances() {
            return this.instances;
        }

        void addInstance(String s) {
            if (!this.instances.contains(s)) {
                this.instances.add(s);
            }
        }

        void addAllInstances(List list) {
            this.instances.addAll(list);
        }
    }
}

