/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.LabelAdapter;
import org.rssowl.core.persist.event.LabelEvent;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.SearchMarkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ITask;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.TaskAdapter;
import org.rssowl.ui.internal.ApplicationActionBarAdvisor;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.StatusLineUpdater;
import org.rssowl.ui.internal.actions.ArchiveNewsAction;
import org.rssowl.ui.internal.actions.AutomateFilterAction;
import org.rssowl.ui.internal.actions.CreateFilterAction;
import org.rssowl.ui.internal.actions.MakeNewsStickyAction;
import org.rssowl.ui.internal.actions.MarkAllNewsReadAction;
import org.rssowl.ui.internal.actions.MoveCopyNewsToBinAction;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.OpenInExternalBrowserAction;
import org.rssowl.ui.internal.actions.OpenNewsAction;
import org.rssowl.ui.internal.actions.ToggleReadStateAction;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.IFeedViewPart;
import org.rssowl.ui.internal.editors.feed.IFeedViewSite;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsColumnViewModel;
import org.rssowl.ui.internal.editors.feed.NewsComparator;
import org.rssowl.ui.internal.editors.feed.NewsContentProvider;
import org.rssowl.ui.internal.editors.feed.NewsTableLabelProvider;
import org.rssowl.ui.internal.editors.feed.NewsTableViewer;
import org.rssowl.ui.internal.undo.NewsStateOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.CTree;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.JobTracker;
import org.rssowl.ui.internal.util.ModelUtils;

public class NewsTableControl
implements IFeedViewPart {
    private IFeedViewSite fFeedViewSite;
    private MarkReadTracker fNewsStateTracker;
    private MarkReadTracker fInstantMarkUnreadTracker;
    private NewsTableViewer fViewer;
    private NewsTableLabelProvider fNewsTableLabelProvider;
    private ISelectionChangedListener fSelectionChangeListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private CTree fCustomTree;
    private int[] fOldColumnOrder;
    private LocalResourceManager fResources;
    private NewsComparator fNewsSorter;
    private Cursor fHandCursor;
    private boolean fShowsHandCursor;
    private final AtomicBoolean fBlockNewsStateTracker = new AtomicBoolean(false);
    private LabelAdapter fLabelListener;
    private IPreferenceScope fInputPreferences;
    private final INewsDAO fNewsDao = Owl.getPersistenceService().getDAOService().getNewsDAO();
    private NewsColumnViewModel fColumnModel;
    private FeedViewInput fEditorInput;
    private boolean fBlockColumMoveEvent;
    private IStructuredSelection fLastSelection = StructuredSelection.EMPTY;
    private IStructuredSelection fLastNonEmptySelection = StructuredSelection.EMPTY;
    private long fLastColumnActionInvokedMillies;
    private Menu fAttachmentsMenu;
    private IPreferenceScope fGlobalPreferences;

    public void init(IFeedViewSite feedViewSite) {
        this.fFeedViewSite = feedViewSite;
        this.fGlobalPreferences = Owl.getPreferenceService().getGlobalScope();
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fInstantMarkUnreadTracker = new MarkReadTracker(0, false);
    }

    public void onInputChanged(FeedViewInput input) {
        this.fEditorInput = input;
        this.fInputPreferences = Owl.getPreferenceService().getEntityScope((IEntity)input.getMark());
        if (this.fNewsStateTracker != null) {
            this.fNewsStateTracker.cancel();
        }
        this.fInstantMarkUnreadTracker.cancel();
        this.fNewsStateTracker = new MarkReadTracker(this.fInputPreferences.getInteger(DefaultPreferences.MARK_READ_IN_MILLIS), false);
        this.fNewsStateTracker.setUpdateDelayDynamically(true);
    }

    public void onLayoutChanged(OwlUI.Layout newLayout) {
    }

    public void createPart(Composite parent) {
        int style = 65538;
        this.fCustomTree = new CTree(parent, style);
        this.fCustomTree.getControl().setHeaderVisible(true);
        this.fViewer = new NewsTableViewer(this.fCustomTree.getControl());
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.setUseHashlookup(true);
        this.fViewer.getControl().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        this.fViewer.getControl().setFont(OwlUI.getThemeFont("org.rssowl.ui.HeadlinesFont", 0));
        FeedColumnToolTipSupport.enableFor((ColumnViewer)this.fViewer);
        this.fViewer.setAutoExpandLevel(-1);
        this.fHandCursor = parent.getDisplay().getSystemCursor(21);
        this.initDragAndDrop();
    }

    IStructuredSelection getLastSelection() {
        return this.fLastSelection;
    }

    IStructuredSelection getLastNonEmptySelection() {
        return this.fLastNonEmptySelection;
    }

    private void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), URLTransfer.getInstance()};
        this.fViewer.addDragSupport(ops, transfers, new DragSourceListener(){

            public void dragStart(final DragSourceEvent event) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        LocalSelectionTransfer.getTransfer().setSelection(NewsTableControl.this.fViewer.getSelection());
                        LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                        event.doit = true;
                    }
                });
            }

            public void dragSetData(final DragSourceEvent event) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                            event.data = LocalSelectionTransfer.getTransfer().getSelection();
                        } else if (TextTransfer.getInstance().isSupportedType(event.dataType) || URLTransfer.getInstance().isSupportedType(event.dataType)) {
                            NewsTableControl.this.setTextData(event);
                        }
                    }
                });
            }

            public void dragFinished(DragSourceEvent event) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        LocalSelectionTransfer.getTransfer().setSelection(null);
                        LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
                    }
                });
            }
        });
    }

    private void setTextData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Collection<INews> news = ModelUtils.normalize(selection.toList());
        if (!news.isEmpty()) {
            StringBuilder strB = new StringBuilder();
            for (INews item : news) {
                String link = CoreUtils.getLink((INews)item);
                if (!StringUtils.isSet((String)link)) continue;
                strB.append(link);
                if (news.size() <= 1) continue;
                strB.append("\n");
            }
            if (strB.length() > 0) {
                event.data = strB.toString();
            }
        }
    }

    public NewsTableViewer getViewer() {
        return this.fViewer;
    }

    public void initViewer(IStructuredContentProvider contentProvider, ViewerFilter filter) {
        this.fViewer.setContentProvider((IContentProvider)contentProvider);
        NewsColumnViewModel columnModel = this.createColumnModel(this.fEditorInput.getMark());
        this.fNewsTableLabelProvider = new NewsTableLabelProvider(columnModel);
        if (!OwlUI.isHighContrast()) {
            this.fViewer.getControl().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    Object element = event.item.getData();
                    NewsTableControl.this.fNewsTableLabelProvider.erase(event, element);
                }
            });
        }
        this.fNewsSorter = new NewsComparator();
        this.fViewer.setComparator(this.fNewsSorter);
        this.fViewer.setComparer(this.getComparer());
        this.fCustomTree.setFlat(!this.isGroupingEnabled());
        this.showColumns(columnModel, false, false);
        this.fViewer.addFilter(filter);
        this.hookContextualMenu();
        this.registerListeners();
        this.fFeedViewSite.getEditorSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    void updateColumns(Object input) {
        this.showColumns(this.createColumnModel(input), true, true);
    }

    private NewsColumnViewModel createColumnModel(Object input) {
        NewsColumnViewModel model = input instanceof IFolderChild ? NewsColumnViewModel.loadFrom(Owl.getPreferenceService().getEntityScope((IEntity)input)) : NewsColumnViewModel.createGlobal();
        if ((input instanceof ISearchMark || input instanceof INewsBin || input instanceof FolderNewsMark) && !model.getColumns().contains((Object)NewsColumn.FEED) && !model.getColumns().contains((Object)NewsColumn.LOCATION) && !this.isGroupingByFeed()) {
            model.getColumns().add(1, NewsColumn.FEED);
        }
        return model;
    }

    private boolean isGroupingEnabled() {
        IContentProvider contentProvider = this.fViewer.getContentProvider();
        if (contentProvider != null && contentProvider instanceof NewsContentProvider) {
            return ((NewsContentProvider)contentProvider).isGroupingEnabled();
        }
        return false;
    }

    private boolean isGroupingByFeed() {
        IContentProvider contentProvider = this.fViewer.getContentProvider();
        if (contentProvider != null && contentProvider instanceof NewsContentProvider) {
            return ((NewsContentProvider)contentProvider).isGroupingByFeed();
        }
        return false;
    }

    private boolean isGroupingByStickyness() {
        IContentProvider contentProvider = this.fViewer.getContentProvider();
        if (contentProvider != null && contentProvider instanceof NewsContentProvider) {
            return ((NewsContentProvider)contentProvider).isGroupingByStickyness();
        }
        return false;
    }

    private void showColumns(NewsColumnViewModel newModel, boolean update, boolean refresh) {
        TreeColumn[] columns;
        if (this.fCustomTree.getControl().isDisposed()) {
            return;
        }
        if (newModel.equals(this.fColumnModel)) {
            return;
        }
        this.fBlockColumMoveEvent = true;
        try {
            this.fCustomTree.clear();
        }
        finally {
            this.fBlockColumMoveEvent = false;
        }
        this.fColumnModel = newModel;
        List<NewsColumn> cols = newModel.getColumns();
        int i = 0;
        while (i < cols.size()) {
            NewsColumn col = cols.get(i);
            TreeViewerColumn viewerColumn = new TreeViewerColumn((TreeViewer)this.fViewer, 16384);
            this.fCustomTree.manageColumn(viewerColumn.getColumn(), newModel.getLayoutData(col), col.showName() ? col.getName() : null, col.showTooltip() ? col.getName() : null, null, col.isMoveable(), col.isResizable());
            if (i == 0) {
                viewerColumn.getColumn().setResizable(true);
            }
            viewerColumn.getColumn().setData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier", (Object)col);
            if (newModel.getSortColumn() == col && col.showSortIndicator()) {
                this.fCustomTree.getControl().setSortColumn(viewerColumn.getColumn());
                this.fCustomTree.getControl().setSortDirection(newModel.isAscending() ? 128 : 1024);
            }
            ++i;
        }
        this.fOldColumnOrder = this.fCustomTree.getControl().getColumnOrder();
        if (update) {
            this.fCustomTree.update();
        }
        this.fNewsSorter.setAscending(newModel.isAscending());
        this.fNewsSorter.setSortBy(newModel.getSortColumn());
        this.fNewsTableLabelProvider.init(newModel);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fNewsTableLabelProvider);
        if (refresh) {
            this.fViewer.refresh(true);
        }
        TreeColumn[] treeColumnArray = columns = this.fCustomTree.getControl().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            final TreeColumn column = treeColumnArray[n2];
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewsColumn oldSortBy = NewsTableControl.this.fNewsSorter.getSortBy();
                    NewsColumn newSortBy = (NewsColumn)((Object)column.getData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier"));
                    boolean defaultAscending = newSortBy.prefersAscending();
                    boolean ascending = oldSortBy != newSortBy ? defaultAscending : !NewsTableControl.this.fNewsSorter.isAscending();
                    NewsTableControl.this.fColumnModel.setSortColumn(newSortBy);
                    NewsTableControl.this.fColumnModel.setAscending(ascending);
                    NewsTableControl.this.fNewsSorter.setSortBy(newSortBy);
                    NewsTableControl.this.fNewsSorter.setAscending(ascending);
                    if (newSortBy.showSortIndicator()) {
                        NewsTableControl.this.fCustomTree.getControl().setSortColumn(column);
                        NewsTableControl.this.fCustomTree.getControl().setSortDirection(ascending ? 128 : 1024);
                    } else {
                        NewsTableControl.this.fCustomTree.getControl().setSortColumn(null);
                    }
                    NewsTableControl.this.fViewer.refresh(false);
                    NewsTableControl.this.saveColumnModelInBackground();
                }
            });
            column.addListener(10, new Listener(){

                public void handleEvent(Event event) {
                    if (NewsTableControl.this.fCustomTree.getControl().isDisposed() || NewsTableControl.this.fBlockColumMoveEvent) {
                        return;
                    }
                    int[] columnOrder = NewsTableControl.this.fCustomTree.getControl().getColumnOrder();
                    if (!Arrays.equals(NewsTableControl.this.fOldColumnOrder, columnOrder)) {
                        NewsTableControl.this.fOldColumnOrder = columnOrder;
                        NewsColumnViewModel currentModel = NewsColumnViewModel.initializeFrom(NewsTableControl.this.fCustomTree.getControl());
                        currentModel.setSortColumn(NewsTableControl.this.fNewsSorter.getSortBy());
                        currentModel.setAscending(NewsTableControl.this.fNewsSorter.isAscending());
                        if (!currentModel.equals(NewsTableControl.this.fColumnModel)) {
                            NewsTableControl.this.fColumnModel = currentModel;
                            NewsTableControl.this.saveColumnModelInBackground();
                        }
                    }
                }
            });
            ++n2;
        }
    }

    private void registerListeners() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewsTableControl.this.onMouseDoubleClick(event);
            }
        });
        this.fViewer.addSelectionChangedListener(new StatusLineUpdater(this.fFeedViewSite.getEditorSite().getActionBars().getStatusLineManager()));
        this.fSelectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewsTableControl.this.onSelectionChanged(event);
            }
        };
        this.fViewer.addSelectionChangedListener(this.fSelectionChangeListener);
        this.fCustomTree.getControl().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                NewsTableControl.this.onMouseDown(event);
            }
        });
        this.fCustomTree.getControl().addListener(4, new Listener(){

            public void handleEvent(Event event) {
                NewsTableControl.this.onMouseUp(event);
            }
        });
        this.fCustomTree.getControl().addListener(5, new Listener(){

            public void handleEvent(Event event) {
                NewsTableControl.this.onMouseMove(event);
            }
        });
        this.fLabelListener = new LabelAdapter(){

            public void entitiesUpdated(Set<LabelEvent> events) {
                JobRunner.runInUIThread((Widget)NewsTableControl.this.fViewer.getTree(), new Runnable(){

                    public void run() {
                        NewsTableControl.this.fViewer.refresh(true);
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(ILabel.class, (EntityListener)this.fLabelListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (NewsTableControl.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                if ("org.rssowl.ui.StickyBGColor".equals(event.getProperty()) || "org.rssowl.ui.NewsListBackgroundColor".equals(event.getProperty())) {
                    ((NewsTableLabelProvider)NewsTableControl.this.fViewer.getLabelProvider()).updateResources();
                    NewsTableControl.this.fViewer.refresh(true);
                    NewsTableControl.this.fViewer.getTree().redraw();
                }
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void onMouseDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object firstElem = selection.getFirstElement();
        if (firstElem instanceof INews) {
            if (System.currentTimeMillis() - this.fLastColumnActionInvokedMillies > 200L) {
                new OpenInBrowserAction(selection, WebBrowserContext.createFrom((INews)firstElem, this.fEditorInput.getMark())).run();
            }
        } else if (firstElem instanceof EntityGroup) {
            this.fViewer.setExpandedState(firstElem, !this.fViewer.getExpandedState(firstElem));
        }
    }

    private void onSelectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        this.fLastSelection = (IStructuredSelection)event.getSelection();
        if (!this.fLastSelection.isEmpty()) {
            this.fLastNonEmptySelection = this.fLastSelection;
        }
        if (this.fBlockNewsStateTracker.get()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof INews)) {
            this.fNewsStateTracker.cancel();
            this.fInstantMarkUnreadTracker.cancel();
            return;
        }
        final INews selectedNews = (INews)selection.getFirstElement();
        if (selectedNews.getState() != INews.State.READ && selectedNews.isVisible()) {
            boolean markRead = this.fInputPreferences.getBoolean(DefaultPreferences.MARK_READ_STATE);
            int delay = this.fNewsStateTracker.getDelay();
            if (!(markRead && delay <= 0 || selectedNews.getState() == INews.State.UNREAD)) {
                this.fInstantMarkUnreadTracker.run((ITask)new TaskAdapter(){

                    public IStatus run(IProgressMonitor monitor) {
                        NewsTableControl.this.setNewsState(selectedNews, INews.State.UNREAD, true);
                        return Status.OK_STATUS;
                    }
                });
            }
            if (markRead && delay == 0) {
                this.setNewsState(selectedNews, INews.State.READ, false);
            } else if (markRead) {
                this.fNewsStateTracker.run((ITask)new TaskAdapter(){

                    public IStatus run(IProgressMonitor monitor) {
                        NewsTableControl.this.setNewsState(selectedNews, INews.State.READ, true);
                        return Status.OK_STATUS;
                    }
                });
            }
        } else if (selectedNews.getState() == INews.State.READ) {
            this.fNewsStateTracker.cancel();
            this.fInstantMarkUnreadTracker.cancel();
        }
    }

    private void onMouseUp(Event event) {
        if (event.button == 2) {
            Point p = new Point(event.x, event.y);
            TreeItem item = this.fCustomTree.getControl().getItem(p);
            if (item == null || item.isDisposed()) {
                return;
            }
            Object element = item.getData();
            if (element instanceof INews) {
                new OpenInBrowserAction((IStructuredSelection)new StructuredSelection(element), WebBrowserContext.createFrom((INews)element, this.fEditorInput.getMark())).run();
            }
        }
    }

    private void onMouseDown(Event event) {
        Point p = new Point(event.x, event.y);
        TreeItem item = this.fCustomTree.getControl().getItem(p);
        if (item == null || item.isDisposed()) {
            return;
        }
        if (event.button == 1 && this.isInImageBounds(item, NewsColumn.TITLE, p)) {
            Object data = item.getData();
            if (data instanceof INews) {
                INews news = (INews)data;
                INews.State newState = news.getState() == INews.State.READ ? INews.State.UNREAD : INews.State.READ;
                this.fBlockNewsStateTracker.set(true);
                try {
                    this.setNewsState(news, newState, false);
                }
                finally {
                    this.fBlockNewsStateTracker.set(false);
                }
                this.fLastColumnActionInvokedMillies = System.currentTimeMillis();
                JobRunner.runDelayedFlagInversion(200, this.fBlockNewsStateTracker);
            }
        } else if (event.button == 1 && this.isInImageBounds(item, NewsColumn.STICKY, p)) {
            final Object data = item.getData();
            if (data instanceof INews) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        new MakeNewsStickyAction((IStructuredSelection)new StructuredSelection(data)).run();
                    }
                };
                INews news = (INews)data;
                if (news.getState() != INews.State.READ && this.isGroupingByStickyness()) {
                    JobRunner.runInBackgroundThread(50, runnable);
                } else {
                    runnable.run();
                }
                this.fLastColumnActionInvokedMillies = System.currentTimeMillis();
            }
        } else if (event.button == 1 && this.isInImageBounds(item, NewsColumn.ATTACHMENTS, p)) {
            Object data = item.getData();
            MenuManager contextMenu = new MenuManager();
            ApplicationActionBarAdvisor.fillAttachmentsMenu((IMenuManager)contextMenu, (IStructuredSelection)new StructuredSelection(data), (IShellProvider)this.fFeedViewSite.getEditorSite(), true);
            if (this.fAttachmentsMenu != null) {
                OwlUI.safeDispose(this.fAttachmentsMenu);
            }
            this.fAttachmentsMenu = contextMenu.createContextMenu(this.fViewer.getControl());
            Point cursorLocation = item.getDisplay().getCursorLocation();
            cursorLocation.y += 16;
            this.fAttachmentsMenu.setLocation(cursorLocation);
            this.fAttachmentsMenu.setVisible(true);
            this.fLastColumnActionInvokedMillies = System.currentTimeMillis();
        }
    }

    private void onMouseMove(Event event) {
        boolean changeToHandCursor;
        Point p = new Point(event.x, event.y);
        TreeItem item = this.fCustomTree.getControl().getItem(p);
        if (item == null || item.isDisposed() || item.getData() instanceof EntityGroup) {
            if (this.fShowsHandCursor && !this.fCustomTree.getControl().isDisposed()) {
                this.fCustomTree.getControl().setCursor(null);
                this.fShowsHandCursor = false;
            }
            return;
        }
        boolean bl = changeToHandCursor = this.isInImageBounds(item, NewsColumn.TITLE, p) || this.isInImageBounds(item, NewsColumn.STICKY, p) || this.isInImageBounds(item, NewsColumn.ATTACHMENTS, p);
        if (!this.fShowsHandCursor && changeToHandCursor) {
            this.fCustomTree.getControl().setCursor(this.fHandCursor);
            this.fShowsHandCursor = true;
        } else if (this.fShowsHandCursor && !changeToHandCursor) {
            this.fCustomTree.getControl().setCursor(null);
            this.fShowsHandCursor = false;
        }
    }

    private IElementComparer getComparer() {
        return new IElementComparer(){

            public boolean equals(Object a, Object b) {
                if (a == b) {
                    return true;
                }
                if (a instanceof ModelReference && b instanceof IEntity) {
                    return ((ModelReference)a).references((IEntity)b);
                }
                if (b instanceof ModelReference && a instanceof IEntity) {
                    return ((ModelReference)b).references((IEntity)a);
                }
                return a.equals(b);
            }

            public int hashCode(Object element) {
                return element.hashCode();
            }
        };
    }

    private void hookContextualMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean entityGroupSelected;
                IStructuredSelection selection = (IStructuredSelection)NewsTableControl.this.fViewer.getSelection();
                boolean isEntityGroupSelected = ModelUtils.isEntityGroupSelected((ISelection)selection);
                if (!isEntityGroupSelected) {
                    manager.add((IContributionItem)new Separator("open"));
                    if (!selection.isEmpty() && !OwlUI.useExternalBrowser()) {
                        manager.add((IAction)new OpenInExternalBrowserAction(selection));
                    }
                }
                ApplicationActionBarAdvisor.fillAttachmentsMenu(manager, selection, (IShellProvider)new SameShellProvider((Control)NewsTableControl.this.fViewer.getTree().getShell()), false);
                manager.add((IContributionItem)new Separator("mark"));
                MenuManager markMenu = new MenuManager(Messages.NewsTableControl_MARK, "mark");
                manager.add((IContributionItem)markMenu);
                Action action = new ToggleReadStateAction(selection);
                action.setEnabled(!selection.isEmpty());
                markMenu.add((IAction)action);
                action = new MarkAllNewsReadAction();
                markMenu.add((IAction)action);
                markMenu.add((IContributionItem)new Separator());
                action = new MakeNewsStickyAction(selection);
                action.setEnabled(!selection.isEmpty());
                markMenu.add((IAction)action);
                ApplicationActionBarAdvisor.fillLabelMenu(manager, selection, (IShellProvider)new SameShellProvider((Control)NewsTableControl.this.fViewer.getTree().getShell()), false);
                if (!selection.isEmpty()) {
                    manager.add((IContributionItem)new Separator("movecopy"));
                    ArrayList newsbins = new ArrayList(DynamicDAO.loadAll(INewsBin.class));
                    Comparator<INewsBin> comparator = new Comparator<INewsBin>(){

                        @Override
                        public int compare(INewsBin o1, INewsBin o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    };
                    Collections.sort(newsbins, comparator);
                    MenuManager moveMenu = new MenuManager(Messages.NewsTableControl_MOVE_TO, "moveto");
                    manager.add((IContributionItem)moveMenu);
                    for (INewsBin bin : newsbins) {
                        if (NewsTableControl.this.fViewer.getInput() instanceof NewsBinReference && bin.getId().equals(((NewsBinReference)NewsTableControl.this.fViewer.getInput()).getId())) continue;
                        moveMenu.add((IAction)new MoveCopyNewsToBinAction(selection, bin, true));
                    }
                    moveMenu.add((IAction)new MoveCopyNewsToBinAction(selection, null, true));
                    moveMenu.add((IContributionItem)new Separator());
                    moveMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.MOVE, (ISelection)selection));
                    MenuManager copyMenu = new MenuManager(Messages.NewsTableControl_COPY_TO, "copyto");
                    manager.add((IContributionItem)copyMenu);
                    for (INewsBin bin : newsbins) {
                        if (NewsTableControl.this.fViewer.getInput() instanceof NewsBinReference && bin.getId().equals(((NewsBinReference)NewsTableControl.this.fViewer.getInput()).getId())) continue;
                        copyMenu.add((IAction)new MoveCopyNewsToBinAction(selection, bin, false));
                    }
                    copyMenu.add((IAction)new MoveCopyNewsToBinAction(selection, null, false));
                    copyMenu.add((IContributionItem)new Separator());
                    copyMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.COPY, (ISelection)selection));
                    manager.add((IAction)new ArchiveNewsAction(selection));
                }
                if (!(entityGroupSelected = ModelUtils.isEntityGroupSelected((ISelection)selection))) {
                    ApplicationActionBarAdvisor.fillShareMenu(manager, selection, (IShellProvider)new SameShellProvider((Control)NewsTableControl.this.fViewer.getTree().getShell()), false);
                }
                manager.add((IContributionItem)new Separator("filter"));
                manager.add((IContributionItem)new Separator("copy"));
                manager.add((IContributionItem)new GroupMarker("edit"));
                if (entityGroupSelected) {
                    manager.add((IContributionItem)new Separator());
                    ImageDescriptor icon = OwlUI.getImageDescriptor("icons/etool16/collapseall.gif");
                    manager.add((IAction)new Action(Messages.NewsTableControl_COLLAPSE_GROUPS, icon){

                        public void run() {
                            NewsTableControl.this.fViewer.getControl().setRedraw(false);
                            try {
                                NewsTableControl.this.fViewer.collapseAll();
                            }
                            finally {
                                NewsTableControl.this.fViewer.getControl().setRedraw(true);
                            }
                        }
                    });
                }
                manager.add((IContributionItem)new Separator("additions"));
                if (NewsTableControl.this.fViewer.getInput() instanceof SearchMarkReference && !selection.isEmpty() && !isEntityGroupSelected) {
                    OpenNewsAction showInFeedAction = new OpenNewsAction(selection);
                    showInFeedAction.setText(Messages.NewsTableControl_SHOW_IN_FEED);
                    manager.appendToGroup("open", (IAction)showInFeedAction);
                }
            }
        });
        Menu menu = manager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.fFeedViewSite.getEditorSite().registerContextMenu(manager, (ISelectionProvider)this.fViewer);
    }

    public void setPartInput(Object input) {
        this.showColumns(this.createColumnModel(input), true, false);
        if (input instanceof IEntity) {
            this.fViewer.setInput(((IEntity)input).toReference());
        } else {
            this.fViewer.setInput(input);
        }
    }

    public void adjustScrollPosition() {
        Tree tree = this.fViewer.getTree();
        int itemCount = tree.getItemCount();
        if (itemCount > 0) {
            if ((this.fNewsSorter.getSortBy() == NewsColumn.DATE || this.fNewsSorter.getSortBy() == NewsColumn.PUBLISHED || this.fNewsSorter.getSortBy() == NewsColumn.MODIFIED || this.fNewsSorter.getSortBy() == NewsColumn.RECEIVED) && this.fNewsSorter.isAscending()) {
                TreeItem item = tree.getItem(itemCount - 1);
                int childCount = item.getItemCount();
                if (childCount != 0) {
                    item = item.getItem(childCount - 1);
                }
                tree.showItem(item);
            } else {
                tree.setTopItem(tree.getItem(0));
            }
        }
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.fAttachmentsMenu != null) {
            OwlUI.safeDispose(this.fAttachmentsMenu);
        }
        this.fNewsStateTracker.cancel();
        this.fInstantMarkUnreadTracker.cancel();
        this.fResources.dispose();
        this.unregisterListeners();
        this.fEditorInput = null;
    }

    void setBlockNewsStateTracker(boolean block) {
        this.fBlockNewsStateTracker.set(block);
    }

    private void unregisterListeners() {
        this.fViewer.removeSelectionChangedListener(this.fSelectionChangeListener);
        DynamicDAO.removeEntityListener(ILabel.class, (EntityListener)this.fLabelListener);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    private void setNewsState(final INews news, final INews.State state, boolean async) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!news.isVisible()) {
                    return;
                }
                Set<INews> singleNewsSet = Collections.singleton(news);
                boolean affectEquivalentNews = state != INews.State.UNREAD && OwlUI.markReadDuplicates();
                UndoStack.getInstance().addOperation(new NewsStateOperation(singleNewsSet, state, affectEquivalentNews));
                NewsTableControl.this.fNewsDao.setState(singleNewsSet, state, affectEquivalentNews, false);
            }
        };
        if (async) {
            JobRunner.runInUIThread((Widget)this.fViewer.getControl(), runnable);
        } else {
            runnable.run();
        }
    }

    private int indexOf(NewsColumn column) {
        Tree tree = this.fCustomTree.getControl();
        if (tree.isDisposed()) {
            return -1;
        }
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (column == columns[i].getData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isInImageBounds(TreeItem item, NewsColumn column, Point p) {
        int index = this.indexOf(column);
        if (index == -1) {
            return false;
        }
        return item.getImageBounds(index).contains(p);
    }

    private void saveColumnModelInBackground() {
        final IPreferenceScope[] scope = new IPreferenceScope[1];
        final boolean[] saveMark = new boolean[1];
        final INewsMark mark = this.fEditorInput.getMark();
        IPreferenceScope entityPrefs = Owl.getPreferenceService().getEntityScope((IEntity)mark);
        if (entityPrefs.hasKey(DefaultPreferences.BM_NEWS_COLUMNS) || entityPrefs.hasKey(DefaultPreferences.BM_NEWS_SORT_COLUMN) || entityPrefs.hasKey(DefaultPreferences.BM_NEWS_SORT_ASCENDING)) {
            scope[0] = entityPrefs;
            saveMark[0] = true;
        } else {
            scope[0] = this.fGlobalPreferences;
        }
        final NewsColumnViewModel modelCopy = new NewsColumnViewModel(this.fColumnModel);
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                modelCopy.saveTo(scope[0]);
                if (saveMark[0]) {
                    if (mark instanceof FolderNewsMark) {
                        DynamicDAO.save((IPersistable)((FolderNewsMark)mark).getFolder());
                    } else {
                        DynamicDAO.save((IPersistable)mark);
                    }
                }
            }
        });
    }

    private static class FeedColumnToolTipSupport
    extends ColumnViewerToolTipSupport {
        FeedColumnToolTipSupport(ColumnViewer viewer, int style) {
            super(viewer, style, false);
        }

        protected Object getToolTipArea(Event event) {
            int feedIndex;
            Tree tree = (Tree)event.widget;
            Point point = new Point(event.x, event.y);
            TreeItem item = tree.getItem(point);
            if (item != null && (feedIndex = FeedColumnToolTipSupport.indexOf(tree, NewsColumn.FEED)) >= 0 && item.getBounds(feedIndex).contains(point)) {
                return super.getToolTipArea(event);
            }
            return null;
        }

        private static int indexOf(Tree tree, NewsColumn column) {
            if (tree.isDisposed()) {
                return -1;
            }
            TreeColumn[] columns = tree.getColumns();
            int i = 0;
            while (i < columns.length) {
                if (column == columns[i].getData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier")) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public static void enableFor(ColumnViewer viewer) {
            new FeedColumnToolTipSupport(viewer, 2);
        }
    }

    private class MarkReadTracker
    extends JobTracker {
        private boolean fUpdateDelayDynamically;

        MarkReadTracker(int delay, boolean showProgress) {
            super(delay, showProgress, ITask.Priority.INTERACTIVE);
        }

        public int getDelay() {
            if (this.fUpdateDelayDynamically) {
                return NewsTableControl.this.fInputPreferences.getInteger(DefaultPreferences.MARK_READ_IN_MILLIS);
            }
            return super.getDelay();
        }

        public void setUpdateDelayDynamically(boolean updateDelayDynamically) {
            this.fUpdateDelayDynamically = updateDelayDynamically;
        }
    }
}

