/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.LongArrayList;
import org.rssowl.core.internal.persist.SearchMark;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.NewsAdapter;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.NewsListener;
import org.rssowl.core.persist.event.SearchMarkAdapter;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.BookMarkReference;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.reference.SearchMarkReference;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.SearchHit;
import org.rssowl.core.util.Triple;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewer;
import org.rssowl.ui.internal.editors.feed.NewsComparator;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.editors.feed.NewsTableViewer;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.util.UIBackgroundJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsContentProvider
implements ITreeContentProvider {
    static final int MAX_FOLDER_ELEMENTS = 500;
    private static final int MAX_RESOLVED_FOLDER_ELEMENTS = 5000;
    private static final int NEWSMARK_SCOPE_SEARCH_LIMIT = 200;
    private static final int BOOKMARK_SCOPE_SEARCH_LIMIT = 500;
    private static final String NO_FOLDER_LIMIT_PROPERTY = "noFolderLimit";
    private final NewsBrowserViewer fBrowserViewer;
    private final NewsTableViewer fTableViewer;
    private final NewsGrouping fGrouping;
    private final NewsFilter fFilter;
    private NewsListener fNewsListener;
    private SearchMarkAdapter fSearchMarkListener;
    private INewsMark fInput;
    private final FeedView fFeedView;
    private final AtomicBoolean fDisposed = new AtomicBoolean(false);
    private final INewsDAO fNewsDao;
    private final IModelFactory fFactory;
    private final IModelSearch fSearch;
    private final boolean fNoFolderLimit;
    private final Map<Long, INews> fCachedNews;

    public NewsContentProvider(NewsTableViewer tableViewer, NewsBrowserViewer browserViewer, FeedView feedView) {
        this.fTableViewer = tableViewer;
        this.fBrowserViewer = browserViewer;
        this.fFeedView = feedView;
        this.fGrouping = feedView.getGrouper();
        this.fFilter = feedView.getFilter();
        this.fCachedNews = new HashMap<Long, INews>();
        this.fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
        this.fFactory = Owl.getModelFactory();
        this.fSearch = Owl.getPersistenceService().getModelSearch();
        this.fNoFolderLimit = System.getProperty(NO_FOLDER_LIMIT_PROPERTY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object inputElement) {
        Object[] objects;
        ArrayList<Object> elements = new ArrayList<Object>();
        if (!(inputElement instanceof Object[])) {
            inputElement = new Object[]{inputElement};
        }
        Object[] objectArray = objects = (Object[])inputElement;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object news;
            Object newsRef;
            Object object = objectArray[n2];
            if (object instanceof INews && ((INews)object).isVisible()) {
                elements.add(object);
            } else if (object instanceof NewsReference) {
                newsRef = (NewsReference)object;
                news = this.obtainFromCache((NewsReference)newsRef);
                if (news != null) {
                    elements.add(news);
                }
            } else if (object instanceof FeedLinkReference) {
                newsRef = this;
                synchronized (newsRef) {
                    news = this.fCachedNews.values();
                    if (news != null) {
                        if (this.fGrouping.getType() == NewsGrouping.Type.NO_GROUPING) {
                            elements.addAll((Collection<Object>)news);
                        } else {
                            elements.addAll(this.fGrouping.group((Collection<INews>)news));
                        }
                    }
                }
            } else if (object instanceof ModelReference) {
                Class entityClass = ((ModelReference)object).getEntityClass();
                if (IMark.class.isAssignableFrom(entityClass) || IFolder.class.isAssignableFrom(entityClass)) {
                    news = this;
                    synchronized (news) {
                        Collection<INews> news2 = this.fCachedNews.values();
                        if (news2 != null) {
                            if (this.fGrouping.getType() == NewsGrouping.Type.NO_GROUPING) {
                                elements.addAll(news2);
                            } else {
                                elements.addAll(this.fGrouping.group(news2));
                            }
                        }
                    }
                }
            } else if (object instanceof EntityGroup) {
                EntityGroup group = (EntityGroup)object;
                List<EntityGroupItem> items = group.getItems();
                for (EntityGroupItem item : items) {
                    if (!((INews)item.getEntity()).isVisible()) continue;
                    elements.add(item.getEntity());
                }
            }
            ++n2;
        }
        return elements.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<IEntity> children = new ArrayList<IEntity>();
        if (parentElement instanceof EntityGroup) {
            List<EntityGroupItem> items = ((EntityGroup)parentElement).getItems();
            for (EntityGroupItem item : items) {
                children.add(item.getEntity());
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        Collection<EntityGroup> groups;
        if (this.fGrouping.isActive() && element instanceof INews && (groups = this.fGrouping.group(Collections.singletonList((INews)element))).size() == 1) {
            return groups.iterator().next();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof EntityGroup;
    }

    public synchronized void dispose() {
        this.fDisposed.set(true);
        this.unregisterListeners();
        this.fCachedNews.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    boolean isGroupingEnabled() {
        return this.fGrouping.getType() != NewsGrouping.Type.NO_GROUPING;
    }

    boolean isGroupingByFeed() {
        return this.fGrouping.getType() == NewsGrouping.Type.GROUP_BY_FEED;
    }

    boolean isGroupingByStickyness() {
        return this.fGrouping.getType() == NewsGrouping.Type.GROUP_BY_STICKY;
    }

    boolean isGroupingByLabel() {
        return this.fGrouping.getType() == NewsGrouping.Type.GROUP_BY_LABEL;
    }

    boolean isGroupingByState() {
        return this.fGrouping.getType() == NewsGrouping.Type.GROUP_BY_STATE;
    }

    synchronized void refreshCache(IProgressMonitor monitor, INewsMark input) throws PersistenceException {
        this.refreshCache(monitor, input, null);
    }

    synchronized void refreshCache(IProgressMonitor monitor, INewsMark input, NewsComparator comparer) throws PersistenceException {
        HashMap<Long, INews> cacheCopy = null;
        if (this.fInput != null && this.fInput.equals(input)) {
            cacheCopy = new HashMap<Long, INews>(this.fCachedNews);
        }
        this.fInput = input;
        if (this.fNewsListener == null) {
            this.registerListeners();
        }
        this.fCachedNews.clear();
        if (this.canceled(monitor)) {
            return;
        }
        List<INews> resolvedNews = new ArrayList<INews>();
        if (this.canceled(monitor)) {
            return;
        }
        NewsFilter.Type filter = this.fFilter.getType();
        Set<Object> states = filter == NewsFilter.Type.SHOW_NEW ? EnumSet.of(INews.State.NEW) : (filter == NewsFilter.Type.SHOW_UNREAD ? EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED) : INews.State.getVisible());
        boolean needToFilter = true;
        if (input.isGetNewsRefsEfficient() || input instanceof IBookMark && this.shouldResolveBookMarkWithSearch((IBookMark)input, filter)) {
            Triple<Boolean, Boolean, List<NewsReference>> result = this.getNewsRefsFromInput(input, this.fFilter, states, monitor);
            needToFilter = (Boolean)result.getFirst() == false;
            List newsReferences = (List)result.getThird();
            for (NewsReference newsRef : newsReferences) {
                if (this.canceled(monitor)) {
                    return;
                }
                INews resolvedNewsItem = null;
                if (cacheCopy != null) {
                    resolvedNewsItem = (INews)cacheCopy.get(newsRef.getId());
                }
                if (resolvedNewsItem == null) {
                    resolvedNewsItem = (INews)this.fNewsDao.load(newsRef.getId());
                }
                if (resolvedNewsItem != null && resolvedNewsItem.isVisible()) {
                    resolvedNews.add(resolvedNewsItem);
                } else if (((Boolean)result.getSecond()).booleanValue()) {
                    CoreUtils.reportIndexIssue();
                }
                if (input instanceof FolderNewsMark && !this.fNoFolderLimit && resolvedNews.size() > 5000) break;
            }
            if (input instanceof FolderNewsMark) {
                resolvedNews = this.limitFolderNewsMark(resolvedNews, comparer != null ? comparer : this.fFeedView.getComparator());
            }
        } else if (this.shouldResolve(input, filter)) {
            resolvedNews.addAll(input.getNews(states));
        }
        if (needToFilter && this.isFilteredByOtherThanState()) {
            this.filterElements(resolvedNews);
        }
        if (this.canceled(monitor)) {
            return;
        }
        for (INews news : resolvedNews) {
            this.fCachedNews.put(news.getId(), news);
        }
    }

    private boolean shouldResolveBookMarkWithSearch(IBookMark input, NewsFilter.Type filter) {
        if (filter == NewsFilter.Type.SHOW_ALL) {
            return false;
        }
        if (filter == NewsFilter.Type.SHOW_NEW || filter == NewsFilter.Type.SHOW_UNREAD) {
            return false;
        }
        if (input.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)) > 500) {
            return true;
        }
        return !this.hasRetentionLimit(input);
    }

    private boolean hasRetentionLimit(IBookMark bookmark) {
        IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)bookmark);
        if (preferences.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE)) {
            return true;
        }
        if (preferences.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE)) {
            return true;
        }
        return preferences.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE) && preferences.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE) <= 500;
    }

    private boolean shouldResolve(INewsMark input, NewsFilter.Type filter) {
        Date mostRecentNewsDate;
        if (filter == NewsFilter.Type.SHOW_NEW && input.getNewsCount(EnumSet.of(INews.State.NEW)) == 0) {
            return false;
        }
        if (filter == NewsFilter.Type.SHOW_UNREAD && input.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)) == 0) {
            return false;
        }
        if (filter == NewsFilter.Type.SHOW_STICKY && input instanceof IBookMark && ((IBookMark)input).getStickyNewsCount() == 0) {
            return false;
        }
        if ((filter == NewsFilter.Type.SHOW_RECENT || filter == NewsFilter.Type.SHOW_LAST_5_DAYS) && input instanceof IBookMark && (mostRecentNewsDate = ((IBookMark)input).getMostRecentNewsDate()) != null) {
            if (filter == NewsFilter.Type.SHOW_RECENT && mostRecentNewsDate.getTime() < DateUtils.getToday().getTimeInMillis() - 86400000L) {
                return false;
            }
            if (filter == NewsFilter.Type.SHOW_LAST_5_DAYS && mostRecentNewsDate.getTime() < DateUtils.getToday().getTimeInMillis() - 432000000L) {
                return false;
            }
        }
        return true;
    }

    private Triple<Boolean, Boolean, List<NewsReference>> getNewsRefsFromInput(INewsMark input, NewsFilter newsFilter, Set<INews.State> states, IProgressMonitor monitor) {
        NewsFilter.Type filter = newsFilter.getType();
        if (input instanceof ISearchMark || input instanceof INewsBin) {
            if (this.isFilteredByOtherThanState() && input.getNewsCount(states) > 200) {
                ISearchCondition filterCondition = ModelUtils.getConditionForFilter(filter);
                List result = null;
                if (input instanceof ISearchMark) {
                    ISearchMark searchMark = (ISearchMark)input;
                    result = this.fSearch.searchNews((Collection)searchMark.getSearchConditions(), filterCondition, searchMark.matchAllConditions());
                } else {
                    INewsBin newsBin = (INewsBin)input;
                    ISearchField locationField = this.fFactory.createSearchField(19, INews.class.getName());
                    ISearchCondition locationCondition = this.fFactory.createSearchCondition(locationField, SearchSpecifier.IS, (Object)ModelUtils.toPrimitive(Collections.singleton(newsBin)));
                    result = this.fSearch.searchNews(Arrays.asList(locationCondition, filterCondition), true);
                }
                ArrayList<NewsReference> newsRefs = new ArrayList<NewsReference>(result.size());
                for (SearchHit item : result) {
                    newsRefs.add((NewsReference)item.getResult());
                }
                return Triple.create((Object)true, (Object)true, newsRefs);
            }
        } else {
            if (input instanceof IBookMark) {
                IBookMark bookmark = (IBookMark)input;
                if (!this.shouldResolve((INewsMark)bookmark, filter)) {
                    return Triple.create((Object)true, (Object)false, Collections.emptyList());
                }
                ISearchCondition filterCondition = ModelUtils.getConditionForFilter(filter);
                ISearchField locationField = this.fFactory.createSearchField(19, INews.class.getName());
                ISearchCondition locationCondition = this.fFactory.createSearchCondition(locationField, SearchSpecifier.IS, (Object)ModelUtils.toPrimitive(Collections.singleton(bookmark)));
                List result = this.fSearch.searchNews(Arrays.asList(locationCondition, filterCondition), true);
                ArrayList<NewsReference> newsRefs = new ArrayList<NewsReference>(result.size());
                for (SearchHit item : result) {
                    newsRefs.add((NewsReference)item.getResult());
                }
                return Triple.create((Object)true, (Object)true, newsRefs);
            }
            if (input instanceof FolderNewsMark) {
                ((FolderNewsMark)input).resolve(filter, monitor);
                List references = input.getNewsRefs(states);
                if (!this.fNoFolderLimit && input.getNewsCount(states) > 500 && newsFilter.isPatternSet()) {
                    Iterator iterator = references.iterator();
                    while (iterator.hasNext()) {
                        if (newsFilter.isTextPatternMatch(((NewsReference)iterator.next()).getId())) continue;
                        iterator.remove();
                    }
                }
                if (!this.fNoFolderLimit && references.size() > 5000) {
                    this.sortDescendingById(references);
                }
                return Triple.create((Object)true, (Object)true, (Object)references);
            }
        }
        return Triple.create((Object)false, (Object)false, (Object)input.getNewsRefs(states));
    }

    private void sortDescendingById(List<NewsReference> references) {
        Collections.sort(references, new Comparator<NewsReference>(){

            @Override
            public int compare(NewsReference o1, NewsReference o2) {
                return o1.getId() > o2.getId() ? -1 : 1;
            }
        });
    }

    private synchronized Triple<Boolean, Collection<NewsEvent>, Collection<INews>> addToCache(Collection<NewsEvent> events, Collection<INews> addedNews) {
        boolean wasEmpty = this.fCachedNews.isEmpty();
        Collection<Object> visibleEvents = new ArrayList();
        Collection<Object> visibleNews = new ArrayList();
        if (this.canceled()) {
            return Triple.create((Object)wasEmpty, visibleEvents, visibleNews);
        }
        if (this.isFilteredByState() || this.isFilteredByOtherThanState()) {
            HashMap<INews, NewsEvent> hashMap = new HashMap<INews, NewsEvent>(events.size());
            for (NewsEvent newsEvent : events) {
                hashMap.put(newsEvent.getEntity(), newsEvent);
            }
            visibleNews.addAll(addedNews);
            this.filterElements(visibleNews);
            for (INews iNews : visibleNews) {
                visibleEvents.add((NewsEvent)hashMap.get(iNews));
            }
        } else {
            visibleEvents = events;
            visibleNews = addedNews;
        }
        for (INews iNews : visibleNews) {
            this.fCachedNews.put(iNews.getId(), iNews);
        }
        if (this.fInput instanceof FolderNewsMark) {
            ((FolderNewsMark)this.fInput).add(visibleNews);
        }
        return Triple.create((Object)wasEmpty, visibleEvents, visibleNews);
    }

    private synchronized Pair<List<NewsEvent>, List<INews>> updateCache(Set<NewsEvent> events, List<INews> updatedNews) {
        ArrayList<NewsEvent> visibleEvents = new ArrayList<NewsEvent>(events.size());
        ArrayList<INews> visibleNews = new ArrayList<INews>(updatedNews.size());
        if (this.canceled()) {
            return Pair.create(visibleEvents, visibleNews);
        }
        for (NewsEvent event : events) {
            if (event.getEntity().getId() == null || !this.fCachedNews.containsKey(event.getEntity().getId())) continue;
            visibleEvents.add(event);
            visibleNews.add(event.getEntity());
        }
        return Pair.create(visibleEvents, visibleNews);
    }

    private synchronized Pair<List<NewsEvent>, List<INews>> removeFromCache(Set<NewsEvent> events, List<INews> deletedNews) {
        ArrayList<NewsEvent> visibleEvents = new ArrayList<NewsEvent>(events.size());
        ArrayList<INews> visibleNews = new ArrayList<INews>(deletedNews.size());
        if (this.canceled()) {
            return Pair.create(visibleEvents, visibleNews);
        }
        for (NewsEvent event : events) {
            if (event.getEntity().getId() == null || this.fCachedNews.remove(event.getEntity().getId()) == null) continue;
            visibleEvents.add(event);
            visibleNews.add(event.getEntity());
        }
        if (this.fInput instanceof FolderNewsMark) {
            ((FolderNewsMark)this.fInput).remove(deletedNews);
        }
        return Pair.create(visibleEvents, visibleNews);
    }

    private synchronized Pair<List<INews>, Boolean> newsChangedFromSearch(IProgressMonitor monitor, List<SearchMarkEvent> eventsRelatedToInput, boolean onlyHandleAddedNews) {
        if (this.canceled(monitor)) {
            return Pair.create(Collections.emptyList(), (Object)false);
        }
        boolean needToFilter = true;
        boolean wasEmpty = this.fCachedNews.isEmpty();
        ArrayList<INews> addedNews = new ArrayList<INews>();
        if (this.fInput instanceof ISearchMark) {
            if (!onlyHandleAddedNews) {
                this.refreshCache(monitor, this.fInput);
                addedNews.addAll(this.fCachedNews.values());
                needToFilter = false;
            } else {
                Set<Long> newsIds = this.extractNewsIds(eventsRelatedToInput);
                for (Long newsId : newsIds) {
                    if (this.hasCachedNews(newsId)) continue;
                    INews news = (INews)this.fNewsDao.load(newsId.longValue());
                    if (news != null && news.isVisible()) {
                        addedNews.add(news);
                    }
                    if (!this.canceled(monitor)) continue;
                    return Pair.create(Collections.emptyList(), (Object)false);
                }
            }
        } else if (this.fInput instanceof FolderNewsMark) {
            FolderNewsMark folderNewsMark = (FolderNewsMark)this.fInput;
            Set<Long> newsIds = this.extractNewsIds(eventsRelatedToInput);
            for (Long newsId : newsIds) {
                if (this.hasCachedNews(newsId) || folderNewsMark.containsNews(newsId)) continue;
                INews news = (INews)this.fNewsDao.load(newsId.longValue());
                if (news != null && news.isVisible()) {
                    addedNews.add(news);
                }
                if (!this.canceled(monitor)) continue;
                return Pair.create(Collections.emptyList(), (Object)false);
            }
        }
        if (this.canceled(monitor)) {
            return Pair.create(Collections.emptyList(), (Object)false);
        }
        if (needToFilter && this.isFilteredByOtherThanState()) {
            this.filterElements(addedNews);
        }
        for (INews news : addedNews) {
            this.fCachedNews.put(news.getId(), news);
        }
        if (this.fInput instanceof FolderNewsMark) {
            ((FolderNewsMark)this.fInput).add(addedNews);
        }
        return Pair.create(addedNews, (Object)wasEmpty);
    }

    private boolean isFilteredByState() {
        return this.fFilter.getType() == NewsFilter.Type.SHOW_NEW || this.fFilter.getType() == NewsFilter.Type.SHOW_UNREAD;
    }

    private boolean isFilteredByOtherThanState() {
        return this.fFilter.getType() == NewsFilter.Type.SHOW_STICKY || this.fFilter.getType() == NewsFilter.Type.SHOW_LABELED || this.fFilter.getType() == NewsFilter.Type.SHOW_RECENT || this.fFilter.getType() == NewsFilter.Type.SHOW_LAST_5_DAYS;
    }

    private void filterElements(Collection<INews> elements) {
        Iterator<INews> iterator = elements.iterator();
        while (iterator.hasNext()) {
            if (this.fFilter.select(iterator.next(), true)) continue;
            iterator.remove();
        }
    }

    private Set<Long> extractNewsIds(List<SearchMarkEvent> events) {
        HashSet<Long> set = new HashSet<Long>();
        for (SearchMarkEvent event : events) {
            LongArrayList[] newsIds = ((SearchMark)event.getEntity()).internalGetNewsContainer().internalGetNewsIds();
            int i = 0;
            while (i < newsIds.length) {
                if (!(i == INews.State.HIDDEN.ordinal() || i == INews.State.DELETED.ordinal() || this.fFilter.getType() == NewsFilter.Type.SHOW_NEW && i != INews.State.NEW.ordinal() || this.fFilter.getType() == NewsFilter.Type.SHOW_UNREAD && i == INews.State.READ.ordinal())) {
                    long[] elements;
                    long[] lArray = elements = newsIds[i].getElements();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long element = lArray[n2];
                        if (element > 0L) {
                            set.add(element);
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return set;
    }

    private List<INews> limitFolderNewsMark(List<INews> resolvedNews, NewsComparator comparer) {
        if (this.fNoFolderLimit || resolvedNews.size() <= 500) {
            return resolvedNews;
        }
        List<INews> priorityItems = Collections.emptyList();
        if (this.isGroupingByLabel() || this.isGroupingByStickyness()) {
            priorityItems = new ArrayList();
            for (INews news : resolvedNews) {
                if ((!this.isGroupingByLabel() || news.getLabels().isEmpty()) && (!this.isGroupingByStickyness() || !news.isFlagged())) continue;
                priorityItems.add(news);
            }
        }
        if (priorityItems.size() >= 500) {
            return priorityItems;
        }
        Object[] elements = resolvedNews.toArray();
        comparer.sort(null, elements);
        int limit = 500 - priorityItems.size();
        ArrayList<INews> limitedResult = new ArrayList<INews>(Math.min(elements.length, 500));
        int i = 0;
        int c = 0;
        while (i < elements.length && c < limit) {
            INews news = (INews)elements[i];
            if (!priorityItems.contains(news)) {
                limitedResult.add(news);
                ++c;
            }
            ++i;
        }
        limitedResult.addAll(priorityItems);
        return limitedResult;
    }

    synchronized INewsMark getInput() {
        return this.fInput;
    }

    synchronized Collection<INews> getCachedNewsCopy() {
        return new ArrayList<INews>(this.fCachedNews.values());
    }

    synchronized boolean hasCachedNews() {
        return !this.fCachedNews.isEmpty();
    }

    synchronized boolean hasCachedNews(INews news) {
        return news.getId() != null && this.hasCachedNews(news.getId());
    }

    private synchronized boolean hasCachedNews(long newsId) {
        return this.fCachedNews.containsKey(newsId);
    }

    private synchronized INews obtainFromCache(NewsReference ref) {
        return this.obtainFromCache(ref.getId());
    }

    synchronized INews obtainFromCache(long newsId) {
        return this.fCachedNews.get(newsId);
    }

    private void registerListeners() {
        this.fSearchMarkListener = new SearchMarkAdapter(){

            public void newsChanged(Set<SearchMarkEvent> events) {
                final ArrayList<SearchMarkEvent> eventsRelatedToInput = new ArrayList<SearchMarkEvent>(1);
                if (NewsContentProvider.this.canceled()) {
                    return;
                }
                for (SearchMarkEvent event : events) {
                    ISearchMark searchMark = event.getEntity();
                    if (NewsContentProvider.this.fInput.equals(searchMark)) {
                        eventsRelatedToInput.add(event);
                        break;
                    }
                    if (!(NewsContentProvider.this.fInput instanceof FolderNewsMark) || !((FolderNewsMark)NewsContentProvider.this.fInput).isRelatedTo(searchMark)) continue;
                    eventsRelatedToInput.add(event);
                }
                if (NewsContentProvider.this.canceled()) {
                    return;
                }
                if (!eventsRelatedToInput.isEmpty()) {
                    JobRunner.runInUIThread((Widget)NewsContentProvider.this.fFeedView.getEditorControl(), new Runnable(){

                        public void run() {
                            final boolean onlyHandleAddedNews = NewsContentProvider.this.fFeedView.isVisible();
                            JobRunner.runUIUpdater(new UIBackgroundJob((Control)NewsContentProvider.this.fFeedView.getEditorControl()){
                                private List<INews> fAddedNews;
                                private boolean fWasEmpty;

                                protected void runInBackground(IProgressMonitor monitor) {
                                    if (NewsContentProvider.this.canceled(monitor)) {
                                        return;
                                    }
                                    Pair result = NewsContentProvider.this.newsChangedFromSearch(monitor, eventsRelatedToInput, onlyHandleAddedNews);
                                    this.fAddedNews = (List)result.getFirst();
                                    this.fWasEmpty = (Boolean)result.getSecond();
                                }

                                protected void runInUI(IProgressMonitor monitor) {
                                    if (NewsContentProvider.this.canceled(monitor)) {
                                        return;
                                    }
                                    if (onlyHandleAddedNews && (this.fAddedNews == null || this.fAddedNews.size() == 0)) {
                                        return;
                                    }
                                    if (!NewsContentProvider.this.browserShowsCollection()) {
                                        NewsContentProvider.this.fFeedView.refreshTableViewer(true, true);
                                    } else if (NewsContentProvider.this.canDoBrowserRefresh(this.fWasEmpty)) {
                                        NewsContentProvider.this.fFeedView.refreshBrowserViewer();
                                    } else {
                                        NewsContentProvider.this.fFeedView.getNewsBrowserControl().setInfoBarVisible(true);
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
            }
        };
        DynamicDAO.addEntityListener(ISearchMark.class, (EntityListener)this.fSearchMarkListener);
        this.fNewsListener = new NewsAdapter(){

            public void entitiesAdded(final Set<NewsEvent> events) {
                JobRunner.runInUIThread((Widget)NewsContentProvider.this.fFeedView.getEditorControl(), new Runnable(){

                    public void run() {
                        HashSet<NewsEvent> addedNews = null;
                        if (NewsContentProvider.this.canceled()) {
                            return;
                        }
                        for (NewsEvent event : events) {
                            if (event.getEntity().isVisible() && NewsContentProvider.this.isInputRelatedTo(event, NewsEventType.PERSISTED)) {
                                if (addedNews == null) {
                                    addedNews = new HashSet<NewsEvent>();
                                }
                                addedNews.add(event);
                            }
                            if (!NewsContentProvider.this.canceled()) continue;
                            return;
                        }
                        if (addedNews == null || addedNews.size() == 0) {
                            return;
                        }
                        boolean refresh = NewsContentProvider.this.handleAddedNews(addedNews);
                        if (refresh) {
                            if (!NewsContentProvider.this.browserShowsCollection()) {
                                NewsContentProvider.this.fFeedView.refreshTableViewer(true, false);
                            } else {
                                NewsContentProvider.this.fFeedView.refresh(true, false);
                            }
                        }
                    }
                });
            }

            public void entitiesUpdated(final Set<NewsEvent> events) {
                JobRunner.runInUIThread((Widget)NewsContentProvider.this.fFeedView.getEditorControl(), new Runnable(){

                    public void run() {
                        HashSet<NewsEvent> restoredNews = null;
                        HashSet<NewsEvent> updatedNews = null;
                        HashSet<NewsEvent> deletedNews = null;
                        if (NewsContentProvider.this.canceled()) {
                            return;
                        }
                        for (NewsEvent event : events) {
                            boolean isRestored = NewsContentProvider.this.gotRestored(event, NewsContentProvider.this.fFilter.getType());
                            INews news = event.getEntity();
                            if (NewsContentProvider.this.canceled()) {
                                return;
                            }
                            if (!NewsContentProvider.this.isInputRelatedTo(event, isRestored ? NewsEventType.RESTORED : NewsEventType.UPDATED)) continue;
                            if (!news.isVisible()) {
                                if (deletedNews == null) {
                                    deletedNews = new HashSet<NewsEvent>();
                                }
                                deletedNews.add(event);
                                continue;
                            }
                            if (isRestored) {
                                if (restoredNews == null) {
                                    restoredNews = new HashSet<NewsEvent>();
                                }
                                restoredNews.add(event);
                                continue;
                            }
                            if (updatedNews == null) {
                                updatedNews = new HashSet<NewsEvent>();
                            }
                            updatedNews.add(event);
                        }
                        if (NewsContentProvider.this.canceled()) {
                            return;
                        }
                        boolean refresh = false;
                        boolean updateSelectionFromDelete = false;
                        if (restoredNews != null && !restoredNews.isEmpty()) {
                            refresh = NewsContentProvider.this.handleAddedNews(restoredNews);
                        }
                        if (updatedNews != null && !updatedNews.isEmpty()) {
                            refresh = NewsContentProvider.this.handleUpdatedNews(updatedNews);
                        }
                        if (deletedNews != null && !deletedNews.isEmpty()) {
                            updateSelectionFromDelete = refresh = NewsContentProvider.this.handleDeletedNews(deletedNews);
                        }
                        if (NewsContentProvider.this.canceled()) {
                            return;
                        }
                        if (updateSelectionFromDelete) {
                            NewsContentProvider.this.fTableViewer.updateSelectionAfterDelete(new Runnable(){

                                public void run() {
                                    NewsContentProvider.this.refreshViewers(events, NewsEventType.REMOVED);
                                }
                            });
                        } else if (refresh) {
                            NewsContentProvider.this.refreshViewers(events, NewsEventType.UPDATED);
                        }
                    }
                });
            }

            public void entitiesDeleted(final Set<NewsEvent> events) {
                JobRunner.runInUIThread((Widget)NewsContentProvider.this.fFeedView.getEditorControl(), new Runnable(){

                    public void run() {
                        HashSet<NewsEvent> deletedNews = null;
                        if (NewsContentProvider.this.canceled()) {
                            return;
                        }
                        for (NewsEvent event : events) {
                            INews news = event.getEntity();
                            if ((news.isVisible() || news.getParentId() != 0L) && NewsContentProvider.this.isInputRelatedTo(event, NewsEventType.REMOVED)) {
                                if (deletedNews == null) {
                                    deletedNews = new HashSet<NewsEvent>();
                                }
                                deletedNews.add(event);
                            }
                            if (!NewsContentProvider.this.canceled()) continue;
                            return;
                        }
                        if (deletedNews == null || deletedNews.size() == 0) {
                            return;
                        }
                        boolean refresh = NewsContentProvider.this.handleDeletedNews(deletedNews);
                        if (NewsContentProvider.this.canceled()) {
                            return;
                        }
                        if (refresh) {
                            if (!NewsContentProvider.this.browserShowsCollection()) {
                                NewsContentProvider.this.fFeedView.refreshTableViewer(true, false);
                            } else {
                                NewsContentProvider.this.fFeedView.refresh(true, false);
                            }
                        }
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(INews.class, (EntityListener)this.fNewsListener);
    }

    private boolean gotRestored(NewsEvent event, NewsFilter.Type filter) {
        INews news = event.getEntity();
        INews old = event.getOldNews();
        if (news == null || old == null || !news.isVisible() || this.hasCachedNews(news)) {
            return false;
        }
        INews.State newState = news.getState();
        INews.State oldState = old.getState();
        if (oldState == INews.State.HIDDEN || oldState == INews.State.DELETED) {
            return true;
        }
        switch (filter) {
            case SHOW_NEW: {
                return newState == INews.State.NEW && oldState != INews.State.NEW;
            }
            case SHOW_UNREAD: {
                return newState != INews.State.READ && oldState == INews.State.READ;
            }
            case SHOW_STICKY: {
                return CoreUtils.isStickyStateChange(Collections.singleton(event), (boolean)true);
            }
            case SHOW_LABELED: {
                return CoreUtils.isLabelChange(Collections.singleton(event), (boolean)true);
            }
        }
        return false;
    }

    private void refreshViewers(Set<NewsEvent> events, NewsEventType type) {
        if (this.canceled()) {
            return;
        }
        if (!this.browserShowsCollection()) {
            ArrayList<INews> items = new ArrayList<INews>(events.size());
            for (NewsEvent event : events) {
                items.add(event.getEntity());
            }
            if (this.fFeedView.isBrowserViewerVisible() && this.contains(this.fBrowserViewer.getInput(), items)) {
                if (type == NewsEventType.UPDATED) {
                    NewsEvent event;
                    Set<NewsEvent> newsToUpdate = events;
                    if (events.size() > 1 && (event = this.findShowingEventFromBrowser(events)) != null) {
                        newsToUpdate = Collections.singleton(event);
                    }
                    this.fBrowserViewer.update(newsToUpdate);
                } else if (type == NewsEventType.REMOVED) {
                    this.fBrowserViewer.remove(items.toArray());
                }
            }
            if (this.canceled()) {
                return;
            }
            this.fFeedView.refreshTableViewer(true, true);
        } else {
            this.fFeedView.refresh(true, true);
        }
    }

    private boolean handleAddedNews(Set<NewsEvent> events) {
        if (this.fFeedView.isTableViewerVisible() && this.fTableViewer.getInput() == null) {
            return false;
        }
        ArrayList<INews> addedNews = new ArrayList<INews>(events.size());
        for (NewsEvent event : events) {
            addedNews.add(event.getEntity());
        }
        Triple<Boolean, Collection<NewsEvent>, Collection<INews>> result = this.addToCache(events, addedNews);
        boolean wasEmpty = (Boolean)result.getFirst();
        Collection visibleEvents = (Collection)result.getSecond();
        Collection visibleNews = (Collection)result.getThird();
        if (this.fGrouping.needsRefresh(visibleEvents, false) && (!this.browserShowsCollection() || this.canDoBrowserRefresh(wasEmpty, visibleEvents))) {
            return true;
        }
        if (this.canceled()) {
            return false;
        }
        this.addToViewers(visibleNews, visibleEvents, wasEmpty);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addToViewers(Collection<INews> addedNews, Collection<NewsEvent> events, boolean wasEmpty) {
        if (this.canceled()) {
            return;
        }
        if (addedNews.isEmpty()) {
            return;
        }
        if (this.fFeedView.isTableViewerVisible()) {
            Tree tree = this.fTableViewer.getTree();
            TreeItem topItem = tree.getTopItem();
            int indexOfTopItem = 0;
            if (topItem != null) {
                indexOfTopItem = tree.indexOf(topItem);
            }
            tree.setRedraw(false);
            try {
                this.fTableViewer.add(this.fTableViewer.getInput(), addedNews.toArray());
                if (topItem == null || indexOfTopItem == 0) return;
                tree.setTopItem(topItem);
                return;
            }
            finally {
                tree.setRedraw(true);
            }
        } else {
            if (!this.browserShowsCollection()) return;
            if (!this.canDoBrowserRefresh(wasEmpty, events)) {
                this.fFeedView.getNewsBrowserControl().setInfoBarVisible(true);
                return;
            } else {
                this.fBrowserViewer.add(this.fBrowserViewer.getInput(), addedNews.toArray());
            }
        }
    }

    private boolean canDoBrowserRefresh(boolean wasEmpty) {
        return this.canDoBrowserRefresh(wasEmpty, Collections.EMPTY_SET);
    }

    private boolean canDoBrowserRefresh(boolean wasEmpty, Collection<NewsEvent> events) {
        return wasEmpty || !this.fFeedView.isVisible() || OwlUI.isMinimized() || CoreUtils.gotRestored(events);
    }

    private boolean browserShowsCollection() {
        Object input = this.fBrowserViewer.getInput();
        return input instanceof BookMarkReference || input instanceof NewsBinReference || input instanceof SearchMarkReference || input instanceof FolderNewsMark.FolderNewsMarkReference;
    }

    private boolean handleUpdatedNews(Set<NewsEvent> events) {
        ViewerComparator sorter;
        ArrayList<INews> updatedNews = new ArrayList<INews>(events.size());
        for (NewsEvent event : events) {
            updatedNews.add(event.getEntity());
        }
        Pair<List<NewsEvent>, List<INews>> result = this.updateCache(events, updatedNews);
        List visibleEvents = (List)result.getFirst();
        List visibleNews = (List)result.getSecond();
        if (visibleNews.isEmpty()) {
            return false;
        }
        if (this.canceled()) {
            return false;
        }
        if (this.fGrouping.needsRefresh(visibleEvents, true)) {
            return true;
        }
        if (this.fFeedView.isTableViewerVisible() && (sorter = this.fTableViewer.getComparator()) instanceof NewsComparator && ((NewsComparator)sorter).needsRefresh(visibleEvents)) {
            return true;
        }
        if (this.fFeedView.isTableViewerVisible()) {
            this.fTableViewer.update(visibleNews.toArray(), null);
        }
        if (this.fFeedView.isBrowserViewerVisible() && this.contains(this.fBrowserViewer.getInput(), visibleNews)) {
            NewsEvent event;
            Collection<Object> newsToUpdate = visibleEvents;
            if (visibleEvents.size() > 1 && (event = this.findShowingEventFromBrowser(visibleEvents)) != null) {
                newsToUpdate = Collections.singleton(event);
            }
            this.fBrowserViewer.update(newsToUpdate);
        }
        return false;
    }

    private boolean handleDeletedNews(Set<NewsEvent> events) {
        ArrayList<INews> deletedNews = new ArrayList<INews>(events.size());
        for (NewsEvent event : events) {
            deletedNews.add(event.getEntity());
        }
        Pair<List<NewsEvent>, List<INews>> result = this.removeFromCache(events, deletedNews);
        List visibleEvents = (List)result.getFirst();
        List visibleNews = (List)result.getSecond();
        if (visibleNews.isEmpty()) {
            return false;
        }
        if (this.canceled()) {
            return false;
        }
        if (this.isGroupingEnabled() && this.fFeedView.isTableViewerVisible() && this.fGrouping.needsRefresh(visibleEvents, false)) {
            return true;
        }
        if (this.fFeedView.isTableViewerVisible()) {
            this.fTableViewer.remove(visibleNews.toArray());
        }
        if (this.fFeedView.isBrowserViewerVisible() && this.contains(this.fBrowserViewer.getInput(), visibleNews)) {
            this.fBrowserViewer.remove(visibleNews.toArray());
        }
        return false;
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(INews.class, (EntityListener)this.fNewsListener);
        DynamicDAO.removeEntityListener(ISearchMark.class, (EntityListener)this.fSearchMarkListener);
    }

    private boolean isInputRelatedTo(NewsEvent event, NewsEventType type) {
        INews news = event.getEntity();
        if (this.fInput instanceof IBookMark) {
            if (news.getParentId() != 0L) {
                return false;
            }
            if (this.hasCachedNews(news)) {
                return true;
            }
            IBookMark bookmark = (IBookMark)this.fInput;
            if (bookmark.getFeedLinkReference().equals((Object)news.getFeedReference())) {
                return true;
            }
        } else {
            if (type != NewsEventType.PERSISTED && this.fInput instanceof ISearchMark) {
                return this.hasCachedNews(news) || this.fInput.containsNews(news);
            }
            if (this.fInput instanceof INewsBin) {
                return news.getParentId() == this.fInput.getId().longValue();
            }
            if (this.fInput instanceof FolderNewsMark) {
                if (this.hasCachedNews(news)) {
                    return true;
                }
                return ((FolderNewsMark)this.fInput).isRelatedTo(news);
            }
        }
        return false;
    }

    private boolean contains(Object input, List<INews> list) {
        block6: {
            Object[] inputNews;
            block5: {
                if (input instanceof BookMarkReference || input instanceof NewsBinReference || input instanceof SearchMarkReference || input instanceof FolderNewsMark.FolderNewsMarkReference) {
                    return true;
                }
                if (input instanceof INews) {
                    return list.contains(input);
                }
                if (!(input instanceof EntityGroup)) break block5;
                List<EntityGroupItem> items = ((EntityGroup)input).getItems();
                for (EntityGroupItem item : items) {
                    if (!list.contains(item.getEntity())) continue;
                    return true;
                }
                break block6;
            }
            if (!(input instanceof Object[])) break block6;
            Object[] objectArray = inputNews = (Object[])input;
            int n = inputNews.length;
            int n2 = 0;
            while (n2 < n) {
                Object inputNewsItem = objectArray[n2];
                if (list.contains(inputNewsItem)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private NewsEvent findShowingEventFromBrowser(Collection<NewsEvent> events) {
        Object input = this.fBrowserViewer.getInput();
        if (input instanceof INews) {
            INews news = (INews)input;
            for (NewsEvent event : events) {
                if (!news.equals(event.getEntity())) continue;
                return event;
            }
        }
        return null;
    }

    private boolean canceled() {
        return this.canceled(null);
    }

    private boolean canceled(IProgressMonitor monitor) {
        return this.fDisposed.get() || Controller.getDefault().isShuttingDown() || monitor != null && monitor.isCanceled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NewsEventType {
        PERSISTED,
        UPDATED,
        REMOVED,
        RESTORED;

    }
}

