/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.util.CColumnLayoutData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsColumnViewModel {
    public static final String COL_ID = "org.rssowl.ui.internal.editors.feed.ColumnIdentifier";
    private final List<NewsColumn> fColumns = new ArrayList<NewsColumn>();
    private NewsColumn fSortColumn;
    private boolean fAscending;

    private NewsColumnViewModel() {
    }

    public NewsColumnViewModel(NewsColumnViewModel copyFrom) {
        this.fColumns.addAll(copyFrom.getColumns());
        this.fSortColumn = copyFrom.getSortColumn();
        this.fAscending = copyFrom.isAscending();
    }

    public static NewsColumnViewModel createGlobal() {
        return NewsColumnViewModel.loadFrom(Owl.getPreferenceService().getGlobalScope());
    }

    public static NewsColumnViewModel createDefault(boolean isSearch) {
        return NewsColumnViewModel.loadFrom(Owl.getPreferenceService().getDefaultScope(), isSearch);
    }

    public static NewsColumnViewModel loadFrom(IPreferenceScope preferences) {
        return NewsColumnViewModel.loadFrom(preferences, false);
    }

    public static NewsColumnViewModel loadFrom(IPreferenceScope preferences, boolean isSearch) {
        int[] columns = preferences.getIntegers(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_COLUMNS : DefaultPreferences.BM_NEWS_COLUMNS);
        int sortColumn = preferences.getInteger(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_SORT_COLUMN : DefaultPreferences.BM_NEWS_SORT_COLUMN);
        boolean ascending = preferences.getBoolean(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_SORT_ASCENDING : DefaultPreferences.BM_NEWS_SORT_ASCENDING);
        return NewsColumnViewModel.createFrom(columns, sortColumn, ascending);
    }

    public static NewsColumnViewModel createFrom(int[] columns, int sortColumn, boolean ascending) {
        NewsColumn[] newsColumns = NewsColumn.values();
        NewsColumnViewModel model = new NewsColumnViewModel();
        int[] nArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            model.addColumn(newsColumns[column]);
            ++n2;
        }
        model.setSortColumn(newsColumns[sortColumn]);
        model.setAscending(ascending);
        return model;
    }

    public static NewsColumnViewModel initializeFrom(Tree tree) {
        int[] columnOrder;
        NewsColumnViewModel model = new NewsColumnViewModel();
        TreeColumn[] columns = tree.getColumns();
        int[] nArray = columnOrder = tree.getColumnOrder();
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int order = nArray[n2];
            Object data = columns[order].getData(COL_ID);
            if (data != null) {
                model.addColumn((NewsColumn)((Object)data));
            }
            ++n2;
        }
        return model;
    }

    public static NewsColumnViewModel initializeFrom(Table table) {
        int[] columnOrder;
        NewsColumnViewModel model = new NewsColumnViewModel();
        TableColumn[] columns = table.getColumns();
        int[] nArray = columnOrder = table.getColumnOrder();
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int order = nArray[n2];
            Object data = columns[order].getData(COL_ID);
            if (data != null) {
                model.addColumn((NewsColumn)((Object)data));
            }
            ++n2;
        }
        return model;
    }

    public List<NewsColumn> getColumns() {
        return this.fColumns;
    }

    public void addColumn(NewsColumn column) {
        if (!this.fColumns.contains((Object)column)) {
            this.fColumns.add(column);
        }
    }

    public void removeColumn(NewsColumn column) {
        this.fColumns.remove((Object)column);
    }

    public NewsColumn getColumn(int index) {
        return this.fColumns.get(index);
    }

    public boolean contains(NewsColumn column) {
        return this.fColumns.contains((Object)column);
    }

    public NewsColumn getSortColumn() {
        return this.fSortColumn;
    }

    public void setSortColumn(NewsColumn column) {
        this.fSortColumn = column;
    }

    public boolean isAscending() {
        return this.fAscending;
    }

    public void setAscending(boolean ascending) {
        this.fAscending = ascending;
    }

    public CColumnLayoutData getLayoutData(NewsColumn column) {
        boolean useLargeColumns = Application.IS_LINUX || Application.IS_MAC;
        switch (column) {
            case TITLE: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FILL, 60);
            }
            case AUTHOR: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FILL, 15);
            }
            case CATEGORY: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FILL, 15);
            }
            case LABELS: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FILL, 10);
            }
            case DATE: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, OwlUI.getDateWidth());
            }
            case PUBLISHED: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, OwlUI.getDateWidth());
            }
            case MODIFIED: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, OwlUI.getDateWidth());
            }
            case RECEIVED: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, OwlUI.getDateWidth());
            }
            case ATTACHMENTS: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, useLargeColumns ? 20 : 18);
            }
            case FEED: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, useLargeColumns ? 20 : 18);
            }
            case RELEVANCE: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, 24);
            }
            case STICKY: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, useLargeColumns ? 20 : 18);
            }
            case STATUS: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, OwlUI.getStateWidth());
            }
            case LOCATION: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, 150);
            }
            case LINK: {
                return new CColumnLayoutData(CColumnLayoutData.Size.FILL, 25);
            }
        }
        return new CColumnLayoutData(CColumnLayoutData.Size.FIXED, 100);
    }

    public boolean saveTo(IPreferenceScope preferences) {
        return this.saveTo(preferences, false);
    }

    public boolean saveTo(IPreferenceScope preferences, boolean isSearch) {
        return this.saveTo(preferences, isSearch, true, true, true);
    }

    public boolean saveTo(IPreferenceScope preferences, boolean isSearch, boolean saveColumns, boolean saveSortColumn, boolean saveSortDirection) {
        boolean changed = true;
        int[] columns = new int[this.fColumns.size()];
        int i = 0;
        while (i < this.fColumns.size()) {
            columns[i] = this.fColumns.get(i).ordinal();
            ++i;
        }
        int[] prefColumns = preferences.getIntegers(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_COLUMNS : DefaultPreferences.BM_NEWS_COLUMNS);
        int prefSortColumn = preferences.getInteger(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_SORT_COLUMN : DefaultPreferences.BM_NEWS_SORT_COLUMN);
        boolean prefAscending = preferences.getBoolean(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_SORT_ASCENDING : DefaultPreferences.BM_NEWS_SORT_ASCENDING);
        boolean bl = changed = !Arrays.equals(prefColumns, columns) || prefSortColumn != this.fSortColumn.ordinal() || prefAscending != this.fAscending;
        if (saveColumns) {
            preferences.putIntegers(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_COLUMNS : DefaultPreferences.BM_NEWS_COLUMNS, columns);
        }
        if (saveSortColumn) {
            preferences.putInteger(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_SORT_COLUMN : DefaultPreferences.BM_NEWS_SORT_COLUMN, this.fSortColumn.ordinal());
        }
        if (saveSortDirection) {
            preferences.putBoolean(isSearch ? DefaultPreferences.SEARCH_DIALOG_NEWS_SORT_ASCENDING : DefaultPreferences.BM_NEWS_SORT_ASCENDING, this.fAscending);
        }
        return changed;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAscending ? 1231 : 1237);
        result = 31 * result + (this.fColumns == null ? 0 : this.fColumns.hashCode());
        result = 31 * result + (this.fSortColumn == null ? 0 : this.fSortColumn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewsColumnViewModel other = (NewsColumnViewModel)obj;
        if (this.fAscending != other.fAscending) {
            return false;
        }
        if (this.fSortColumn == null ? other.fSortColumn != null : !this.fSortColumn.equals((Object)other.fSortColumn)) {
            return false;
        }
        return !(this.fColumns == null ? other.fColumns != null : !this.fColumns.equals(other.fColumns));
    }
}

