/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class ConfirmDialog
extends TitleAreaDialog {
    private String fDialogHeaderMessage;
    private String fDialogMessage;
    private Button fNeverAskAgainCheck;
    private String fTitle;
    private LocalResourceManager fResources;
    private String fConfirmPrefKey;
    private IPreferenceScope fPreferences;
    private String fButtonName;

    public ConfirmDialog(Shell parentShell, String title, String dialogHeaderMessage, String dialogMessage, String confirmPrefKey) {
        this(parentShell, title, dialogHeaderMessage, dialogMessage, Messages.ConfirmDialog_DELETE, confirmPrefKey);
    }

    public ConfirmDialog(Shell parentShell, String title, String dialogHeaderMessage, String dialogMessage, String okButtonName, String confirmPrefKey) {
        super(parentShell);
        this.fTitle = title;
        this.fDialogMessage = dialogMessage;
        this.fDialogHeaderMessage = dialogHeaderMessage;
        this.fButtonName = okButtonName;
        this.fConfirmPrefKey = confirmPrefKey;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void okPressed() {
        if (this.fNeverAskAgainCheck != null && this.fNeverAskAgainCheck.getSelection()) {
            this.fPreferences.putBoolean(this.fConfirmPrefKey, false);
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    protected String getTitleImage() {
        return "/icons/wizban/trash.gif";
    }

    protected String getTitleLabel() {
        return Messages.ConfirmDialog_DELETE;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(this.getTitleLabel());
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, this.getTitleImage()));
        this.setMessage(this.fDialogHeaderMessage, 2);
        Label dialogMessageLabel = new Label(composite, 64);
        dialogMessageLabel.setText(this.fDialogMessage);
        dialogMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        new Label(composite, 0);
        if (this.fConfirmPrefKey != null) {
            this.fNeverAskAgainCheck = new Button(composite, 32);
            this.fNeverAskAgainCheck.setText(Messages.ConfirmDialog_NEVER_ASK_AGAIN);
        }
        Composite sepHolder = new Composite(parent, 0);
        sepHolder.setLayoutData((Object)new GridData(4, 1, true, false));
        sepHolder.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        Label separator = new Label(sepHolder, 258);
        separator.setLayoutData((Object)new GridData(768));
        ConfirmDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.fButtonName, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.getButton(1).setFocus();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point bestSize = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point location = this.getInitialLocation(bestSize);
        this.getShell().setBounds(location.x, location.y, bestSize.x, bestSize.y);
    }
}

