/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.connection.SyncConnectionException;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.INews;

public class SyncUtils {
    public static final boolean ENABLED = false;
    public static final String GOOGLE_LOGIN_URL = "https://www.google.com/accounts/ClientLogin";
    public static final String GOOGLE_API_URL = "http://www.google.com/reader/api/0/";
    public static final String GOOGLE_API_TOKEN_URL = "http://www.google.com/reader/api/0/token";
    public static final String GOOGLE_EDIT_TAG_URL = "http://www.google.com/reader/api/0/edit-tag?client=scroll";
    public static final String GOOGLE_FEED_URL = "http://www.google.com/reader/api/0/stream/contents/feed/";
    public static final String GOOGLE_STREAM_CONTENTS_URL = "http://www.google.com/reader/api/0/stream/contents/";
    public static final String GOOGLE_UNREAD_COUNT_URL = "http://www.google.com/reader/api/0/unread-count";
    public static final String GOOGLE_NEW_ACCOUNT_URL = "https://www.google.com/accounts/NewAccount?continue=http%3A%2F%2Fwww.google.com%2Freader%2F&followup=http%3A%2F%2Fwww.google.com%2Freader%2F&service=reader";
    public static final String GOOGLE_READER_URL = "https://reader.google.com";
    public static final String GOOGLE_READER_OPML_URI = "https://www.google.com/reader/subscriptions/export";
    public static final String CAPTCHA_UNLOCK_URL = "https://www.google.com/accounts/DisplayUnlockCaptcha";
    public static final String READER_HTTP_SCHEME = "reader";
    public static final String READER_HTTPS_SCHEME = "readers";
    public static final String GOOGLE_READER_ALL_ITEMS_FEED = "reader://readinglist";
    public static final String GOOGLE_READER_STARRED_FEED = "reader://starred";
    public static final String GOOGLE_READER_SHARED_ITEMS_FEED = "reader://shared";
    public static final String GOOGLE_READER_RECOMMENDED_ITEMS_FEED = "reader://recommended";
    public static final String GOOGLE_READER_NOTES_FEED = "reader://notes";
    public static final String GOOGLE_MARKED_UNREAD = "org.rssowl.pref.GoogleMarkedUnRead";
    public static final String GOOGLE_MARKED_READ = "org.rssowl.pref.GoogleMarkedRead";
    public static final String GOOGLE_LABELS = "org.rssowl.pref.GoogleLabels";
    public static final String CATEGORY_STARRED = "user/-/state/com.google/starred";
    public static final String CATEGORY_READ = "user/-/state/com.google/read";
    public static final String CATEGORY_UNREAD = "user/-/state/com.google/kept-unread";
    public static final String CATEGORY_TRACKING_UNREAD = "user/-/state/com.google/tracking-kept-unread ";
    public static final String CATEGORY_LABEL_PREFIX = "user/-/label/";
    public static final String API_PARAM_TOKEN = "T";
    public static final String API_PARAM_STREAM = "s";
    public static final String API_PARAM_IDENTIFIER = "i";
    public static final String API_PARAM_TAG_TO_ADD = "a";
    public static final String API_PARAM_TAG_TO_REMOVE = "r";
    public static final int DEFAULT_CON_TIMEOUT = 30000;
    public static final int SHORT_CON_TIMEOUT = 5000;
    private static final String AUTH_IDENTIFIER = "Auth=";
    private static final String GOOGLE_LOGIN_HEADER_VALUE = "GoogleLogin auth=";
    private static String fgSharedAuthToken;
    private static final Object AUTH_TOKEN_LOCK;
    private static final String GOOGLE_HTTP_URL_PREFIX = "http://www.google.com";
    private static final String GOOGLE_HTTPS_URL_PREFIX = "https://www.google.com";

    static {
        AUTH_TOKEN_LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGoogleAuthToken(String email, String pw, boolean refresh, IProgressMonitor monitor) throws ConnectionException {
        if (!refresh) {
            return fgSharedAuthToken;
        }
        fgSharedAuthToken = null;
        if (monitor.isCanceled()) {
            return null;
        }
        Object object = AUTH_TOKEN_LOCK;
        synchronized (object) {
            block10: {
                if (fgSharedAuthToken != null) {
                    return fgSharedAuthToken;
                }
                if (!monitor.isCanceled()) break block10;
                return null;
            }
            try {
                fgSharedAuthToken = SyncUtils.internalGetGoogleAuthToken(email, pw, monitor);
            }
            catch (URISyntaxException e) {
                throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
            catch (IOException e) {
                throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
        return fgSharedAuthToken;
    }

    /*
     * Exception decompiling
     */
    private static String internalGetGoogleAuthToken(String email, String pw, IProgressMonitor monitor) throws ConnectionException, URISyntaxException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getGoogleAuthorizationHeader(String authToken) {
        return GOOGLE_LOGIN_HEADER_VALUE + authToken;
    }

    public static String getGoogleApiToken(String email, String pw, IProgressMonitor monitor) throws ConnectionException {
        try {
            try {
                return SyncUtils.internalGetGoogleApiToken(email, pw, false, monitor);
            }
            catch (ConnectionException e) {
                if (!(e instanceof AuthenticationRequiredException) && !(e instanceof SyncConnectionException)) {
                    throw e;
                }
                return SyncUtils.internalGetGoogleApiToken(email, pw, true, monitor);
            }
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
        catch (IOException e) {
            throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
    }

    private static String internalGetGoogleApiToken(String email, String pw, boolean refresh, IProgressMonitor monitor) throws ConnectionException, IOException, URISyntaxException {
        URI uri = new URI(GOOGLE_API_TOKEN_URL);
        IProtocolHandler handler = Owl.getConnectionService().getHandler(uri);
        if (handler != null) {
            BufferedReader reader;
            block12: {
                String string;
                String token = SyncUtils.getGoogleAuthToken(email, pw, refresh, monitor);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", SyncUtils.getGoogleAuthorizationHeader(token));
                HashMap<Object, Object> properties = new HashMap<Object, Object>();
                properties.put("HEADERS", headers);
                properties.put("CON_TIMEOUT", SyncUtils.getConnectionTimeout());
                reader = null;
                try {
                    String line;
                    InputStream inS = handler.openStream(uri, monitor, properties);
                    reader = new BufferedReader(new InputStreamReader(inS));
                    if (monitor.isCanceled() || (line = reader.readLine()) == null) break block12;
                    string = line;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return string;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static boolean isSynchronized(INews news) {
        return news != null && news.getParentId() == 0L && SyncUtils.isSynchronized(news.getFeedLinkAsText());
    }

    public static boolean isSynchronized(IBookMark bm) {
        return SyncUtils.isSynchronized(bm.getFeedLinkReference().getLinkAsText());
    }

    public static boolean isSynchronized(String link) {
        return link != null && link.startsWith(READER_HTTP_SCHEME);
    }

    public static boolean fromGoogle(String link) {
        return SyncUtils.isSynchronized(link) || link.startsWith(GOOGLE_HTTP_URL_PREFIX) || link.startsWith(GOOGLE_HTTPS_URL_PREFIX);
    }

    public static boolean hasSyncCredentials() {
        try {
            return Owl.getConnectionService().getAuthCredentials(URI.create(GOOGLE_LOGIN_URL), null) != null;
        }
        catch (CredentialsException credentialsException) {
            return false;
        }
    }

    private static int getConnectionTimeout() {
        return Owl.isShuttingDown() ? 5000 : 30000;
    }
}

