/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.rssowl.core.connection.MonitorCanceledException;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.util.HTMLFilterReader;
import org.rssowl.core.util.HTMLStripReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final String EMPTY_STRING = "";
    public static final String[] ENGLISH_STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;

    private StringUtils() {
    }

    public static final String safeTrim(String string) {
        return string == null ? null : string.trim();
    }

    public static boolean isSet(String str) {
        return str != null && str.length() > 0;
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        char[] n = new char[str.length()];
        boolean white = true;
        int pos = 0;
        int i = 0;
        int c = str.length();
        while (i < c) {
            char element = str.charAt(i);
            if (" \t\n\r".indexOf(element) != -1) {
                if (!white) {
                    n[pos++] = 32;
                    white = true;
                }
            } else {
                n[pos++] = element;
                white = false;
            }
            ++i;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    public static String smartTrim(String str, int limit) {
        if (str.indexOf(32) == -1 || str.length() < limit) {
            return str;
        }
        str = str.substring(0, limit);
        int a = limit - 1;
        while (a >= 0) {
            if (str.charAt(a) == ' ') {
                return String.valueOf(str.substring(0, a)) + "...";
            }
            --a;
        }
        return str;
    }

    public static String stripTags(String str, boolean replaceEntities) {
        return StringUtils.filterTags(str, null, replaceEntities);
    }

    public static String filterTags(String str, Set<String> tags, boolean replaceEntities) {
        if (!StringUtils.isSet(str)) {
            return str;
        }
        Reader stripReader = tags == null || tags.isEmpty() ? new HTMLStripReader(new StringReader(str), replaceEntities) : new HTMLFilterReader(new StringReader(str), tags, replaceEntities);
        try {
            String string = StringUtils.readString(stripReader);
            return string;
        }
        catch (IOException e) {
            if (!(e instanceof MonitorCanceledException)) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            String string = str;
            return string;
        }
        finally {
            block13: {
                try {
                    stripReader.close();
                }
                catch (IOException e) {
                    if (e instanceof MonitorCanceledException) break block13;
                    Activator.getDefault().logError(e.getMessage(), e);
                }
            }
        }
    }

    public static boolean isValidRGB(String rgb) {
        if (rgb == null) {
            return true;
        }
        String[] split = rgb.split(",");
        if (split.length != 3) {
            return false;
        }
        try {
            Integer.parseInt(split[0]);
            Integer.parseInt(split[1]);
            Integer.parseInt(split[2]);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static Set<String> replaceAll(Set<String> strings, String search, String replace) {
        HashSet<String> replacedStrings = new HashSet<String>(strings.size());
        for (String string : strings) {
            replacedStrings.add(StringUtils.replaceAll(string, search, replace));
        }
        return replacedStrings;
    }

    public static String replaceAll(String str, String search, String replace) {
        int pos;
        int start = 0;
        StringBuilder result = null;
        while ((pos = str.indexOf(search, start)) >= 0) {
            if (result == null) {
                result = new StringBuilder(str.length());
            }
            result.append(str.substring(start, pos));
            result.append(replace);
            start = pos + search.length();
        }
        if (result != null) {
            result.append(str.substring(start));
        }
        return result != null ? result.toString() : str;
    }

    public static int stringToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static List<String> tokenizePhraseAware(String str, boolean keepQuotes) {
        if (!StringUtils.isSet(str)) {
            return Collections.emptyList();
        }
        str = StringUtils.normalizeString(str);
        boolean inQuotes = false;
        ArrayList<String> tokens = new ArrayList<String>(1);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\"' && !inQuotes) {
                inQuotes = true;
                if (keepQuotes) {
                    builder.append(c);
                }
            } else if (c == '\"' && inQuotes) {
                inQuotes = false;
                if (keepQuotes) {
                    builder.append(c);
                }
            } else if (c == ' ' && !inQuotes) {
                tokens.add(builder.toString());
                builder.setLength(0);
            } else if (c == ' ' && inQuotes) {
                builder.append(c);
            } else {
                builder.append(c);
            }
            ++i;
        }
        if (builder.length() > 0) {
            tokens.add(builder.toString());
        }
        return tokens;
    }

    public static String htmlEscape(String str) {
        if (!StringUtils.isSet(str)) {
            return str;
        }
        str = StringUtils.replaceAll(str, "<", "&lt;");
        str = StringUtils.replaceAll(str, ">", "&gt;");
        return str;
    }

    public static String readString(Reader reader) throws IOException {
        StringBuilder str = new StringBuilder();
        int len = 0;
        char[] buf = new char[1000];
        while ((len = reader.read(buf)) != -1) {
            str.append(buf, 0, len);
        }
        return str.toString();
    }

    public static boolean isPhraseSearch(String str) {
        if (!StringUtils.isSet(str)) {
            return false;
        }
        return (str = str.trim()).startsWith("\"") && str.endsWith("\"") && str.length() != 1;
    }

    public static boolean isPhraseSearchWithWildcardToken(String str) {
        if (!StringUtils.isPhraseSearch(str)) {
            return false;
        }
        return str.contains("*") || str.contains("?");
    }

    public static boolean isWildcardsOnly(String str) {
        if (!StringUtils.isSet(str)) {
            return false;
        }
        str = str.trim();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != '*' && c != '?') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSpecialCharacterSearchWithWildcardToken(String str) {
        if (!StringUtils.isSet(str)) {
            return false;
        }
        str = str.trim();
        boolean containsSpecialChars = false;
        boolean containsWildcards = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '*' || c == '?') {
                containsWildcards = true;
                if (containsSpecialChars) {
                    return true;
                }
            } else if (c != '.' && c != '@' && (c > ' ' && c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z' && c < '\u007f' || String.valueOf(c).equals("\u00c2\u00a7"))) {
                containsSpecialChars = true;
                if (containsWildcards) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean supportsTrailingWildcards(String str) {
        return StringUtils.isSet(str) && !str.endsWith("*") && !str.endsWith("?") && !StringUtils.isPhraseSearch(str) && !StringUtils.isSpecialCharacterSearchWithWildcardToken(str = String.valueOf(str) + "*");
    }
}

