/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist.service;

import org.rssowl.core.internal.persist.search.ModelSearchImpl;
import org.rssowl.core.persist.dao.DAOService;
import org.rssowl.core.persist.service.IDGenerator;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.persist.service.IPersistenceService;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.ExtensionUtils;
import org.rssowl.core.util.LongOperationMonitor;

public abstract class AbstractPersistenceService
implements IPersistenceService {
    private static final String MODEL_ID_GENERATOR_EXTENSION_POINT = "org.rssowl.core.IDGenerator";
    private static final String MODEL_DAO_FACTORY_EXTENSION_POINT = "org.rssowl.core.DAOService";
    private volatile IModelSearch fModelSearch;
    private volatile IDGenerator fIDGenerator;
    private volatile DAOService fDAOService;

    protected AbstractPersistenceService() {
    }

    public void startup(LongOperationMonitor monitor, boolean emergency, boolean forRestore) throws PersistenceException {
        this.getModelSearch();
        this.getIDGenerator();
        this.getDAOService();
    }

    public DAOService getDAOService() {
        if (this.fDAOService == null) {
            this.fDAOService = (DAOService)ExtensionUtils.loadSingletonExecutableExtension(MODEL_DAO_FACTORY_EXTENSION_POINT);
        }
        return this.fDAOService;
    }

    public IDGenerator getIDGenerator() {
        if (this.fIDGenerator == null) {
            this.fIDGenerator = (IDGenerator)ExtensionUtils.loadSingletonExecutableExtension(MODEL_ID_GENERATOR_EXTENSION_POINT);
        }
        return this.fIDGenerator;
    }

    public IModelSearch getModelSearch() {
        if (this.fModelSearch == null) {
            this.fModelSearch = new ModelSearchImpl();
        }
        return this.fModelSearch;
    }
}

