/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.migration;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.query.Query;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.NewsBin;
import org.rssowl.core.internal.persist.migration.Messages;
import org.rssowl.core.internal.persist.migration.MigrationHelper;
import org.rssowl.core.internal.persist.migration.MigrationResult;
import org.rssowl.core.internal.persist.service.ConfigurationFactory;
import org.rssowl.core.internal.persist.service.Migration;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.reference.NewsReference;

public class Migration3To4
implements Migration {
    public int getDestinationFormat() {
        return 4;
    }

    public int getOriginFormat() {
        return 3;
    }

    public MigrationResult migrate(ConfigurationFactory configFactory, String dbFileName, IProgressMonitor progressMonitor) {
        int totalProgressIncremented = 0;
        progressMonitor.beginTask(Messages.Migration3To4_MIGRATING_DATA, 100);
        ObjectContainer oc = Db4o.openFile((Configuration)configFactory.createConfiguration(), (String)dbFileName);
        ObjectSet newsBins = oc.query(NewsBin.class);
        for (INewsBin newsBin : newsBins) {
            oc.activate((Object)newsBin, Integer.MAX_VALUE);
            for (NewsReference newsRef : newsBin.getNewsRefs()) {
                Query query = oc.query();
                query.constrain(News.class);
                query.descend("fId").constrain((Object)newsRef.getId());
                News news = (News)query.execute().iterator().next();
                oc.activate((Object)news, Integer.MAX_VALUE);
                String parentIdFieldName = "fParentId";
                MigrationHelper.setField(news, parentIdFieldName, (long)newsBin.getId());
                oc.ext().set((Object)news, Integer.MAX_VALUE);
            }
        }
        oc.commit();
        oc.close();
        progressMonitor.worked(100 - totalProgressIncremented);
        return new MigrationResult(true, false, true);
    }
}

