/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ext.Db4oException;
import java.util.Set;
import java.util.TreeSet;
import org.rssowl.core.internal.persist.Person;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.dao.IPersonDAO;
import org.rssowl.core.persist.event.PersonEvent;
import org.rssowl.core.persist.event.PersonListener;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonDAOImpl
extends AbstractEntityDAO<IPerson, PersonListener, PersonEvent>
implements IPersonDAO {
    public PersonDAOImpl() {
        super(Person.class, false);
    }

    @Override
    protected PersonEvent createDeleteEventTemplate(IPerson entity) {
        return this.createSaveEventTemplate(entity);
    }

    @Override
    protected final PersonEvent createSaveEventTemplate(IPerson entity) {
        return new PersonEvent(entity, true);
    }

    @Override
    public Set<String> loadAllNames() {
        try {
            TreeSet<String> strings = new TreeSet<String>();
            for (IPerson person : this.loadAll()) {
                String name = StringUtils.safeTrim(person.getName());
                if (StringUtils.isSet(name)) {
                    strings.add(name);
                    continue;
                }
                if (person.getEmail() == null) continue;
                strings.add(person.getEmail().toString());
            }
            return strings;
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }
}

