/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.reference.SearchConditionReference;

public class SearchCondition
extends AbstractEntity
implements ISearchCondition {
    private SearchSpecifier fSpecifier;
    private Object fValue;
    private ISearchField fField;

    public SearchCondition(Long id, ISearchField field, SearchSpecifier specifier, Object value) {
        super(id);
        Assert.isNotNull((Object)field, (String)"Search-Field for SearchCondition must not be NULL");
        this.fField = field;
        Assert.isNotNull((Object)specifier, (String)"Search-Specifier for SearchCondition must not be NULL");
        this.fSpecifier = specifier;
        Assert.isNotNull((Object)value, (String)"Search-Value for SearchCondition must not be NULL");
        this.fValue = value;
    }

    public SearchCondition(ISearchField field, SearchSpecifier specifier, Object value) {
        super(null);
        Assert.isNotNull((Object)field, (String)"Search-Field for SearchCondition must not be NULL");
        this.fField = field;
        Assert.isNotNull((Object)specifier, (String)"Search-Specifier for SearchCondition must not be NULL");
        this.fSpecifier = specifier;
        Assert.isNotNull((Object)value, (String)"Search-Value for SearchCondition must not be NULL");
        this.fValue = value;
    }

    protected SearchCondition() {
    }

    public synchronized ISearchField getField() {
        return this.fField;
    }

    public synchronized SearchSpecifier getSpecifier() {
        return this.fSpecifier;
    }

    public synchronized Object getValue() {
        return this.fValue;
    }

    public synchronized void setField(ISearchField field) {
        this.fField = field;
    }

    public synchronized void setSpecifier(SearchSpecifier specifier) {
        this.fSpecifier = specifier;
    }

    public synchronized void setValue(Object value) {
        this.fValue = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(ISearchCondition searchCondition) {
        if (this == searchCondition) {
            return true;
        }
        if (!(searchCondition instanceof SearchCondition)) {
            return false;
        }
        ISearchCondition iSearchCondition = searchCondition;
        synchronized (iSearchCondition) {
            SearchCondition s = (SearchCondition)searchCondition;
            return (this.getId() == null ? s.getId() == null : this.getId().equals(s.getId())) && this.fField.equals(s.fField) && this.fSpecifier.equals(s.fSpecifier) && this.fValue.equals(s.fValue) && (this.getProperties() == null ? s.getProperties() == null : this.getProperties().equals(s.getProperties()));
        }
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Search-Field = " + this.fField + ", Search-Specifier = " + this.fSpecifier.name() + ", Search-Value = " + this.fValue + ")";
    }

    public SearchConditionReference toReference() {
        return new SearchConditionReference(this.getIdAsPrimitive());
    }
}

