/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.LongArrayList;
import org.rssowl.core.persist.IEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyList<E extends IEntity>
implements List<E> {
    private final LongArrayList fIds;
    private final ObjectContainer fObjectContainer;

    public LazyList(ObjectSet<? extends E> entities, ObjectContainer objectContainer) {
        Assert.isNotNull(entities, (String)"entities");
        Assert.isNotNull((Object)objectContainer, (String)"objectContainer");
        long[] ids = entities.ext().getIDs();
        this.fIds = new LongArrayList(ids.length);
        this.fIds.setAll(ids);
        this.fObjectContainer = objectContainer;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int index = 0;
        for (IEntity e : this) {
            array[index++] = e;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] array = a;
        if (a.length < size) {
            array = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int index = 0;
        for (IEntity e : this) {
            array[index++] = e;
        }
        return array;
    }

    private E getEntity(long id) {
        IEntity object = (IEntity)this.fObjectContainer.ext().getByID(id);
        this.fObjectContainer.activate((Object)object, Integer.MAX_VALUE);
        return (E)object;
    }

    @Override
    public E get(int index) {
        return this.getEntity(this.fIds.get(index));
    }

    @Override
    public int indexOf(Object o) {
        IEntity entity;
        if (o instanceof IEntity && (entity = (IEntity)o).getId() != null) {
            return this.fIds.indexOf(entity.getId());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        IEntity entity;
        if (o instanceof IEntity && (entity = (IEntity)o).getId() != null) {
            return this.fIds.lastIndexOf(entity.getId());
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIterator<E>(){
            private int cursor;
            private int lastReturned = -1;

            @Override
            public boolean hasNext() {
                return this.cursor < LazyList.this.fIds.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E next() {
                IEntity entity = LazyList.this.getEntity(LazyList.this.fIds.get(this.cursor));
                this.lastReturned = this.cursor++;
                return entity;
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public E previous() {
                IEntity entity = LazyList.this.getEntity(LazyList.this.fIds.get(--this.cursor));
                this.lastReturned = this.cursor;
                return entity;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                if (this.lastReturned == -1) {
                    throw new IllegalStateException();
                }
                LazyList.this.fIds.removeByIndex(this.lastReturned);
                if (this.lastReturned < this.cursor) {
                    --this.cursor;
                }
                this.lastReturned = -1;
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public E remove(int index) {
        return this.getEntity(this.fIds.removeByIndex(index));
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public void clear() {
        this.fIds.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IEntity) {
            return this.fIds.contains(((IEntity)o).getId());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.fIds.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.fIds.removeByIndex(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public int size() {
        return this.fIds.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        return this.containsAll(c);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (IEntity e : this) {
            if (e == null) continue;
            h += e.hashCode();
        }
        return h;
    }
}

