/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.interpreter.BasicInterpreter;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.URIUtils;

public class CDFInterpreter
extends BasicInterpreter {
    private int fNewsCounter;

    public void interpret(Document document, IFeed feed) {
        Element root = document.getRootElement();
        this.setDefaultNamespaceUri(root.getNamespace().getURI());
        this.setRootElementName(root.getName());
        feed.setFormat("CDF");
        this.processChannel(root, feed);
    }

    private void processChannel(Element element, IFeed feed) {
        List channelAttributes = element.getAttributes();
        for (Attribute attribute : channelAttributes) {
            URI uri;
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, feed)) continue;
            if ("lastmod".equals(name)) {
                feed.setLastModifiedDate(DateUtils.parseDate(attribute.getValue()));
                continue;
            }
            if (!"base".equals(name) || (uri = URIUtils.createURI(attribute.getValue())) == null) continue;
            feed.setHomepage(uri);
        }
        List feedChildren = element.getChildren();
        for (Element child : feedChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("title".equals(name)) {
                feed.setTitle(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("abstract".equals(name)) {
                feed.setDescription(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if (!"item".equals(name)) continue;
            this.processItem(child, feed);
        }
    }

    private void processItem(Element element, IFeed feed) {
        INews news = Owl.getModelFactory().createNews(null, feed, new Date(System.currentTimeMillis() - (long)(this.fNewsCounter++ * 1)));
        news.setBase(feed.getBase());
        String baseUrl = feed.getHomepage() != null ? feed.getHomepage().toString() : "";
        List itemAttributes = element.getAttributes();
        for (Attribute attribute : itemAttributes) {
            URI uri;
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, news)) continue;
            if ("lastmod".equals(name)) {
                news.setPublishDate(DateUtils.parseDate(attribute.getValue()));
                continue;
            }
            if (!"href".equals(name) || (uri = URIUtils.createURI(String.valueOf(baseUrl) + attribute.getValue())) == null) continue;
            news.setLink(uri);
        }
        List newsChilds = element.getChildren();
        for (Element child : newsChilds) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, news)) continue;
            if ("title".equals(name)) {
                news.setTitle(child.getText());
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if (!"abstract".equals(name)) continue;
            news.setDescription(child.getText());
            this.processNamespaceAttributes(child, news);
        }
    }
}

