/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fieldindex;

import com.db4o.foundation.Arrays4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.fieldindex.AndIndexedLeaf;
import com.db4o.internal.fieldindex.IndexedLeaf;
import com.db4o.internal.fieldindex.IndexedNodeWithRange;
import com.db4o.internal.fieldindex.OrIndexedLeaf;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConJoin;
import com.db4o.internal.query.processor.QConObject;

public class IndexedNodeCollector {
    private final Collection4 _nodes = new Collection4();
    private final Hashtable4 _nodeCache = new Hashtable4();

    public IndexedNodeCollector(QCandidates qCandidates) {
        this.collectIndexedNodes(qCandidates);
    }

    public Iterator4 getNodes() {
        return this._nodes.iterator();
    }

    private void collectIndexedNodes(QCandidates qCandidates) {
        this.collectIndexedNodes(qCandidates.iterateConstraints());
        this.implicitlyAndJoinsOnSameField();
    }

    private void implicitlyAndJoinsOnSameField() {
        Object[] objectArray = this._nodes.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            OrIndexedLeaf orIndexedLeaf;
            OrIndexedLeaf orIndexedLeaf2;
            Object object = objectArray[i];
            if (!(object instanceof OrIndexedLeaf) || null == (orIndexedLeaf2 = this.findJoinOnSameFieldAtSameLevel(orIndexedLeaf = (OrIndexedLeaf)object))) continue;
            objectArray[Arrays4.indexOf((Object[])objectArray, (Object)orIndexedLeaf2)] = null;
            this.collectImplicitAnd(orIndexedLeaf.getConstraint(), orIndexedLeaf, orIndexedLeaf2);
        }
    }

    private OrIndexedLeaf findJoinOnSameFieldAtSameLevel(OrIndexedLeaf orIndexedLeaf) {
        Iterator4 iterator4 = this._nodes.iterator();
        while (iterator4.moveNext()) {
            OrIndexedLeaf orIndexedLeaf2;
            if (iterator4.current() == orIndexedLeaf || !(iterator4.current() instanceof OrIndexedLeaf) || (orIndexedLeaf2 = (OrIndexedLeaf)iterator4.current()).getIndex() != orIndexedLeaf.getIndex() || this.parentConstraint(orIndexedLeaf2) != this.parentConstraint(orIndexedLeaf)) continue;
            return orIndexedLeaf2;
        }
        return null;
    }

    private Object parentConstraint(OrIndexedLeaf orIndexedLeaf) {
        return orIndexedLeaf.getConstraint().parent();
    }

    private void collectIndexedNodes(Iterator4 iterator4) {
        while (iterator4.moveNext()) {
            QCon qCon = (QCon)iterator4.current();
            if (this.isCached(qCon)) continue;
            if (this.isLeaf(qCon)) {
                if (!qCon.canLoadByIndex() || !qCon.canBeIndexLeaf()) continue;
                QConObject qConObject = (QConObject)qCon;
                if (qConObject.hasJoins()) {
                    this.collectJoinedNode(qConObject);
                    continue;
                }
                this.collectStandaloneNode(qConObject);
                continue;
            }
            if (qCon.hasJoins()) continue;
            this.collectIndexedNodes(qCon.iterateChildren());
        }
    }

    private boolean isCached(QCon qCon) {
        return null != this._nodeCache.get(qCon);
    }

    private void collectStandaloneNode(QConObject qConObject) {
        IndexedLeaf indexedLeaf = this.findLeafOnSameField(qConObject);
        if (indexedLeaf != null) {
            this.collectImplicitAnd(qConObject, indexedLeaf, new IndexedLeaf(qConObject));
        } else {
            this._nodes.add(new IndexedLeaf(qConObject));
        }
    }

    private void collectJoinedNode(QConObject qConObject) {
        Collection4 collection4 = this.collectTopLevelJoins(qConObject);
        if (!this.canJoinsBeSearchedByIndex(collection4)) {
            return;
        }
        if (1 == collection4.size()) {
            this._nodes.add(this.nodeForConstraint((QCon)collection4.singleElement()));
            return;
        }
        this.collectImplicitlyAndingJoins(collection4, qConObject);
    }

    private boolean allHaveSamePath(Collection4 collection4) {
        Iterator4 iterator4 = collection4.iterator();
        iterator4.moveNext();
        QCon qCon = (QCon)iterator4.current();
        while (iterator4.moveNext()) {
            if (this.haveSamePath(qCon, (QCon)iterator4.current())) continue;
            return false;
        }
        return true;
    }

    private boolean haveSamePath(QCon qCon, QCon qCon2) {
        if (qCon == qCon2) {
            return true;
        }
        if (!qCon.onSameFieldAs(qCon2)) {
            return false;
        }
        if (!qCon.hasParent()) {
            return !qCon2.hasParent();
        }
        return this.haveSamePath(qCon.parent(), qCon2.parent());
    }

    private Collection4 collectLeaves(Collection4 collection4) {
        Collection4 collection42 = new Collection4();
        this.collectLeaves(collection42, collection4);
        return collection42;
    }

    private void collectLeaves(Collection4 collection4, Collection4 collection42) {
        Iterator4 iterator4 = collection42.iterator();
        while (iterator4.moveNext()) {
            QConJoin qConJoin = (QConJoin)iterator4.current();
            this.collectLeavesFromJoin(collection4, qConJoin);
        }
    }

    private void collectLeavesFromJoin(Collection4 collection4, QConJoin qConJoin) {
        this.collectLeavesFromJoinConstraint(collection4, qConJoin.i_constraint1);
        this.collectLeavesFromJoinConstraint(collection4, qConJoin.i_constraint2);
    }

    private void collectLeavesFromJoinConstraint(Collection4 collection4, QCon qCon) {
        if (qCon instanceof QConJoin) {
            this.collectLeavesFromJoin(collection4, (QConJoin)qCon);
        } else if (!collection4.containsByIdentity(qCon)) {
            collection4.add(qCon);
        }
    }

    private boolean canJoinsBeSearchedByIndex(Collection4 collection4) {
        Collection4 collection42 = this.collectLeaves(collection4);
        return this.allHaveSamePath(collection42) && this.allCanBeSearchedByIndex(collection42);
    }

    private boolean allCanBeSearchedByIndex(Collection4 collection4) {
        Iterator4 iterator4 = collection4.iterator();
        while (iterator4.moveNext()) {
            QCon qCon = (QCon)iterator4.current();
            if (qCon.canLoadByIndex()) continue;
            return false;
        }
        return true;
    }

    private void collectImplicitlyAndingJoins(Collection4 collection4, QConObject qConObject) {
        Iterator4 iterator4 = collection4.iterator();
        iterator4.moveNext();
        IndexedNodeWithRange indexedNodeWithRange = this.nodeForConstraint((QCon)iterator4.current());
        while (iterator4.moveNext()) {
            IndexedNodeWithRange indexedNodeWithRange2 = this.nodeForConstraint((QCon)iterator4.current());
            indexedNodeWithRange = new AndIndexedLeaf((QCon)qConObject, indexedNodeWithRange2, indexedNodeWithRange);
            this._nodes.add(indexedNodeWithRange);
        }
    }

    private Collection4 collectTopLevelJoins(QConObject qConObject) {
        Collection4 collection4 = new Collection4();
        this.collectTopLevelJoins(collection4, qConObject);
        return collection4;
    }

    private void collectTopLevelJoins(Collection4 collection4, QCon qCon) {
        Iterator4 iterator4 = qCon.i_joins.iterator();
        while (iterator4.moveNext()) {
            QConJoin qConJoin = (QConJoin)iterator4.current();
            if (!qConJoin.hasJoins()) {
                if (collection4.containsByIdentity(qConJoin)) continue;
                collection4.add(qConJoin);
                continue;
            }
            this.collectTopLevelJoins(collection4, qConJoin);
        }
    }

    private IndexedNodeWithRange newNodeForConstraint(QConJoin qConJoin) {
        IndexedNodeWithRange indexedNodeWithRange = this.nodeForConstraint(qConJoin.i_constraint1);
        IndexedNodeWithRange indexedNodeWithRange2 = this.nodeForConstraint(qConJoin.i_constraint2);
        if (qConJoin.isOr()) {
            return new OrIndexedLeaf(this.findLeafForJoin(qConJoin), indexedNodeWithRange, indexedNodeWithRange2);
        }
        return new AndIndexedLeaf(qConJoin.i_constraint1, indexedNodeWithRange, indexedNodeWithRange2);
    }

    private QCon findLeafForJoin(QConJoin qConJoin) {
        if (qConJoin.i_constraint1 instanceof QConObject) {
            return qConJoin.i_constraint1;
        }
        QCon qCon = qConJoin.i_constraint2;
        if (qCon instanceof QConObject) {
            return qCon;
        }
        return this.findLeafForJoin((QConJoin)qCon);
    }

    private IndexedNodeWithRange nodeForConstraint(QCon qCon) {
        IndexedNodeWithRange indexedNodeWithRange = (IndexedNodeWithRange)this._nodeCache.get(qCon);
        if (null != indexedNodeWithRange || this._nodeCache.containsKey(qCon)) {
            return indexedNodeWithRange;
        }
        indexedNodeWithRange = this.newNodeForConstraint(qCon);
        this._nodeCache.put(qCon, (Object)indexedNodeWithRange);
        return indexedNodeWithRange;
    }

    private IndexedNodeWithRange newNodeForConstraint(QCon qCon) {
        if (qCon instanceof QConJoin) {
            return this.newNodeForConstraint((QConJoin)qCon);
        }
        return new IndexedLeaf((QConObject)qCon);
    }

    private void collectImplicitAnd(QCon qCon, IndexedNodeWithRange indexedNodeWithRange, IndexedNodeWithRange indexedNodeWithRange2) {
        this._nodes.remove(indexedNodeWithRange);
        this._nodes.remove(indexedNodeWithRange2);
        this._nodes.add(new AndIndexedLeaf(qCon, indexedNodeWithRange, indexedNodeWithRange2));
    }

    private IndexedLeaf findLeafOnSameField(QConObject qConObject) {
        Iterator4 iterator4 = this._nodes.iterator();
        while (iterator4.moveNext()) {
            IndexedLeaf indexedLeaf;
            if (!(iterator4.current() instanceof IndexedLeaf) || !qConObject.onSameFieldAs((indexedLeaf = (IndexedLeaf)iterator4.current()).constraint())) continue;
            return indexedLeaf;
        }
        return null;
    }

    private boolean isLeaf(QCon qCon) {
        return !qCon.hasChildren();
    }
}

