/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.Db4o;
import com.db4o.User;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.PartialObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.LazyClientObjectSetStub;
import com.db4o.internal.cs.ObjectServerImpl;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgD;
import java.io.IOException;

public final class ServerMessageDispatcher
extends Thread {
    private String i_clientName;
    private boolean i_loggedin;
    private long i_lastClientMessage;
    private final LocalObjectContainer i_mainStream;
    private Transaction i_mainTrans;
    private int i_pingAttempts = 0;
    private int i_nullMessages;
    private boolean i_rollbackOnClose = true;
    private boolean i_sendCloseMessage = true;
    private final ObjectServerImpl i_server;
    private Socket4 i_socket;
    private LocalObjectContainer i_substituteStream;
    private Transaction i_substituteTrans;
    private Hashtable4 _queryResults;
    private Config4Impl i_config;
    final int i_threadID;

    ServerMessageDispatcher(ObjectServerImpl objectServerImpl, LocalObjectContainer localObjectContainer, Socket4 socket4, int n, boolean bl) throws Exception {
        this.setDaemon(true);
        this.i_loggedin = bl;
        this.i_lastClientMessage = System.currentTimeMillis();
        this.i_server = objectServerImpl;
        this.i_config = (Config4Impl)this.i_server.configure();
        this.i_mainStream = localObjectContainer;
        this.i_threadID = n;
        this.setName("db4o message server " + n);
        this.i_mainTrans = localObjectContainer.newTransaction();
        try {
            this.i_socket = socket4;
            this.i_socket.setSoTimeout(((Config4Impl)objectServerImpl.configure()).timeoutServerSocket());
        }
        catch (Exception exception) {
            this.i_socket.close();
            throw exception;
        }
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.closeSubstituteStream();
        this.sendCloseMessage();
        this.rollbackMainTransaction();
        this.closeSocket();
        this.removeFromServer();
    }

    private void sendCloseMessage() {
        try {
            if (this.i_sendCloseMessage) {
                this.write(Msg.CLOSE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rollbackMainTransaction() {
        if (this.i_mainStream != null && this.i_mainTrans != null) {
            this.i_mainTrans.close(this.i_rollbackOnClose);
        }
    }

    private void removeFromServer() {
        try {
            this.i_server.removeThread(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSocket() {
        try {
            this.i_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.i_socket = null;
    }

    private boolean isClosed() {
        return this.i_socket == null;
    }

    private void closeSubstituteStream() {
        if (this.i_substituteStream != null) {
            if (this.i_substituteTrans != null) {
                this.i_substituteTrans.close(this.i_rollbackOnClose);
                this.i_substituteTrans = null;
            }
            try {
                this.i_substituteStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.i_substituteStream = null;
        }
    }

    private final LocalObjectContainer getStream() {
        if (this.i_substituteStream != null) {
            return this.i_substituteStream;
        }
        return this.i_mainStream;
    }

    Transaction getTransaction() {
        if (this.i_substituteTrans != null) {
            return this.i_substituteTrans;
        }
        return this.i_mainTrans;
    }

    public void run() {
        while (this.i_socket != null) {
            try {
                if (!this.messageProcessor()) {
                    break;
                }
            }
            catch (Exception exception) {
                if (this.i_mainStream == null || this.i_mainStream.isClosed() || !this.i_socket.isConnected()) break;
                ++this.i_nullMessages;
            }
            if (this.i_nullMessages <= 20 && !this.pingClientTimeoutReached()) continue;
            if (this.i_pingAttempts > 5) {
                this.getStream().logMsg(33, this.i_clientName);
                break;
            }
            if (null == this.i_socket) break;
            this.write(Msg.PING);
            ++this.i_pingAttempts;
        }
        this.close();
    }

    private boolean pingClientTimeoutReached() {
        return System.currentTimeMillis() - this.i_lastClientMessage > (long)this.i_config.timeoutPingClients();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean messageProcessor() throws IOException {
        Msg msg = Msg.readMessage(this.getTransaction(), this.i_socket);
        if (msg == null) {
            ++this.i_nullMessages;
            return true;
        }
        this.i_lastClientMessage = System.currentTimeMillis();
        this.i_nullMessages = 0;
        this.i_pingAttempts = 0;
        if (!this.i_loggedin) {
            if (!Msg.LOGIN.equals(msg)) return true;
            String string = ((MsgD)msg).readString();
            String string2 = ((MsgD)msg).readString();
            User user = this.i_server.getUser(string);
            if (user == null) {
                this.write(Msg.FAILED);
                return false;
            }
            if (!user.password.equals(string2)) {
                this.write(Msg.FAILED);
                return false;
            }
            this.i_clientName = string;
            this.i_mainStream.logMsg(32, this.i_clientName);
            byte by = this.i_mainStream.blockSize();
            int n = this.i_mainStream.i_handlers.i_encrypt ? 1 : 0;
            this.write(Msg.LOGIN_OK.getWriterForInts(this.getTransaction(), new int[]{by, n}));
            this.i_loggedin = true;
            this.setName("db4o server socket for client " + this.i_clientName);
            return true;
        }
        if (msg.processAtServer(this)) {
            return true;
        }
        this.processSpecialMsg(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSpecialMsg(Msg msg) {
        if (Msg.PING.equals(msg)) {
            this.writeOK();
            return true;
        }
        if (Msg.OBJECTSET_FINALIZED.equals(msg)) {
            int n = ((MsgD)msg).readInt();
            this.queryResultFinalized(n);
            return true;
        }
        if (Msg.CLOSE.equals(msg)) {
            this.write(Msg.CLOSE);
            this.getTransaction().commit();
            this.i_sendCloseMessage = false;
            this.getStream().logMsg(34, this.i_clientName);
            return false;
        }
        if (Msg.IDENTITY.equals(msg)) {
            this.respondInt((int)this.getStream().getID(this.getStream().identity()));
            return true;
        }
        if (Msg.CURRENT_VERSION.equals(msg)) {
            long l = 0L;
            LocalObjectContainer localObjectContainer = this.getStream();
            synchronized (localObjectContainer) {
                l = this.getStream().currentVersion();
            }
            this.write(Msg.ID_LIST.getWriterForLong(this.getTransaction(), l));
            return true;
        }
        if (Msg.RAISE_VERSION.equals(msg)) {
            LocalObjectContainer localObjectContainer;
            long l = ((MsgD)msg).readLong();
            LocalObjectContainer localObjectContainer2 = localObjectContainer = this.getStream();
            synchronized (localObjectContainer2) {
                ((PartialObjectContainer)localObjectContainer).raiseVersion(l);
            }
            return true;
        }
        if (Msg.GET_THREAD_ID.equals(msg)) {
            this.respondInt(this.i_threadID);
            return true;
        }
        if (Msg.SWITCH_TO_FILE.equals(msg)) {
            this.switchToFile(msg);
            return true;
        }
        if (Msg.SWITCH_TO_MAIN_FILE.equals(msg)) {
            this.switchToMainFile();
            return true;
        }
        if (Msg.USE_TRANSACTION.equals(msg)) {
            this.useTransaction(msg);
            return true;
        }
        return true;
    }

    private void writeOK() {
        this.write(Msg.OK);
    }

    private void queryResultFinalized(int n) {
        this._queryResults.remove(n);
    }

    public void mapQueryResultToID(LazyClientObjectSetStub lazyClientObjectSetStub, int n) {
        if (this._queryResults == null) {
            this._queryResults = new Hashtable4();
        }
        this._queryResults.put(n, (Object)lazyClientObjectSetStub);
    }

    public LazyClientObjectSetStub queryResultForID(int n) {
        return (LazyClientObjectSetStub)this._queryResults.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToFile(Msg msg) {
        Object object = this.i_mainStream.i_lock;
        synchronized (object) {
            String string = ((MsgD)msg).readString();
            try {
                this.closeSubstituteStream();
                this.i_substituteStream = (LocalObjectContainer)Db4o.openFile(string);
                this.i_substituteTrans = this.i_substituteStream.newTransaction();
                this.i_substituteStream.configImpl().setMessageRecipient(this.i_mainStream.configImpl().messageRecipient());
                this.writeOK();
            }
            catch (Exception exception) {
                this.closeSubstituteStream();
                this.write(Msg.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToMainFile() {
        Object object = this.i_mainStream.i_lock;
        synchronized (object) {
            this.closeSubstituteStream();
            this.writeOK();
        }
    }

    private void useTransaction(Msg msg) {
        int n = ((MsgD)msg).readInt();
        ServerMessageDispatcher serverMessageDispatcher = this.i_server.findThread(n);
        if (serverMessageDispatcher != null) {
            Transaction transaction = serverMessageDispatcher.getTransaction();
            if (this.i_substituteTrans != null) {
                this.i_substituteTrans = transaction;
            } else {
                this.i_mainTrans = transaction;
            }
            this.i_rollbackOnClose = false;
        }
    }

    private void respondInt(int n) {
        this.write(Msg.ID_LIST.getWriterForInt(this.getTransaction(), n));
    }

    public void write(Msg msg) {
        msg.write(this.getStream(), this.i_socket);
    }

    public Socket4 socket() {
        return this.i_socket;
    }
}

