/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.Configuration;
import com.db4o.config.FreespaceFiller;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.internal.Buffer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.io.IoAdapter;
import com.db4o.io.IoAdapterWindow;
import java.io.IOException;

public class IoAdaptedObjectContainer
extends LocalObjectContainer {
    private final String _fileName;
    private IoAdapter _file;
    private IoAdapter _timerFile;
    private volatile IoAdapter _backupFile;
    private Object _fileLock;
    private final FreespaceFiller _freespaceFiller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IoAdaptedObjectContainer(Configuration configuration, String string) throws Exception {
        super(configuration, null);
        Object object = this.i_lock;
        synchronized (object) {
            this._fileLock = new Object();
            this._fileName = string;
            this._freespaceFiller = this.createFreespaceFiller();
            try {
                this.open();
            }
            catch (DatabaseFileLockedException databaseFileLockedException) {
                this.stopSession();
                throw databaseFileLockedException;
            }
            this.initialize3();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String string) throws IOException {
        Object object;
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.checkClosed();
            if (this._backupFile != null) {
                Exceptions4.throwRuntimeException(61);
            }
            try {
                this._backupFile = this.configImpl().ioAdapter().open(string, true, this._file.getLength());
                this._backupFile.blockSize(this.blockSize());
            }
            catch (Exception exception) {
                this._backupFile = null;
                Exceptions4.throwRuntimeException(12, string);
            }
        }
        long l = 0L;
        int n = 8192;
        byte[] byArray = new byte[n];
        while (true) {
            object = this.i_lock;
            synchronized (object) {
                this._file.seek(l);
                int n2 = this._file.read(byArray);
                if (n2 <= 0) {
                    break;
                }
                this._backupFile.seek(l);
                this._backupFile.write(byArray, n2);
                l += (long)n2;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = this.i_lock;
        synchronized (object) {
            this._backupFile.close();
            this._backupFile = null;
        }
    }

    public void blockSize(int n) {
        this._file.blockSize(n);
        if (this._timerFile != null) {
            this._timerFile.blockSize(n);
        }
    }

    public byte blockSize() {
        return (byte)this._file.blockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean close2() {
        this.freePrefetchedPointers();
        try {
            this.write(true);
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
        super.close2();
        Object object = this._fileLock;
        synchronized (object) {
            try {
                this._file.close();
                this._file = null;
                this._fileHeader.close();
                this.closeTimerFile();
            }
            catch (Exception exception) {
                this._file = null;
                Exceptions4.throwRuntimeException(11, exception);
            }
            this._file = null;
        }
        return true;
    }

    public void commit1() {
        this.ensureLastSlotWritten();
        super.commit1();
    }

    public void copy(int n, int n2, int n3, int n4, int n5) {
        try {
            if (this._backupFile == null) {
                this._file.blockCopy(n, n2, n3, n4, n5);
                return;
            }
            byte[] byArray = new byte[n5];
            this._file.blockSeek(n, n2);
            this._file.read(byArray);
            this._file.blockSeek(n3, n4);
            this._file.write(byArray);
            if (this._backupFile != null) {
                this._backupFile.blockSeek(n3, n4);
                this._backupFile.write(byArray);
            }
        }
        catch (Exception exception) {
            Exceptions4.throwRuntimeException(16, exception);
        }
    }

    private void checkXBytes(int n, int n2, int n3) {
    }

    void emergencyClose() {
        super.emergencyClose();
        try {
            this._file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._file = null;
    }

    public long fileLength() {
        try {
            return this._file.getLength();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public String fileName() {
        return this._fileName;
    }

    private void open() throws Exception {
        block12: {
            boolean bl = false;
            IoAdapter ioAdapter = this.configImpl().ioAdapter();
            try {
                if (this.fileName().length() > 0) {
                    if (!ioAdapter.exists(this.fileName())) {
                        bl = true;
                        this.logMsg(14, this.fileName());
                        this.i_handlers.oldEncryptionOff();
                    }
                    try {
                        boolean bl2 = this.configImpl().lockFile() && !this.configImpl().isReadOnly();
                        this._file = ioAdapter.open(this.fileName(), bl2, 0L);
                        if (this.needsTimerFile()) {
                            this._timerFile = ioAdapter.delegatedIoAdapter().open(this.fileName(), false, 0L);
                        }
                    }
                    catch (DatabaseFileLockedException databaseFileLockedException) {
                        throw databaseFileLockedException;
                    }
                    catch (Exception exception) {
                        Exceptions4.throwRuntimeException(12, this.fileName(), exception);
                    }
                    if (bl) {
                        this.configureNewFile();
                        if (this.configImpl().reservedStorageSpace() > 0) {
                            this.reserve(this.configImpl().reservedStorageSpace());
                        }
                        this.write(false);
                        this.writeHeader(true, false);
                    } else {
                        this.readThis();
                    }
                    break block12;
                }
                Exceptions4.throwRuntimeException(21);
            }
            catch (Exception exception) {
                if (this.i_references != null) {
                    this.i_references.stopTimer();
                }
                throw exception;
            }
        }
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        this.readBytes(byArray, n, 0, n2);
    }

    public void readBytes(byte[] byArray, int n, int n2, int n3) {
        try {
            this._file.blockSeek(n, n2);
            int n4 = this._file.read(byArray, n3);
            if (n4 != n3) {
                Exceptions4.throwRuntimeException(68, n + "/" + n2, null, false);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reserve(int n) {
        Object object = this.i_lock;
        synchronized (object) {
            int n2 = this.getSlot(n);
            this.zeroReservedStorage(n2, n);
            this.free(n2, n);
        }
    }

    private void zeroReservedStorage(int n, int n2) {
        if (this.configImpl().isReadOnly()) {
            return;
        }
        try {
            this.zeroFile(this._file, n, n2);
            this.zeroFile(this._backupFile, n, n2);
        }
        catch (IOException iOException) {
            Exceptions4.throwRuntimeException(16, iOException);
        }
    }

    private void zeroFile(IoAdapter ioAdapter, int n, int n2) throws IOException {
        int n3;
        if (ioAdapter == null) {
            return;
        }
        byte[] byArray = new byte[1024];
        ioAdapter.blockSeek(n, 0);
        for (n3 = n2; n3 > byArray.length; n3 -= byArray.length) {
            ioAdapter.write(byArray, byArray.length);
        }
        if (n3 > 0) {
            ioAdapter.write(byArray, n3);
        }
    }

    public void syncFiles() {
        try {
            this._file.sync();
            if (this._timerFile != null) {
                this._timerFile.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean needsTimerFile() {
        return this.needsLockFileThread();
    }

    private void closeTimerFile() throws IOException {
        if (this._timerFile == null) {
            return;
        }
        this._timerFile.close();
        this._timerFile = null;
    }

    public void writeBytes(Buffer buffer, int n, int n2) {
        if (this.configImpl().isReadOnly()) {
            return;
        }
        try {
            this._file.blockSeek(n, n2);
            this._file.write(buffer._buffer, buffer.getLength());
            if (this._backupFile != null) {
                this._backupFile.blockSeek(n, n2);
                this._backupFile.write(buffer._buffer, buffer.getLength());
            }
        }
        catch (Exception exception) {
            Exceptions4.throwRuntimeException(16, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteDeletedBytes(int n, int n2) {
        if (!this.configImpl().isReadOnly() && this._freespaceFiller != null && n > 0 && n2 > 0) {
            IoAdapterWindow ioAdapterWindow = new IoAdapterWindow(this._file, n, n2);
            try {
                this.createFreespaceFiller().fill(ioAdapterWindow);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                ioAdapterWindow.disable();
            }
        }
    }

    public IoAdapter timerFile() {
        return this._timerFile;
    }

    private FreespaceFiller createFreespaceFiller() {
        FreespaceFiller freespaceFiller = this.config().freespaceFiller();
        return freespaceFiller;
    }

    private static class XByteFreespaceFiller
    implements FreespaceFiller {
        private XByteFreespaceFiller() {
        }

        public void fill(IoAdapterWindow ioAdapterWindow) throws IOException {
            ioAdapterWindow.write(0, this.xBytes(ioAdapterWindow.length()));
        }

        private byte[] xBytes(int n) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = 88;
            }
            return byArray;
        }
    }
}

