/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.DeepClone;
import com.db4o.foundation.HashtableByteArrayEntry;
import com.db4o.foundation.HashtableIntEntry;
import com.db4o.foundation.HashtableObjectEntry;
import com.db4o.foundation.Visitor4;

public class Hashtable4
implements DeepClone {
    private static final float FILL = 0.5f;
    private int i_tableSize;
    private int i_mask;
    private int i_maximumSize;
    private int i_size;
    private HashtableIntEntry[] i_table;

    public Hashtable4(int n) {
        n = this.newSize(n);
        this.i_tableSize = 1;
        while (this.i_tableSize < n) {
            this.i_tableSize <<= 1;
        }
        this.i_mask = this.i_tableSize - 1;
        this.i_maximumSize = (int)((float)this.i_tableSize * 0.5f);
        this.i_table = new HashtableIntEntry[this.i_tableSize];
    }

    public Hashtable4() {
        this(1);
    }

    protected Hashtable4(DeepClone deepClone) {
    }

    public int size() {
        return this.i_size;
    }

    public Object deepClone(Object object) {
        return this.deepCloneInternal(new Hashtable4(null), object);
    }

    public void forEachKey(Visitor4 visitor4) {
        for (int i = 0; i < this.i_table.length; ++i) {
            HashtableIntEntry hashtableIntEntry = this.i_table[i];
            while (hashtableIntEntry != null) {
                hashtableIntEntry.acceptKeyVisitor(visitor4);
                hashtableIntEntry = hashtableIntEntry.i_next;
            }
        }
    }

    public void forEachKeyForIdentity(Visitor4 visitor4, Object object) {
        for (int i = 0; i < this.i_table.length; ++i) {
            HashtableIntEntry hashtableIntEntry = this.i_table[i];
            while (hashtableIntEntry != null) {
                if (hashtableIntEntry.i_object == object) {
                    hashtableIntEntry.acceptKeyVisitor(visitor4);
                }
                hashtableIntEntry = hashtableIntEntry.i_next;
            }
        }
    }

    public void forEachValue(Visitor4 visitor4) {
        for (int i = 0; i < this.i_table.length; ++i) {
            HashtableIntEntry hashtableIntEntry = this.i_table[i];
            while (hashtableIntEntry != null) {
                visitor4.visit(hashtableIntEntry.i_object);
                hashtableIntEntry = hashtableIntEntry.i_next;
            }
        }
    }

    public Object get(byte[] byArray) {
        int n = HashtableByteArrayEntry.hash(byArray);
        return this.getFromObjectEntry(n, byArray);
    }

    public Object get(int n) {
        HashtableIntEntry hashtableIntEntry = this.i_table[n & this.i_mask];
        while (hashtableIntEntry != null) {
            if (hashtableIntEntry.i_key == n) {
                return hashtableIntEntry.i_object;
            }
            hashtableIntEntry = hashtableIntEntry.i_next;
        }
        return null;
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        return this.getFromObjectEntry(object.hashCode(), object);
    }

    public boolean containsKey(Object object) {
        if (null == object) {
            return false;
        }
        return null != this.getObjectEntry(object.hashCode(), object);
    }

    public void put(byte[] byArray, Object object) {
        this.putEntry(new HashtableByteArrayEntry(byArray, object));
    }

    public void put(int n, Object object) {
        this.putEntry(new HashtableIntEntry(n, object));
    }

    public void put(Object object, Object object2) {
        this.putEntry(new HashtableObjectEntry(object, object2));
    }

    public Object remove(byte[] byArray) {
        int n = HashtableByteArrayEntry.hash(byArray);
        return this.removeObjectEntry(n, byArray);
    }

    public void remove(int n) {
        HashtableIntEntry hashtableIntEntry = this.i_table[n & this.i_mask];
        HashtableIntEntry hashtableIntEntry2 = null;
        while (hashtableIntEntry != null) {
            if (hashtableIntEntry.i_key == n) {
                this.removeEntry(hashtableIntEntry2, hashtableIntEntry);
                return;
            }
            hashtableIntEntry2 = hashtableIntEntry;
            hashtableIntEntry = hashtableIntEntry.i_next;
        }
    }

    public void remove(Object object) {
        int n = object.hashCode();
        this.removeObjectEntry(n, object);
    }

    protected Hashtable4 deepCloneInternal(Hashtable4 hashtable4, Object object) {
        hashtable4.i_mask = this.i_mask;
        hashtable4.i_maximumSize = this.i_maximumSize;
        hashtable4.i_size = this.i_size;
        hashtable4.i_tableSize = this.i_tableSize;
        hashtable4.i_table = new HashtableIntEntry[this.i_tableSize];
        for (int i = 0; i < this.i_tableSize; ++i) {
            if (this.i_table[i] == null) continue;
            hashtable4.i_table[i] = (HashtableIntEntry)this.i_table[i].deepClone(object);
        }
        return hashtable4;
    }

    private int entryIndex(HashtableIntEntry hashtableIntEntry) {
        return hashtableIntEntry.i_key & this.i_mask;
    }

    private HashtableIntEntry findWithSameKey(HashtableIntEntry hashtableIntEntry) {
        HashtableIntEntry hashtableIntEntry2 = this.i_table[this.entryIndex(hashtableIntEntry)];
        while (null != hashtableIntEntry2) {
            if (hashtableIntEntry2.sameKeyAs(hashtableIntEntry)) {
                return hashtableIntEntry2;
            }
            hashtableIntEntry2 = hashtableIntEntry2.i_next;
        }
        return null;
    }

    private Object getFromObjectEntry(int n, Object object) {
        HashtableObjectEntry hashtableObjectEntry = this.getObjectEntry(n, object);
        return hashtableObjectEntry == null ? null : hashtableObjectEntry.i_object;
    }

    private HashtableObjectEntry getObjectEntry(int n, Object object) {
        HashtableObjectEntry hashtableObjectEntry = (HashtableObjectEntry)this.i_table[n & this.i_mask];
        while (hashtableObjectEntry != null) {
            if (hashtableObjectEntry.i_key == n && hashtableObjectEntry.hasKey(object)) {
                return hashtableObjectEntry;
            }
            hashtableObjectEntry = (HashtableObjectEntry)hashtableObjectEntry.i_next;
        }
        return null;
    }

    private void increaseSize() {
        this.i_tableSize <<= 1;
        this.i_maximumSize <<= 1;
        this.i_mask = this.i_tableSize - 1;
        HashtableIntEntry[] hashtableIntEntryArray = this.i_table;
        this.i_table = new HashtableIntEntry[this.i_tableSize];
        for (int i = 0; i < hashtableIntEntryArray.length; ++i) {
            this.reposition(hashtableIntEntryArray[i]);
        }
    }

    private void insert(HashtableIntEntry hashtableIntEntry) {
        ++this.i_size;
        if (this.i_size > this.i_maximumSize) {
            this.increaseSize();
        }
        int n = this.entryIndex(hashtableIntEntry);
        hashtableIntEntry.i_next = this.i_table[n];
        this.i_table[n] = hashtableIntEntry;
    }

    private final int newSize(int n) {
        return (int)((float)n / 0.5f);
    }

    private void putEntry(HashtableIntEntry hashtableIntEntry) {
        HashtableIntEntry hashtableIntEntry2 = this.findWithSameKey(hashtableIntEntry);
        if (null != hashtableIntEntry2) {
            this.replace(hashtableIntEntry2, hashtableIntEntry);
        } else {
            this.insert(hashtableIntEntry);
        }
    }

    private void removeEntry(HashtableIntEntry hashtableIntEntry, HashtableIntEntry hashtableIntEntry2) {
        if (hashtableIntEntry != null) {
            hashtableIntEntry.i_next = hashtableIntEntry2.i_next;
        } else {
            this.i_table[this.entryIndex((HashtableIntEntry)hashtableIntEntry2)] = hashtableIntEntry2.i_next;
        }
        --this.i_size;
    }

    private Object removeObjectEntry(int n, Object object) {
        HashtableObjectEntry hashtableObjectEntry = (HashtableObjectEntry)this.i_table[n & this.i_mask];
        HashtableObjectEntry hashtableObjectEntry2 = null;
        while (hashtableObjectEntry != null) {
            if (hashtableObjectEntry.i_key == n && hashtableObjectEntry.hasKey(object)) {
                this.removeEntry(hashtableObjectEntry2, hashtableObjectEntry);
                return hashtableObjectEntry.i_object;
            }
            hashtableObjectEntry2 = hashtableObjectEntry;
            hashtableObjectEntry = (HashtableObjectEntry)hashtableObjectEntry.i_next;
        }
        return null;
    }

    private void replace(HashtableIntEntry hashtableIntEntry, HashtableIntEntry hashtableIntEntry2) {
        hashtableIntEntry2.i_next = hashtableIntEntry.i_next;
        HashtableIntEntry hashtableIntEntry3 = this.i_table[this.entryIndex(hashtableIntEntry)];
        if (hashtableIntEntry3 == hashtableIntEntry) {
            this.i_table[this.entryIndex((HashtableIntEntry)hashtableIntEntry)] = hashtableIntEntry2;
        } else {
            while (hashtableIntEntry3.i_next != hashtableIntEntry) {
                hashtableIntEntry3 = hashtableIntEntry3.i_next;
            }
            hashtableIntEntry3.i_next = hashtableIntEntry2;
        }
    }

    private void reposition(HashtableIntEntry hashtableIntEntry) {
        if (hashtableIntEntry != null) {
            this.reposition(hashtableIntEntry.i_next);
            hashtableIntEntry.i_next = this.i_table[this.entryIndex(hashtableIntEntry)];
            this.i_table[this.entryIndex((HashtableIntEntry)hashtableIntEntry)] = hashtableIntEntry;
        }
    }
}

