/*
 * Decompiled with CFR 0.152.
 */
package msearch.gui;

import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.gui.MSearchGui;
import msearch.tool.MSConfig;

public class MSearchGuiLoad {
    public MSFilmeSuchen msFilmeSuchen;
    private final EventListenerList listeners = new EventListenerList();
    private boolean istAmLaufen = false;

    public MSearchGuiLoad() {
        this.msFilmeSuchen = new MSFilmeSuchen();
        this.msFilmeSuchen.addAdListener(new MSListenerFilmeLaden(){

            @Override
            public synchronized void start(MSListenerFilmeLadenEvent event) {
                MSearchGuiLoad.this.notifyStart(event);
            }

            @Override
            public synchronized void progress(MSListenerFilmeLadenEvent event) {
                MSearchGuiLoad.this.notifyProgress(event);
            }

            @Override
            public synchronized void fertig(MSListenerFilmeLadenEvent event) {
                MSearchGui.listeFilme = MSearchGuiLoad.this.msFilmeSuchen.listeFilmeNeu;
                MSearchGuiLoad.this.undEnde(event);
            }
        });
    }

    public void filmeBeimSenderSuchen(boolean filmlisteUpdate) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            MSConfig.updateFilmliste = filmlisteUpdate;
            this.msFilmeSuchen.filmeBeimSenderLaden(MSearchGui.listeFilme);
        }
    }

    public void updateSender(String[] sender) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.msFilmeSuchen.updateSender(sender, MSearchGui.listeFilme);
        }
    }

    public String[] getSenderNamen() {
        return MSFilmeSuchen.getNamenSender();
    }

    private void undEnde(MSListenerFilmeLadenEvent event) {
        this.istAmLaufen = false;
        this.notifyFertig(event);
        System.gc();
    }

    public void addAdListener(MSListenerFilmeLaden listener) {
        this.listeners.add(MSListenerFilmeLaden.class, listener);
    }

    private void notifyStart(MSListenerFilmeLadenEvent event) {
        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
            this.run_(new Start(l, event, ListenerMelden.START));
        }
    }

    private void notifyProgress(MSListenerFilmeLadenEvent event) {
        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
            this.run_(new Start(l, event, ListenerMelden.PROGRESS));
        }
    }

    private void notifyFertig(MSListenerFilmeLadenEvent event) {
        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
            this.run_(new Start(l, event, ListenerMelden.FINISHED));
        }
    }

    private void run_(Runnable r) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Start
    implements Runnable {
        private final MSListenerFilmeLaden listenerFilmeLaden;
        private final MSListenerFilmeLadenEvent event;
        private final ListenerMelden listenerMelden;

        public Start(MSListenerFilmeLaden llistenerFilmeLaden, MSListenerFilmeLadenEvent eevent, ListenerMelden lliListenerMelden) {
            this.listenerFilmeLaden = llistenerFilmeLaden;
            this.event = eevent;
            this.listenerMelden = lliListenerMelden;
        }

        @Override
        public synchronized void run() {
            switch (this.listenerMelden) {
                case START: {
                    this.listenerFilmeLaden.start(this.event);
                    break;
                }
                case PROGRESS: {
                    this.listenerFilmeLaden.progress(this.event);
                    break;
                }
                case FINISHED: {
                    this.listenerFilmeLaden.fertig(this.event);
                }
            }
        }
    }

    private static enum ListenerMelden {
        START,
        PROGRESS,
        FINISHED;

    }
}

