/*
 * Decompiled with CFR 0.152.
 */
package msearch.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import msearch.daten.ListeFilme;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmlisten.MSFilmlisteLesen;
import msearch.filmlisten.WriteFilmlistJson;
import msearch.gui.MSearchGuiLoad;
import msearch.gui.PanelSenderSearch;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;

public final class MSearchGui
extends JFrame {
    String pfad = "";
    public static ListeFilme listeFilme;
    private MSearchGuiLoad filmeLaden;
    private final JButton[] buttonSender;
    private final String[] sender;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAlleSenderLaden;
    private JButton jButtonCheck;
    private JButton jButtonFilmliste;
    private JButton jButtonFilmlisteLoeschen;
    private JButton jButtonGc;
    private JButton jButtonLog;
    private JButton jButtonSpeichern;
    private JCheckBox jCheckBoxDebug;
    private JCheckBox jCheckBoxLoadTime;
    private JLabel jLabel1;
    private JLabel jLabel2;
    public static JLabel jLabelAnzahl;
    private JPanel jPanel1;
    private JPanel jPanelLoeschen;
    private JPanel jPanelSenderDelete;
    private JPanel jPanelSenderLaden;
    private JPanel jPanelSuchen;
    private JPanel jPanelTool;
    private JRadioButton jRadioButtonLong;
    private JRadioButton jRadioButtonMax;
    private JRadioButton jRadioButtonShort;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldFilmliste;
    private JToggleButton jToggleButtonUpdate;

    public MSearchGui(String[] ar) {
        this.initComponents();
        if (ar != null && ar.length > 0 && !ar[0].startsWith("-")) {
            this.pfad = ar[0];
        }
        listeFilme = new ListeFilme();
        this.filmeLaden = new MSearchGuiLoad();
        if (this.pfad.isEmpty()) {
            this.jTextFieldFilmliste.setText(System.getProperty("user.home") + File.separator + ".mediathek3" + File.separator + "filme.json");
        } else {
            this.jTextFieldFilmliste.setText(this.pfad);
        }
        new MSFilmlisteLesen().readFilmListe(this.jTextFieldFilmliste.getText(), listeFilme, 0);
        jLabelAnzahl.setText(listeFilme.size() + "");
        this.jButtonFilmlisteLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listeFilme.clear();
            }
        });
        this.jButtonCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listeFilme.check();
            }
        });
        this.jRadioButtonShort.setSelected(true);
        MSConfig.senderLoadHow = 0;
        this.jRadioButtonShort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSConfig.senderLoadHow = 0;
            }
        });
        this.jRadioButtonLong.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSConfig.senderLoadHow = 1;
            }
        });
        this.jRadioButtonMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSConfig.senderLoadHow = 2;
            }
        });
        MSGetUrl.showLoadTime = this.jCheckBoxLoadTime.isSelected();
        this.jCheckBoxLoadTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSGetUrl.showLoadTime = MSearchGui.this.jCheckBoxLoadTime.isSelected();
            }
        });
        MSConfig.debug = this.jCheckBoxDebug.isSelected();
        this.jCheckBoxDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSConfig.debug = MSearchGui.this.jCheckBoxDebug.isSelected();
            }
        });
        this.jToggleButtonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSConfig.updateFilmliste = MSearchGui.this.jToggleButtonUpdate.isSelected();
            }
        });
        this.jButtonAlleSenderLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MSearchGui.this.filmeLaden.filmeBeimSenderSuchen(true);
                    }
                }).start();
            }
        });
        this.jButtonSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new WriteFilmlistJson().filmlisteSchreibenJson(MSearchGui.this.jTextFieldFilmliste.getText(), listeFilme);
            }
        });
        this.jButtonFilmliste.addActionListener(new BeobPfad());
        this.jPanelSenderLaden.setLayout(new BorderLayout());
        this.jPanelSenderLaden.add((Component)new PanelSenderSearch(this.filmeLaden), "Center");
        this.sender = this.filmeLaden.getSenderNamen();
        this.buttonSender = new JButton[this.sender.length];
        for (int i = 0; i < this.filmeLaden.getSenderNamen().length; ++i) {
            this.buttonSender[i] = new JButton(this.sender[i]);
            this.buttonSender[i].addActionListener(new BeobSenderLoeschen(this.sender[i]));
        }
        this.addSender();
        this.jButtonLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                String datei = "/tmp/testfile";
                Date aktTime = new Date(System.currentTimeMillis());
                String aktTimeStr = sdf.format(aktTime);
                MSLog.systemMeldung("");
                MSLog.systemMeldung("Log schreiben: " + datei);
                MSLog.systemMeldung("--> " + aktTimeStr);
                File file = new File(datei);
                File dir = new File(file.getParent());
                if (!dir.exists() && !dir.mkdirs()) {
                    MSLog.fehlerMeldung(632012165, "Kann den Pfad nicht anlegen: " + dir.toString());
                }
                try {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8");
                    out.write("===============================================================");
                    out.write("===============================================================");
                    out.write("\n");
                    out.write("--> " + aktTimeStr);
                    out.write("\n");
                    ArrayList<String> ret = ((MSearchGui)MSearchGui.this).filmeLaden.msFilmeSuchen.endeMeldung();
                    for (String s : ret) {
                        out.write(s);
                        out.write("\n");
                    }
                    ret = MSLog.fehlerMeldungen();
                    for (String s : ret) {
                        out.write(s);
                        out.write("\n");
                    }
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.write("\n");
                    out.close();
                    MSLog.systemMeldung("--> geschrieben!");
                }
                catch (Exception ex) {
                    MSLog.fehlerMeldung(846930145, ex, "nach: " + datei);
                }
            }
        });
    }

    private void addSender() {
        this.jPanelSenderDelete.removeAll();
        this.jPanelSenderDelete.setLayout(new GridLayout(0, 5));
        int nr = 0;
        for (String aSender : this.sender) {
            JButton btn = this.buttonSender[nr];
            btn.setText(aSender);
            this.jPanelSenderDelete.add(btn);
            ++nr;
        }
        this.jPanelSenderDelete.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.jPanelSuchen = new JPanel();
        this.jButtonFilmlisteLoeschen = new JButton();
        this.jButtonAlleSenderLaden = new JButton();
        this.jPanelSenderLaden = new JPanel();
        this.jToggleButtonUpdate = new JToggleButton();
        this.jRadioButtonShort = new JRadioButton();
        this.jRadioButtonLong = new JRadioButton();
        this.jRadioButtonMax = new JRadioButton();
        this.jCheckBoxLoadTime = new JCheckBox();
        this.jCheckBoxDebug = new JCheckBox();
        this.jPanelLoeschen = new JPanel();
        this.jPanelSenderDelete = new JPanel();
        this.jPanelTool = new JPanel();
        this.jButtonCheck = new JButton();
        this.jButtonGc = new JButton();
        this.jButtonLog = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        jLabelAnzahl = new JLabel();
        this.jTextFieldFilmliste = new JTextField();
        this.jButtonFilmliste = new JButton();
        this.jButtonSpeichern = new JButton();
        this.setDefaultCloseOperation(3);
        this.jButtonFilmlisteLoeschen.setText("Filmliste l\u00f6schen");
        this.jButtonAlleSenderLaden.setText("alle Sender laden");
        this.jPanelSenderLaden.setBorder(new SoftBevelBorder(1));
        GroupLayout jPanelSenderLadenLayout = new GroupLayout(this.jPanelSenderLaden);
        this.jPanelSenderLaden.setLayout(jPanelSenderLadenLayout);
        jPanelSenderLadenLayout.setHorizontalGroup(jPanelSenderLadenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelSenderLadenLayout.setVerticalGroup(jPanelSenderLadenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 408, Short.MAX_VALUE));
        this.jToggleButtonUpdate.setText("[-update] setzen");
        this.buttonGroup1.add(this.jRadioButtonShort);
        this.jRadioButtonShort.setSelected(true);
        this.jRadioButtonShort.setText("Short");
        this.buttonGroup1.add(this.jRadioButtonLong);
        this.jRadioButtonLong.setText("Long");
        this.buttonGroup1.add(this.jRadioButtonMax);
        this.jRadioButtonMax.setText("Max");
        this.jCheckBoxLoadTime.setText("Ladezeit");
        this.jCheckBoxDebug.setText("Debug");
        GroupLayout jPanelSuchenLayout = new GroupLayout(this.jPanelSuchen);
        this.jPanelSuchen.setLayout(jPanelSuchenLayout);
        jPanelSuchenLayout.setHorizontalGroup(jPanelSuchenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSuchenLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSuchenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSuchenLayout.createSequentialGroup().addComponent(this.jPanelSenderLaden, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelSuchenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonLong).addComponent(this.jRadioButtonShort).addComponent(this.jRadioButtonMax).addComponent(this.jCheckBoxLoadTime).addComponent(this.jCheckBoxDebug))).addGroup(jPanelSuchenLayout.createSequentialGroup().addComponent(this.jButtonFilmlisteLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAlleSenderLaden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonUpdate).addGap(0, 424, Short.MAX_VALUE))).addContainerGap()));
        jPanelSuchenLayout.setVerticalGroup(jPanelSuchenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSuchenLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSuchenLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFilmlisteLoeschen).addComponent(this.jButtonAlleSenderLaden).addComponent(this.jToggleButtonUpdate)).addGroup(jPanelSuchenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSuchenLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelSenderLaden, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(jPanelSuchenLayout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jRadioButtonShort).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonLong).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonMax).addGap(18, 18, 18).addComponent(this.jCheckBoxLoadTime).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxDebug).addContainerGap(-1, Short.MAX_VALUE)))));
        this.jTabbedPane.addTab("Suchen", this.jPanelSuchen);
        GroupLayout jPanelSenderDeleteLayout = new GroupLayout(this.jPanelSenderDelete);
        this.jPanelSenderDelete.setLayout(jPanelSenderDeleteLayout);
        jPanelSenderDeleteLayout.setHorizontalGroup(jPanelSenderDeleteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanelSenderDeleteLayout.setVerticalGroup(jPanelSenderDeleteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        GroupLayout jPanelLoeschenLayout = new GroupLayout(this.jPanelLoeschen);
        this.jPanelLoeschen.setLayout(jPanelLoeschenLayout);
        jPanelLoeschenLayout.setHorizontalGroup(jPanelLoeschenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLoeschenLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelSenderDelete, -2, -1, -2).addContainerGap(814, Short.MAX_VALUE)));
        jPanelLoeschenLayout.setVerticalGroup(jPanelLoeschenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLoeschenLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelSenderDelete, -2, -1, -2).addContainerGap(363, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("L\u00f6schen", this.jPanelLoeschen);
        this.jButtonCheck.setText("Check Filmliste");
        this.jButtonGc.setText("Gcc");
        this.jButtonLog.setText("Log schreiben");
        GroupLayout jPanelToolLayout = new GroupLayout(this.jPanelTool);
        this.jPanelTool.setLayout(jPanelToolLayout);
        jPanelToolLayout.setHorizontalGroup(jPanelToolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelToolLayout.createSequentialGroup().addContainerGap().addGroup(jPanelToolLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCheck, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonGc, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonLog, -1, -1, Short.MAX_VALUE)).addContainerGap(775, Short.MAX_VALUE)));
        jPanelToolLayout.linkSize(0, this.jButtonCheck, this.jButtonGc);
        jPanelToolLayout.setVerticalGroup(jPanelToolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelToolLayout.createSequentialGroup().addContainerGap().addComponent(this.jButtonCheck).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonGc).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonLog).addContainerGap(364, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("Tool", this.jPanelTool);
        this.jLabel1.setText("Filmliste:");
        this.jLabel2.setText("Anzahl Filme:");
        jLabelAnzahl.setText("-1");
        this.jTextFieldFilmliste.setText("jTextField1");
        this.jButtonFilmliste.setText("Ausw\u00e4hlen");
        this.jButtonSpeichern.setText("Speichern");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabelAnzahl).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilmliste))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilmliste).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSpeichern).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTabbedPane, -2, 502, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jTextFieldFilmliste, -2, -1, -2).addComponent(this.jButtonFilmliste).addComponent(this.jButtonSpeichern)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(jLabelAnzahl)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jButtonFilmliste, this.jButtonSpeichern, this.jLabel1, this.jTextFieldFilmliste);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (!MSearchGui.this.jTextFieldFilmliste.getText().equals("")) {
                chooser.setCurrentDirectory(new File(MSearchGui.this.jTextFieldFilmliste.getText()));
            }
            chooser.setFileSelectionMode(0);
            chooser.setFileHidingEnabled(false);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    MSearchGui.this.jTextFieldFilmliste.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class BeobSenderLoeschen
    implements ActionListener {
        private final String sender;

        public BeobSenderLoeschen(String ssender) {
            this.sender = ssender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            listeFilme.deleteAllFilms(this.sender);
            jLabelAnzahl.setText(listeFilme.size() + "");
        }
    }
}

