/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmlisten;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import msearch.daten.DatenFilm;
import msearch.daten.ListeFilme;
import msearch.tool.MSLog;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

public class WriteFilmlistJson {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filmlisteSchreibenJson(String datei, ListeFilme listeFilme) {
        ZipOutputStream zipOutputStream = null;
        XZOutputStream xZOutputStream = null;
        JsonGenerator jg = null;
        try {
            int i;
            MSLog.systemMeldung("Filme schreiben (" + listeFilme.size() + " Filme) :");
            File file = new File(datei);
            File dir = new File(file.getParent());
            if (!dir.exists() && !dir.mkdirs()) {
                MSLog.fehlerMeldung(915236478, "Kann den Pfad nicht anlegen: " + dir.toString());
            }
            MSLog.systemMeldung("   --> Start Schreiben nach: " + datei);
            String sender = "";
            String thema = "";
            JsonFactory jsonF = new JsonFactory();
            if (datei.endsWith(".xz")) {
                LZMA2Options options = new LZMA2Options();
                xZOutputStream = new XZOutputStream((OutputStream)new FileOutputStream(file), (FilterOptions)options);
                jg = jsonF.createGenerator((OutputStream)xZOutputStream);
            } else if (datei.endsWith(".zip")) {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                ZipEntry entry = new ZipEntry("filme.xml");
                zipOutputStream.putNextEntry(entry);
                jg = jsonF.createGenerator((OutputStream)zipOutputStream, JsonEncoding.UTF8);
            } else {
                jg = jsonF.createGenerator(new File(datei), JsonEncoding.UTF8);
            }
            jg.useDefaultPrettyPrinter();
            jg.writeStartObject();
            jg.writeArrayFieldStart("Filmliste");
            for (i = 0; i < 5; ++i) {
                jg.writeString(listeFilme.metaDaten[i]);
            }
            jg.writeEndArray();
            jg.writeArrayFieldStart("Filmliste");
            for (i = 0; i < DatenFilm.COLUMN_NAMES_JSON.length; ++i) {
                jg.writeString(DatenFilm.COLUMN_NAMES[DatenFilm.COLUMN_NAMES_JSON[i]]);
            }
            jg.writeEndArray();
            ListIterator iterator = listeFilme.listIterator();
            while (iterator.hasNext()) {
                DatenFilm datenFilm = (DatenFilm)iterator.next();
                jg.writeArrayFieldStart("X");
                for (int i2 = 0; i2 < DatenFilm.COLUMN_NAMES_JSON.length; ++i2) {
                    int m = DatenFilm.COLUMN_NAMES_JSON[i2];
                    if (m == 1) {
                        if (datenFilm.arr[m].equals(sender)) {
                            jg.writeString("");
                            continue;
                        }
                        sender = datenFilm.arr[m];
                        jg.writeString(datenFilm.arr[m]);
                        continue;
                    }
                    if (m == 2) {
                        if (datenFilm.arr[m].equals(thema)) {
                            jg.writeString("");
                            continue;
                        }
                        thema = datenFilm.arr[m];
                        jg.writeString(datenFilm.arr[m]);
                        continue;
                    }
                    jg.writeString(datenFilm.arr[m]);
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
            MSLog.systemMeldung("   --> geschrieben!");
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(846930145, ex, "nach: " + datei);
        }
        finally {
            try {
                if (jg != null) {
                    jg.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (xZOutputStream != null) {
                    xZOutputStream.close();
                }
            }
            catch (Exception e) {
                MSLog.fehlerMeldung(732101201, e, "close stream: " + datei);
            }
        }
    }
}

