/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.util.ArrayList;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekRbb
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "RBB";
    static final String ROOTADR = "http://mediathek.rbb-online.de";

    public MediathekRbb(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 500, startPrio);
    }

    @Override
    void addToList() {
        MSStringBuilder seite = new MSStringBuilder(65536);
        ArrayList<String> liste = new ArrayList<String>();
        String ADRESSE_1 = "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=a-k";
        String ADRESSE_2 = "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=l-z";
        String URL2 = "<a href=\"/tv/";
        this.meldungStart();
        try {
            seite = this.getUrlIo.getUri(SENDERNAME, "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=a-k", "UTF-8", 5, seite, "");
            seite.extractList("<a href=\"/tv/", "\"", 0, "", liste);
            seite = this.getUrlIo.getUri(SENDERNAME, "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=l-z", "UTF-8", 5, seite, "");
            seite.extractList("<a href=\"/tv/", "\"", 0, "", liste);
            for (String s : liste) {
                if (s.isEmpty() || !s.contains("documentId=")) continue;
                s = "http://mediathek.rbb-online.de/tv/" + s;
                this.listeThemen.addUrl(new String[]{s});
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(398214058, ex);
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden(false));
                th.setName(SENDERNAME + t);
                th.start();
            }
            this.meldungAddMax(7);
            Thread th = new Thread(new ThemaLaden(true));
            th.setName("RBB_Tage");
            th.start();
        }
    }

    private class ThemaLaden
    implements Runnable {
        boolean addTage = false;
        MSGetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private MSStringBuilder seite3;

        public ThemaLaden(boolean addTage) {
            this.getUrl = new MSGetUrl(MediathekRbb.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.addTage = addTage;
        }

        @Override
        public void run() {
            try {
                MediathekRbb.this.meldungAddThread();
                if (this.addTage) {
                    this.addTage();
                } else {
                    String[] link;
                    while (!MSConfig.getStop() && (link = MediathekRbb.this.listeThemen.getListeThemen()) != null) {
                        MediathekRbb.this.meldungProgress(link[0]);
                        this.addThema(link[0], true);
                    }
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(794625882, ex);
            }
            MediathekRbb.this.meldungThreadUndFertig();
        }

        void addTage() {
            String MUSTER_START = "<h2 class=\"modHeadline\">7 Tage R\u00fcckblick</h2>";
            String MUSTER_URL = "<div class=\"media mediaA\">";
            String URL2 = "<a href=\"/tv/";
            for (int i = 0; i <= 6; ++i) {
                String urlTage = "http://mediathek.rbb-online.de/tv/sendungVerpasst?topRessort=tv&kanal=5874&tag=" + i;
                MediathekRbb.this.meldungProgress(urlTage);
                this.seite1 = MediathekRbb.this.getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, urlTage, this.seite1, "");
                int pos1 = this.seite1.indexOf("<h2 class=\"modHeadline\">7 Tage R\u00fcckblick</h2>");
                while (!MSConfig.getStop() && (pos1 = this.seite1.indexOf("<div class=\"media mediaA\">", pos1)) != -1) {
                    String urlSeite = this.seite1.extract("<a href=\"/tv/", "\"", pos1 += "<div class=\"media mediaA\">".length());
                    if (!urlSeite.isEmpty()) {
                        urlSeite = "http://mediathek.rbb-online.de/tv/" + urlSeite;
                        this.addFilme(urlSeite);
                        continue;
                    }
                    MSLog.fehlerMeldung(751203697, "keine URL f\u00fcr: " + urlSeite);
                }
            }
        }

        void addThema(String url, boolean weiter) {
            try {
                int startPos;
                String URL2 = "<a href=\"/tv/";
                String MUSTER_URL = "<div class=\"media mediaA\">";
                this.seite1 = MediathekRbb.this.getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, url, this.seite1, "");
                int pos1 = startPos = this.seite1.indexOf("<div class=\"entry\">");
                while (!MSConfig.getStop() && (pos1 = this.seite1.indexOf("<div class=\"media mediaA\">", pos1)) != -1) {
                    String urlSeite = this.seite1.extract("<a href=\"/tv/", "\"", pos1 += "<div class=\"media mediaA\">".length());
                    if (!urlSeite.isEmpty()) {
                        urlSeite = "http://mediathek.rbb-online.de/tv/" + urlSeite;
                        this.addFilme(urlSeite);
                        continue;
                    }
                    MSLog.fehlerMeldung(751203697, "keine URL f\u00fcr: " + url);
                }
                if (weiter && MSConfig.loadLongMax()) {
                    for (int i = 2; i < 10; ++i) {
                        if (this.seite1.indexOf("mcontents=page." + i) == -1) continue;
                        this.addThema(url + "&mcontents=page." + i, false);
                    }
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(541236987, ex);
            }
        }

        void addFilme(String urlSeite) {
            try {
                String subtitle;
                MediathekRbb.this.meldung(urlSeite);
                String datum = "";
                String zeit = "";
                this.seite2 = MediathekRbb.this.getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, urlSeite, this.seite2, "");
                String description = this.seite2.extract("<meta name=\"description\" content=\"", "\"");
                String durationInSeconds = this.seite2.extract("<meta property=\"video:duration\" content=\"", "\"");
                long duration = 0L;
                if (!durationInSeconds.isEmpty()) {
                    try {
                        duration = Long.parseLong(durationInSeconds);
                    }
                    catch (Exception ex) {
                        MSLog.fehlerMeldung(200145787, ex);
                        duration = 0L;
                    }
                }
                String title = this.seite2.extract("<meta name=\"dcterms.title\" content=\"", "\"");
                String thema = this.seite2.extract("<meta name=\"dcterms.isPartOf\" content=\"", "\"");
                String sub = this.seite2.extract("<p class=\"subtitle\">", "<");
                if (sub.contains("|")) {
                    datum = sub.substring(0, sub.indexOf("|") - 1);
                    zeit = (datum = datum.substring(datum.indexOf(" ")).trim()).substring(datum.indexOf(" ")).trim();
                    if (zeit.length() == 5) {
                        zeit = zeit + ":00";
                    }
                    if ((datum = datum.substring(0, datum.indexOf(" ")).trim()).length() == 8) {
                        datum = datum.substring(0, 6) + "20" + datum.substring(6);
                    }
                }
                String urlFilm = urlSeite.substring(urlSeite.indexOf("documentId=") + "documentId=".length(), urlSeite.indexOf("&"));
                urlFilm = "http://mediathek.rbb-online.de/play/media/" + urlFilm + "?devicetype=pc&features=hls";
                this.seite3 = MediathekRbb.this.getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, urlFilm, this.seite3, "");
                String urlNormal = "";
                String urlLow = "";
                urlLow = this.seite3.extract("\"_quality\":1,\"_server\":\"\",\"_cdn\":\"akamai\",\"_stream\":\"http://", "\"");
                if (urlLow.isEmpty()) {
                    urlLow = this.seite3.extract("\"_quality\":1,\"_server\":\"\",\"_cdn\":\"default\",\"_stream\":\"http://", "\"");
                }
                if ((urlNormal = this.seite3.extract("\"_quality\":3,\"_server\":\"\",\"_cdn\":\"akamai\",\"_stream\":\"http://", "\"")).isEmpty()) {
                    urlNormal = this.seite3.extract("\"_quality\":3,\"_server\":\"\",\"_cdn\":\"default\",\"_stream\":\"http://", "\"");
                }
                if (urlLow.contains("?url=")) {
                    urlLow = urlLow.substring(0, urlLow.indexOf("?url="));
                }
                if (urlNormal.contains("?url=")) {
                    urlNormal = urlNormal.substring(0, urlNormal.indexOf("?url="));
                }
                if (urlNormal.isEmpty() && !urlLow.isEmpty()) {
                    urlNormal = urlLow;
                    urlLow = "";
                }
                if (!(subtitle = this.seite3.extract("subtitleUrl\":\"", "\"")).isEmpty() && !subtitle.startsWith("http")) {
                    subtitle = MediathekRbb.ROOTADR + subtitle;
                }
                if (datum.isEmpty() || zeit.isEmpty() || thema.isEmpty() || title.isEmpty() || description.isEmpty() || durationInSeconds.isEmpty()) {
                    MSLog.fehlerMeldung(912012036, "empty f\u00fcr: " + urlSeite);
                }
                if (!urlNormal.isEmpty()) {
                    urlNormal = "http://" + urlNormal;
                    DatenFilm film = new DatenFilm(MediathekRbb.SENDERNAME, thema, urlSeite, title, urlNormal, "", datum, zeit, duration, description);
                    MediathekRbb.this.addFilm(film);
                    if (!urlLow.isEmpty()) {
                        urlLow = "http://" + urlLow;
                        film.addUrlKlein(urlLow, "");
                    }
                    if (!subtitle.isEmpty()) {
                        film.addUrlSubtitle(subtitle);
                    }
                } else {
                    MSLog.fehlerMeldung(302014569, "keine URL f\u00fcr: " + urlSeite);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(541236987, ex);
            }
        }
    }
}

