/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekArte_de
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "ARTE.DE";
    SimpleDateFormat sdfZeit = new SimpleDateFormat("HH:mm:ss");
    SimpleDateFormat sdfDatum = new SimpleDateFormat("dd.MM.yyyy");
    String URL_ARTE = "http://www.arte.tv/papi/tvguide/epg/schedule/D/L3/";
    String URL_CONCERT = "http://concert.arte.tv/de/videos/all";
    String URL_CONCERT_NOT_CONTAIN = "-STF";

    public MediathekArte_de(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 500, startPrio);
        this.getUrlIo.setTimeout(15000);
    }

    public MediathekArte_de(MSFilmeSuchen ssearch, int startPrio, String name) {
        super(ssearch, name, 2, 500, startPrio);
        this.getUrlIo.setTimeout(15000);
    }

    @Override
    public void addToList() {
        this.meldungStart();
        this.addTage();
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            if (MSConfig.loadLongMax()) {
                this.addConcert();
            } else {
                this.meldungThreadUndFertig();
            }
        } else {
            if (MSConfig.loadLongMax()) {
                this.addConcert();
            }
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(this.sendername + t);
                th.start();
            }
        }
    }

    private void addConcert() {
        Thread th = new Thread(new ConcertLaden(0, 20));
        th.setName(this.sendername + "Concert-0");
        th.start();
        th = new Thread(new ConcertLaden(20, 40));
        th.setName(this.sendername + "Concert-1");
        th.start();
    }

    private void addTage() {
        Date d = new Date();
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-M-dd");
        for (int i = 0; i <= 14; ++i) {
            String out1 = formatter1.format(new Date(d.getTime() - (long)(i * 86400000)));
            String out2 = formatter2.format(new Date(d.getTime() - (long)(i * 86400000)));
            String u = this.URL_ARTE + out1 + "/" + out2 + ".json";
            this.listeThemen.add(new String[]{u});
        }
    }

    private void addTheman(MSStringBuilder seite1, MSStringBuilder seite2, String startUrl) {
        String MUSTER_START = "{\"programId\":";
        String MUSTER_URL_JSON = "\"videoStreamUrl\":\"";
        String MUSTER_DATUM = "\"BAD\":\"";
        String MUSTER_ZEIT = "\"BAT\":\"";
        String MUSTER_TITEL = "\"TIT\":\"";
        String MUSTER_THEMA = "\"GEN\":\"";
        seite1 = this.getUrlIo.getUri_Utf(this.sendername, startUrl, seite1, "");
        int posStart = 0;
        while ((posStart = seite1.indexOf("{\"programId\":", posStart)) != -1) {
            int pos2;
            int posStop = seite1.indexOf("{\"programId\":", posStart += "{\"programId\":".length());
            String urlJson = "";
            String datum = "";
            String zeit = "";
            String titel = "";
            String thema = "";
            int pos1 = seite1.indexOf("\"videoStreamUrl\":\"", posStart);
            if (pos1 != -1 && (posStop == -1 || (pos1 += "\"videoStreamUrl\":\"".length()) < posStop) && (pos2 = seite1.indexOf("\"", pos1)) != -1) {
                urlJson = seite1.substring(pos1, pos2);
            }
            int pos = posStart;
            while ((pos = seite1.indexOf("\"BAD\":\"", pos)) != -1 && (posStop == -1 || (pos += "\"BAD\":\"".length()) <= posStop)) {
                if (posStop != -1 && pos >= posStop || (pos2 = seite1.indexOf("\"", pos)) == -1) continue;
                datum = seite1.substring(pos, pos2);
            }
            pos = posStart;
            while ((pos = seite1.indexOf("\"BAT\":\"", pos)) != -1 && (posStop == -1 || (pos += "\"BAT\":\"".length()) <= posStop)) {
                if (posStop != -1 && pos >= posStop || (pos2 = seite1.indexOf("\"", pos)) == -1) continue;
                zeit = seite1.substring(pos, pos2);
            }
            pos1 = seite1.indexOf("\"TIT\":\"", posStart);
            if (pos1 != -1 && (posStop == -1 || (pos1 += "\"TIT\":\"".length()) < posStop) && (pos2 = seite1.indexOf("\",", pos1)) != -1) {
                titel = seite1.substring(pos1, pos2);
                titel = titel.replace("\\", "");
            }
            if ((pos1 = seite1.indexOf("\"GEN\":\"", posStart)) != -1 && (posStop == -1 || (pos1 += "\"GEN\":\"".length()) < posStop) && (pos2 = seite1.indexOf("\"", pos1)) != -1) {
                thema = seite1.substring(pos1, pos2);
            }
            if (urlJson.isEmpty()) continue;
            String[] arr = new String[]{urlJson, datum, zeit, titel, thema};
            this.filmeLaden(seite2, arr);
        }
    }

    void filmeLaden(MSStringBuilder seite, String[] arr) {
        int pos2;
        String datum = "";
        String zeit = "";
        String urlHd = "";
        String urlKlein = "";
        String url = "";
        String beschreibung = "";
        String filmWebsite = "";
        String dauerStr = "";
        String titel = "";
        String thema = "";
        String subTitle = "";
        long dauer = 0L;
        String MUSTER_BESCHREIBUNG = "\"VDE\":\"";
        String MUSTER_FILM_WEBSITE = "\"VUP\":\"";
        String MUSTER_URL_HD = "\"HBBTV\",\"VQU\":\"SQ\",\"VMT\":\"mp4\",\"VUR\":\"";
        String MUSTER_URL = "HBBTV\",\"VQU\":\"EQ\",\"VMT\":\"mp4\",\"VUR\":\"";
        String MUSTER_URL_KLEIN = "HBBTV\",\"VQU\":\"HQ\",\"VMT\":\"mp4\",\"VUR\":\"";
        String MUSTER_DAUER = "\"videoDurationSeconds\":";
        if (MSConfig.getStop()) {
            return;
        }
        this.meldung(arr[0]);
        seite = this.getUrlIo.getUri_Utf(this.sendername, arr[0], seite, "");
        int pos1 = seite.indexOf("\"VDE\":\"");
        if (pos1 != -1 && (pos2 = seite.indexOf("\",", pos1 += "\"VDE\":\"".length())) != -1 && !(beschreibung = seite.substring(pos1, pos2)).isEmpty() && beschreibung.endsWith("\"")) {
            beschreibung = beschreibung.substring(0, beschreibung.length() - 2);
        }
        if ((pos1 = seite.indexOf("\"VUP\":\"")) != -1 && (pos2 = seite.indexOf("\"", pos1 += "\"VUP\":\"".length())) != -1) {
            filmWebsite = seite.substring(pos1, pos2);
        }
        if ((pos1 = seite.indexOf("\"HBBTV\",\"VQU\":\"SQ\",\"VMT\":\"mp4\",\"VUR\":\"")) != -1 && (pos2 = seite.indexOf("\"", pos1 += "\"HBBTV\",\"VQU\":\"SQ\",\"VMT\":\"mp4\",\"VUR\":\"".length())) != -1) {
            urlHd = seite.substring(pos1, pos2);
        }
        if ((pos1 = seite.indexOf("HBBTV\",\"VQU\":\"HQ\",\"VMT\":\"mp4\",\"VUR\":\"")) != -1 && (pos2 = seite.indexOf("\"", pos1 += "HBBTV\",\"VQU\":\"HQ\",\"VMT\":\"mp4\",\"VUR\":\"".length())) != -1) {
            urlKlein = seite.substring(pos1, pos2);
        }
        if ((pos1 = seite.indexOf("HBBTV\",\"VQU\":\"EQ\",\"VMT\":\"mp4\",\"VUR\":\"")) != -1 && (pos2 = seite.indexOf("\"", pos1 += "HBBTV\",\"VQU\":\"EQ\",\"VMT\":\"mp4\",\"VUR\":\"".length())) != -1) {
            url = seite.substring(pos1, pos2);
        }
        if ((pos1 = seite.indexOf("\"videoDurationSeconds\":")) != -1 && (pos2 = seite.indexOf(",", pos1 += "\"videoDurationSeconds\":".length())) != -1 && !(dauerStr = seite.substring(pos1, pos2)).isEmpty()) {
            try {
                dauer = Long.parseLong(dauerStr);
            }
            catch (Exception ex) {
                dauer = 0L;
            }
        }
        datum = this.convertDatum(arr[1]);
        zeit = this.convertZeit(arr[2]);
        titel = arr[3];
        subTitle = seite.extract("\"VSU\":\"", "\",");
        if (!(subTitle = subTitle.replace("\\\"", "\"")).isEmpty() && !titel.equals(subTitle)) {
            titel = titel + " - " + subTitle;
        }
        thema = arr[4];
        if (!url.isEmpty()) {
            if (!url.endsWith("EXTRAIT.mp4")) {
                DatenFilm film = new DatenFilm(this.sendername, thema, filmWebsite, titel, url, "", datum, zeit, dauer, beschreibung);
                if (!urlKlein.isEmpty()) {
                    film.addUrlKlein(urlKlein, "");
                }
                if (!urlHd.isEmpty()) {
                    film.addUrlHd(urlHd, "");
                }
                this.addFilm(film);
            }
        } else if (!urlKlein.isEmpty()) {
            DatenFilm film = new DatenFilm(this.sendername, thema, filmWebsite, titel, urlKlein, "", datum, zeit, dauer, beschreibung);
            if (!urlHd.isEmpty()) {
                film.addUrlHd(urlHd, "");
            }
            this.addFilm(film);
        } else if (!urlHd.isEmpty()) {
            DatenFilm film = new DatenFilm(this.sendername, thema, filmWebsite, titel, urlHd, "", datum, zeit, dauer, beschreibung);
            this.addFilm(film);
        } else {
            MSLog.fehlerMeldung(963025874, "Keine URL: " + arr[0]);
        }
    }

    String convertDatum(String datum) {
        return datum.replace("/", ".");
    }

    String convertZeit(String zeit) {
        return zeit + ":00";
    }

    class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private final MSStringBuilder seite1;
        private final MSStringBuilder seite2;

        ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekArte_de.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekArte_de.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekArte_de.this.listeThemen.getListeThemen()) != null) {
                    MediathekArte_de.this.meldungProgress(link[0]);
                    MediathekArte_de.this.addTheman(this.seite1, this.seite2, link[0]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(894330854, ex, "");
            }
            MediathekArte_de.this.meldungThreadUndFertig();
        }
    }

    private class ConcertLaden
    implements Runnable {
        private final int start;
        private final int anz;
        MSStringBuilder seite1 = new MSStringBuilder(65536);
        MSStringBuilder seite2 = new MSStringBuilder(65536);

        public ConcertLaden(int start, int anz) {
            this.start = start;
            this.anz = anz;
        }

        @Override
        public void run() {
            try {
                MediathekArte_de.this.meldungAddThread();
                this.addConcert(this.start, this.anz);
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(787452309, ex, "");
            }
            MediathekArte_de.this.meldungThreadUndFertig();
        }

        private void addConcert(int start, int anz) {
            String THEMA = "Concert";
            String MUSTER_START = "<div class=\"header-article \">";
            MediathekArte_de.this.meldungAddMax(anz);
            for (int i = start; !MSConfig.getStop() && i < anz; ++i) {
                String urlStart = i > 0 ? MediathekArte_de.this.URL_CONCERT + "?page=" + i : MediathekArte_de.this.URL_CONCERT;
                MediathekArte_de.this.meldungProgress(urlStart);
                this.seite1 = MediathekArte_de.this.getUrlIo.getUri_Utf(MediathekArte_de.this.sendername, urlStart, this.seite1, "");
                int pos1 = 0;
                String urlHd = "";
                String urlLow = "";
                String urlNormal = "";
                while (!MSConfig.getStop() && (pos1 = this.seite1.indexOf("<div class=\"header-article \">", pos1)) != -1) {
                    urlHd = "";
                    urlLow = "";
                    urlNormal = "";
                    pos1 += "<div class=\"header-article \">".length();
                    try {
                        String url = this.seite1.extract("<a href=\"", "\"", pos1);
                        String titel = this.seite1.extract("title=\"", "\"", pos1);
                        String datum = this.seite1.extract("<span class=\"date-container\">", "<", pos1).trim();
                        String beschreibung = this.seite1.extract("property=\"content:encoded\">", "<", pos1);
                        String dauer = this.seite1.extract("<span class=\"time-container\">", "<", pos1).trim();
                        dauer = dauer.replace("\"", "");
                        int duration = 0;
                        if (!dauer.equals("")) {
                            String[] parts = dauer.split(":");
                            duration = 0;
                            long power = 1L;
                            for (int ii = parts.length - 1; ii >= 0; --ii) {
                                duration = (int)((long)duration + Long.parseLong(parts[ii]) * power);
                                power *= 60L;
                            }
                        }
                        if (url.equals("")) {
                            MSLog.fehlerMeldung(825241452, "keine URL");
                            continue;
                        }
                        String urlWeb = "http://concert.arte.tv" + url;
                        MediathekArte_de.this.meldung(urlWeb);
                        this.seite2 = MediathekArte_de.this.getUrlIo.getUri_Utf(MediathekArte_de.this.sendername, urlWeb, this.seite2, "");
                        String genre = this.seite2.extract("<span class=\"tag tag-link\">", "\">", "<");
                        if (!genre.isEmpty()) {
                            beschreibung = genre + "\n" + DatenFilm.cleanDescription(beschreibung, "Concert", titel);
                        }
                        if ((url = this.seite2.extract("arte_vp_url=\"", "\"")).isEmpty()) {
                            MSLog.fehlerMeldung(784512698, "keine URL");
                            continue;
                        }
                        this.seite2 = MediathekArte_de.this.getUrlIo.getUri_Utf(MediathekArte_de.this.sendername, url, this.seite2, "");
                        int p1 = 0;
                        String a = "\"bitrate\":800";
                        String b = "\"url\":\"";
                        String c = "\"";
                        while ((p1 = this.seite2.indexOf(a, p1)) != -1) {
                            urlLow = this.seite2.extract(b, c, p1 += a.length()).replace("\\", "");
                            if (urlLow.endsWith(".m3u8")) {
                                urlLow = "";
                                continue;
                            }
                            if (urlLow.contains(MediathekArte_de.this.URL_CONCERT_NOT_CONTAIN)) continue;
                        }
                        a = "\"bitrate\":1500";
                        p1 = 0;
                        while ((p1 = this.seite2.indexOf(a, p1)) != -1) {
                            urlNormal = this.seite2.extract(b, c, p1 += a.length()).replace("\\", "");
                            if (urlNormal.endsWith(".m3u8")) {
                                urlNormal = "";
                                continue;
                            }
                            if (urlNormal.contains(MediathekArte_de.this.URL_CONCERT_NOT_CONTAIN)) continue;
                        }
                        a = "\"bitrate\":2200";
                        p1 = 0;
                        while ((p1 = this.seite2.indexOf(a, p1)) != -1) {
                            urlHd = this.seite2.extract(b, c, p1 += a.length()).replace("\\", "");
                            if (urlHd.endsWith(".m3u8")) {
                                urlHd = "";
                                continue;
                            }
                            if (urlHd.contains(MediathekArte_de.this.URL_CONCERT_NOT_CONTAIN)) continue;
                        }
                        if (urlNormal.isEmpty()) {
                            urlNormal = urlLow;
                            urlLow = "";
                            MSLog.fehlerMeldung(951236487, "keine URL");
                        }
                        if (urlNormal.isEmpty()) {
                            MSLog.fehlerMeldung(989562301, "keine URL");
                            continue;
                        }
                        DatenFilm film = new DatenFilm(MediathekArte_de.this.sendername, "Concert", urlWeb, titel, urlNormal, "", datum, "", duration, beschreibung);
                        if (!urlHd.isEmpty()) {
                            film.addUrlHd(urlHd, "");
                        }
                        if (!urlLow.isEmpty()) {
                            film.addUrlKlein(urlLow, "");
                        }
                        MediathekArte_de.this.addFilm(film);
                    }
                    catch (Exception ex) {
                        MSLog.fehlerMeldung(465623121, ex);
                    }
                }
            }
        }
    }
}

