/*
 * Decompiled with CFR 0.152.
 */
package msearch.daten;

import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.SimpleTimeZone;
import java.util.TreeSet;
import msearch.daten.DatenFilm;
import msearch.tool.GermanStringSorter;
import msearch.tool.MSConfig;
import msearch.tool.MSFileSize;
import msearch.tool.MSFunktionen;
import msearch.tool.MSLog;

public class ListeFilme
extends ArrayList<DatenFilm> {
    public static final String THEMA_LIVE = "Livestream";
    public static final String FILMLISTE = "Filmliste";
    public static final String FILMLISTE_DATUM = "Filmliste-Datum";
    public static final int FILMLISTE_DATUM_NR = 0;
    public static final String FILMLISTE_DATUM_GMT = "Filmliste-Datum-GMT";
    public static final int FILMLISTE_DATUM_GMT_NR = 1;
    public static final String FILMLISTE_VERSION = "Filmliste-Version";
    public static final int FILMLISTE_VERSION_NR = 2;
    public static final String FILMLISTE_PROGRAMM = "Filmliste-Programm";
    public static final int FILMLISTE_PRGRAMM_NR = 3;
    public static final String FILMLISTE_ID = "Filmliste-Id";
    public static final int FILMLISTE_ID_NR = 4;
    public static final int MAX_ELEM = 5;
    public static final String[] COLUMN_NAMES = new String[]{"Filmliste-Datum", "Filmliste-Datum-GMT", "Filmliste-Version", "Filmliste-Programm", "Filmliste-Id"};
    public int nr = 1;
    public String[] metaDaten = new String[]{"", "", "", "", ""};
    private static final String DATUM_ZEIT_FORMAT = "dd.MM.yyyy, HH:mm";
    private static final String DATUM_ZEIT_FORMAT_REV = "yyyy.MM.dd__HH:mm";
    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
    public String[] sender = new String[]{""};
    public String[][] themenPerSender = new String[][]{{""}};
    public boolean neueFilme = false;
    final int COUNTER_MAX = 20;
    int counter = 0;
    int treffer = 0;

    public synchronized boolean importFilmliste(DatenFilm film) {
        film.nr = this.nr++;
        return this.addInit(film);
    }

    public synchronized boolean addFilmVomSender(DatenFilm film) {
        MSFunktionen.unescape(film);
        String idx = film.getIndex();
        for (DatenFilm datenFilm : this) {
            DatenFilm f = datenFilm;
            if (!f.getIndex().equals(idx)) continue;
            return false;
        }
        return this.addInit(film);
    }

    public synchronized void updateListe(ListeFilme listeEinsortieren, boolean index, boolean ersetzen) {
        HashSet<String> hash = new HashSet<String>();
        if (ersetzen) {
            for (DatenFilm f : listeEinsortieren) {
                if (f.arr[1].equals("KiKA")) {
                    hash.add(f.arr[2] + f.arr[3]);
                    continue;
                }
                if (index) {
                    hash.add(f.getIndex());
                    continue;
                }
                hash.add(DatenFilm.getUrl(f));
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                DatenFilm f;
                f = (DatenFilm)it.next();
                if (f.arr[1].equals("KiKA")) {
                    if (!hash.contains(f.arr[2] + f.arr[3])) continue;
                    it.remove();
                    continue;
                }
                if (index) {
                    if (!hash.contains(f.getIndex())) continue;
                    it.remove();
                    continue;
                }
                if (!hash.contains(DatenFilm.getUrl(f))) continue;
                it.remove();
            }
            for (DatenFilm f : listeEinsortieren) {
                this.addInit(f);
            }
        } else {
            for (DatenFilm f : this) {
                if (f.arr[1].equals("KiKA")) {
                    hash.add(f.arr[2] + f.arr[3]);
                    continue;
                }
                if (index) {
                    hash.add(f.getIndex());
                    continue;
                }
                hash.add(DatenFilm.getUrl(f));
            }
            for (DatenFilm f : listeEinsortieren) {
                if (f.arr[1].equals("KiKA")) {
                    if (hash.contains(f.arr[2] + f.arr[3])) continue;
                    this.addInit(f);
                    continue;
                }
                if (index) {
                    if (hash.contains(f.getIndex())) continue;
                    this.addInit(f);
                    continue;
                }
                if (hash.contains(DatenFilm.getUrl(f))) continue;
                this.addInit(f);
            }
        }
        hash.clear();
    }

    public synchronized int updateListeOld(ListeFilme listeEinsortieren) {
        HashSet<String> hash = new HashSet<String>();
        for (DatenFilm f : this) {
            if (f.arr[1].equals("KiKA")) {
                hash.add(f.arr[2] + f.arr[3]);
                continue;
            }
            hash.add(f.getIndex());
        }
        Iterator it = listeEinsortieren.iterator();
        while (it.hasNext()) {
            DatenFilm f;
            f = (DatenFilm)it.next();
            if (f.arr[1].equals("KiKA")) {
                if (!hash.contains(f.arr[2] + f.arr[3])) continue;
                it.remove();
                continue;
            }
            if (!hash.contains(f.getIndex())) continue;
            it.remove();
        }
        hash.clear();
        for (int i = 0; i < 20; ++i) {
            new Thread(new AddOld(listeEinsortieren)).start();
        }
        int count = 0;
        while (!MSConfig.getStop() && this.counter > 0) {
            try {
                System.out.println("s: " + 2 * count++ + "  Liste: " + listeEinsortieren.size() + "  Treffer: " + this.treffer + "   Threads: " + this.counter);
                this.wait(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.treffer;
    }

    private synchronized DatenFilm popOld(ListeFilme listeOld) {
        if (listeOld.size() > 0) {
            return (DatenFilm)listeOld.remove(0);
        }
        return null;
    }

    private synchronized boolean addOld(DatenFilm film) {
        ++this.treffer;
        film.init();
        return this.add(film);
    }

    private boolean addInit(DatenFilm film) {
        film.init();
        return this.add(film);
    }

    @Override
    public synchronized void clear() {
        this.nr = 1;
        this.neueFilme = false;
        super.clear();
    }

    public void cleanList() {
        int count = 0;
        SimpleDateFormat sdfClean = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
        MSLog.systemMeldung("cleanList start: " + sdfClean.format(System.currentTimeMillis()));
        ListeFilme tmp = new ListeFilme();
        for (DatenFilm datenFilm : this) {
            if (!datenFilm.arr[1].equals("BR") || !datenFilm.arr[2].equals("BR")) continue;
            tmp.add(datenFilm);
        }
        block1: for (DatenFilm tFilm : tmp) {
            for (DatenFilm datenFilm : this) {
                if (!datenFilm.arr[1].equals("BR") || datenFilm.arr[2].equals("BR") || !datenFilm.arr[12].equals(tFilm.arr[12])) continue;
                this.remove(tFilm);
                ++count;
                continue block1;
            }
        }
        MSLog.systemMeldung("cleanList stop: " + sdfClean.format(System.currentTimeMillis()));
        MSLog.systemMeldung("cleanList count: " + count);
    }

    public synchronized void check() {
        for (DatenFilm film : this) {
            film.arr[2] = MSFunktionen.cleanUnicode(film.arr[2], "!!!!!!!!!!!!!");
            film.arr[3] = MSFunktionen.cleanUnicode(film.arr[3], "!!!!!!!!!!!!!");
            String s = film.arr[10];
            film.arr[10] = MSFunktionen.removeHtml(film.arr[10]);
            if (!s.equals(film.arr[10])) {
                System.out.println("---------------------");
                System.out.println(s);
                System.out.println(film.arr[10]);
            }
            s = film.arr[2];
            film.arr[2] = MSFunktionen.removeHtml(film.arr[2]);
            if (!s.equals(film.arr[2])) {
                System.out.println("---------------------");
                System.out.println(s);
                System.out.println(film.arr[2]);
            }
            s = film.arr[3];
            film.arr[3] = MSFunktionen.removeHtml(film.arr[3]);
            if (!s.equals(film.arr[3])) {
                System.out.println("---------------------");
                System.out.println(s);
                System.out.println(film.arr[3]);
            }
            if (!film.arr[12].contains(" ")) continue;
            System.out.println(film.arr[12]);
        }
    }

    public synchronized void nurDoppelteAnzeigen(boolean index) {
        HashSet<String> hashDoppelt = new HashSet<String>();
        HashSet<String> hash = new HashSet<String>();
        for (DatenFilm film : this) {
            if (index) {
                if (!hash.contains(film.getIndex())) {
                    hash.add(film.getIndex());
                    continue;
                }
                hashDoppelt.add(film.arr[12]);
                continue;
            }
            if (!hash.contains(film.arr[12])) {
                hash.add(film.arr[12]);
                continue;
            }
            hashDoppelt.add(film.arr[12]);
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (hashDoppelt.contains(((DatenFilm)it.next()).arr[12])) continue;
            it.remove();
        }
        hash.clear();
        hashDoppelt.clear();
    }

    public synchronized void sort() {
        Collections.sort(this);
        int i = 1;
        for (DatenFilm film : this) {
            film.nr = i++;
        }
    }

    public synchronized void setMeta(ListeFilme listeFilme) {
        System.arraycopy(listeFilme.metaDaten, 0, this.metaDaten, 0, 5);
    }

    public synchronized DatenFilm istInFilmListe(String sender, String thema, String titel) {
        for (DatenFilm film : this) {
            if (!film.arr[1].equals(sender) || !film.arr[2].equalsIgnoreCase(thema) || !film.arr[3].equalsIgnoreCase(titel)) continue;
            return film;
        }
        return null;
    }

    public synchronized ListeFilme neueFilme(ListeFilme orgListe) {
        String s;
        DatenFilm film;
        ListeFilme ret = new ListeFilme();
        HashSet<String> hashSet = new HashSet<String>();
        ListIterator it = orgListe.listIterator();
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            s = film.arr[1] + film.arr[2] + film.arr[3] + film.arr[12];
            hashSet.add(s);
        }
        it = this.listIterator();
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            s = film.arr[1] + film.arr[2] + film.arr[3] + film.arr[12];
            if (hashSet.contains(s)) continue;
            ret.add(film);
        }
        ret.metaDaten = this.metaDaten;
        return ret;
    }

    public synchronized String getDateiGroesse(String url, String sender) {
        for (DatenFilm film : this) {
            if (!film.arr[12].equals(url)) continue;
            if (!film.arr[9].isEmpty()) {
                return film.arr[9];
            }
            return MSFileSize.laengeString(url, sender);
        }
        return MSFileSize.laengeString(url, sender);
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        for (DatenFilm film : this) {
            if (!film.arr[1].equalsIgnoreCase(sender)) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized void deleteAllFilms(String sender) {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (!film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public synchronized void liveStreamEintragen() {
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ARD", "", "http://daserste_live-lh.akamaihd.net/i/daserste_de@91204/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ARD", " Alpha", "http://livestreams.br.de/i/bralpha_germany@119899/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ARD", " Tagesschau", "http://tagesschau-lh.akamaihd.net/i/tagesschau_1@119231/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("BR", "", "http://livestreams.br.de/i/bfsnord_germany@119898/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ARTE.DE", "", "http://delive.artestras.cshls.lldns.net/artestras/contrib/delive.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("HR", "", "http://live1_hr-lh.akamaihd.net/i/hr_fernsehen@75910/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("KiKA", "", "http://kika_geo-lh.akamaihd.net/i/livetvkika_de@75114/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("MDR", "", "http://mdr_th_hls-lh.akamaihd.net/i/livetvmdrthueringen_de@106903/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("NDR", "", "http://ndr_fs-lh.akamaihd.net/i/ndrfs_nds@119224/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("RBB", "", "http://rbb_live-lh.akamaihd.net/i/rbb_brandenburg@107638/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("SR", "", "http://live2_sr-lh.akamaihd.net/i/sr_universal02@107595/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("SWR", "", "http://swrbw-lh.akamaihd.net/i/swrbw_live@196738/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("WDR", "", "http://wdr_fs_geo-lh.akamaihd.net/i/wdrfs_geogeblockt@112044/master.m3u8", "http://www.ardmediathek.de/tv/live?kanal=Alle"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("3Sat", "", "http://zdf0910-lh.akamaihd.net/i/dach10_v1@392872/master.m3u8", "http://www.zdf.de/ZDFmediathek/hauptnavigation/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ZDF", "", "http://zdf1314-lh.akamaihd.net/i/de14_v1@392878/master.m3u8", "http://www.zdf.de/ZDFmediathek/hauptnavigation/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ZDF", ".info", "http://zdf1112-lh.akamaihd.net/i/de12_v1@392882/master.m3u8", "http://www.zdf.de/ZDFmediathek/hauptnavigation/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ZDF", ".neo", "http://zdf1314-lh.akamaihd.net/i/de13_v1@392877/master.m3u8", "http://www.zdf.de/ZDFmediathek/hauptnavigation/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ZDF", ".kultur", "http://zdf1112-lh.akamaihd.net/i/de11_v1@392881/master.m3u8", "http://www.zdf.de/ZDFmediathek/hauptnavigation/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ZDF", ".heute", "http://zdf0102-lh.akamaihd.net/i/none01_v1@392849/master.m3u8", "http://www.zdf.de/ZDFmediathek/hauptnavigation/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ORF", "-1", "http://apasfiisl.apa.at/ipad/orf1_q4a/orf.sdp/playlist.m3u8", "http://tvthek.orf.at/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ORF", "-2", "http://apasfiisl.apa.at/ipad/orf2_q4a/orf.sdp/playlist.m3u8", "http://tvthek.orf.at/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ORF", "-3", "http://apasfiisl.apa.at/ipad/orf3_q4a/orf.sdp/playlist.m3u8", "http://tvthek.orf.at/live"));
        this.addFilmVomSender(DatenFilm.getDatenFilmLiveStream("ORF", "-Sport", "http://apasfiisl.apa.at/ipad/orfs_q4a/orf.sdp/playlist.m3u8", "http://tvthek.orf.at/live"));
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        for (DatenFilm film : this) {
            if (!film.arr[12].equalsIgnoreCase(url)) continue;
            return film;
        }
        return null;
    }

    public synchronized void checkThema(String sender, LinkedList<String> liste, String thema) {
        for (DatenFilm film : this) {
            if (!film.arr[1].equals(sender) || film.arr[2].equals(THEMA_LIVE) || liste.contains(film.arr[2])) continue;
            film.arr[2] = thema;
        }
    }

    public synchronized void getThema(String sender, LinkedList<String> liste) {
        for (DatenFilm film : this) {
            if (!film.arr[1].equals(sender) || liste.contains(film.arr[2])) continue;
            liste.add(film.arr[2]);
        }
    }

    public synchronized DatenFilm getFilmByUrl_klein_hoch_hd(String url) {
        DatenFilm ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm f = (DatenFilm)it.next();
            if (f.arr[12].equals(url)) {
                ret = f;
                break;
            }
            if (f.getUrlFuerAufloesung("hd").equals(url)) {
                ret = f;
                break;
            }
            if (!f.getUrlFuerAufloesung("klein").equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    public synchronized String genDate() {
        String ret;
        SimpleDateFormat sdf_ = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
        if (this.metaDaten[1].equals("")) {
            ret = this.metaDaten[0];
        } else {
            String date = this.metaDaten[1];
            sdf_.setTimeZone(new SimpleTimeZone(2, "UTC"));
            Date filmDate = null;
            try {
                filmDate = sdf_.parse(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (filmDate == null) {
                ret = this.metaDaten[1];
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
                ret = formatter.format(filmDate);
            }
        }
        return ret;
    }

    public synchronized String getId() {
        return this.metaDaten[4];
    }

    public synchronized String genDateRev() {
        String ret;
        SimpleDateFormat sdf_ = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
        if (this.metaDaten[1].equals("")) {
            ret = this.metaDaten[0];
        } else {
            String date = this.metaDaten[1];
            sdf_.setTimeZone(new SimpleTimeZone(2, "UTC"));
            Date filmDate = null;
            try {
                filmDate = sdf_.parse(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (filmDate == null) {
                ret = this.metaDaten[1];
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat(DATUM_ZEIT_FORMAT_REV);
                ret = formatter.format(filmDate);
            }
        }
        return ret;
    }

    public synchronized int getAge() {
        int ret = 0;
        Date now = new Date(System.currentTimeMillis());
        Date filmDate = this.getAgeAsDate();
        if (filmDate != null && (ret = Math.round((now.getTime() - filmDate.getTime()) / 1000L)) < 0) {
            ret = 0;
        }
        return ret;
    }

    public synchronized Date getAgeAsDate() {
        String date;
        if (!this.metaDaten[1].isEmpty()) {
            date = this.metaDaten[1];
            this.sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        } else {
            date = this.metaDaten[0];
        }
        Date filmDate = null;
        try {
            filmDate = this.sdf.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return filmDate;
    }

    public synchronized boolean isTooOld() {
        return this.isEmpty() || this.isOlderThan(10800);
    }

    public synchronized boolean isTooOldForDiff() {
        if (this.isEmpty()) {
            return true;
        }
        try {
            String dateMaxDiff_str = new SimpleDateFormat("yyyy.MM.dd__").format(new Date()) + "09" + ":00:00";
            Date dateMaxDiff = new SimpleDateFormat("yyyy.MM.dd__HH:mm:ss").parse(dateMaxDiff_str);
            Date dateFilmliste = this.getAgeAsDate();
            if (dateFilmliste != null) {
                return dateFilmliste.getTime() < dateMaxDiff.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public synchronized boolean isOlderThan(int sekunden) {
        int ret = this.getAge();
        if (ret != 0) {
            MSLog.systemMeldung("Die Filmliste ist " + ret / 60 + " Minuten alt");
        }
        return ret > sekunden;
    }

    public synchronized void writeMetaData() {
        for (int i = 0; i < this.metaDaten.length; ++i) {
            this.metaDaten[i] = "";
        }
        this.metaDaten[0] = this.getJetzt_ddMMyyyy_HHmm();
        this.metaDaten[1] = this.getJetzt_ddMMyyyy_HHmm_gmt();
        this.metaDaten[4] = this.createChecksum(this.metaDaten[1]);
        this.metaDaten[2] = "3";
        this.metaDaten[3] = "MSearch" + MSFunktionen.getProgVersionString() + " - Compiled: " + MSFunktionen.getCompileDate();
    }

    private String createChecksum(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] digest;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            for (byte b : digest = md.digest()) {
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private String getJetzt_ddMMyyyy_HHmm() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
        return formatter.format(new Date());
    }

    private String getJetzt_ddMMyyyy_HHmm_gmt() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
        formatter.setTimeZone(new SimpleTimeZone(2, "UTC"));
        return formatter.format(new Date());
    }

    public synchronized int setFilmNew() {
        int ret = 0;
        for (DatenFilm film : this) {
            if (!film.arr[23].equals(Boolean.TRUE.toString())) continue;
            film.neuerFilm = true;
            ++ret;
        }
        return ret;
    }

    public synchronized int countFilmNew() {
        int ret = 0;
        for (DatenFilm film : this) {
            if (!film.neuerFilm) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized void themenLaden() {
        TreeSet<String> senderSet = new TreeSet<String>();
        senderSet.add("");
        for (DatenFilm film : this) {
            String str = film.arr[1];
            if (senderSet.contains(str)) continue;
            senderSet.add(str);
        }
        this.sender = senderSet.toArray(new String[senderSet.size()]);
        senderSet.clear();
        this.themenPerSender = new String[this.sender.length][];
        TreeSet[] tree = new TreeSet[this.sender.length];
        HashSet[] hashSet = new HashSet[this.sender.length];
        for (int i = 0; i < tree.length; ++i) {
            tree[i] = new TreeSet<String>(GermanStringSorter.getInstance());
            tree[i].add("");
            hashSet[i] = new HashSet();
        }
        for (DatenFilm film : this) {
            String filmSender = film.arr[1];
            String filmThema = film.arr[2];
            if (!hashSet[0].contains(filmThema)) {
                hashSet[0].add(filmThema);
                tree[0].add(filmThema);
            }
            for (int i = 1; i < this.sender.length; ++i) {
                if (!filmSender.equals(this.sender[i]) || hashSet[i].contains(filmThema)) continue;
                hashSet[i].add(filmThema);
                tree[i].add(filmThema);
            }
        }
        for (int i = 0; i < this.themenPerSender.length; ++i) {
            this.themenPerSender[i] = tree[i].toArray(new String[tree[i].size()]);
            tree[i].clear();
            hashSet[i].clear();
        }
    }

    private class AddOld
    implements Runnable {
        private DatenFilm film;
        private final ListeFilme listeOld;

        public AddOld(ListeFilme listeOld) {
            this.listeOld = listeOld;
            ++ListeFilme.this.counter;
        }

        @Override
        public void run() {
            while ((this.film = ListeFilme.this.popOld(this.listeOld)) != null) {
                String size = MSFileSize.laengeString(this.film.arr[12]);
                if (size.isEmpty()) continue;
                ListeFilme.this.addOld(this.film);
            }
            --ListeFilme.this.counter;
        }
    }
}

