/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.tool.TimedTextMarkupLanguageParser;

public class MVSubtitle {
    private static final int timeout = 10000;
    public static final String KODIERUNG_UTF = "UTF-8";
    private static String subFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSubtitle(DatenDownload datenDownload) {
        block42: {
            HttpURLConnection conn = null;
            InputStream in = null;
            FileOutputStream fos = null;
            if (datenDownload.arr[21].isEmpty()) {
                return;
            }
            try {
                int n;
                Log.systemMeldung(new String[]{"Untertitel: ", datenDownload.arr[21], "schreiben nach: ", datenDownload.arr[28]});
                String url = datenDownload.arr[21];
                new File(datenDownload.arr[28]).mkdirs();
                String suff = ".xml";
                if (url.contains(".")) {
                    suff = url.substring(url.lastIndexOf("."));
                    String newSuff = suff.replaceAll("[:\\\\/*?|<>\"]", "--");
                    if (!(newSuff = newSuff.replaceAll("[:\\\\/*|<>]", "--")).equals(suff) || suff.length() > 6) {
                        suff = ".xml";
                    }
                }
                File file = new File(datenDownload.arr[29] + suff);
                subFile = datenDownload.arr[29] + suff;
                conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setRequestProperty("User-Agent", Daten.getUserAgent());
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                conn.setReadTimeout(10000);
                conn.setConnectTimeout(10000);
                String encoding = conn.getContentEncoding();
                if (conn.getResponseCode() < 400) {
                    in = conn.getInputStream();
                } else {
                    Log.fehlerMeldung(752301248, "url: " + url);
                }
                if (in == null) {
                    return;
                }
                if (encoding != null) {
                    switch (encoding.toLowerCase()) {
                        case "gzip": {
                            in = new GZIPInputStream(in);
                            break;
                        }
                        case "deflate": {
                            in = new InflaterInputStream(in, new Inflater(true));
                        }
                    }
                }
                fos = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((n = in.read(buffer)) != -1) {
                    fos.write(buffer, 0, n);
                }
                Log.systemMeldung(new String[]{"Untertitel", "  geschrieben"});
            }
            catch (IOException ex) {
                subFile = null;
                if (conn == null) break block42;
                try {
                    InputStream i = conn.getErrorStream();
                    if (i != null) {
                        i.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            catch (Exception ignored) {
                subFile = null;
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        if (subFile != null && !subFile.endsWith(".srt")) {
            TimedTextMarkupLanguageParser ttmlp = new TimedTextMarkupLanguageParser();
            Path p = new File(subFile).toPath();
            Path srt = new File(subFile + ".srt").toPath();
            if (ttmlp.parse(p)) {
                ttmlp.toSrt(srt);
            }
            ttmlp.cleanup();
        }
    }
}

