/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.jidesoft.utils.SystemInfo;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import mediathek.MediathekGui;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.tool.MVFunctionSys;

public class GuiFunktionen
extends MVFunctionSys {
    private static final int WIN_MAX_PATH_LENGTH = 250;
    private static final int X_MAX_NAME_LENGTH = 255;

    public static void updateGui(MediathekGui mediathekGui) {
        try {
            SwingUtilities.updateComponentTreeUI(mediathekGui);
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyToClipboard(String s) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
    }

    public static void getSize(String nr, JFrame jFrame) {
        Daten.mVConfig.add(nr, jFrame.getSize().width + ":" + jFrame.getSize().height + ":" + jFrame.getLocation().x + ":" + jFrame.getLocation().y);
    }

    public static void getSize(String nr, JDialog jDialog) {
        Daten.mVConfig.add(nr, jDialog.getSize().width + ":" + jDialog.getSize().height + ":" + jDialog.getLocation().x + ":" + jDialog.getLocation().y);
    }

    public static void setSize(String nr, JFrame jFrame, JFrame relativFrame) {
        int breite = 0;
        int hoehe = 0;
        int posX = 0;
        int posY = 0;
        String[] arr = Daten.mVConfig.get(nr).split(":");
        try {
            if (arr.length == 4) {
                breite = Integer.parseInt(arr[0]);
                hoehe = Integer.parseInt(arr[1]);
                posX = Integer.parseInt(arr[2]);
                posY = Integer.parseInt(arr[3]);
            }
        }
        catch (Exception ex) {
            breite = 0;
            hoehe = 0;
            posX = 0;
            posY = 0;
        }
        if (breite > 0 && hoehe > 0) {
            jFrame.setSize(new Dimension(breite, hoehe));
        }
        if (posX > 0 && posY > 0) {
            jFrame.setLocation(posX, posY);
        } else if (relativFrame != null) {
            jFrame.setLocationRelativeTo(relativFrame);
        }
    }

    public static boolean setSize(String nr, JDialog jDialog, JFrame relativFrame) {
        boolean ret = false;
        int breite = 0;
        int hoehe = 0;
        int posX = 0;
        int posY = 0;
        String[] arr = Daten.mVConfig.get(nr).split(":");
        try {
            if (arr.length == 4) {
                breite = Integer.parseInt(arr[0]);
                hoehe = Integer.parseInt(arr[1]);
                posX = Integer.parseInt(arr[2]);
                posY = Integer.parseInt(arr[3]);
            }
        }
        catch (Exception ex) {
            breite = 0;
            hoehe = 0;
            posX = 0;
            posY = 0;
        }
        if (breite > 0 && hoehe > 0) {
            jDialog.setSize(new Dimension(breite, hoehe));
            ret = true;
        }
        if (posX > 0 && posY > 0) {
            jDialog.setLocation(posX, posY);
        } else if (relativFrame != null) {
            jDialog.setLocationRelativeTo(relativFrame);
        }
        return ret;
    }

    public static String addsPfad(String pfad1, String pfad2) {
        String ret = GuiFunktionen.concatPaths(pfad1, pfad2);
        if (ret.equals("")) {
            Log.fehlerMeldung(283946015, pfad1 + " - " + pfad2);
        }
        return ret;
    }

    public static String concatPaths(String pfad1, String pfad2) {
        if (pfad1 == null || pfad2 == null) {
            return "";
        }
        if (pfad1.isEmpty() || pfad2.isEmpty()) {
            return pfad1 + pfad2;
        }
        String ret = pfad1.endsWith(File.separator) ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
        ret = pfad2.charAt(0) == File.separatorChar ? ret + pfad2 : ret + File.separator + pfad2;
        return ret;
    }

    public static String[] checkLengthPath(String[] pathName) {
        if (SystemInfo.isWindows()) {
            if (pathName[0].length() + 10 > 250) {
                Log.fehlerMeldung(102036598, "Pfad zu lang: " + pathName[0]);
                pathName[0] = GuiFunktionen.getHomePath();
            }
            if (pathName[0].length() + pathName[1].length() > 250) {
                Log.fehlerMeldung(902367369, "Name zu lang: " + pathName[0]);
                int maxNameL = 250 - pathName[0].length();
                pathName[1] = GuiFunktionen.cutName(pathName[1], maxNameL);
            }
        } else if (pathName[1].length() > 255) {
            Log.fehlerMeldung(823012012, "Name zu lang: " + pathName[1]);
            pathName[1] = GuiFunktionen.cutName(pathName[1], 255);
        }
        return pathName;
    }

    public static String cutName(String name, int length) {
        if (name.length() > length) {
            name = name.substring(0, length - 4) + name.substring(name.length() - 4);
        }
        return name;
    }

    public static boolean istUrl(String dateiUrl) {
        return dateiUrl.startsWith("http") || dateiUrl.startsWith("www");
    }

    public static String getDateiName(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.equals("")) {
            ret = pfad.substring(pfad.lastIndexOf(47) + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf(38));
        }
        if (ret.equals("")) {
            Log.fehlerMeldung(395019631, pfad);
        }
        return ret;
    }

    public static String getHash(String pfad) {
        int h = pfad.hashCode();
        h = Math.abs(h);
        String hh = h + "";
        while (hh.length() < 10) {
            hh = "0" + hh;
        }
        return hh;
    }

    public static String getDateiSuffix(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.equals("") && pfad.contains(".")) {
            ret = pfad.substring(pfad.lastIndexOf(46) + 1);
        }
        if (ret.equals("")) {
            Log.fehlerMeldung(969871236, pfad);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.length() > 5) {
            ret = "---";
            Log.fehlerMeldung(821397046, pfad);
        }
        return ret;
    }

    public static String getHomePath() {
        return System.getProperty("user.home");
    }

    public static String getStandardDownloadPath() {
        if (GuiFunktionen.getOs() == MVFunctionSys.OperatingSystemType.MAC) {
            return GuiFunktionen.addsPfad(GuiFunktionen.getHomePath(), "Downloads");
        }
        return GuiFunktionen.addsPfad(GuiFunktionen.getHomePath(), "MediathekView");
    }

    public static String[] addLeerListe(String[] str) {
        int len = str.length + 1;
        String[] liste = new String[len];
        liste[0] = "";
        System.arraycopy(str, 0, liste, 1, len - 1);
        return liste;
    }

    public static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (text.length() > max) {
            text = mitte ? text.substring(0, 25) + " .... " + text.substring(text.length() - (max - 31)) : text.substring(0, max - 1);
        }
        while (text.length() < max) {
            if (addVorne) {
                text = " " + text;
                continue;
            }
            text = text + " ";
        }
        return text;
    }

    public static int getImportArtFilme() {
        int ret;
        try {
            ret = Integer.parseInt(Daten.mVConfig.get("update-filme"));
        }
        catch (Exception ex) {
            Daten.mVConfig.add("update-filme", String.valueOf(2));
            ret = 2;
        }
        return ret;
    }
}

