/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.controller.Log;
import mediathek.controller.starter.Start;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.res.GetIcon;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVColor;
import mediathek.tool.MVFont;
import mediathek.tool.MVSenderIconCache;
import mediathek.tool.MVTable;

public class CellRendererDownloads
extends DefaultTableCellRenderer {
    private static final String DOWNLOAD_STARTEN = "Download starten";
    private static final String DOWNLOAD_LOESCHEN = "Download aus Liste entfernen";
    private static final String DOWNLOAD_STOPPEN = "Download stoppen";
    private static final String DOWNLOAD_ENTFERNEN = "Download entfernen";
    private static final String PLAY_DOWNLOADED_FILM = "gespeicherten Film abspielen";
    private static ImageIcon ja_16 = null;
    private static ImageIcon nein_12 = null;
    private static ImageIcon film_start_tab = null;
    private static ImageIcon download_stop_tab = null;
    private static ImageIcon download_start_tab = null;
    private static ImageIcon film_start_sw_tab = null;
    private static ImageIcon download_stop_sw_tab = null;
    private static ImageIcon download_start_sw_tab = null;
    private static ImageIcon download_clear_tab = null;
    private static ImageIcon download_clear_sw_tab = null;
    private static ImageIcon download_del_tab = null;
    private static ImageIcon download_del_sw_tab = null;
    private boolean geoMelden = false;
    private JProgressBar progressBar;
    private final Border emptyBorder = BorderFactory.createEmptyBorder();
    private final Border largeBorder = BorderFactory.createEmptyBorder(9, 2, 9, 2);
    private final JPanel panel;
    private final MVSenderIconCache senderIconCache;

    public CellRendererDownloads() {
        ja_16 = GetIcon.getProgramIcon("ja_16.png");
        nein_12 = GetIcon.getProgramIcon("nein_12.png");
        film_start_tab = GetIcon.getProgramIcon("film_start_tab.png");
        film_start_sw_tab = GetIcon.getProgramIcon("film_start_sw_tab.png");
        download_stop_tab = GetIcon.getProgramIcon("download_stop_tab.png");
        download_stop_sw_tab = GetIcon.getProgramIcon("download_stop_sw_tab.png");
        download_start_tab = GetIcon.getProgramIcon("download_start_tab.png");
        download_start_sw_tab = GetIcon.getProgramIcon("download_start_sw_tab.png");
        download_clear_tab = GetIcon.getProgramIcon("download_clear_tab.png");
        download_clear_sw_tab = GetIcon.getProgramIcon("download_clear_sw_tab.png");
        download_del_tab = GetIcon.getProgramIcon("download_del_tab.png");
        download_del_sw_tab = GetIcon.getProgramIcon("download_del_sw_tab.png");
        this.geoMelden = Boolean.parseBoolean(Daten.mVConfig.get("Geo-melden"));
        ListenerMediathekView.addListener(new ListenerMediathekView(31, CellRendererDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                CellRendererDownloads.this.geoMelden = Boolean.parseBoolean(Daten.mVConfig.get("Geo-melden"));
            }
        });
        this.progressBar = new JProgressBar(0, 1000);
        this.progressBar.setStringPainted(true);
        if (!SystemInfo.isMacOSX()) {
            this.progressBar.setUI(new BasicProgressBarUI(){

                @Override
                protected Color getSelectionBackground() {
                    return UIManager.getDefaults().getColor("Table.foreground");
                }

                @Override
                protected Color getSelectionForeground() {
                    return Color.white;
                }
            });
        }
        this.panel = new JPanel(new BorderLayout());
        this.panel.add(this.progressBar);
        this.senderIconCache = new MVSenderIconCache();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.setBackground(null);
            this.setForeground(null);
            this.setIcon(null);
            this.setToolTipText(null);
            this.setHorizontalAlignment(10);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int rowModelIndex = table.convertRowIndexToModel(row);
            int columnModelIndex = table.convertColumnIndexToModel(column);
            DatenDownload datenDownload = (DatenDownload)table.getModel().getValueAt(rowModelIndex, 37);
            if (!SystemInfo.isMacOSX()) {
                if (isSelected) {
                    this.setFont(new Font("Dialog", 1, MVFont.fontSize));
                } else {
                    this.setFont(new Font("Dialog", 0, MVFont.fontSize));
                }
            }
            switch (columnModelIndex) {
                case 8: {
                    this.setHorizontalAlignment(0);
                    if (((MVTable)table).iconAnzeigen && !((MVTable)table).iconKlein) {
                        this.progressBar.setBorder(this.largeBorder);
                    } else {
                        this.progressBar.setBorder(this.emptyBorder);
                    }
                    if (datenDownload.start != null) {
                        if (1 < datenDownload.start.percent && datenDownload.start.percent < 1000) {
                            this.setColor(this.panel, datenDownload.start, isSelected);
                            this.setColor(this.progressBar, datenDownload.start, isSelected);
                            this.progressBar.setValue(datenDownload.start.percent);
                            double progressValue = (double)datenDownload.start.percent / 10.0;
                            this.progressBar.setString(Double.toString(progressValue) + "%");
                            return this.panel;
                        }
                        this.setText(Start.getTextProgress(datenDownload));
                        break;
                    }
                    this.setText("");
                    break;
                }
                case 9: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.start == null || !datenDownload.start.beginnAnschauen) break;
                    this.setForeground(MVColor.DOWNLOAD_ANSEHEN.color);
                    break;
                }
                case 1: {
                    if ((Integer)table.getModel().getValueAt(rowModelIndex, 1) == 0) {
                        this.setText("");
                    }
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 26: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.isRestart()) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                    break;
                }
                case 36: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.isDownloadManager()) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                    break;
                }
                case 30: {
                    switch (datenDownload.art) {
                        case 1: {
                            this.setText("direkter Download");
                            break;
                        }
                        case 2: {
                            this.setText("Programm");
                        }
                    }
                    break;
                }
                case 31: {
                    switch (datenDownload.quelle) {
                        case -1: {
                            this.setText("Alle");
                            break;
                        }
                        case 3: {
                            this.setText("Abo");
                            break;
                        }
                        case 1: {
                            this.setText("Button");
                            break;
                        }
                        case 2: {
                            this.setText("Download");
                        }
                    }
                    break;
                }
                case 15: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.isInterrupted()) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                    break;
                }
                case 32: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.istZurueckgestellt()) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                    break;
                }
                case 33: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.isInfoFile()) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                    break;
                }
                case 35: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.isSubtitle()) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                    break;
                }
                case 34: {
                    this.setHorizontalAlignment(0);
                    if (datenDownload.isSpotlight()) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                    break;
                }
                case 6: {
                    this.handleButtonStartColumn(datenDownload, isSelected);
                    break;
                }
                case 7: {
                    this.handleButtonDeleteColumn(datenDownload, isSelected);
                    break;
                }
                case 11: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 2: {
                    this.handleAboColumn(datenDownload);
                    break;
                }
                case 0: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 3: {
                    if (!((MVTable)table).iconAnzeigen) break;
                    this.handleSenderColumn((String)value, ((MVTable)table).iconKlein);
                }
            }
            this.setColor(this, datenDownload.start, isSelected);
            this.handleGeoBlocking(datenDownload, isSelected);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(758200166, ex);
        }
        return this;
    }

    private void handleSenderColumn(String sender, boolean small) {
        this.setHorizontalAlignment(0);
        ImageIcon icon = this.senderIconCache.get(sender, small);
        if (icon != null) {
            this.setText("");
            this.setIcon(icon);
        }
    }

    private void handleButtonStartColumn(DatenDownload datenDownload, boolean isSelected) {
        this.setHorizontalAlignment(0);
        if (isSelected) {
            if (datenDownload.start != null && !datenDownload.isDownloadManager()) {
                if (datenDownload.start.status == 3) {
                    this.setIcon(film_start_tab);
                    this.setToolTipText(PLAY_DOWNLOADED_FILM);
                } else if (datenDownload.start.status == 4) {
                    this.setIcon(download_start_tab);
                    this.setToolTipText(DOWNLOAD_STARTEN);
                } else {
                    this.setIcon(download_stop_tab);
                    this.setToolTipText(DOWNLOAD_STOPPEN);
                }
            } else {
                this.setIcon(download_start_tab);
                this.setToolTipText(DOWNLOAD_STARTEN);
            }
        } else if (datenDownload.start != null && !datenDownload.isDownloadManager()) {
            if (datenDownload.start.status == 3) {
                this.setIcon(film_start_sw_tab);
                this.setToolTipText(PLAY_DOWNLOADED_FILM);
            } else if (datenDownload.start.status == 4) {
                this.setIcon(download_start_sw_tab);
                this.setToolTipText(DOWNLOAD_STARTEN);
            } else {
                this.setIcon(download_stop_sw_tab);
                this.setToolTipText(DOWNLOAD_STOPPEN);
            }
        } else {
            this.setIcon(download_start_sw_tab);
            this.setToolTipText(DOWNLOAD_STARTEN);
        }
    }

    private void handleButtonDeleteColumn(DatenDownload datenDownload, boolean isSelected) {
        this.setHorizontalAlignment(0);
        if (datenDownload.start != null) {
            if (datenDownload.start.status >= 3) {
                if (isSelected) {
                    this.setIcon(download_clear_tab);
                    this.setToolTipText(DOWNLOAD_ENTFERNEN);
                } else {
                    this.setIcon(download_clear_sw_tab);
                    this.setToolTipText(DOWNLOAD_ENTFERNEN);
                }
            } else {
                this.setupDownloadLoeschen(isSelected);
            }
        } else {
            this.setupDownloadLoeschen(isSelected);
        }
    }

    private void handleAboColumn(DatenDownload datenDownload) {
        this.setHorizontalAlignment(0);
        if (!datenDownload.arr[2].equals("")) {
            this.setForeground(MVColor.DOWNLOAD_IST_ABO.color);
        } else {
            this.setForeground(MVColor.DOWNLOAD_IST_DIREKTER_DOWNLOAD.color);
            this.setText("Download");
        }
    }

    private void handleGeoBlocking(DatenDownload datenDownload, boolean isSelected) {
        if (datenDownload.start == null && this.geoMelden && !datenDownload.arr[16].isEmpty() && !datenDownload.arr[16].contains(Daten.mVConfig.get("Geo-Standort"))) {
            if (isSelected) {
                this.setBackground(MVColor.FILM_GEOBLOCK_BACKGROUND_SEL.color);
            } else {
                this.setBackground(MVColor.FILM_GEOBLOCK_BACKGROUND.color);
            }
        }
    }

    private void setupDownloadLoeschen(boolean isSelected) {
        if (isSelected) {
            this.setIcon(download_del_tab);
            this.setToolTipText(DOWNLOAD_LOESCHEN);
        } else {
            this.setIcon(download_del_sw_tab);
            this.setToolTipText(DOWNLOAD_LOESCHEN);
        }
    }

    private void setColor(Component c, Start s, boolean isSelected) {
        if (s != null) {
            switch (s.status) {
                case 1: {
                    if (isSelected) {
                        c.setBackground(MVColor.DOWNLOAD_WAIT_SEL.color);
                        break;
                    }
                    c.setBackground(MVColor.DOWNLOAD_WAIT.color);
                    break;
                }
                case 2: {
                    if (isSelected) {
                        c.setBackground(MVColor.DOWNLOAD_RUN_SEL.color);
                        break;
                    }
                    c.setBackground(MVColor.DOWNLOAD_RUN.color);
                    break;
                }
                case 3: {
                    if (isSelected) {
                        c.setBackground(MVColor.DOWNLOAD_FERTIG_SEL.color);
                        break;
                    }
                    c.setBackground(MVColor.DOWNLOAD_FERTIG.color);
                    break;
                }
                case 4: {
                    if (isSelected) {
                        c.setBackground(MVColor.DOWNLOAD_FEHLER_SEL.color);
                        break;
                    }
                    c.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                }
            }
        }
    }
}

