/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.jidesoft.utils.SystemInfo;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Konstanten;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.MVMessageDialog;

public class PanelEinstellungenErweitert
extends PanelVorlage {
    private ButtonGroup buttonGroup2;
    private JButton jButtonHilfe;
    private JButton jButtonHilfeNeuladen;
    private JButton jButtonHilfeProgrammDateimanager;
    private JButton jButtonHilfeProgrammShutdown;
    private JButton jButtonHilfeProgrammUrl;
    private JButton jButtonHilfeVideoplayer;
    private JButton jButtonProgrammDateimanager;
    private JButton jButtonProgrammShutdown;
    private JButton jButtonProgrammUrl;
    private JButton jButtonProgrammVideoplayer;
    private JCheckBox jCheckBoxAboSuchen;
    private JCheckBox jCheckBoxDownloadSofortStarten;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButtonAuto;
    private JRadioButton jRadioButtonManuel;
    private JTextField jTextFieldAuto;
    private JTextField jTextFieldProgrammDateimanager;
    private JTextField jTextFieldProgrammShutdown;
    private JTextField jTextFieldProgrammUrl;
    private JTextField jTextFieldUserAgent;
    private JTextField jTextFieldVideoplayer;

    public PanelEinstellungenErweitert(Daten d, JFrame pparentComponent) {
        super(d, pparentComponent);
        this.initComponents();
        this.daten = d;
        this.init();
        this.setIcon();
        this.setHelp();
        this.jRadioButtonAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEinstellungenErweitert.this.setUserAgent();
            }
        });
        this.jRadioButtonManuel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEinstellungenErweitert.this.setUserAgent();
            }
        });
        this.jTextFieldUserAgent.getDocument().addDocumentListener(new BeobUserAgent());
        ListenerMediathekView.addListener(new ListenerMediathekView(19, PanelEinstellungenErweitert.class.getSimpleName()){

            @Override
            public void ping() {
                PanelEinstellungenErweitert.this.init();
            }
        });
        this.jCheckBoxAboSuchen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Abos-sofort-suchen")));
        this.jCheckBoxAboSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Abos-sofort-suchen", Boolean.toString(PanelEinstellungenErweitert.this.jCheckBoxAboSuchen.isSelected()));
            }
        });
        this.jCheckBoxDownloadSofortStarten.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Download-sofort-starten")));
        this.jCheckBoxDownloadSofortStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Download-sofort-starten", Boolean.toString(PanelEinstellungenErweitert.this.jCheckBoxDownloadSofortStarten.isSelected()));
            }
        });
        this.jButtonProgrammDateimanager.addActionListener(new BeobPfad("Download-Ordner-oeffnen", "Dateimanager suchen", this.jTextFieldProgrammDateimanager));
        this.jButtonProgrammVideoplayer.addActionListener(new BeobPfad("Player-zum-Abspielen", "Videoplayer suchen", this.jTextFieldVideoplayer));
        this.jButtonProgrammUrl.addActionListener(new BeobPfad("Programm-Url-oeffnen", "Browser suchen", this.jTextFieldProgrammUrl));
        this.jButtonProgrammShutdown.addActionListener(new BeobPfad("Programm-Linux-Shutdown", "Shutdown Befehl", this.jTextFieldProgrammShutdown));
        this.jTextFieldProgrammDateimanager.setText(Daten.mVConfig.get("Download-Ordner-oeffnen"));
        this.jTextFieldProgrammDateimanager.getDocument().addDocumentListener(new BeobDoc("Download-Ordner-oeffnen", this.jTextFieldProgrammDateimanager));
        this.jTextFieldVideoplayer.setText(Daten.mVConfig.get("Player-zum-Abspielen"));
        this.jTextFieldVideoplayer.getDocument().addDocumentListener(new BeobDoc("Player-zum-Abspielen", this.jTextFieldVideoplayer));
        this.jTextFieldProgrammUrl.setText(Daten.mVConfig.get("Programm-Url-oeffnen"));
        this.jTextFieldProgrammUrl.getDocument().addDocumentListener(new BeobDoc("Programm-Url-oeffnen", this.jTextFieldProgrammUrl));
        this.jTextFieldProgrammShutdown.setText(Daten.mVConfig.get("Programm-Linux-Shutdown"));
        if (this.jTextFieldProgrammShutdown.getText().isEmpty()) {
            this.jTextFieldProgrammShutdown.setText("shutdown -h now");
            Daten.mVConfig.add("Programm-Linux-Shutdown", "shutdown -h now");
        }
        this.jTextFieldProgrammShutdown.getDocument().addDocumentListener(new BeobDoc("Programm-Linux-Shutdown", this.jTextFieldProgrammShutdown));
        if (MVFunctionSys.getOs() != MVFunctionSys.OperatingSystemType.LINUX) {
            this.jButtonHilfeProgrammShutdown.setEnabled(false);
            this.jTextFieldProgrammShutdown.setEnabled(false);
            this.jButtonProgrammShutdown.setEnabled(false);
        }
    }

    private void init() {
        this.jRadioButtonAuto.setSelected(Daten.isUserAgentAuto());
        this.jRadioButtonManuel.setSelected(!Daten.isUserAgentAuto());
        this.jTextFieldUserAgent.setEditable(!Daten.isUserAgentAuto());
        this.jTextFieldUserAgent.setText(Daten.mVConfig.get("User-Agent"));
        this.jTextFieldAuto.setText(Konstanten.USER_AGENT_DEFAULT);
        this.jTextFieldProgrammDateimanager.setText(Daten.mVConfig.get("Download-Ordner-oeffnen"));
        this.jTextFieldProgrammUrl.setText(Daten.mVConfig.get("Programm-Url-oeffnen"));
    }

    private void setUserAgent() {
        if (this.jRadioButtonAuto.isSelected()) {
            Daten.setUserAgentAuto();
        } else {
            Daten.setUserAgentManuel(this.jTextFieldUserAgent.getText());
        }
        this.jTextFieldUserAgent.setEditable(!Daten.isUserAgentAuto());
    }

    private void setHelp() {
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelEinstellungenErweitert.this.parentComponent, true, "\nDieser Text wird als User-Agent\nan den Webserver \u00fcbertragen. Das entspricht\nder Kennung, die auch die Browser senden.").setVisible(true);
            }
        });
        this.jButtonHilfeProgrammDateimanager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelEinstellungenErweitert.this.parentComponent, true, "\nIm Tab \"Downloads\" kann man mit der rechten\nMaustaste den Downloadordner (Zielordner)\ndes jeweiligen Downloads \u00f6ffnen.\nNormalerweise wird der Dateimanager des\nBetriebssystems gefunden und ge\u00f6ffnet. Klappt das nicht,\nkann hier ein Programm daf\u00fcr angegeben werden.").setVisible(true);
            }
        });
        this.jButtonHilfeNeuladen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelEinstellungenErweitert.this.parentComponent, true, "\nAbos automatisch suchen:\nNach dem Neuladen einer Filmliste wird dann\nsofort nach neuen Abos gesucht. Ansonsten muss man\nim Tab Download auf \"Downloads aktualisieren\" klicken.\n\nDownloads sofort starten:\nNeu angelegte Downloads (aus Abos) werden\nsofort gestartet. Ansonsten muss man sie\nselbst starten.\n").setVisible(true);
            }
        });
        this.jButtonHilfeVideoplayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelEinstellungenErweitert.this.parentComponent, true, "\nIm Tab \"Downloads\" kann man den gespeicherten\nFilm in einem Videoplayer \u00f6ffnen.\nNormalerweise wird der Videoplayer des\nBetriebssystems gefunden und ge\u00f6ffnet. Klappt das nicht,\nkann hier ein Programm daf\u00fcr angegeben werden.").setVisible(true);
            }
        });
        this.jButtonHilfeProgrammUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelEinstellungenErweitert.this.parentComponent, true, "\nWenn das Programm versucht, einen Link zu \u00f6ffnen\n(z.B. den Link im Men\u00fcpunkt \"Hilfe\" zu den \"Hilfeseiten\")\nund die Standardanwendung (z.B. \"Firefox\") nicht startet,\nkann damit ein Programm ausgew\u00e4hlt und\nfest zugeordnet werden (z.B. der Browser \"Firefox\").").setVisible(true);
            }
        });
        this.jButtonHilfeProgrammShutdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelEinstellungenErweitert.this.parentComponent, true, "\nBei Linux wird das Programm/Script ausgef\u00fchrt\num den Recher herunter zu fahren\n\nm\u00f6gliche Aufrufe sind:\n\nsystemctl poweroff\npoweroff\nsudo shutdown -P now\nshutdown -h now").setVisible(true);
            }
        });
    }

    private void setIcon() {
        this.jButtonHilfe.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfeNeuladen.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfeProgrammDateimanager.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfeVideoplayer.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfeProgrammUrl.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfeProgrammShutdown.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonProgrammDateimanager.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonProgrammVideoplayer.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonProgrammUrl.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonProgrammShutdown.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        JPanel jPanel6 = new JPanel();
        this.jCheckBoxAboSuchen = new JCheckBox();
        this.jCheckBoxDownloadSofortStarten = new JCheckBox();
        this.jButtonHilfeNeuladen = new JButton();
        JPanel jPanel1 = new JPanel();
        this.jTextFieldUserAgent = new JTextField();
        this.jButtonHilfe = new JButton();
        this.jRadioButtonAuto = new JRadioButton();
        this.jRadioButtonManuel = new JRadioButton();
        this.jTextFieldAuto = new JTextField();
        this.jPanel2 = new JPanel();
        this.jTextFieldProgrammDateimanager = new JTextField();
        this.jButtonProgrammDateimanager = new JButton();
        this.jButtonHilfeProgrammDateimanager = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldVideoplayer = new JTextField();
        this.jButtonHilfeVideoplayer = new JButton();
        this.jButtonProgrammVideoplayer = new JButton();
        this.jPanel4 = new JPanel();
        this.jTextFieldProgrammUrl = new JTextField();
        this.jButtonProgrammUrl = new JButton();
        this.jButtonHilfeProgrammUrl = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonHilfeProgrammShutdown = new JButton();
        this.jButtonProgrammShutdown = new JButton();
        this.jTextFieldProgrammShutdown = new JTextField();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Nach dem Neuladen der Filmliste"));
        this.jCheckBoxAboSuchen.setText("Abos automatisch suchen");
        this.jCheckBoxDownloadSofortStarten.setText("Downloads aus Abos sofort starten");
        this.jButtonHilfeNeuladen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAboSuchen).addComponent(this.jCheckBoxDownloadSofortStarten)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHilfeNeuladen).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxAboSuchen).addComponent(this.jButtonHilfeNeuladen)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDownloadSofortStarten).addContainerGap(17, Short.MAX_VALUE)));
        jPanel1.setBorder(BorderFactory.createTitledBorder("User-Agent"));
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        buttonGroup1.add(this.jRadioButtonAuto);
        this.jRadioButtonAuto.setText("Auto:");
        buttonGroup1.add(this.jRadioButtonManuel);
        this.jTextFieldAuto.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonManuel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUserAgent)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(13, 13, 13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jRadioButtonAuto).addComponent(this.jTextFieldAuto, -2, -1, -2).addComponent(this.jButtonHilfe)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jRadioButtonManuel).addComponent(this.jTextFieldUserAgent, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonHilfe, this.jTextFieldAuto, this.jTextFieldUserAgent);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Tab Downloads"));
        this.jButtonProgrammDateimanager.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonHilfeProgrammDateimanager.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jLabel1.setText("Datei-Manager zum \u00d6ffnen des Downloadordners");
        this.jLabel2.setText("Videoplayer zum Abspielen gespeicherter Filme");
        this.jButtonHilfeVideoplayer.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jButtonProgrammVideoplayer.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldProgrammDateimanager).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammDateimanager).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeProgrammDateimanager)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldVideoplayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammVideoplayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeVideoplayer)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(0, 180, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldProgrammDateimanager, -2, -1, -2).addComponent(this.jButtonProgrammDateimanager).addComponent(this.jButtonHilfeProgrammDateimanager)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVideoplayer, -2, -1, -2).addGap(1, 1, 1)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHilfeVideoplayer).addComponent(this.jButtonProgrammVideoplayer))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonHilfeProgrammDateimanager, this.jButtonProgrammDateimanager, this.jTextFieldProgrammDateimanager);
        jPanel2Layout.linkSize(1, this.jButtonHilfeVideoplayer, this.jButtonProgrammVideoplayer, this.jTextFieldVideoplayer);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Webbrowser zum \u00d6ffnen von URLs"));
        this.jButtonProgrammUrl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonHilfeProgrammUrl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldProgrammUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeProgrammUrl).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldProgrammUrl, -2, -1, -2).addComponent(this.jButtonProgrammUrl).addComponent(this.jButtonHilfeProgrammUrl)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jButtonHilfeProgrammUrl, this.jButtonProgrammUrl, this.jTextFieldProgrammUrl);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Linux: Aufruf zum Shutdown"));
        this.jButtonHilfeProgrammShutdown.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jButtonProgrammShutdown.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jTextFieldProgrammShutdown.setText("shutdown -h now");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldProgrammShutdown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammShutdown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeProgrammShutdown).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldProgrammShutdown, -2, -1, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonHilfeProgrammShutdown).addComponent(this.jButtonProgrammShutdown))).addGap(0, 12, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(1, this.jButtonHilfeProgrammShutdown, this.jButtonProgrammShutdown, this.jTextFieldProgrammShutdown);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(79, Short.MAX_VALUE)));
    }

    private class BeobPfad
    implements ActionListener {
        String config;
        String title;
        JTextField textField;

        public BeobPfad(String config, String title, JTextField textField) {
            this.config = config;
            this.title = title;
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog((Frame)PanelEinstellungenErweitert.this.daten.mediathekGui, this.title);
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        this.textField.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(915263014, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!this.textField.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(this.textField.getText()));
                } else {
                    chooser.setCurrentDirectory(new File(GuiFunktionen.getHomePath()));
                }
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(751214501, ex);
                    }
                }
            }
            Daten.mVConfig.add(this.config, this.textField.getText());
            String programm = this.textField.getText();
            if (!programm.equals("")) {
                try {
                    if (!new File(programm).exists()) {
                        MVMessageDialog.showMessageDialog(PanelEinstellungenErweitert.this.daten.mediathekGui, "Das Programm:  \"" + programm + "\"" + "  existiert nicht!", "Fehler", 0);
                    } else if (!new File(programm).canExecute()) {
                        MVMessageDialog.showMessageDialog(PanelEinstellungenErweitert.this.daten.mediathekGui, "Das Programm:  \"" + programm + "\"" + "  kann nicht ausgef\u00fchrt werden!", "Fehler", 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class BeobDoc
    implements DocumentListener {
        String config;
        JTextField txt;

        public BeobDoc(String config, JTextField txt) {
            this.config = config;
            this.txt = txt;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Daten.mVConfig.add(this.config, this.txt.getText());
        }
    }

    private class BeobUserAgent
    implements DocumentListener {
        private BeobUserAgent() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Daten.setUserAgentManuel(PanelEinstellungenErweitert.this.jTextFieldUserAgent.getText());
        }
    }
}

