/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.daten.Daten;
import mediathek.gui.MVDownloadInfo;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.ListenerMediathekView;

public class PanelDownload
extends PanelVorlage {
    private JButton jButtonBeep;
    private JButton jButtonHilfeAnzahl;
    private JCheckBox jCheckBoxBeep;
    private JCheckBox jCheckBoxNotification;
    private JCheckBox jCheckBoxServer;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelBandwidth;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider jSliderBandbreite;
    private JSpinner jSpinnerDownload;
    private JTextField jTextFieldWarnung;

    public PanelDownload(Daten d, JFrame parent) {
        super(d, parent);
        this.initComponents();
        this.daten = d;
        this.initSpinner();
        this.jSpinnerDownload.addChangeListener(new BeobSpinnerDownload());
        this.jButtonHilfeAnzahl.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfeAnzahl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelDownload.this.parentComponent, true, "\nHier kann angegeben werden, wie viele\nDownloads gleichzeitig gestartet werden k\u00f6nnen.\n\nEs gibt jedoch noch eine Begrenzung\ndie trotzdem nicht \u00fcberschritten wird:\n\n2 Downloads pro Server, das kann auch noch\nauf 1 Download pro Server\n(z.B. nur ein Download von \"www.zdf.de\")\nweiter begrenzt werden.").setVisible(true);
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(6, PanelDownload.class.getSimpleName()){

            @Override
            public void ping() {
                PanelDownload.this.initSpinner();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(28, PanelDownload.class.getSimpleName()){

            @Override
            public void ping() {
                PanelDownload.this.setSliderBandwith();
            }
        });
        this.jCheckBoxNotification.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Notification-anzeigen")));
        this.jCheckBoxNotification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Notification-anzeigen", Boolean.toString(PanelDownload.this.jCheckBoxNotification.isSelected()));
            }
        });
        this.jCheckBoxBeep.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Download-Beep")));
        this.jCheckBoxBeep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.mVConfig.add("Download-Beep", String.valueOf(PanelDownload.this.jCheckBoxBeep.isSelected()));
            }
        });
        this.jCheckBoxServer.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("max1DownloadProServer")));
        this.jCheckBoxServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.mVConfig.add("max1DownloadProServer", String.valueOf(PanelDownload.this.jCheckBoxServer.isSelected()));
            }
        });
        this.jButtonBeep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        this.jSliderBandbreite.setMinimum(5);
        this.jSliderBandbreite.setMaximum(100);
        this.setSliderBandwith();
        this.jSliderBandbreite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanelDownload.this.stopBeob) {
                    return;
                }
                int bandbreiteKByte = PanelDownload.this.jSliderBandbreite.getValue() * 10;
                PanelDownload.this.jLabelBandwidth.setText(bandbreiteKByte + " kByte/s");
                Daten.mVConfig.add("maxBandbreite", String.valueOf(bandbreiteKByte));
                ListenerMediathekView.notify(28, PanelDownload.class.getName());
            }
        });
    }

    private void setSliderBandwith() {
        this.stopBeob = true;
        MVDownloadInfo.setSliderBandwith(this.jSliderBandbreite, this.jLabelBandwidth);
        this.stopBeob = false;
    }

    private void initSpinner() {
        if (Daten.mVConfig.get("maxDownload").equals("")) {
            Daten.mVConfig.add("maxDownload", "1");
        }
        this.jSpinnerDownload.setValue(Integer.parseInt(Daten.mVConfig.get("maxDownload")));
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jCheckBoxNotification = new JCheckBox();
        JLabel jLabel3 = new JLabel();
        this.jSpinnerDownload = new JSpinner();
        this.jButtonHilfeAnzahl = new JButton();
        this.jCheckBoxBeep = new JCheckBox();
        this.jButtonBeep = new JButton();
        this.jCheckBoxServer = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabelBandwidth = new JLabel();
        this.jSliderBandbreite = new JSlider();
        this.jLabel5 = new JLabel();
        this.jTextFieldWarnung = new JTextField();
        this.setMinimumSize(this.getPreferredSize());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.jCheckBoxNotification.setText("Benachrichtigung wenn abgeschlossen");
        jLabel3.setText("gleichzeitige Downloads laden:");
        this.jSpinnerDownload.setModel(new SpinnerNumberModel(1, 1, 10, 1));
        this.jButtonHilfeAnzahl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jCheckBoxBeep.setText("nach jedem Download einen \"Beep\" ausgeben");
        this.jButtonBeep.setText("Testen");
        this.jCheckBoxServer.setText("nur ein Download pro Downloadserver");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxNotification, -1, -1, Short.MAX_VALUE).addGap(64, 64, 64)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jCheckBoxServer)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxBeep).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonBeep)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(jLabel3).addGap(51, 51, 51).addComponent(this.jSpinnerDownload, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeAnzahl))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxNotification).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxBeep).addComponent(this.jButtonBeep)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel3).addComponent(this.jSpinnerDownload, -2, -1, -2).addComponent(this.jButtonHilfeAnzahl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxServer).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel4.setText("Downloadgeschwindigkeit begrenzen:");
        this.jLabelBandwidth.setHorizontalAlignment(0);
        this.jLabelBandwidth.setText("1000 kByte/s");
        this.jLabelBandwidth.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jSliderBandbreite.setMajorTickSpacing(10);
        this.jSliderBandbreite.setMaximum(1000);
        this.jSliderBandbreite.setMinimum(50);
        this.jSliderBandbreite.setMinorTickSpacing(5);
        this.jSliderBandbreite.setToolTipText("");
        this.jLabel5.setText("(max. Bandbreite pro Download, nur f\u00fcr direkte Downloads)");
        this.jTextFieldWarnung.setEditable(false);
        this.jTextFieldWarnung.setText("Bei zu hoher Bandbreite kann es zum Ausbremsen des Downloads durch den Server kommen.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel5).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldWarnung, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelBandwidth, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderBandbreite, -1, -1, Short.MAX_VALUE))).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelBandwidth).addComponent(this.jSliderBandbreite, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.jTextFieldWarnung, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(249, Short.MAX_VALUE)));
    }

    private class BeobSpinnerDownload
    implements ChangeListener {
        private BeobSpinnerDownload() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            Daten.mVConfig.add("maxDownload", String.valueOf(((Number)PanelDownload.this.jSpinnerDownload.getModel().getValue()).intValue()));
            ListenerMediathekView.notify(6, PanelDownload.class.getSimpleName());
        }
    }
}

