/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.controller.Log;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenProg;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialog.MVPanelDownloadZiel;
import mediathek.res.GetIcon;
import mediathek.tool.EscBeenden;
import mediathek.tool.MVMessageDialog;

public class DialogEditDownload
extends JDialog {
    private final DatenDownload datenDownload;
    public boolean ok = false;
    private final JTextField[] textfeldListe = new JTextField[38];
    private final JLabel[] labelListe = new JLabel[38];
    private final JCheckBox jCheckBoxRestart = new JCheckBox();
    private final JCheckBox jCheckBoxDownloadmanager = new JCheckBox();
    private final JCheckBox jCheckBoxUnterbrochen = new JCheckBox();
    private final JCheckBox jCheckBoxInfodatei = new JCheckBox();
    private final JCheckBox jCheckBoxSubtitle = new JCheckBox();
    private final JCheckBox jCheckBoxSpotlight = new JCheckBox();
    private final MVPanelDownloadZiel mVPanelDownloadZiel;
    private final boolean gestartet;
    private String dateiGroesse_HD = "";
    private String dateiGroesse_Hoch = "";
    private String dateiGroesse_Klein = "";
    private JFrame parent = null;
    private String orgProgArray = "";
    private String resolution = "normal";
    private ButtonGroup buttonGroup1;
    private JButton jButtonAbbrechen;
    private JButton jButtonOk;
    private JLabel jLabelRes;
    private JPanel jPanelExtra;
    private JPanel jPanelRes;
    private JRadioButton jRadioButtonResHd;
    private JRadioButton jRadioButtonResHi;
    private JRadioButton jRadioButtonResLo;
    private JScrollPane jScrollPane1;

    public DialogEditDownload(JFrame parent, boolean modal, DatenDownload ddownload, boolean ggestartet) {
        super((Frame)parent, modal);
        this.initComponents();
        this.parent = parent;
        this.datenDownload = ddownload;
        this.gestartet = ggestartet;
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.orgProgArray = this.datenDownload.arr[25];
        this.mVPanelDownloadZiel = new MVPanelDownloadZiel(parent, this.datenDownload, false);
        this.mVPanelDownloadZiel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonResHd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditDownload.this.changeRes();
            }
        });
        this.jRadioButtonResHi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditDownload.this.changeRes();
            }
        });
        this.jRadioButtonResLo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditDownload.this.changeRes();
            }
        });
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogEditDownload.this.check()) {
                    DialogEditDownload.this.beenden();
                }
            }
        });
        this.jButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditDownload.this.beenden();
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonOk);
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogEditDownload.this.beenden();
            }
        };
        this.setupResolutionButtons();
        this.setExtra();
    }

    private void setupResolutionButtons() {
        this.jRadioButtonResHd.setEnabled(false);
        this.jRadioButtonResHi.setEnabled(false);
        this.jRadioButtonResLo.setEnabled(false);
        if (this.datenDownload.art != 1 && this.datenDownload.pSet == null) {
            this.jPanelRes.setVisible(false);
            return;
        }
        if (this.datenDownload.film != null) {
            this.jRadioButtonResHi.setEnabled(!this.gestartet);
            this.jRadioButtonResHi.setSelected(this.datenDownload.arr[19].equals(this.datenDownload.film.getUrlFuerAufloesung("normal")));
            this.dateiGroesse_Hoch = this.datenDownload.film.getDateigroesse(this.datenDownload.film.getUrlFuerAufloesung("normal"));
            if (!this.dateiGroesse_Hoch.isEmpty()) {
                this.jRadioButtonResHi.setText(this.jRadioButtonResHi.getText() + "   [ " + this.dateiGroesse_Hoch + " MB ]");
            }
            if (!this.datenDownload.film.arr[20].isEmpty()) {
                this.jRadioButtonResHd.setEnabled(!this.gestartet);
                this.jRadioButtonResHd.setSelected(this.datenDownload.arr[19].equals(this.datenDownload.film.getUrlFuerAufloesung("hd")));
                this.dateiGroesse_HD = this.datenDownload.film.getDateigroesse(this.datenDownload.film.getUrlFuerAufloesung("hd"));
                if (!this.dateiGroesse_HD.isEmpty()) {
                    this.jRadioButtonResHd.setText(this.jRadioButtonResHd.getText() + "   [ " + this.dateiGroesse_HD + " MB ]");
                }
            }
            if (!this.datenDownload.film.arr[18].isEmpty()) {
                this.jRadioButtonResLo.setEnabled(!this.gestartet);
                this.jRadioButtonResLo.setSelected(this.datenDownload.arr[19].equals(this.datenDownload.film.getUrlFuerAufloesung("klein")));
                this.dateiGroesse_Klein = this.datenDownload.film.getDateigroesse(this.datenDownload.film.getUrlFuerAufloesung("klein"));
                if (!this.dateiGroesse_Klein.isEmpty()) {
                    this.jRadioButtonResLo.setText(this.jRadioButtonResLo.getText() + "   [ " + this.dateiGroesse_Klein + " MB ]");
                }
            }
        }
        this.resolution = this.jRadioButtonResHd.isSelected() ? "hd" : (this.jRadioButtonResLo.isSelected() ? "klein" : "normal");
    }

    private void changeRes() {
        String res = this.jRadioButtonResHd.isSelected() ? "hd" : (this.jRadioButtonResLo.isSelected() ? "klein" : "normal");
        this.datenDownload.arr[19] = this.datenDownload.film.getUrlFuerAufloesung(res);
        this.datenDownload.arr[20] = this.datenDownload.film.getUrlRtmpFuerAufloesung(res);
        this.textfeldListe[19].setText(this.datenDownload.arr[19]);
        this.textfeldListe[20].setText(this.datenDownload.arr[20]);
        String size = this.jRadioButtonResHd.isSelected() ? this.dateiGroesse_HD : (this.jRadioButtonResLo.isSelected() ? this.dateiGroesse_Klein : this.dateiGroesse_Hoch);
        if (this.datenDownload.art == 2 && this.datenDownload.pSet != null) {
            DatenDownload d = new DatenDownload(this.datenDownload.pSet, this.datenDownload.film, this.datenDownload.quelle, this.datenDownload.abo, this.datenDownload.arr[27], this.datenDownload.arr[28], res);
            this.datenDownload.arr[24] = d.arr[24];
            this.datenDownload.arr[25] = d.arr[25];
            this.textfeldListe[24].setText(this.datenDownload.arr[24]);
            this.textfeldListe[25].setText(this.datenDownload.arr[25]);
        }
        this.datenDownload.setGroesse(size);
    }

    private void setExtra() {
        this.jPanelExtra.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < 38; ++i) {
            JLabel label;
            this.labelListe[i] = label = new JLabel("  " + DatenDownload.COLUMN_NAMES[i] + ": ");
            JTextField textfeld = new JTextField();
            textfeld.setEditable(false);
            textfeld.setText(this.datenDownload.arr[i]);
            this.textfeldListe[i] = textfeld;
            this.addExtraFeld(i, gridbag, c);
            c.gridy = ++zeile;
        }
        this.jPanelExtra.validate();
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c) {
        c.gridx = 0;
        c.weightx = 0.0;
        if (i == 32 || i == 20 || i == 7 || i == 6 || i == 37 || i == 10) {
            return;
        }
        if (!(this.datenDownload.art != 1 || i != 27 && i != 29 && i != 28 || this.gestartet)) {
            if (i == 27) {
                c.gridx = 1;
                c.weightx = 10.0;
                gridbag.setConstraints(this.mVPanelDownloadZiel, c);
                this.jPanelExtra.add(this.mVPanelDownloadZiel);
            }
        } else if (i == 26) {
            this.labelListe[i].setForeground(Color.BLUE);
            this.jCheckBoxRestart.setSelected(this.datenDownload.isRestart());
            this.jCheckBoxRestart.addActionListener(new BeobCheckbox());
            this.jCheckBoxRestart.setEnabled(!this.gestartet);
            gridbag.setConstraints(this.labelListe[i], c);
            this.jPanelExtra.add(this.labelListe[i]);
            c.gridx = 1;
            c.weightx = 10.0;
            gridbag.setConstraints(this.jCheckBoxRestart, c);
            this.jPanelExtra.add(this.jCheckBoxRestart);
            if (this.datenDownload.isDownloadManager()) {
                this.jCheckBoxRestart.setEnabled(false);
            }
        } else if (i == 36) {
            this.jCheckBoxDownloadmanager.setSelected(this.datenDownload.isDownloadManager());
            this.jCheckBoxDownloadmanager.setEnabled(false);
            gridbag.setConstraints(this.labelListe[i], c);
            this.jPanelExtra.add(this.labelListe[i]);
            c.gridx = 1;
            c.weightx = 10.0;
            gridbag.setConstraints(this.jCheckBoxDownloadmanager, c);
            this.jPanelExtra.add(this.jCheckBoxDownloadmanager);
        } else if (i == 15) {
            if (!this.datenDownload.isInterrupted()) {
                return;
            }
            this.labelListe[i].setForeground(Color.BLUE);
            this.jCheckBoxUnterbrochen.setSelected(this.datenDownload.isInterrupted());
            this.jCheckBoxUnterbrochen.addActionListener(new BeobCheckbox());
            this.jCheckBoxUnterbrochen.setEnabled(!this.gestartet);
            gridbag.setConstraints(this.labelListe[i], c);
            this.jPanelExtra.add(this.labelListe[i]);
            c.gridx = 1;
            c.weightx = 10.0;
            gridbag.setConstraints(this.jCheckBoxUnterbrochen, c);
            this.jPanelExtra.add(this.jCheckBoxUnterbrochen);
        } else if (i == 33) {
            this.labelListe[i].setForeground(Color.BLUE);
            this.jCheckBoxInfodatei.setSelected(Boolean.parseBoolean(this.datenDownload.arr[33]));
            this.jCheckBoxInfodatei.addActionListener(new BeobCheckbox());
            this.jCheckBoxInfodatei.setEnabled(!this.gestartet);
            gridbag.setConstraints(this.labelListe[i], c);
            this.jPanelExtra.add(this.labelListe[i]);
            c.gridx = 1;
            c.weightx = 10.0;
            gridbag.setConstraints(this.jCheckBoxInfodatei, c);
            this.jPanelExtra.add(this.jCheckBoxInfodatei);
        } else if (i == 35) {
            this.labelListe[i].setForeground(Color.BLUE);
            this.jCheckBoxSubtitle.setSelected(Boolean.parseBoolean(this.datenDownload.arr[35]));
            this.jCheckBoxSubtitle.addActionListener(new BeobCheckbox());
            this.jCheckBoxSubtitle.setEnabled(!this.gestartet);
            gridbag.setConstraints(this.labelListe[i], c);
            this.jPanelExtra.add(this.labelListe[i]);
            c.gridx = 1;
            c.weightx = 10.0;
            gridbag.setConstraints(this.jCheckBoxSubtitle, c);
            this.jPanelExtra.add(this.jCheckBoxSubtitle);
        } else if (i == 34) {
            this.labelListe[i].setForeground(Color.BLUE);
            this.jCheckBoxSpotlight.setSelected(Boolean.parseBoolean(this.datenDownload.arr[34]));
            this.jCheckBoxSpotlight.addActionListener(new BeobCheckbox());
            this.jCheckBoxSpotlight.setEnabled(!this.gestartet);
            gridbag.setConstraints(this.labelListe[i], c);
            this.jPanelExtra.add(this.labelListe[i]);
            c.gridx = 1;
            c.weightx = 10.0;
            gridbag.setConstraints(this.jCheckBoxSpotlight, c);
            this.jPanelExtra.add(this.jCheckBoxSpotlight);
        } else if (i != 24) {
            if (i == 25) {
                if (this.datenDownload.art == 2) {
                    if (this.datenDownload.arr[25].isEmpty()) {
                        this.labelListe[25].setForeground(Color.BLUE);
                        this.textfeldListe[24].setEditable(!this.gestartet);
                        this.textfeldListe[24].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(24));
                        gridbag.setConstraints(this.labelListe[25], c);
                        this.jPanelExtra.add(this.labelListe[25]);
                        c.gridx = 1;
                        c.weightx = 10.0;
                        gridbag.setConstraints(this.textfeldListe[24], c);
                        this.jPanelExtra.add(this.textfeldListe[24]);
                    } else {
                        this.labelListe[i].setForeground(Color.BLUE);
                        this.textfeldListe[i].setEditable(!this.gestartet);
                        this.textfeldListe[i].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
                        gridbag.setConstraints(this.labelListe[i], c);
                        this.jPanelExtra.add(this.labelListe[i]);
                        JPanel jp = new JPanel();
                        jp.setBorder(BorderFactory.createTitledBorder(""));
                        GridBagLayout gb = new GridBagLayout();
                        GridBagConstraints gc = new GridBagConstraints();
                        gc.fill = 2;
                        gc.insets = new Insets(2, 2, 2, 2);
                        jp.setLayout(gb);
                        JButton jButtonReset = new JButton("");
                        jButtonReset.setToolTipText("Reset");
                        jButtonReset.setIcon(GetIcon.getProgramIcon("view-refresh_16.png"));
                        jButtonReset.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DialogEditDownload.this.textfeldListe[25].setText(DialogEditDownload.this.orgProgArray);
                            }
                        });
                        JButton jButtonHelp = new JButton("");
                        jButtonHelp.setToolTipText("Hilfe");
                        jButtonHelp.setIcon(GetIcon.getProgramIcon("help_16.png"));
                        jButtonHelp.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                new DialogHilfe(DialogEditDownload.this.parent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_EDIT_DOWNLOAD_PROG)).setVisible(true);
                            }
                        });
                        gc.gridy = 0;
                        gc.gridx = 0;
                        gc.weightx = 1.0;
                        gb.setConstraints(jButtonHelp, gc);
                        jp.add(jButtonHelp);
                        gc.gridx = 1;
                        gc.weightx = 10.0;
                        gb.setConstraints(this.textfeldListe[24], gc);
                        jp.add(this.textfeldListe[24]);
                        gc.gridy = 1;
                        gc.gridx = 0;
                        gc.weightx = 1.0;
                        gb.setConstraints(jButtonReset, gc);
                        jp.add(jButtonReset);
                        gc.gridx = 1;
                        gc.weightx = 10.0;
                        gb.setConstraints(this.textfeldListe[i], gc);
                        jp.add(this.textfeldListe[i]);
                        c.gridx = 1;
                        c.weightx = 10.0;
                        gridbag.setConstraints(jp, c);
                        this.jPanelExtra.add(jp);
                    }
                }
            } else {
                if (i == 0) {
                    this.textfeldListe[i].setText(this.datenDownload.nr + "");
                } else if (i == 1) {
                    if (this.datenDownload.film != null) {
                        this.textfeldListe[i].setText(this.datenDownload.film.nr + "");
                    }
                } else if (i == 19) {
                    if (this.datenDownload.art == 1) {
                        this.labelListe[i].setForeground(Color.BLUE);
                        this.textfeldListe[i].setEditable(!this.gestartet);
                        this.textfeldListe[i].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
                    }
                } else if (i == 11) {
                    this.textfeldListe[i].setText(this.datenDownload.mVFilmSize.toString());
                } else if (i == 8) {
                    this.textfeldListe[i].setText(Start.getTextProgress(this.datenDownload));
                } else if (i == 9) {
                    this.textfeldListe[i].setText(this.datenDownload.getTextRestzeit());
                } else if (i == 30) {
                    switch (this.datenDownload.art) {
                        case 1: {
                            this.textfeldListe[i].setText("direkter Download");
                            break;
                        }
                        case 2: {
                            this.textfeldListe[i].setText("Programm");
                        }
                    }
                } else if (i == 31) {
                    switch (this.datenDownload.quelle) {
                        case -1: {
                            this.textfeldListe[i].setText("Alle");
                            break;
                        }
                        case 3: {
                            this.textfeldListe[i].setText("Abo");
                            break;
                        }
                        case 1: {
                            this.textfeldListe[i].setText("Button");
                            break;
                        }
                        case 2: {
                            this.textfeldListe[i].setText("Download");
                        }
                    }
                }
                gridbag.setConstraints(this.labelListe[i], c);
                this.jPanelExtra.add(this.labelListe[i]);
                c.gridx = 1;
                c.weightx = 10.0;
                gridbag.setConstraints(this.textfeldListe[i], c);
                this.jPanelExtra.add(this.textfeldListe[i]);
            }
        }
    }

    private boolean downloadDateiLoeschen(DatenDownload datenDownload) {
        try {
            File file = new File(datenDownload.arr[29]);
            if (!file.exists()) {
                return true;
            }
            int ret = JOptionPane.showConfirmDialog(this.parent, "Die Aufl\u00f6sung wurde ge\u00e4ndert, der Film kann nicht weitergef\u00fchrt werden.\nDatei muss zuerst gel\u00f6scht werden.", "Film L\u00f6schen?", 0);
            if (ret != 0) {
                return false;
            }
            Log.systemMeldung(new String[]{"Datei l\u00f6schen: ", file.getAbsolutePath()});
            if (!file.delete()) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.parent, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            Log.fehlerMeldung(812036789, "Fehler beim l\u00f6schen: " + datenDownload.arr[29]);
        }
        return true;
    }

    private boolean check() {
        this.mVPanelDownloadZiel.setPfadName_geaendert();
        this.ok = this.jRadioButtonResHd.isSelected() && !this.resolution.equals("hd") || this.jRadioButtonResLo.isSelected() && !this.resolution.equals("klein") || this.jRadioButtonResHi.isSelected() && !this.resolution.equals("normal") ? this.downloadDateiLoeschen(this.datenDownload) : true;
        return this.ok;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jPanelRes = new JPanel();
        this.jLabelRes = new JLabel();
        this.jRadioButtonResHd = new JRadioButton();
        this.jRadioButtonResHi = new JRadioButton();
        this.jRadioButtonResLo = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Download editieren");
        this.setMinimumSize(new Dimension(500, 0));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        this.jButtonOk.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jPanelRes.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabelRes.setText("Aufl\u00f6sung \u00e4ndern:");
        this.buttonGroup1.add(this.jRadioButtonResHd);
        this.jRadioButtonResHd.setText("HD");
        this.buttonGroup1.add(this.jRadioButtonResHi);
        this.jRadioButtonResHi.setText("hoher Aufl\u00f6sung");
        this.buttonGroup1.add(this.jRadioButtonResLo);
        this.jRadioButtonResLo.setText("niedriger Aufl\u00f6sung");
        GroupLayout jPanelResLayout = new GroupLayout(this.jPanelRes);
        this.jPanelRes.setLayout(jPanelResLayout);
        jPanelResLayout.setHorizontalGroup(jPanelResLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelRes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonResHd).addGap(18, 18, 18).addComponent(this.jRadioButtonResHi).addGap(18, 18, 18).addComponent(this.jRadioButtonResLo).addContainerGap(237, Short.MAX_VALUE)));
        jPanelResLayout.setVerticalGroup(jPanelResLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelResLayout.createSequentialGroup().addContainerGap().addGroup(jPanelResLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRes).addComponent(this.jRadioButtonResHd).addComponent(this.jRadioButtonResHi).addComponent(this.jRadioButtonResLo)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelRes, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 577, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelRes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonAbbrechen)).addContainerGap()));
        this.pack();
    }

    private class BeobCheckbox
    implements ActionListener {
        private BeobCheckbox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[26] = Boolean.toString(DialogEditDownload.this.jCheckBoxRestart.isSelected());
            ((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[15] = Boolean.toString(DialogEditDownload.this.jCheckBoxUnterbrochen.isSelected());
            ((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[33] = Boolean.toString(DialogEditDownload.this.jCheckBoxInfodatei.isSelected());
            ((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[35] = Boolean.toString(DialogEditDownload.this.jCheckBoxSubtitle.isSelected());
            ((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[34] = Boolean.toString(DialogEditDownload.this.jCheckBoxSpotlight.isSelected());
        }
    }

    private class BeobachterDocumentTextfeld
    implements DocumentListener {
        int nr;

        public BeobachterDocumentTextfeld(int n) {
            this.nr = n;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            ((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[this.nr] = DialogEditDownload.this.textfeldListe[this.nr].getText().trim();
            if (this.nr == 25) {
                ((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[24] = DatenProg.makeProgAufrufArray(((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[25]);
                DialogEditDownload.this.textfeldListe[24].setText(((DialogEditDownload)DialogEditDownload.this).datenDownload.arr[24]);
            }
        }
    }
}

