/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import mediathek.daten.Daten;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.EscBeenden;
import org.jdesktop.swingx.JXBusyLabel;

public class DialogBeenden
extends JDialog {
    private static final String CANCEL_AND_TERMINATE_PROGRAM = "Downloads abbrechen und Programm beenden";
    private static final String WAIT_FOR_DOWNLOADS_AND_TERMINATE = "Auf Abschlu\u00df aller Downloads warten, danach beenden";
    private static final String DONT_TERMINATE = "Programm nicht beenden";
    private final JFrame parent;
    private boolean applicationCanTerminate = false;
    private boolean shutdown = false;
    private JPanel glassPane = null;
    private SwingWorker<Void, Void> downloadMonitorWorker = null;
    private JButton btnCancel;
    private JButton btnContinue;
    private JCheckBox cbShutdownComputer;
    private JComboBox<String> comboActions;
    private JButton jButtonHilfe;

    public boolean applicationCanTerminate() {
        return this.applicationCanTerminate;
    }

    public DialogBeenden(JFrame pparent) {
        super((Frame)pparent, true);
        this.initComponents();
        this.parent = pparent;
        if (this.parent != null) {
            this.setLocationRelativeTo(this.parent);
        }
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogBeenden.this.escapeHandler();
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogBeenden.this.escapeHandler();
            }
        });
        this.jButtonHilfe.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(DialogBeenden.this.parent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_BEENDEN)).setVisible(true);
            }
        });
        this.jButtonHilfe.setEnabled(false);
        this.cbShutdownComputer.setEnabled(false);
        this.comboActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strSelectedItem;
                switch (strSelectedItem = (String)DialogBeenden.this.comboActions.getSelectedItem()) {
                    case "Auf Abschlu\u00df aller Downloads warten, danach beenden": {
                        DialogBeenden.this.jButtonHilfe.setEnabled(true);
                        DialogBeenden.this.cbShutdownComputer.setEnabled(true);
                        break;
                    }
                    default: {
                        DialogBeenden.this.jButtonHilfe.setEnabled(false);
                        DialogBeenden.this.cbShutdownComputer.setEnabled(false);
                        DialogBeenden.this.jButtonHilfe.setEnabled(false);
                        DialogBeenden.this.cbShutdownComputer.setSelected(false);
                        DialogBeenden.this.shutdown = false;
                    }
                }
            }
        });
        this.cbShutdownComputer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBeenden.this.shutdown = DialogBeenden.this.cbShutdownComputer.isSelected();
            }
        });
        this.btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strSelectedItem;
                switch (strSelectedItem = (String)DialogBeenden.this.comboActions.getSelectedItem()) {
                    case "Auf Abschlu\u00df aller Downloads warten, danach beenden": {
                        DialogBeenden.this.waitUntilDownloadsHaveFinished();
                        break;
                    }
                    case "Downloads abbrechen und Programm beenden": {
                        DialogBeenden.this.applicationCanTerminate = true;
                        DialogBeenden.this.dispose();
                        break;
                    }
                    case "Programm nicht beenden": {
                        DialogBeenden.this.applicationCanTerminate = false;
                        DialogBeenden.this.dispose();
                    }
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBeenden.this.escapeHandler();
            }
        });
        this.pack();
        this.getRootPane().setDefaultButton(this.btnContinue);
    }

    public boolean isShutdownRequested() {
        return this.shutdown;
    }

    public void setComboWaitAndTerminate() {
        this.comboActions.setSelectedItem(WAIT_FOR_DOWNLOADS_AND_TERMINATE);
        this.cbShutdownComputer.setSelected(true);
        this.shutdown = true;
    }

    private DefaultComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{CANCEL_AND_TERMINATE_PROGRAM, WAIT_FOR_DOWNLOADS_AND_TERMINATE, DONT_TERMINATE});
    }

    private void escapeHandler() {
        if (this.downloadMonitorWorker != null) {
            this.downloadMonitorWorker.cancel(true);
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
        this.applicationCanTerminate = false;
        this.dispose();
    }

    private JPanel createGlassPane() {
        String strMessage = "<html>Warte auf Abschluss der Downloads...";
        if (this.isShutdownRequested()) {
            strMessage = strMessage + "<br><b>Der Rechner wird danach heruntergefahren.</b>";
        }
        strMessage = strMessage + "<br>Sie k\u00f6nnen den Vorgang mit Escape abbrechen.</html>";
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        JXBusyLabel lbl = new JXBusyLabel();
        lbl.setText(strMessage);
        lbl.setBusy(true);
        lbl.setVerticalAlignment(0);
        lbl.setHorizontalAlignment(0);
        panel.add((Component)lbl, "Center");
        return panel;
    }

    private void waitUntilDownloadsHaveFinished() {
        this.glassPane = this.createGlassPane();
        this.setGlassPane(this.glassPane);
        this.glassPane.setVisible(true);
        this.downloadMonitorWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                while (Daten.listeDownloads.nochNichtFertigeDownloads() > 0 && !this.isCancelled()) {
                    Thread.sleep(1000L);
                }
                return null;
            }

            @Override
            protected void done() {
                DialogBeenden.this.applicationCanTerminate = true;
                DialogBeenden.this.glassPane.setVisible(false);
                DialogBeenden.this.dispose();
                DialogBeenden.this.downloadMonitorWorker = null;
            }
        };
        this.downloadMonitorWorker.execute();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.comboActions = new JComboBox();
        this.btnContinue = new JButton();
        this.cbShutdownComputer = new JCheckBox();
        this.btnCancel = new JButton();
        this.jButtonHilfe = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("MediathekView beenden");
        this.setResizable(false);
        jLabel1.setText("<html>Es sind noch nicht alle Downloads fertig.<br>Wie m\u00f6chten Sie fortfahren?</html>");
        this.comboActions.setModel(this.getComboBoxModel());
        this.btnContinue.setText("Weiter");
        this.cbShutdownComputer.setText("Rechner herunterfahren");
        this.btnCancel.setText("Zur\u00fcck");
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel1, -1, 504, Short.MAX_VALUE).addComponent(this.comboActions, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cbShutdownComputer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHilfe)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnContinue))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboActions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShutdownComputer).addComponent(this.jButtonHilfe)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnContinue).addComponent(this.btnCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }
}

