/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mediathek.controller.Log;
import mediathek.controller.MVUsedUrl;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenPset;
import mediathek.gui.MVStatusBar;
import mediathek.gui.PanelFilmBeschreibung;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogBeendenZeit;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.dialog.DialogEditDownload;
import mediathek.gui.dialog.MVFilmInfo;
import mediathek.res.GetIcon;
import mediathek.tool.BeobTableHeader;
import mediathek.tool.CellRendererDownloads;
import mediathek.tool.DirOpenAction;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVFilmSize;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MVTable;
import mediathek.tool.OpenPlayerAction;
import mediathek.tool.TModelDownload;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.tool.Datum;

public class GuiDownloads
extends PanelVorlage {
    private final MVFilmInfo filmInfoHud;
    private final PanelFilmBeschreibung panelBeschreibung;
    private long lastUpdate = 0L;
    private boolean showAbos = true;
    private boolean showDownloads = true;
    private static final String COMBO_DISPLAY_ALL = "alles";
    private static final String COMBO_DISPLAY_DOWNLOADS_ONLY = "nur Downloads";
    private static final String COMBO_DISPLAY_ABOS_ONLY = "nur Abos";
    private TModelDownload model;
    private JComboBox<String> cbDisplayCategories;
    private JLabel jLabel2;
    private JPanel jPanelBeschreibung;
    private JScrollPane jScrollPane1;

    public GuiDownloads(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        this.initComponents();
        if (SystemInfo.isWindows()) {
            InputMap im = this.cbDisplayCategories.getInputMap();
            im.put(KeyStroke.getKeyStroke(115, 0), "einstellungen");
            ActionMap am = this.cbDisplayCategories.getActionMap();
            am.put("einstellungen", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiDownloads.this.daten.mediathekGui.showDialogPreferences();
                }
            });
        }
        this.tabelle = new MVTable(1);
        this.jScrollPane1.setViewportView(this.tabelle);
        this.filmInfoHud = this.daten.filmInfo;
        this.panelBeschreibung = new PanelFilmBeschreibung(this.daten.mediathekGui, this.daten);
        this.jPanelBeschreibung.add((Component)this.panelBeschreibung, "Center");
        this.init();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
        this.addListenerMediathekView();
        this.cbDisplayCategories.setModel(this.getDisplaySelectionModel());
        this.cbDisplayCategories.addActionListener(new DisplayCategoryListener());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiDownloads.this.downloadsAktualisieren();
            }
        });
    }

    @Override
    public void isShown() {
        super.isShown();
        if (!this.solo) {
            this.daten.mediathekGui.setToolbar("Tab-Downloads");
            this.daten.mediathekGui.getStatusBar().setIndexForLeftDisplay(MVStatusBar.StatusbarIndex.DOWNLOAD);
        }
        this.aktFilmSetzen();
    }

    public void aktualisieren() {
        this.downloadsAktualisieren();
    }

    public void filmAbspielen() {
        this.filmAbspielen_();
    }

    public void guiFilmMediensammlung() {
        this.mediensammlung();
    }

    public void starten(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, true);
    }

    public void startAtTime() {
        this.filmStartAtTime();
    }

    public void stoppen(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, false);
    }

    public void wartendeStoppen() {
        this.wartendeDownloadsStoppen();
    }

    public void vorziehen() {
        this.downloadsVorziehen();
    }

    public void zurueckstellen() {
        this.downloadLoeschen(false);
    }

    public void loeschen() {
        this.downloadLoeschen(true);
    }

    public void aufraeumen() {
        this.downloadsAufraeumen();
    }

    public void aendern() {
        this.downloadAendern();
    }

    public void filmGesehen() {
        this.daten.history.setGesehen(true, this.getSelFilme());
    }

    public void filmUngesehen() {
        this.daten.history.setGesehen(false, this.getSelFilme());
    }

    private void init() {
        ActionMap am = this.tabelle.getActionMap();
        InputMap im = this.tabelle.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), "aendern");
        am.put("aendern", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDownloads.this.downloadAendern();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "tabelle");
        this.getActionMap().put("tabelle", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDownloads.this.tabelle.requestFocusSelelct(GuiDownloads.this.jScrollPane1);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "download");
        this.getActionMap().put("download", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDownloads.this.filmStartenWiederholenStoppen(false, true);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "info");
        this.getActionMap().put("info", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiDownloads.this.filmInfoHud.isVisible()) {
                    GuiDownloads.this.filmInfoHud.showInfo();
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "url-copy");
        this.getActionMap().put("url-copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = GuiDownloads.this.tabelle.getSelectedRow();
                if (row >= 0) {
                    GuiFunktionen.copyToClipboard(GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 19).toString());
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "mediensammlung");
        this.getActionMap().put("mediensammlung", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = GuiDownloads.this.tabelle.getSelectedRow();
                if (row >= 0) {
                    Daten.mVConfig.add("Media_DB_Dialog-anzeigen", Boolean.TRUE.toString());
                    GuiDownloads.this.daten.dialogMediaDB.setVis();
                    DatenDownload datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 37);
                    if (datenDownload != null) {
                        GuiDownloads.this.daten.dialogMediaDB.setFilter(datenDownload.arr[5]);
                    }
                }
            }
        });
        this.panelBeschreibungSetzen();
        CellRendererDownloads cellRenderer = new CellRendererDownloads();
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Datum.class, cellRenderer);
        this.tabelle.setDefaultRenderer(MVFilmSize.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
        this.model = new TModelDownload(new Object[0][], DatenDownload.COLUMN_NAMES);
        this.tabelle.setModel(this.model);
        this.tabelle.addMouseListener(new BeobMausTabelle());
        this.tabelle.getSelectionModel().addListSelectionListener(new BeobachterTableSelect());
        this.tabelle.getTableHeader().addMouseListener(new BeobTableHeader(this.tabelle, DatenDownload.COLUMN_NAMES, DatenDownload.spaltenAnzeigen, new int[]{6, 7, 37}, new int[]{6, 7}, true));
        Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden(){

            public void fertig(MSListenerFilmeLadenEvent event) {
                Daten.listeDownloads.filmEintragen();
                if (Boolean.parseBoolean(Daten.mVConfig.get("Abos-sofort-suchen"))) {
                    GuiDownloads.this.downloadsAktualisieren();
                } else {
                    GuiDownloads.this.reloadTable();
                }
            }
        });
    }

    private void addListenerMediathekView() {
        ListenerMediathekView.addListener(new ListenerMediathekView(39, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                if (Boolean.parseBoolean(Daten.mVConfig.get("Abos-sofort-suchen")) && Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-auch-Abo"))) {
                    GuiDownloads.this.downloadsAktualisieren();
                }
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(new int[]{27, 10}, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                if (Boolean.parseBoolean(Daten.mVConfig.get("Abos-sofort-suchen"))) {
                    GuiDownloads.this.downloadsAktualisieren();
                }
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(new int[]{9, 29, 33}, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiDownloads.this.reloadTable();
                GuiDownloads.this.daten.allesSpeichern();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(new int[]{14}, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                Daten.listeDownloads.setModelProgressAlleStart(GuiDownloads.this.model);
                GuiDownloads.this.tabelle.fireTableDataChanged(true);
                GuiDownloads.this.setInfo();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(31, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiDownloads.this.tabelle.fireTableDataChanged(true);
                GuiDownloads.this.setInfo();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(new int[]{13}, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                if (GuiDownloads.this.lastUpdate < new Date().getTime() - 500L) {
                    GuiDownloads.this.lastUpdate = new Date().getTime();
                    Daten.listeDownloads.setModelProgress(GuiDownloads.this.model);
                }
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(25, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiDownloads.this.panelBeschreibungSetzen();
            }
        });
    }

    private void panelBeschreibungSetzen() {
        this.jPanelBeschreibung.setVisible(Boolean.parseBoolean(Daten.mVConfig.get("system-panel-beschreibung-anzeigen")));
    }

    private synchronized void reloadTable() {
        this.stopBeob = true;
        this.tabelle.getSpalten();
        Daten.listeDownloads.getModel(this.model, this.showAbos, this.showDownloads);
        this.tabelle.setSpalten();
        this.stopBeob = false;
        this.aktFilmSetzen();
        this.setInfo();
    }

    private void mediensammlung() {
        DatenDownload datenDownload = this.getSelDownload();
        Daten.mVConfig.add("Media_DB_Dialog-anzeigen", Boolean.TRUE.toString());
        this.daten.dialogMediaDB.setVis();
        if (datenDownload != null) {
            this.daten.dialogMediaDB.setFilter(datenDownload.arr[5]);
        }
    }

    private synchronized void downloadsAktualisieren() {
        Daten.listeDownloads.abosPutzen();
        Daten.listeDownloads.zurueckgestellteWiederAktivieren();
        Daten.listeDownloads.abosSuchen(this.parentComponent);
        this.reloadTable();
        if (Boolean.parseBoolean(Daten.mVConfig.get("Download-sofort-starten"))) {
            this.filmStartenWiederholenStoppen(true, true, false);
        }
    }

    private synchronized void downloadsAufraeumen() {
        Daten.listeDownloads.listePutzen();
    }

    private synchronized void downloadsAufraeumen(DatenDownload datenDownload) {
        Daten.listeDownloads.listePutzen(datenDownload);
    }

    private ArrayList<DatenDownload> getSelDownloads() {
        ArrayList<DatenDownload> arrayDownloads = new ArrayList<DatenDownload>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 37);
                arrayDownloads.add(datenDownload);
            }
        } else {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        }
        return arrayDownloads;
    }

    private DatenDownload getSelDownload() {
        DatenDownload datenDownload = null;
        int row = this.tabelle.getSelectedRow();
        if (row >= 0) {
            datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 37);
        } else {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        }
        return datenDownload;
    }

    private synchronized void downloadAendern() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        boolean gestartet = false;
        if (datenDownload.start != null && datenDownload.start.status >= 2) {
            gestartet = true;
        }
        DatenDownload datenDownloadKopy = datenDownload.getCopy();
        DialogEditDownload dialog = new DialogEditDownload(this.parentComponent, true, datenDownloadKopy, gestartet);
        dialog.setVisible(true);
        if (dialog.ok) {
            datenDownload.aufMichKopieren(datenDownloadKopy);
            this.reloadTable();
        }
    }

    private void downloadsVorziehen() {
        ArrayList<DatenDownload> arrayDownloads = this.getSelDownloads();
        if (arrayDownloads.isEmpty()) {
            return;
        }
        Daten.listeDownloads.downloadsVorziehen(arrayDownloads);
    }

    private void zielordnerOeffnen() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        String s = datenDownload.arr[28];
        DirOpenAction.zielordnerOeffnen(this.parentComponent, s);
    }

    private void filmAbspielen_() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        String s = datenDownload.arr[29];
        OpenPlayerAction.filmAbspielen(this.parentComponent, s);
    }

    private void filmLoeschen_() {
        DatenDownload datenDownload = this.getSelDownload();
        if (datenDownload == null) {
            return;
        }
        if (datenDownload.start != null && datenDownload.start.status < 3) {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Download erst stoppen!", "Film l\u00f6schen", 0);
            return;
        }
        try {
            File file = new File(datenDownload.arr[29]);
            if (!file.exists()) {
                MVMessageDialog.showMessageDialog(this.parentComponent, "Die Datei existiert nicht!", "Film l\u00f6schen", 0);
                return;
            }
            int ret = JOptionPane.showConfirmDialog(this.parentComponent, datenDownload.arr[29], "Film L\u00f6schen?", 0);
            if (ret == 0) {
                Log.systemMeldung(new String[]{"Datei l\u00f6schen: ", file.getAbsolutePath()});
                if (!file.delete()) {
                    throw new Exception();
                }
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            Log.fehlerMeldung(915236547, "Fehler beim l\u00f6schen: " + datenDownload.arr[29]);
        }
    }

    private void downloadLoeschen(boolean dauerhaft) {
        ArrayList<DatenDownload> arrayDownloads = this.getSelDownloads();
        if (arrayDownloads.isEmpty()) {
            return;
        }
        int[] rows = this.tabelle.getSelectedRows();
        String zeit = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
        ArrayList<DatenDownload> arrayDownloadsLoeschen = new ArrayList<DatenDownload>();
        LinkedList<MVUsedUrl> urlAboList = new LinkedList<MVUsedUrl>();
        for (DatenDownload datenDownload : arrayDownloads) {
            if (dauerhaft) {
                arrayDownloadsLoeschen.add(datenDownload);
                if (!datenDownload.istAbo()) continue;
                urlAboList.add(new MVUsedUrl(zeit, datenDownload.arr[4], datenDownload.arr[5], datenDownload.arr[18]));
                continue;
            }
            datenDownload.zurueckstellen();
        }
        if (!urlAboList.isEmpty()) {
            this.daten.erledigteAbos.zeilenSchreiben(urlAboList);
        }
        Daten.listeDownloads.downloadLoeschen(arrayDownloadsLoeschen);
        this.reloadTable();
        this.tabelle.setSelRow(rows[0]);
    }

    private void filmStartAtTime() {
        ArrayList<DatenDownload> listeAllDownloads = new ArrayList<DatenDownload>();
        ArrayList<DatenDownload> listeUrlsDownloadsAbbrechen = new ArrayList<DatenDownload>();
        ArrayList<DatenDownload> listeDownloadsStarten = new ArrayList<DatenDownload>();
        if (this.tabelle.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < this.tabelle.getRowCount(); ++i) {
            DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(i), 37);
            listeAllDownloads.add(datenDownload);
            Daten.listeDownloads.remove(datenDownload);
            Daten.listeDownloads.add(datenDownload);
        }
        for (DatenDownload download : listeAllDownloads) {
            if (download.start != null) {
                if (download.start.status == 2) continue;
                if (download.start.status > 2) {
                    int a = JOptionPane.showConfirmDialog(this.parentComponent, "Film nochmal starten?  ==> " + download.arr[5], "Fertiger Download", 0);
                    if (a != 0) continue;
                    listeUrlsDownloadsAbbrechen.add(download);
                    if (download.istAbo()) {
                        this.daten.erledigteAbos.urlAusLogfileLoeschen(download.arr[18]);
                    }
                }
            }
            listeDownloadsStarten.add(download);
        }
        Daten.listeDownloads.downloadAbbrechen(listeUrlsDownloadsAbbrechen);
        DialogBeendenZeit dialogBeenden = new DialogBeendenZeit(this.daten.mediathekGui, this.daten, listeDownloadsStarten);
        dialogBeenden.setVisible(true);
        if (dialogBeenden.applicationCanTerminate()) {
            this.daten.mediathekGui.beenden(false, dialogBeenden.isShutdownRequested());
        }
        this.reloadTable();
    }

    private void filmStartenWiederholenStoppen(boolean alle, boolean starten) {
        this.filmStartenWiederholenStoppen(alle, starten, true);
    }

    private void filmStartenWiederholenStoppen(boolean alle, boolean starten, boolean fertige) {
        DatenDownload datenDownload;
        int i;
        ArrayList<DatenDownload> listeDownloadsLoeschen = new ArrayList<DatenDownload>();
        ArrayList<DatenDownload> listeDownloadsStarten = new ArrayList<DatenDownload>();
        ArrayList<Object> listeDownloadsMarkiert = new ArrayList();
        if (this.tabelle.getRowCount() == 0) {
            return;
        }
        if (starten && alle) {
            for (i = 0; i < this.tabelle.getRowCount(); ++i) {
                datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(i), 37);
                Daten.listeDownloads.remove(datenDownload);
                Daten.listeDownloads.add(datenDownload);
            }
        }
        if (alle) {
            for (i = 0; i < this.tabelle.getRowCount(); ++i) {
                datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(i), 37);
                listeDownloadsMarkiert.add(datenDownload);
            }
        } else {
            listeDownloadsMarkiert = this.getSelDownloads();
        }
        if (!starten) {
            this.daten.starterClass.pause();
        }
        int antwort = -1;
        for (DatenDownload datenDownload2 : listeDownloadsMarkiert) {
            if (starten) {
                if (datenDownload2.start != null) {
                    if (datenDownload2.start.status == 2 || !fertige && datenDownload2.start.status > 2) continue;
                    if (datenDownload2.start.status > 2) {
                        if (antwort == -1) {
                            String text = listeDownloadsMarkiert.size() > 1 ? "Es sind bereits fertige Filme dabei,\ndiese nochmal starten?" : "Film nochmal starten?  ==> " + datenDownload2.arr[5];
                            antwort = JOptionPane.showConfirmDialog(this.parentComponent, text, "Fertiger Download", 0);
                        }
                        if (antwort != 0) continue;
                        listeDownloadsLoeschen.add(datenDownload2);
                        if (datenDownload2.istAbo()) {
                            this.daten.erledigteAbos.urlAusLogfileLoeschen(datenDownload2.arr[18]);
                        }
                    }
                }
                listeDownloadsStarten.add(datenDownload2);
                continue;
            }
            if (datenDownload2.start == null || datenDownload2.start.status > 2) continue;
            listeDownloadsLoeschen.add(datenDownload2);
        }
        Daten.listeDownloads.downloadAbbrechen(listeDownloadsLoeschen);
        if (starten) {
            DatenDownload.startenDownloads(this.daten, listeDownloadsStarten);
        }
        this.reloadTable();
    }

    private void wartendeDownloadsStoppen() {
        ArrayList<DatenDownload> listeStopDownload = new ArrayList<DatenDownload>();
        for (int i = 0; i < this.tabelle.getRowCount(); ++i) {
            DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(i), 37);
            if (datenDownload.start == null || datenDownload.start.status >= 2) continue;
            listeStopDownload.add(datenDownload);
        }
        Daten.listeDownloads.downloadAbbrechen(listeStopDownload);
    }

    private void setInfo() {
        this.daten.mediathekGui.getStatusBar().setTextForLeftDisplay();
    }

    private DefaultComboBoxModel<String> getDisplaySelectionModel() {
        return new DefaultComboBoxModel<String>(new String[]{COMBO_DISPLAY_ALL, COMBO_DISPLAY_DOWNLOADS_ONLY, COMBO_DISPLAY_ABOS_ONLY});
    }

    private void aktFilmSetzen() {
        if (this.isShowing()) {
            DatenDownload datenDownload;
            DatenFilm aktFilm = null;
            int selectedTableRow = this.tabelle.getSelectedRow();
            if (selectedTableRow >= 0 && (datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(selectedTableRow), 37)) != null) {
                aktFilm = datenDownload.film;
            }
            this.filmInfoHud.updateCurrentFilm(aktFilm);
            this.panelBeschreibung.setAktFilm(aktFilm);
        }
    }

    private ArrayList<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenDownload datenDownload = (DatenDownload)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 37);
                if (datenDownload.film == null) continue;
                arrayFilme.add(datenDownload.film);
            }
        } else {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        }
        return arrayFilme;
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        JTable jTable1 = new JTable();
        JPanel jPanelFilter = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.cbDisplayCategories = new JComboBox();
        this.jPanelBeschreibung = new JPanel();
        this.jLabel2.setText("jLabel2");
        this.setLayout(new BorderLayout());
        jTable1.setAutoCreateRowSorter(true);
        jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(jTable1);
        this.add((Component)this.jScrollPane1, "Center");
        FlowLayout flowLayout1 = new FlowLayout(0);
        flowLayout1.setAlignOnBaseline(true);
        jPanelFilter.setLayout(flowLayout1);
        jLabel1.setText("Anzeigen:");
        jPanelFilter.add(jLabel1);
        jPanelFilter.add(this.cbDisplayCategories);
        this.add((Component)jPanelFilter, "First");
        this.jPanelBeschreibung.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanelBeschreibung.setLayout(new BorderLayout());
        this.add((Component)this.jPanelBeschreibung, "Last");
    }

    private class DisplayCategoryListener
    implements ActionListener {
        private DisplayCategoryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action;
            JComboBox box = (JComboBox)e.getSource();
            switch (action = (String)box.getSelectedItem()) {
                case "alles": {
                    GuiDownloads.this.showAbos = true;
                    GuiDownloads.this.showDownloads = true;
                    break;
                }
                case "nur Downloads": {
                    GuiDownloads.this.showAbos = false;
                    GuiDownloads.this.showDownloads = true;
                    break;
                }
                case "nur Abos": {
                    GuiDownloads.this.showAbos = true;
                    GuiDownloads.this.showDownloads = false;
                }
            }
            GuiDownloads.this.reloadTable();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private Point p;
        DatenDownload datenDownload = null;

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = GuiDownloads.this.tabelle.rowAtPoint(this.p);
                    int column = GuiDownloads.this.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1) {
                    GuiDownloads.this.downloadAendern();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            this.p = arg0.getPoint();
            int row = GuiDownloads.this.tabelle.rowAtPoint(this.p);
            if (row >= 0) {
                this.datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 37);
            }
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            this.p = arg0.getPoint();
            int row = GuiDownloads.this.tabelle.rowAtPoint(this.p);
            if (row >= 0) {
                this.datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 37);
            }
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                this.datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 37);
                if (GuiDownloads.this.tabelle.convertColumnIndexToModel(column) == 6) {
                    if (this.datenDownload.start != null && !this.datenDownload.isDownloadManager()) {
                        if (this.datenDownload.start.status == 3) {
                            GuiDownloads.this.filmAbspielen_();
                        } else if (this.datenDownload.start.status == 4) {
                            GuiDownloads.this.filmStartenWiederholenStoppen(false, true);
                        } else {
                            GuiDownloads.this.filmStartenWiederholenStoppen(false, false);
                        }
                    } else {
                        GuiDownloads.this.filmStartenWiederholenStoppen(false, true);
                    }
                } else if (GuiDownloads.this.tabelle.convertColumnIndexToModel(column) == 7) {
                    if (this.datenDownload.start != null) {
                        if (this.datenDownload.start.status >= 3) {
                            GuiDownloads.this.downloadsAufraeumen(this.datenDownload);
                        } else {
                            GuiDownloads.this.downloadLoeschen(true);
                        }
                    } else {
                        GuiDownloads.this.downloadLoeschen(true);
                    }
                }
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiDownloads.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiDownloads.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            int row = GuiDownloads.this.tabelle.getSelectedRow();
            boolean wartenOderLaufen = false;
            if (row >= 0) {
                DatenDownload download = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(row), 37);
                if (download.start != null && download.start.status <= 2) {
                    wartenOderLaufen = true;
                }
            }
            JMenuItem itemStarten = new JMenuItem("Download starten");
            itemStarten.setIcon(GetIcon.getProgramIcon("download_start_16.png"));
            itemStarten.setEnabled(!wartenOderLaufen);
            jPopupMenu.add(itemStarten);
            itemStarten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(false, true);
                }
            });
            JMenuItem itemStoppen = new JMenuItem("Download stoppen");
            itemStoppen.setIcon(GetIcon.getProgramIcon("download_stop_16.png"));
            itemStoppen.setEnabled(wartenOderLaufen);
            jPopupMenu.add(itemStoppen);
            itemStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(false, false);
                }
            });
            jPopupMenu.addSeparator();
            JMenuItem itemVorziehen = new JMenuItem("Download vorziehen");
            itemVorziehen.setIcon(GetIcon.getProgramIcon("move_up_16.png"));
            jPopupMenu.add(itemVorziehen);
            itemVorziehen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadsVorziehen();
                }
            });
            JMenuItem itemLoeschen = new JMenuItem("Download zur\u00fcckstellen");
            itemLoeschen.setIcon(GetIcon.getProgramIcon("undo_16.png"));
            jPopupMenu.add(itemLoeschen);
            itemLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadLoeschen(false);
                }
            });
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download aus Liste entfernen");
            itemDauerhaftLoeschen.setIcon(GetIcon.getProgramIcon("download_del_16.png"));
            jPopupMenu.add(itemDauerhaftLoeschen);
            itemDauerhaftLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadLoeschen(true);
                }
            });
            JMenuItem itemAendern = new JMenuItem("Download \u00e4ndern");
            itemAendern.setIcon(GetIcon.getProgramIcon("configure_16.png"));
            jPopupMenu.add(itemAendern);
            itemAendern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadAendern();
                }
            });
            jPopupMenu.addSeparator();
            JMenuItem itemAlleStarten = new JMenuItem("alle Downloads starten");
            itemAlleStarten.setIcon(GetIcon.getProgramIcon("download_alleStarten_16.png"));
            jPopupMenu.add(itemAlleStarten);
            itemAlleStarten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(true, true);
                }
            });
            JMenuItem itemAlleStoppen = new JMenuItem("alle Downloads stoppen");
            itemAlleStoppen.setIcon(GetIcon.getProgramIcon("download_stop_16.png"));
            jPopupMenu.add(itemAlleStoppen);
            itemAlleStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(true, false);
                }
            });
            JMenuItem itemWartendeStoppen = new JMenuItem("wartende Downloads stoppen");
            itemWartendeStoppen.setIcon(GetIcon.getProgramIcon("download_stop_16.png"));
            jPopupMenu.add(itemWartendeStoppen);
            itemWartendeStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.wartendeDownloadsStoppen();
                }
            });
            JMenuItem itemAktualisieren = new JMenuItem("Liste der Downloads aktualisieren");
            itemAktualisieren.setIcon(GetIcon.getProgramIcon("view-refresh_16.png"));
            jPopupMenu.add(itemAktualisieren);
            itemAktualisieren.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadsAktualisieren();
                }
            });
            JMenuItem itemAufraeumen = new JMenuItem("Liste der Downloads aufr\u00e4umen");
            itemAufraeumen.setIcon(GetIcon.getProgramIcon("download_clear_16.png"));
            jPopupMenu.add(itemAufraeumen);
            itemAufraeumen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadsAufraeumen();
                }
            });
            jPopupMenu.addSeparator();
            JMenuItem itemPlayerDownload = new JMenuItem("gespeicherten Film (Datei) abspielen");
            itemPlayerDownload.setIcon(GetIcon.getProgramIcon("film_start_16.png"));
            itemPlayerDownload.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiDownloads.this.filmAbspielen_();
                }
            });
            jPopupMenu.add(itemPlayerDownload);
            JMenuItem itemDeleteDownload = new JMenuItem("gespeicherten Film (Datei) l\u00f6schen");
            itemDeleteDownload.setIcon(GetIcon.getProgramIcon("film_del_16.png"));
            itemDeleteDownload.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiDownloads.this.filmLoeschen_();
                }
            });
            jPopupMenu.add(itemDeleteDownload);
            JMenuItem itemOeffnen = new JMenuItem("Zielordner \u00f6ffnen");
            itemOeffnen.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
            jPopupMenu.add(itemOeffnen);
            itemOeffnen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.zielordnerOeffnen();
                }
            });
            jPopupMenu.addSeparator();
            JMenu submenueAbo = new JMenu("Abo");
            JMenuItem itemChangeAbo = new JMenuItem("Abo \u00e4ndern");
            JMenuItem itemDelAbo = new JMenuItem("Abo l\u00f6schen");
            if (this.datenDownload == null) {
                submenueAbo.setEnabled(false);
                itemChangeAbo.setEnabled(false);
                itemDelAbo.setEnabled(false);
            } else if (this.datenDownload.film == null) {
                submenueAbo.setEnabled(false);
                itemChangeAbo.setEnabled(false);
                itemDelAbo.setEnabled(false);
            } else {
                final DatenAbo datenAbo = Daten.listeAbo.getAboFuerFilm_schnell(this.datenDownload.film, false);
                if (datenAbo == null) {
                    submenueAbo.setEnabled(false);
                    itemChangeAbo.setEnabled(false);
                    itemDelAbo.setEnabled(false);
                } else {
                    itemDelAbo.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Daten.listeAbo.aboLoeschen(datenAbo);
                        }
                    });
                    itemChangeAbo.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GuiDownloads.this.stopBeob = true;
                            DialogEditAbo dialog = new DialogEditAbo(GuiDownloads.this.daten.mediathekGui, true, GuiDownloads.this.daten, datenAbo);
                            dialog.setVisible(true);
                            if (dialog.ok) {
                                Daten.listeAbo.aenderungMelden();
                            }
                            GuiDownloads.this.stopBeob = false;
                        }
                    });
                }
            }
            submenueAbo.add(itemDelAbo);
            submenueAbo.add(itemChangeAbo);
            jPopupMenu.add(submenueAbo);
            jPopupMenu.addSeparator();
            JMenuItem itemDb = new JMenuItem("Titel in der Mediensammlung suchen");
            itemDb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiDownloads.this.mediensammlung();
                }
            });
            jPopupMenu.add(itemDb);
            JMenuItem itemPlayer = new JMenuItem("Film (URL) abspielen");
            itemPlayer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nr = GuiDownloads.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        DatenPset gruppe = Daten.listePset.getPsetAbspielen();
                        if (gruppe != null) {
                            DatenDownload datenDownload = (DatenDownload)GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(nr), 37);
                            if (datenDownload != null && datenDownload.film != null) {
                                DatenFilm filmDownload = datenDownload.film.getCopy();
                                filmDownload.arr[12] = datenDownload.arr[19];
                                filmDownload.arr[16] = datenDownload.arr[20];
                                filmDownload.arr[18] = "";
                                filmDownload.arr[19] = "";
                                GuiDownloads.this.daten.starterClass.urlMitProgrammStarten(gruppe, filmDownload, "");
                            }
                        } else {
                            String menuPath = SystemInfo.isMacOSX() ? "MediathekView->Einstellungen\u2026->Aufzeichnen und Abspielen->Set bearbeiten" : "Datei->Einstellungen->Set bearbeiten";
                            MVMessageDialog.showMessageDialog(GuiDownloads.this.parentComponent, "Bitte legen Sie im Men\u00fc \"" + menuPath + "\" ein Programm zum Abspielen fest.", "Kein Videoplayer!", 1);
                        }
                    }
                }
            });
            jPopupMenu.add(itemPlayer);
            JMenuItem itemUrl = new JMenuItem("URL kopieren");
            KeyStroke ctrlU = KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            itemUrl.setAccelerator(ctrlU);
            itemUrl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nr = GuiDownloads.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFunktionen.copyToClipboard(GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(nr), 19).toString());
                    }
                }
            });
            jPopupMenu.add(itemUrl);
            JMenuItem itemInfo = new JMenuItem("Filminformation anzeigen");
            itemInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!GuiDownloads.this.filmInfoHud.isVisible()) {
                        GuiDownloads.this.filmInfoHud.showInfo();
                    }
                }
            });
            jPopupMenu.add(itemInfo);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobachterTableSelect
    implements ListSelectionListener {
        private BeobachterTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                GuiDownloads.this.aktFilmSetzen();
            }
        }
    }
}

