/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.gui.MVStatusBar;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.res.GetIcon;
import mediathek.tool.BeobTableHeader;
import mediathek.tool.CellRendererAbo;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVTable;
import mediathek.tool.TModelAbo;
import msearch.tool.Datum;

public class GuiAbo
extends PanelVorlage {
    private JScrollPane jScrollPane1;

    public GuiAbo(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        this.initComponents();
        this.tabelle = new MVTable(2);
        this.jScrollPane1.setViewportView(this.tabelle);
        this.initBeobachter();
        this.tabelleLaden();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void isShown() {
        super.isShown();
        if (!this.solo) {
            this.daten.mediathekGui.setToolbar("Tab-Abos");
            this.daten.mediathekGui.getStatusBar().setIndexForLeftDisplay(MVStatusBar.StatusbarIndex.ABO);
        }
    }

    public void aendern() {
        this.aboAendern();
    }

    public void einAus(boolean ein) {
        this.aboEinAus(ein);
    }

    public void loeschen() {
        this.aboLoeschen();
    }

    public void neu() {
        this.aboNeu();
    }

    private void initBeobachter() {
        ListenerMediathekView.addListener(new ListenerMediathekView(10, GuiAbo.class.getSimpleName()){

            @Override
            public void ping() {
                GuiAbo.this.tabelleLaden();
            }
        });
        this.tabelle.addMouseListener(new BeobMausTabelle1());
        this.tabelle.setDefaultRenderer(Object.class, new CellRendererAbo());
        this.tabelle.setDefaultRenderer(Datum.class, new CellRendererAbo());
        this.tabelle.setDefaultRenderer(Integer.class, new CellRendererAbo());
        this.tabelle.setModel(new TModelAbo(new Object[0][], DatenAbo.COLUMN_NAMES));
        this.tabelle.getTableHeader().addMouseListener(new BeobTableHeader(this.tabelle, DatenAbo.COLUMN_NAMES, DatenAbo.spaltenAnzeigen, new int[]{1}, new int[0], true));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "tabelle");
        this.getActionMap().put("tabelle", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiAbo.this.tabelle.requestFocusSelelct(GuiAbo.this.jScrollPane1);
            }
        });
        ActionMap am = this.tabelle.getActionMap();
        InputMap im = this.tabelle.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), "aendern");
        am.put("aendern", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiAbo.this.aendern();
            }
        });
    }

    private void tabelleLaden() {
        this.tabelle.getSpalten();
        Daten.listeAbo.addObjectData((TModelAbo)this.tabelle.getModel());
        this.tabelle.setSpalten();
        this.setInfo();
    }

    private void aboLoeschen() {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            String text;
            if (rows.length == 1) {
                int delRow = this.tabelle.convertRowIndexToModel(rows[0]);
                text = "\"" + this.tabelle.getModel().getValueAt(delRow, 2).toString() + "\" l\u00f6schen?";
            } else {
                text = rows.length + " Abos l\u00f6schen?";
            }
            int ret = JOptionPane.showConfirmDialog(this.parentComponent, text, "L\u00f6schen?", 0);
            if (ret == 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    int delRow = this.tabelle.convertRowIndexToModel(rows[i]);
                    ((TModelAbo)this.tabelle.getModel()).removeRow(delRow);
                    Daten.listeAbo.remove(delRow);
                }
            }
            this.tabelleLaden();
            this.zeileMarkieren(0);
            Daten.listeAbo.aenderungMelden();
        } else {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        }
    }

    private void zeileMarkieren(int row) {
        if (this.tabelle.getRowCount() > 0 && this.tabelle.getSelectedRow() == -1) {
            this.tabelle.requestFocus();
            this.tabelle.setRowSelectionInterval(row, row);
        }
    }

    private void aboAendern() {
        int row = this.tabelle.getSelectedRow();
        if (row >= 0) {
            int modelRow = this.tabelle.convertRowIndexToModel(row);
            DatenAbo akt = Daten.listeAbo.getAboNr(modelRow);
            DialogEditAbo dialog = new DialogEditAbo(this.daten.mediathekGui, true, this.daten, akt);
            dialog.setVisible(true);
            if (dialog.ok) {
                this.tabelleLaden();
                Daten.listeAbo.aenderungMelden();
            }
            this.setInfo();
        } else {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        }
    }

    private void aboNeu() {
        Daten.listeAbo.addAbo("Neu");
    }

    private void aboEinAus(boolean ein) {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                int modelRow = this.tabelle.convertRowIndexToModel(row);
                DatenAbo akt = Daten.listeAbo.getAboNr(modelRow);
                akt.arr[1] = String.valueOf(ein);
            }
            this.tabelleLaden();
            this.tabelle.clearSelection();
            this.tabelle.requestFocus();
            for (int row : rows) {
                this.tabelle.addRowSelectionInterval(row, row);
            }
            this.setInfo();
            Daten.listeAbo.aenderungMelden();
        } else {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        }
    }

    private void setInfo() {
        this.daten.mediathekGui.getStatusBar().setTextForLeftDisplay();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        JTable jTable1 = new JTable();
        jTable1.setAutoCreateRowSorter(true);
        jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 602, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 271, Short.MAX_VALUE));
    }

    private class BeobMausTabelle1
    extends MouseAdapter {
        private Point p;

        private BeobMausTabelle1() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = GuiAbo.this.tabelle.rowAtPoint(this.p);
                    int column = GuiAbo.this.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1) {
                    GuiAbo.this.aboAendern();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1 && GuiAbo.this.tabelle.convertColumnIndexToModel(column) == 1) {
                DatenAbo akt = Daten.listeAbo.getAboNr(GuiAbo.this.tabelle.convertRowIndexToModel(row));
                akt.arr[1] = Boolean.toString(!Boolean.parseBoolean(akt.arr[1]));
                GuiAbo.this.tabelle.getSpalten();
                GuiAbo.this.tabelleLaden();
                GuiAbo.this.tabelle.setSpalten();
                GuiAbo.this.setInfo();
                Daten.listeAbo.aenderungMelden();
            }
        }

        private void showMenu(MouseEvent evt) {
            boolean ein = true;
            this.p = evt.getPoint();
            int nr = GuiAbo.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiAbo.this.tabelle.setRowSelectionInterval(nr, nr);
                int modelRow = GuiAbo.this.tabelle.convertRowIndexToModel(nr);
                DatenAbo akt = Daten.listeAbo.getAboNr(modelRow);
                ein = Boolean.parseBoolean(akt.arr[1]);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem itemEinschalten = new JMenuItem("Abo einschalten");
            itemEinschalten.setIcon(GetIcon.getProgramIcon("ja_16.png"));
            itemEinschalten.setEnabled(!ein);
            itemEinschalten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboEinAus(true);
                }
            });
            jPopupMenu.add(itemEinschalten);
            JMenuItem itemDeaktivieren = new JMenuItem("Abo ausschalten");
            itemDeaktivieren.setIcon(GetIcon.getProgramIcon("nein_16.png"));
            itemDeaktivieren.setEnabled(ein);
            itemDeaktivieren.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboEinAus(false);
                }
            });
            jPopupMenu.add(itemDeaktivieren);
            JMenuItem itemLoeschen = new JMenuItem("Abo l\u00f6schen");
            itemLoeschen.setIcon(GetIcon.getProgramIcon("del_16.png"));
            itemLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboLoeschen();
                }
            });
            jPopupMenu.add(itemLoeschen);
            JMenuItem itemAendern = new JMenuItem("Abo \u00e4ndern");
            itemAendern.setIcon(GetIcon.getProgramIcon("configure_16.png"));
            itemAendern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboAendern();
                }
            });
            jPopupMenu.add(itemAendern);
            jPopupMenu.addSeparator();
            JMenuItem itemNeu = new JMenuItem("Abo anlegen");
            itemNeu.setIcon(GetIcon.getProgramIcon("add_16.png"));
            itemNeu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboNeu();
                }
            });
            jPopupMenu.add(itemNeu);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

