/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.awt.Frame;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import mediathek.controller.starter.Start;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenPset;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.TModel;
import mediathek.tool.TModelDownload;
import msearch.daten.DatenFilm;

public class ListeDownloads
extends LinkedList<DatenDownload> {
    private final Daten daten;
    private final LinkedList<DatenDownload> aktivDownloads = new LinkedList();

    public ListeDownloads(Daten daten_) {
        this.daten = daten_;
    }

    public void sort() {
        Collections.sort(this);
    }

    public synchronized boolean addMitNummer(DatenDownload e) {
        boolean ret = super.add(e);
        this.listeNummerieren();
        return ret;
    }

    public synchronized void zurueckgestellteWiederAktivieren() {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            ((DatenDownload)it.next()).arr[32] = Boolean.FALSE.toString();
        }
    }

    public synchronized void filmEintragen() {
        for (DatenDownload d : this) {
            if (d.film != null) continue;
            d.film = Daten.listeFilme.getFilmByUrl_klein_hoch_hd(d.arr[19]);
        }
    }

    public synchronized void listePutzen() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (d.start == null) continue;
            if (d.start.status == 3) {
                it.remove();
                gefunden = true;
                continue;
            }
            if (d.start.status != 4) continue;
            d.resetDownload();
            gefunden = true;
        }
        if (gefunden) {
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
        }
    }

    public synchronized void listePutzen(DatenDownload datenDownload) {
        boolean gefunden = false;
        if (datenDownload.start != null) {
            if (datenDownload.start.status == 3) {
                this.remove(datenDownload);
                gefunden = true;
            } else if (datenDownload.start.status == 4) {
                datenDownload.resetDownload();
                gefunden = true;
            }
        }
        if (gefunden) {
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
        }
    }

    public synchronized void abosPutzen() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (d.isInterrupted() || !d.istAbo()) continue;
            if (d.start == null) {
                it.remove();
                gefunden = true;
                continue;
            }
            if (d.start.status != 4) continue;
            d.resetDownload();
            gefunden = true;
        }
        if (gefunden) {
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
        }
    }

    public synchronized int nochNichtFertigeDownloads() {
        int ret = 0;
        for (DatenDownload download : this) {
            if (download.start == null || download.start.status >= 3) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized void downloadsVorziehen(ArrayList<DatenDownload> download) {
        for (DatenDownload datenDownload : download) {
            this.remove(datenDownload);
            this.addFirst(datenDownload);
        }
        ListenerMediathekView.notify(29, this.getClass().getSimpleName());
    }

    public synchronized DatenDownload getDownloadByUrl(String url) {
        DatenDownload ret = null;
        for (DatenDownload download : this) {
            if (!download.arr[19].equals(url)) continue;
            ret = download;
            break;
        }
        return ret;
    }

    public synchronized void delDownloadButton(String url) {
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            DatenDownload datenDownload = (DatenDownload)it.next();
            if (!datenDownload.arr[19].equals(url)) continue;
            if (datenDownload.start != null && datenDownload.start.status < 3) {
                datenDownload.start.stoppen = true;
            }
            datenDownload.mVFilmSize.reset();
            datenDownload.start = null;
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
            break;
        }
    }

    public synchronized void downloadAbbrechen(ArrayList<DatenDownload> download) {
        boolean gefunden = false;
        if (download != null) {
            for (DatenDownload down : download) {
                if (!this.contains(down)) continue;
                if (down.start != null) {
                    if (down.start.status < 3) {
                        down.start.stoppen = true;
                    }
                    if (down.start.status == 2) {
                        down.interrupt();
                    }
                }
                down.resetDownload();
                gefunden = true;
            }
        }
        if (gefunden) {
            ListenerMediathekView.notify(14, this.getClass().getSimpleName());
        }
    }

    public synchronized void downloadLoeschen(ArrayList<DatenDownload> download) {
        boolean gefunden = false;
        if (download != null) {
            for (DatenDownload down : download) {
                if (down.start != null && down.start.status < 3) {
                    down.start.stoppen = true;
                }
                if (!this.remove(down)) continue;
                gefunden = true;
            }
        }
        if (gefunden) {
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
        }
    }

    public synchronized DatenDownload getDownloadUrlFilm(String urlFilm) {
        for (DatenDownload datenDownload : this) {
            if (!datenDownload.arr[17].equals(urlFilm)) continue;
            return datenDownload;
        }
        return null;
    }

    public synchronized void getModel(TModelDownload tModel, boolean abos, boolean downloads) {
        tModel.setRowCount(0);
        for (DatenDownload download : this) {
            if (download.istZurueckgestellt()) continue;
            boolean istAbo = download.istAbo();
            if ((!abos || !istAbo) && (!downloads || istAbo)) continue;
            Object[] object = new Object[38];
            for (int i = 0; i < 38; ++i) {
                if (i == 0) {
                    object[i] = download.nr;
                    continue;
                }
                if (i == 1) {
                    if (download.film != null) {
                        object[i] = download.film.nr;
                        continue;
                    }
                    object[i] = 0;
                    continue;
                }
                object[i] = i == 26 || i == 15 || i == 34 || i == 33 || i == 35 || i == 32 ? "" : (i == 36 ? Boolean.valueOf(download.isDownloadManager()) : (i == 12 ? download.datumFilm : (i == 9 ? download.getTextRestzeit() : (i == 10 ? download.getTextBandbreite() : (i == 8 ? this.setProgress(download) : (i == 11 ? download.mVFilmSize : (i == 37 ? download : (i != 19 && !DatenDownload.anzeigen(i) ? "" : download.arr[i]))))))));
            }
            tModel.addRow(object);
        }
    }

    private String setProgress(DatenDownload download) {
        if (download.start != null) {
            if (1 < download.start.percent && download.start.percent < 1000) {
                String s = Double.toString((double)download.start.percent / 10.0) + "%";
                while (s.length() < 5) {
                    s = "0" + s;
                }
                return s;
            }
            return Start.getTextProgress(download);
        }
        return "";
    }

    public synchronized void setModelProgress(TModelDownload tModel) {
        ListIterator<Vector> it = tModel.getDataVector().listIterator();
        int row = 0;
        while (it.hasNext()) {
            List l = it.next();
            DatenDownload datenDownload = (DatenDownload)l.get(37);
            if (datenDownload.start != null && datenDownload.start.status == 2) {
                tModel.setValueAt(datenDownload.getTextRestzeit(), row, 9);
                tModel.setValueAt(datenDownload.getTextBandbreite(), row, 10);
                tModel.setValueAt(this.setProgress(datenDownload), row, 8);
                tModel.setValueAt(datenDownload.mVFilmSize, row, 11);
            }
            ++row;
        }
    }

    public synchronized void setModelProgressAlleStart(TModelDownload tModel) {
        for (List list : tModel.getDataVector()) {
            DatenDownload datenDownload = (DatenDownload)list.get(37);
            if (datenDownload.start == null) continue;
            list.set(9, datenDownload.getTextRestzeit());
            list.set(10, datenDownload.getTextBandbreite());
            list.set(8, this.setProgress(datenDownload));
            list.set(11, datenDownload.mVFilmSize);
            list.set(15, null);
        }
    }

    public synchronized void abosSuchen(Frame parent) {
        boolean gefunden = false;
        boolean checkWithBlackList = Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-auch-Abo"));
        ListIterator itFilm = Daten.listeFilme.listIterator();
        while (itFilm.hasNext()) {
            DatenFilm film = (DatenFilm)itFilm.next();
            DatenAbo abo = Daten.listeAbo.getAboFuerFilm_schnell(film, true);
            if (abo == null || !abo.aboIstEingeschaltet() || checkWithBlackList && !Daten.listeBlacklist.checkBlackOkFilme_Downloads(film) || this.daten.erledigteAbos.urlPruefen(film.getUrlHistory())) continue;
            DatenPset pSet = Daten.listePset.getPsetAbo(abo.arr[11]);
            if (pSet != null) {
                String urlDownload = film.getUrlFuerAufloesung(pSet.arr[15]);
                if (this.checkUrlExists(urlDownload)) continue;
                abo.arr[10] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                if (!abo.arr[11].equals(pSet.arr[0])) {
                    abo.arr[11] = pSet.arr[0];
                }
                this.add(new DatenDownload(pSet, film, 3, abo, "", "", ""));
                gefunden = true;
                continue;
            }
            if (parent == null) continue;
            MVMessageDialog.showMessageDialog(parent, "Im Men\u00fc unter \"Datei->Einstellungen->Set bearbeiten\" ein Programm zum Aufzeichnen f\u00fcr Abos festlegen.", "kein Videoplayer!", 1);
            break;
        }
        if (gefunden) {
            this.listeNummerieren();
        }
    }

    public synchronized void listeNummerieren() {
        int i = 1;
        for (DatenDownload datenDownload : this) {
            datenDownload.nr = i++;
        }
    }

    public synchronized int[] getStarts() {
        int[] ret = new int[]{0, 0, 0, 0, 0, 0, 0};
        for (DatenDownload download : this) {
            if (!download.istZurueckgestellt()) {
                ret[0] = ret[0] + 1;
            }
            if (download.istAbo()) {
                ret[1] = ret[1] + 1;
            } else {
                ret[2] = ret[2] + 1;
            }
            if (download.start == null || download.quelle != 3 && download.quelle != 2) continue;
            switch (download.start.status) {
                case 1: {
                    ret[3] = ret[3] + 1;
                    break;
                }
                case 2: {
                    ret[4] = ret[4] + 1;
                    break;
                }
                case 3: {
                    ret[5] = ret[5] + 1;
                    break;
                }
                case 4: {
                    ret[6] = ret[6] + 1;
                }
            }
        }
        return ret;
    }

    public synchronized int getNumberOfStartsNotFinished() {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            Start s = ((DatenDownload)it.next()).start;
            if (s == null || s.status >= 3) continue;
            return this.size();
        }
        return 0;
    }

    public synchronized long getMaximumFinishTimeOfRunningStarts() {
        long rem = 0L;
        for (DatenDownload d : this) {
            Start s = d.start;
            if (s == null || s.status >= 3) continue;
            rem = Math.max(rem, s.restSekunden);
        }
        return rem;
    }

    public synchronized LinkedList<DatenDownload> getListOfStartsNotFinished(int quelle) {
        this.aktivDownloads.clear();
        for (DatenDownload download : this) {
            if (download.start == null || download.start.status >= 3 || quelle != -1 && download.quelle != quelle) continue;
            this.aktivDownloads.add(download);
        }
        return this.aktivDownloads;
    }

    public synchronized TModel getModelStarts(TModel model) {
        model.setRowCount(0);
        if (!this.isEmpty()) {
            Iterator iterator = this.iterator();
            int objLen = 39;
            Object[] object = new Object[39];
            while (iterator.hasNext()) {
                DatenDownload datenDownload = (DatenDownload)iterator.next();
                if (datenDownload.start != null) {
                    for (int k = 0; k < 39; ++k) {
                        object[k] = k < 38 ? datenDownload.arr[k] : (datenDownload.istAbo() ? "Abo" : "");
                    }
                }
                model.addRow(object);
            }
        }
        return model;
    }

    public synchronized void buttonStartsPutzen() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (d.start == null || d.quelle != 1 || d.start.status < 3) continue;
            it.remove();
            gefunden = true;
        }
        if (gefunden) {
            ListenerMediathekView.notify(15, this.getClass().getSimpleName());
        }
    }

    public synchronized DatenDownload getNextStart() {
        DatenDownload datenDownload;
        DatenDownload ret = null;
        if (this.size() > 0 && this.getDown(Integer.parseInt(Daten.mVConfig.get("maxDownload"))) && (datenDownload = this.naechsterStart()) != null && datenDownload.start != null && datenDownload.start.status == 1) {
            ret = datenDownload;
        }
        return ret;
    }

    private boolean getDown(int max) {
        int count = 0;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            Start s = ((DatenDownload)it.next()).start;
            if (s == null || s.status != 2 || ++count < max) continue;
            return false;
        }
        return true;
    }

    private DatenDownload naechsterStart() {
        for (DatenDownload datenDownload : this) {
            if (datenDownload.start == null || datenDownload.start.status != 1 || this.maxSenderLaufen(datenDownload, 1)) continue;
            return datenDownload;
        }
        int maxProSender = 2;
        if (Boolean.parseBoolean(Daten.mVConfig.get("max1DownloadProServer"))) {
            maxProSender = 1;
        }
        for (DatenDownload datenDownload : this) {
            if (datenDownload.start == null || datenDownload.start.status != 1 || this.maxSenderLaufen(datenDownload, maxProSender)) continue;
            return datenDownload;
        }
        return null;
    }

    private boolean maxSenderLaufen(DatenDownload d, int max) {
        try {
            int counter = 0;
            String host = this.getHost(d);
            for (DatenDownload download : this) {
                if (download.start == null || download.start.status != 2 || !this.getHost(download).equalsIgnoreCase(host) || ++counter < max) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHost(DatenDownload datenDownload) {
        String host = "";
        try {
            try {
                URL url;
                String tmp;
                String uurl = datenDownload.arr[19];
                if (uurl.startsWith("rtmpt:")) {
                    uurl = uurl.toLowerCase().replace("rtmpt:", "http:");
                }
                if (uurl.startsWith("rtmp:")) {
                    uurl = uurl.toLowerCase().replace("rtmp:", "http:");
                }
                if (uurl.startsWith("mms:")) {
                    uurl = uurl.toLowerCase().replace("mms:", "http:");
                }
                if ((tmp = (url = new URL(uurl)).getHost()).contains(".")) {
                    host = tmp.substring(tmp.lastIndexOf(46));
                    host = (tmp = tmp.substring(0, tmp.lastIndexOf(46))).contains(".") ? tmp.substring(tmp.lastIndexOf(46) + 1) + host : (tmp.contains("/") ? tmp.substring(tmp.lastIndexOf(47) + 1) + host : "host");
                }
            }
            catch (Exception ex) {
                host = "host";
            }
            finally {
                if (host.equals("")) {
                    host = "host";
                }
            }
        }
        catch (Exception ex) {
            host = "exception";
        }
        return host;
    }

    private synchronized boolean checkUrlExists(String url) {
        for (DatenDownload download : this) {
            if (!download.arr[19].equals(url)) continue;
            return true;
        }
        return false;
    }
}

