/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class TreeUtils {
    private TreeUtils() {
    }

    public static void setCollapsedIcon(JTree tree, Icon icon) {
        if (tree.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)tree.getUI()).setCollapsedIcon(icon);
        }
    }

    public static void setExpandedIcon(JTree tree, Icon icon) {
        ((BasicTreeUI)tree.getUI()).setExpandedIcon(icon);
    }

    public static void setLeftChildIndent(JTree tree, int indent) {
        ((BasicTreeUI)tree.getUI()).setLeftChildIndent(indent);
    }

    public static void setRightChildIndent(JTree tree, int indent) {
        ((BasicTreeUI)tree.getUI()).setRightChildIndent(indent);
    }

    public static void repaintSelection(JTree tree) {
        int[] selectedRows = tree.getSelectionRows();
        if (selectedRows != null && selectedRows.length > 0) {
            Rectangle firstSelectedCell = tree.getRowBounds(selectedRows[0]);
            Rectangle lastSelectedCell = tree.getRowBounds(selectedRows[selectedRows.length - 1]);
            Rectangle repaintRectangle = firstSelectedCell.union(lastSelectedCell);
            repaintRectangle.x = 0;
            repaintRectangle.width = tree.getWidth();
            tree.repaint(repaintRectangle);
        }
    }

    public static void setExpandedOnEdt(JTree tree, TreePath path, boolean expanded) {
        if (expanded) {
            TreeUtils.expandPathOnEdt(tree, path);
        } else {
            TreeUtils.collapsePathOnEdt(tree, path);
        }
    }

    public static void expandPathOnEdt(final JTree tree, final TreePath path) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.expandPath(path);
            }
        });
    }

    public static void collapsePathOnEdt(final JTree tree, final TreePath path) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.collapsePath(path);
            }
        });
    }

    public static void installRootExpandingTreeModelListener(final JTree tree) {
        TreeModelListener listener = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                if (e.getTreePath().getParentPath() == null && tree.isCollapsed(e.getTreePath())) {
                    TreeUtils.expandPathOnEdt(tree, e.getTreePath());
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        };
        tree.getModel().addTreeModelListener(listener);
    }
}

