/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class PopupButton<E> {
    private static final ImageIcon ARROWS_ICON = new ImageIcon(PopupButton.class.getResource("/com/explodingpixels/macwidgets/images/up_down_arrows_small.png"));
    private JButton fButton = new CustomJButton();
    private List<E> fPopupItemsList;
    private E fSelectedItem;
    private JPopupMenu fPopupMenu = new JPopupMenu();

    public PopupButton(E selectedItem, List<E> popupItemsList) {
        if (selectedItem == null) {
            throw new IllegalArgumentException("The selected item cannot be null.");
        }
        if (popupItemsList == null) {
            throw new IllegalArgumentException("The list of items to add tothe popup menu cannot be null.");
        }
        if (!popupItemsList.contains(selectedItem)) {
            throw new IllegalArgumentException("The item to select is not inthe given list of items.");
        }
        this.fSelectedItem = selectedItem;
        this.fPopupItemsList = popupItemsList;
        this.init();
    }

    private void init() {
        Font oldPopupMenuFont = this.fButton.getFont();
        Font newPopupMenuFont = oldPopupMenuFont.deriveFont((float)oldPopupMenuFont.getSize() - 2.0f);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (E item : this.fPopupItemsList) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(item.toString());
            menuItem.setFont(newPopupMenuFont);
            menuItem.addActionListener(this.createMenuItemListener(item));
            buttonGroup.add(menuItem);
            this.fPopupMenu.add(menuItem);
        }
        this.setSelectedItem(this.fSelectedItem);
        this.fPopupMenu.pack();
        Font oldButtonFont = this.fButton.getFont();
        Font newButtonFont = oldButtonFont.deriveFont((float)oldButtonFont.getSize() - 2.0f);
        this.fButton.setFont(newButtonFont);
        this.fButton.setContentAreaFilled(false);
        this.fButton.setHorizontalAlignment(2);
        this.fButton.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, ARROWS_ICON.getIconWidth() + 10));
        this.fButton.addActionListener(this.createButtonListener());
        Insets insets = new Insets(2, 2, 2, 2);
        Border border = UIManager.getBorder("MenuItem.border");
        if (border != null) {
            insets = border.getBorderInsets(new JMenuItem());
        }
        int width = this.fPopupMenu.getPreferredSize().width - insets.left - insets.right;
        int height = this.fButton.getPreferredSize().height;
        this.fButton.setPreferredSize(new Dimension(width, height));
    }

    public JComponent getComponent() {
        return this.fButton;
    }

    private void setSelectedItem(E itemToSelect) {
        this.fSelectedItem = itemToSelect;
        ((JMenuItem)this.fPopupMenu.getComponent(this.fPopupItemsList.indexOf(this.fSelectedItem))).setSelected(true);
        this.fButton.setText(this.fSelectedItem.toString());
    }

    private ActionListener createButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int buttonRightX = PopupButton.this.fButton.getWidth();
                Insets insets = PopupButton.this.fPopupMenu.getInsets();
                int itemHeight_px = (((PopupButton)PopupButton.this).fPopupMenu.getPreferredSize().height - insets.top - insets.bottom) / PopupButton.this.fPopupItemsList.size();
                int x = buttonRightX - ((PopupButton)PopupButton.this).fPopupMenu.getPreferredSize().width;
                int y = PopupButton.this.fButton.getY() - insets.top - PopupButton.this.fPopupItemsList.indexOf(PopupButton.this.fSelectedItem) * itemHeight_px;
                Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                Point bottomOfMenuOnScreen = new Point(0, y + ((PopupButton)PopupButton.this).fPopupMenu.getPreferredSize().height);
                SwingUtilities.convertPointToScreen(bottomOfMenuOnScreen, PopupButton.this.fButton);
                if (bottomOfMenuOnScreen.y > size.height) {
                    y = PopupButton.this.fButton.getHeight() - ((PopupButton)PopupButton.this).fPopupMenu.getPreferredSize().height;
                }
                PopupButton.this.fPopupMenu.setSelected(PopupButton.this.fPopupMenu.getComponent(PopupButton.this.fPopupItemsList.indexOf(PopupButton.this.fSelectedItem)));
                PopupButton.this.fPopupMenu.show(PopupButton.this.fButton, x, y);
                int index = PopupButton.this.fPopupMenu.getSelectionModel().getSelectedIndex();
                MenuElement[] menuPath = new MenuElement[]{PopupButton.this.fPopupMenu, PopupButton.this.fPopupMenu.getSubElements()[index]};
                MenuSelectionManager.defaultManager().setSelectedPath(menuPath);
            }
        };
    }

    private ActionListener createMenuItemListener(final E item) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupButton.this.setSelectedItem(item);
            }
        };
    }

    private static class CustomJButton
    extends JButton {
        private CustomJButton() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int x = this.getWidth() - ARROWS_ICON.getIconWidth() - 4;
            int y = this.getHeight() / 2 - ARROWS_ICON.getIconHeight() / 2;
            g.drawImage(ARROWS_ICON.getImage(), x, y, null);
        }
    }
}

